!----------------------------------------------------------------------
!     Copyright (c) 2002 Shin-ichi Takehiro. All rights reserved.
!----------------------------------------------------------------------
!
!$BI=Bj(B  ae_module $B%F%9%H%W%m%0%i%`(B
!
!$BMzNr(B  2002/01/25  $BC]9-??0l(B
!      2002/04/10  $BC]9-??0l(B
!      2007/11/07  $BC]9-??0l(B  $B%(%i!<%a%C%;!<%8DI2C(B
!
program ae_test_base1d

  use dc_message, only : MessageNotify
  use ae_module
  implicit none
  integer, parameter :: im=16, km=7
  real(8), parameter :: xmin=0, xmax=1.0
  real(8), parameter :: eps=1.0D-10
  real(8), parameter :: pi=3.1415926535897932385D0

  real(8), dimension(0:im-1) :: g_f
  real(8), dimension(-km:km) :: e_f, e_f_sol

  call MessageNotify('M','ae_test_base1d','ae_module 1-dim function tests')

  call ae_initial(im,km,xmin,xmax)

  g_f = 1.0D0
  e_f_sol = 0.0D0 ; e_f_sol(0)=1.0D0
  e_f = e_g(g_f)

  !----------- test 1 ---------------
  write(6,*) 'g_f=1'
  write(6,*) 'Calculated values are ', e_f
  if ( maxval(abs(e_f_sol-e_f)) > eps )then
     call MessageNotify('E','Test of e_g', &
          'Transform error too large.')
  endif

  write(6,*) 'g_e(e_g(g_f)) - g_f = 0'
  write(6,*) 'Max.val of calculated values is ', maxval(abs(g_e(e_f)- g_f))
  if ( maxval(abs(g_e(e_f)- g_f)) > eps )then
     call MessageNotify('E','Test of g_e', &
          'Transform error too large.')
  endif

  write(6,*) 'g_e(e_dx_e(e_g(g_f))) =0'
  write(6,*) 'Max.val of calculated values are ',&
       maxval(abs(g_e(e_dx_e(e_f))))
  if ( maxval(abs(g_e(e_dx_e(e_f)))) > eps )then
     call MessageNotify('E','Test of e_dx_e', &
          'Differentiation error too large.')
  end if

  !----------- test 2 ---------------
  g_f = sin(2*pi*g_x)
  e_f_sol = 0.0D0 ; e_f_sol(-1)=-0.5D0
  e_f = e_g(g_f)

  write(6,*) 
  write(6,*) 'f=sin(2*pi*x)'
  write(6,*) 'Calculated values are ', e_f
  if ( maxval(abs(e_f_sol-e_f)) > eps )then
     call MessageNotify('E','Test of e_g', &
          'Transform error too large.')
  endif
  write(6,*) 'g_e(e_g(f)) - f = 0'
  write(6,*) 'Max.val of calculated values is ', maxval(abs(g_e(e_f)- g_f))
  if ( maxval(abs(g_e(e_f)- g_f)) > eps )then
     call MessageNotify('E','Test of g_e', &
          'Transform error too large.')
  endif
  write(6,*) 'g_e(e_dx_e(e_g(f))) - 2*pi*cos(2*pi*g_x) = 0'
  write(6,*) 'Max.val of calculated values are ',&
       maxval(abs(g_e(e_dx_e(e_f))- 2*pi*cos(2*pi*g_x)))
  if ( maxval(abs(g_e(e_dx_e(e_f)) - 2*pi*cos(2*pi*g_x))) > eps )then
     call MessageNotify('E','Test of e_dx_e', &
          'Differentiation error too large.')
  end if

  !----------- test 3 ---------------
  g_f = cos(4*pi*g_x)
  e_f_sol = 0.0D0 ; e_f_sol(2)=0.5D0
  e_f = e_g(g_f)

  write(6,*) 
  write(6,*) 'f=cos(4*pi*x)'
  write(6,*) 'Calculated values are ', e_f
  if ( maxval(abs(e_f_sol-e_f)) > eps )then
     call MessageNotify('E','Test of e_g', &
          'Transform error too large.')
  endif
  write(6,*) 'g_e(e_g(f)) - f = 0'
  write(6,*) 'Max.val of calculated values is ', maxval(abs(g_e(e_f)- g_f))
  if ( maxval(abs(g_e(e_f)- g_f)) > eps )then
     call MessageNotify('E','Test of g_e', &
          'Transform error too large.')
  endif
  write(6,*) 'g_e(e_dx_e(e_dx_e((e_g(f))))) + 16*pi**2*cos(4*pi*g_x) = 0'
  write(6,*) 'Max.val of calculated values are ',&
       maxval(abs(g_e(e_dx_e(e_dx_e((e_g(g_f))))) + 16*pi**2*cos(4*pi*g_x)))
  if ( maxval(abs(g_e(e_dx_e(e_dx_e((e_g(g_f))))) + 16*pi**2*cos(4*pi*g_x))) &
       > eps )then
     call MessageNotify('E','Test of e_dx_e', &
          'Differentiation error too large.')
  end if

  write(6,*) 
  call MessageNotify('M','ae_test_base1d', &
       'ae_module 1-dim function tests succeeded!')

end program ae_test_base1d

