!----------------------------------------------------------------------
!     Copyright (c) 2008 Shin-ichi Takehiro. All rights reserved.
!----------------------------------------------------------------------
!
!ɽ  wq_module ƥȥץ
!
!     ֥롼Υƥ
!       wq_Potential2Vector
!
!  2008/04/04  ݹ
!      2008/07/05  ʿ  ѹ
!
program wq_test_derivative6

  use dc_message, only : MessageNotify
  use wq_module
  implicit none

  integer,parameter  :: im=32, jm=16, km=8  ! ʻ(, , ư)
  integer,parameter  :: nm=10, lm=15         ! ȿ(ʿ, ư)
  real(8),parameter  :: ra=7.0D0/13.0D0      ! ⳰Ⱦ \eta=0.35

  real(8), dimension((nm+1)*(nm+1),0:lm) :: wq_VTor    ! ȥݥƥ󥷥
  real(8), dimension((nm+1)*(nm+1),0:lm) :: wq_VPol    ! ݥݥƥ󥷥

  real(8), dimension(0:im-1,1:jm,km)     :: xyr_VLon  ! ®()
  real(8), dimension(0:im-1,1:jm,km)     :: xyr_VLat  ! ®()
  real(8), dimension(0:im-1,1:jm,km)     :: xyr_Vrad  ! ®(ư)
  real(8), dimension(0:im-1,1:jm,km)     :: xyr_V0Lon  ! ®(, )
  real(8), dimension(0:im-1,1:jm,km)     :: xyr_V0Lat  ! ®(, )
  real(8), dimension(0:im-1,1:jm,km)     :: xyr_V0rad  ! ®(,ư)

  real(8), parameter :: eps = 1D-10

  integer :: i,j,k

  call MessageNotify('M','wq_test_derivative6', &
       'wq_module derivative subroutine test #6')

  call wq_Initial(im,jm,km,nm,lm,ra)

  write( 6,* ) 'Test for wq_Potential2Vector'
  write( 6,* ) 'Output is displayed if computational error is larger than',eps

! -----------------  1 --------------------
  ! βž
  wq_VTor = wq_xyr(xyr_Rad * sin(xyr_Lat))
  wq_VPol = 0.0D0

  xyr_V0lon = xyr_Rad * cos(xyr_Lat)
  xyr_V0lat = 0.0D0
  xyr_V0Rad = 0.0D0

  write(6,*)
  write(6,*)
  write(6,*)'Example 1 : rigid rotation'
  write(6,*)'    xyr_Vlon = xyr_Rad * cos(xyr_Lat)'
  write(6,*)'    xyr_Vlat = 0.0'
  write(6,*)'    xyr_VRad = 0.0'

  call checkresult

! -----------------  2 --------------------
  ! βž(ή)
  wq_VTor = wq_xyr(xyr_Rad * cos(xyr_Lat) * sin(xyr_Lon))
  wq_VPol = 0.0D0

  xyr_V0Lon = -xyr_Rad*sin(xyr_Lat)*sin(xyr_Lon)
  xyr_V0Lat = -xyr_Rad*cos(xyr_Lon)
  xyr_V0Rad = 0.0D0

  write(6,*)
  write(6,*)
  write(6,*)'Example 2 : rigid rotation'
  write(6,*)'    xyr_Vlon=xyr_Rad*sin(xyr_Lat)*sin(xyr_Lon)'
  write(6,*)'    xyr_Vlat=-xyr_Rad*cos(xyr_Lon)'
  write(6,*)'    xyr_VRad = 0.0'

  call checkresult

! -----------------  3 --------------------
 ! ̵

  wq_VTor = 0.0D0
  wq_VPol = wq_xyr(xyr_Rad**3 * sin(xyr_Lat))

  xyr_V0lon = 0.0D0
  xyr_V0lat = 4 * xyr_Rad**2 * cos(xyr_Lat)
  xyr_V0rad = 2 * xyr_Rad**2 * sin(xyr_Lat)

  write(6,*)
  write(6,*)
  write(6,*)'Example 3 : no rotation'
  write(6,*)'    xyr_Vlon = 0.0'
  write(6,*)'    xyr_Vlat = 4 * xyr_Rad**2 * cos(xyr_Lat)'
  write(6,*)'    xyr_VRad = 2 * xyr_Rad**2 * sin(xyr_Lat)'

  call checkresult


! -----------------  4 --------------------
 ! ݥ®پ

  wq_VTor = 0.0D0
  wq_VPol = wq_xyr(xyr_Rad**5 * cos(xyr_Lat)*sin(xyr_Lon))

  xyr_V0lon = 6 * xyr_Rad**4 * cos(xyr_Lon)
  xyr_V0lat = - 6 * xyr_Rad**4 * sin(xyr_Lat) * sin(xyr_Lon)
  xyr_V0rad = 2 * xyr_Rad**4 * cos(xyr_Lat) * sin(xyr_Lon)

  write(6,*)
  write(6,*)
  write(6,*)'Example 4 : poloidal field'
  write(6,*)'    xyr_Vlon =  6 * xyr_Rad**4 * cos(xyr_Lon)'
  write(6,*)'    xyr_Vlat = - 6 * xyr_Rad**4 * sin(xyr_Lat) * sin(xyr_Lon)'
  write(6,*)'    xyr_VRad = 2 * xyr_Rad**4 * cos(xyr_Lat) * sin(xyr_Lon)'

  call checkresult

  call MessageNotify('M','wq_test_derivative6', &
       'wq_module derivative function test #6 succeeded!')

  stop
contains

 !-------  -------
  subroutine checkresult

    call wq_Potential2Vector(&
         xyr_VLon,xyr_VLat,xyr_VRad, wq_VTor, wq_VPol )

    write(6,*)
    write(6,*)'Checking V_Lon '
    do k=1,km
       do j=1,jm
          do i=0,im-1
             if ( abs(xyr_VLon(i,j,k)-xyr_V0Lon(i,j,k)) > eps ) then
                write(6,*) i,j,k, xyr_VLon(i,j,k),xyr_V0Lon(i,j,k),&
                                  xyr_VLon(i,j,k)-xyr_V0Lon(i,j,k)
                call MessageNotify('E','wq_test_derivative7', &
                     'Derivative error too large.')
             endif
          end do
       end do
    end do

    write(6,*)
    write(6,*)'Checking V_Lat '
    do k=1,km
       do j=1,jm
          do i=0,im-1
             if ( abs(xyr_VLat(i,j,k)-xyr_V0Lat(i,j,k)) > eps ) then
                write(6,*) i,j,k, xyr_VLat(i,j,k),xyr_V0Lat(i,j,k), &
                                  xyr_VLat(i,j,k)-xyr_V0Lat(i,j,k)
                call MessageNotify('E','wq_test_derivative7', &
                     'Derivative error too large.')
             endif
          end do
       end do
    end do

    write(6,*)
    write(6,*)'Checking V_Rad '
    do k=1,km
       do j=1,jm
          do i=0,im-1
             if ( abs(xyr_VRad(i,j,k)-xyr_V0Rad(i,j,k)) > eps ) then
                write(6,*) i,j,k, xyr_VRad(i,j,k),xyr_V0rad(i,j,k),&
                                  xyr_VRad(i,j,k)-xyr_V0rad(i,j,k)
                call MessageNotify('E','wq_test_derivative7', &
                     'Derivative error too large.')
             endif
          end do
       end do
    end do

  end subroutine checkresult

end program wq_test_derivative6
