!----------------------------------------------------------------------
!     Copyright (c) 2008 Shin-ichi Takehiro. All rights reserved.
!----------------------------------------------------------------------
!
!ɽ  wq_module ƥȥץ
!
!      ȥݥƥ󥷥ζ
!
!  2008/04/04  ݹ
!      2008/07/05  ʿ  ѹ
!
program wq_test_torvelbc

  use dc_message, only : MessageNotify
  use wq_module

  implicit none

  integer,parameter  :: im=32, jm=16, km=8   ! ʻ(, , ư)
  integer,parameter  :: nm=10, lm=15         ! ȿ(ʿ, ư)
  real(8),parameter  :: ra=2.0               ! Ⱦ

  real(8), dimension(0:im-1,1:jm,km)             :: xyr_TorVel0
  real(8), dimension(0:im-1,1:jm,km)             :: xyr_TorVel
  real(8), dimension((nm+1)*(nm+1),0:lm)   :: wq_TorVel
  real(8), dimension((nm+1)*(nm+1),0:lm)   :: wq_TorVel0
  real(8), dimension((nm+1)*(nm+1),km)     :: wr_TorVel
  character(len=1), dimension(2),parameter :: BCond=(/'F','R'/)

  real(8), dimension(0:im-1,1:jm,km)             :: xyr_True

  real(8), parameter  :: eps=1D-14

  integer :: i,j,k,l,n,ll

  call MessageNotify('M','wq_test_torvelbc', &
       'wq_module  wq_TorBoundaryGrid subroutine test')

  call wq_initial(im,jm,km,nm,lm,ra)

  do ll=1,2

     ! P_10
     !xyr_TorVel = sin(xyr_lat) * cos( pi*(xyr_rad-ri)/(ro-ri) )
     ! P_1_1
     !xyr_TorVel = cos(xyr_lat)*cos(xyr_lon)* cos( pi*(xyr_rad-ri)/(ro-ri) )
     xyr_TorVel = 2*sin(xyr_lat)**2 * (xyr_rad-ra)**2 * xyr_Rad**2

     xyr_TorVel0 = xyr_TorVel
     wq_TorVel = wq_xyr(xyr_TorVel)
     wq_TorVel0 = wq_TorVel  
     wr_TorVel = wr_xyr(xyr_TorVel)


     !---- wq_TorBoundary test
     call wq_TorBoundary(wq_TorVel,cond=BCond(ll),new=.true.)
     xyr_TorVel = xyr_wq(wq_TorVel)

     do n=1,(nm+1)**2
        do l=0,lm-2
           if ( abs(wq_TORVEL(n,l)-wq_TORVEL0(n,l)) > eps ) then
              write(6,*) 'internal value. : ', n,l,&
                        wq_TORVEL(n,l)-wq_TORVEL0(n,l)
              call MessageNotify('E','wq_test_polvelbc',&
                              'internal value error too large')
           endif
        enddo
     enddo
           

!!$     !---- wr_TorBoundaryGrid test
!!$     call wr_TorBoundaryGrid(wr_TorVel,cond=BCond(l),new=.true.)
!!$     xyr_TorVel = xyr_wr(wr_TorVel)
!!$     wq_TorVel = wq_wr(wr_TorVel)
!!$
!!$     ! å
!!$     xyr_True = xyr_TorVel - xyr_TorVel0
!!$
!!$     do k=1,km-1
!!$        do j=1,jm
!!$           do i=1,im
!!$              if ( abs(xyr_True(i,j,k)) > eps ) then
!!$                 write(6,*) 'internal value. : ', i,j,xyr_True(i,j,k)
!!$                 call MessageNotify('E','wq_test_torvelbc',&
!!$                              'internal value error too large')
!!$              endif
!!$           enddo
!!$        enddo
!!$     enddo

     ! üå
     if( BCond(ll) == 'F' ) then
        xyr_True = xyr_wq(wq_RadDRad_wq(wq_Torvel)- wq_Torvel)/xyr_Rad
     else
        xyr_True = xyr_TorVel
     endif

     do j=1,jm
        do i=0,im-1
           if ( abs(xyr_True(i,j,km)) > eps ) then
              write(6,*) 'Top B.C. : ', i,j,xyr_True(i,j,km)
              call MessageNotify('E','wq_test_torvelbc',&
                              'Top B.C. error too large')
           endif
        enddo
     enddo
     call MessageNotify('M','wq_test_torvelbc', &
                        BCond(ll)//'-Top B.C. test succeeded!')

  enddo

  call MessageNotify('M','wq_test_torvelbc', &
       'wq_module  wq_TorgBoundaryGrid subroutine test succeeded!')

end program wq_test_torvelbc

