!--
!----------------------------------------------------------------------
!     Copyright 2001--2008 Shin-ichi Takehiro. All rights reserved.
!----------------------------------------------------------------------
!
!ɽ  ee_module
!
!      spml/ee_module ⥸塼ϼβǤ 2 ΰ
!      ήαư򥹥ڥȥˡˤͷ׻뤿 Fortran90 ؿ
!      󶡤. 
!
!       ISPACK/P2PACK  Fortran77 ֥롼ƤǤ. 
!      ڥȥǡӳʻǡγǼˡˤĤƤ
!      ISPACK/P2PACK Υޥ˥奢򻲾Ȥ줿. 
!
!  2001/10/07  ݹ
!      2001/12/25  ݹ  ؿ, ѿ̿̾ˡѹ
!      2002/03/25  ݹ  ⥸塼̾ѹ
!      2002/08/19  ݹ  ʻҥǡź gg -> xy ѹ
!      2002/08/20  ݹ  ʬʿѴؿɲ
!      2005/03/15  ݹ  xy -> yx ƬҤѹ
!      2005/07/18  ݹ  Ѥ ISPACK 饤֥ p2pack ѹ
!      2005/10/26  ݹ  ͥ륮, 󥹥ȥեڥȥɲ
!      2006/03/05  ݹ  Ȥ RDoc Ѥ˽
!      2006/03/19  ݹ  ѿ³򥳥Ȥɲ
!      2008/05/10  ߷ => ݹ ΰʣб
!      2008/10/28  ݹ  ַ׻ɲ
!      2009/01/09  ݹ  ee_Initial åդɲ
!      2009/01/29  ʿ Ȥ RDoc Ѥ˽
!
!++
module ee_module
  !
  != ee_module
  !
  ! Authors:: Shin-ichi Takehiro, Youhei SASAKI
  ! Version:: $Id: ee_module.f90,v 1.20 2009-02-28 21:33:46 uwabami Exp $
  ! Copyright&License:: See COPYRIGHT[link:../COPYRIGHT]
  !
  !== 
  !
  ! spml/ee_module ⥸塼ϼβǤ 2 ΰ
  ! ήαư򥹥ڥȥˡˤͷ׻뤿 Fortran90 ؿ
  ! 󶡤. 
  !
  !  ISPACK/P2PACK  Fortran77 ֥롼ƤǤ. 
  ! ڥȥǡӳʻǡγǼˡˤĤƤ
  ! ISPACK/P2PACK Υޥ˥奢򻲾Ȥ줿. 
  !
  !== ؿѿ̾ȷˤĤ
  !
  !=== ̿̾ˡ
  !  
  ! * ؿ̾Ƭ (ee_, yx_, x_, y_) , ֤ͤη򼨤Ƥ.
  !   ee_ :: ڥȥǡ( 1,2 줾 Y,X ȿ)
  !   yx_ :: 2 ʻǡ( 1,2 줾 Y,X γʻ)
  !   x_  :: X  1 ʻǡ, y_ : Y  1 ʻǡ
  !
  ! * ؿ̾δ֤ʸ(Dx, Dy, Lapla, LaplaInv, Jacobian), 
  !   δؿκѤɽƤ.
  !
  ! * ؿ̾κǸ (_ee_ee, _ee, _yx, _x, _y) , ѿη
  !   ڥȥǡӳʻǡǤ뤳Ȥ򼨤Ƥ.
  !   _ee    :: ڥȥǡ
  !   _ee_ee :: 2 ĤΥڥȥǡ
  !   _yx    :: 2 ʻǡ
  !   _x     :: X  1 ʻǡ
  !   _y     :: Y  1 ʻǡ.
  !  
  !=== ƥǡμ
  !  
  ! * yx : 2 ʻǡ.
  !   * ѿμȼ real(8), dimension(0:jm-1,0:im-1). 
  !   * im, jm Ϥ줾 X, Y ɸγʻǤ, ֥롼 
  !     ee_initial ˤƤ餫ꤷƤ.
  !   *  1  Y ɸγʻֹ,  2  X ɸ
  !     ʻֹǤ (X, Y νǤϤʤ)Ȥ.
  !
  ! * ee : ڥȥǡ.
  !   * ѿμȼ real(8), dimension(-lm:lm,-km:km). 
  !   * km, lm Ϥ줾 X, Y κȿǤ, ֥롼 
  !     ee_initial ˤƤ餫ꤷƤ.
  !     (X, Y ȿνǤϤʤ)Ȥ. 
  !   * ڥȥǡγǼΤˤĤƤ...
  !
  ! * x, y : X, Y  1 ʻǡ.
  !   * ѿμȼϤ줾
  !     real(8), dimension(0:im-1)  real(8), dimension(0:jm-1).
  !
  ! * ee_ ǻϤޤؿ֤ͤϥڥȥǡƱ.
  !
  ! * yx_ ǻϤޤؿ֤ͤ 2 ʻǡƱ.
  !
  ! * x_, y_ ǻϤޤؿ֤ͤ 1 ʻǡƱ.
  !
  ! * ڥȥǡФʬκѤȤ, бʻǡ
  !   ʬʤɤѤǡ򥹥ڥȥѴΤȤǤ.
  !
  !== ѿ³
  !
  !====  
  !
  ! ee_Initial :: ڥȥѴγʻ, ȿ, ΰ礭
  ! ee_ChangeResolutionDomain :: , ΰѹ
  !
  !==== ɸѿ
  !
  ! x_X, y_Y     ::  ʻɸ(X,Yɸ)Ǽ 1 
  ! x_X_Weight, y_Y_Weight ::  ŤߺɸǼ 1 
  ! yx_X, yx_Y   :: ʻǡ XY ɸ(X,Y)(ʻǡ 2 )
  !
  !==== Ѵ
  !
  ! yx_ee :: ڥȥǡʻҥǡؤѴ
  ! ee_yx :: ʻҥǡ饹ڥȥǡؤѴ
  !
  !==== ʬ
  !
  ! ee_Lapla_ee       :: ڥȥǡ˥ץ饷Ѥ
  ! ee_LaplaInv_ee    :: ڥȥǡ˥ץ饷εѴѤ
  ! ee_Dx_ee          :: ڥȥǡ X ʬѤ
  ! ee_Dy_ee          :: ڥȥǡ Y ʬѤ
  ! ee_Jacobian_ee_ee :: 2 ĤΥڥȥǡ䥳ӥ׻
  !
  !==== ʬʿ
  !
  ! IntYX_yx, AvrYX_yx   :: 2 ʻǡΰʬʿ
  ! y_IntX_yx, y_AvrX_yx :: 2 ʻǡ X ʬʿ
  ! IntX_x, AvrX_x       :: 1 (X)ʻǡ X ʬʿ
  ! x_IntY_yx, x_AvrY_yx :: 2 ʻǡ Y ʬʿ
  ! IntY_y, AvrY_y       :: 1 (Y)ʻǡ Y ʬʿ
  !
  !==== ڥȥ
  !
  ! ee_EnergyFromStreamfunc_ee    :: 
  ! ήؿ饨ͥ륮ڥȥ׻
  !
  ! ee_EnstrophyFromStreamfunc_ee :: 
  ! ήؿ饨󥹥ȥեڥȥ׻
  !
  !==== ַ׻
  !
  ! Interpolate_ee       :: Ǥդͤ򥹥ڥȥǡ׻
  !
  use dc_message, only : MessageNotify
  implicit none

  private
  public ee_Initial                                       ! 롼
  public ee_ChangeResolutionDomain                        ! ΰѹ
  public yx_ee, ee_yx                                     ! Ѵ
  public ee_Lapla_ee, ee_LaplaInv_ee, ee_Dx_ee, ee_Dy_ee  ! ʬ
  public ee_JacobianZ_ee, ee_Jacobian_ee_ee               ! ׻
  public IntYX_yx, y_IntX_yx, x_IntY_yx, IntX_x, IntY_y   ! ʬ
  public AvrYX_yx, y_AvrX_yx, x_AvrY_yx, AvrX_x, AvrY_y   ! ʿ
  public ee_EnergyFromStreamfunc_ee                       ! ͥ륮
  public ee_EnstrophyFromStreamfunc_ee                    ! 󥹥ȥե
  public Interpolate_ee                                   ! 
  public x_X, y_Y, x_X_Weight, y_Y_Weight, yx_X, yx_Y     ! ɸѿ

  integer   :: im=32, jm=32                      ! ʻ(X,Y)
  integer   :: km=10, lm=10                      ! ȿ(X,Y)
  real(8)   :: xl=1.0, yl=1.0                    ! ΰ礭

  integer, dimension(:),   pointer :: itj => null()
  real(8), dimension(:),   pointer :: tj => null()
  integer, dimension(:),   pointer :: iti => null()
  real(8), dimension(:),   pointer :: ti => null()

  real(8), dimension(:),   pointer :: x_X => null()
                                         ! ʻɸ(X)
  real(8), dimension(:),   pointer :: y_Y => null()
                                         ! ʻɸ(Y)

  real(8), dimension(:),   pointer :: x_X_Weight => null()
                                         ! ʻŤ(X)
                                         ! X γʻδֳ֤ǼƤ.
  real(8), dimension(:),   pointer :: y_Y_Weight => null()
                                         ! ʻŤ(Y)
                                         ! Y γʻδֳ֤ǼƤ.

  real(8), dimension(:,:), pointer :: yx_X => null()
                          ! ʻ(X)ɸ(2 )
                          ! Ƴʻ(i,j)ΰ֤ X ɸǼʻҥǡ
  real(8), dimension(:,:), pointer :: yx_Y => null()
                          ! ʻ(Y)ɸ(2 )
                          ! Ƴʻ(i,j)ΰ֤ Y ɸǼʻҥǡ

  real(8), dimension(:),   pointer :: w => null(), ws => null(), wg => null()
  real(8), dimension(:,:), pointer :: yx_tmp => null()


  integer, parameter :: nparams_max = 10 ! ee_Initial Ƥ٤
  type ee_param                          ! ΰ¤
     integer   :: im, jm
     integer   :: km, lm
     real(8)   :: xl, yl
     integer, dimension(:),   pointer :: itj
     real(8), dimension(:),   pointer :: tj
     integer, dimension(:),   pointer :: iti
     real(8), dimension(:),   pointer :: ti
     real(8), dimension(:),   pointer :: x_X
     real(8), dimension(:),   pointer :: y_Y
     real(8), dimension(:),   pointer :: x_X_Weight
     real(8), dimension(:),   pointer :: y_Y_Weight
     real(8), dimension(:,:), pointer :: yx_X
     real(8), dimension(:,:), pointer :: yx_Y 
     real(8), dimension(:),   pointer :: w, ws, wg
     real(8), dimension(:,:), pointer :: yx_tmp
  end type ee_param
  type(ee_param) :: params(nparams_max)  ! ΰ
  integer :: nparams                     ! ΰθĿ

  real(8), parameter  :: pi=3.1415926535897932385D0

  save im, jm, km, lm, itj, tj, iti, ti, xl, yl
  save x_X, y_Y, x_X_Weight, y_Y_Weight, yx_X, yx_Y
  save params, nparams

  contains
  !---------------  -----------------
    subroutine ee_Initial(i,j,k,l,xmin,xmax,ymin,ymax,id)
      !
      ! ڥȥѴγʻ, ȿ, ΰ礭ꤹ.
      !
      ! ¾δؿѿƤ, ǽˤΥ֥롼Ƥ
      ! 򤷤ʤФʤʤ.
      !
      ! ץʥ id Ѥưۤʤ, ΰƱ
      ! ȤǤ. ee_Initial , ΰ褴Ȥ˸Ƥ
      !  id 򥭡פ, ee_ChangeResolutionDomain ؤ. 
      !
      integer,intent(in) :: i           ! ʻ(X)
      integer,intent(in) :: j           ! ʻ(Y)
      integer,intent(in) :: K           ! ȿ(X)
      integer,intent(in) :: l           ! ȿ(Y)

      real(8),intent(in) :: xmin, xmax     ! X ɸϰ
      real(8),intent(in) :: ymin, ymax     ! Y ɸϰ

      integer, intent(out), optional :: id  ! ΰֹ

      character(len=3) cid
      integer :: ii, jj

      im = i         ; jm = j
      km = k         ; lm = l
      xl = xmax-xmin ; yl = ymax-ymin

      if ( nparams .ge. nparams_max ) then
         call MessageNotify('W','ee_initial',&
              'too many call of ee_Initial, nothing was done.')
         if ( present(id) ) id = -1
         return
      end if

      nparams = nparams + 1

      params(nparams)%im = im
      params(nparams)%jm = jm
      params(nparams)%km = km
      params(nparams)%lm = lm
      params(nparams)%xl = xl
      params(nparams)%yl = yl

      allocate(params(nparams)%itj(5))
      allocate(params(nparams)%iti(5))
      allocate(params(nparams)%tj(jm*2))
      allocate(params(nparams)%ti(im*2))
      allocate(params(nparams)%w(jm*im))
      allocate(params(nparams)%ws((2*km+1)*(2*lm+1)))
      allocate(params(nparams)%wg(jm*im*3))
      allocate(params(nparams)%yx_tmp(0:jm-1,0:im-1))

      allocate(params(nparams)%x_X(0:im-1))
      allocate(params(nparams)%x_X_Weight(0:im-1))
      allocate(params(nparams)%y_Y(0:jm-1))
      allocate(params(nparams)%y_Y_Weight(0:jm-1))
      allocate(params(nparams)%yx_X(0:jm-1,0:im-1))
      allocate(params(nparams)%yx_Y(0:jm-1,0:im-1))

      call ee_ChangeResolutionDomain(nparams)

      call p2init(jm,im,itj,tj,iti,ti)

      do ii=0,im-1
         x_X(ii) = xmin + xl/im*ii
      enddo
      x_X_Weight = xl/im

      do jj=0,jm-1
         y_Y(jj) = ymin + yl/jm*jj
      enddo
      y_Y_Weight = yl/jm

      yx_X = spread(x_X,1,jm)
      yx_Y = spread(y_Y,2,im)

      if ( present(id) ) id = nparams

      write(cid,'(I3)') nparams
      call MessageNotify('M','ee_initial','ee_module (2009/01/09) is initialized')
      call MessageNotify('M','ee_initial',&
           'ResolutionDomain ID is '//trim(adjustl(cid)))
    end subroutine ee_initial

  !--------------- id ѹ -----------------
    subroutine ee_ChangeResolutionDomain(id)
      !
      ! , ΰѹ. ee_Initial ꤹݤ
      ! äƤ륪ץʥ id ͤѤ. 
      ! 
      integer, intent(in) :: id

      if (id .gt. nparams .or. id .lt. 1) then
         write(*,*)"id is invalid"
      end if

      im = params(id)%im
      jm = params(id)%jm
      km = params(id)%km
      lm = params(id)%lm
      xl = params(id)%xl
      yl = params(id)%yl
      itj => params(id)%itj
      tj => params(id)%tj
      iti => params(id)%iti
      ti => params(id)%ti
      x_X => params(id)%x_X
      y_Y => params(id)%y_Y
      x_X_Weight => params(id)%x_X_Weight
      y_Y_Weight => params(id)%y_Y_Weight
      yx_X => params(id)%yx_X
      yx_Y => params(id)%yx_Y
      w => params(id)%w
      ws => params(id)%ws
      wg => params(id)%wg
      yx_tmp => params(id)%yx_tmp

    end subroutine ee_ChangeResolutionDomain

  !--------------- Ѵ -----------------
    function yx_ee(ee)
      !
      ! ڥȥǡʻҥǡѴ.
      !
      real(8), dimension(0:jm-1,0:im-1)             :: yx_ee 
                                                      !(out) ʻǡ
      real(8), dimension(-lm:lm,-km:km), intent(in) :: ee
                                                      !(in)  ڥȥǡ

      call p2s2ga(lm,km,jm,im,ee,yx_ee,w,itj,tj,iti,ti)
    end function yx_ee

    function ee_yx(yx)
      !
      ! ʻҥǡ饹ڥȥǡѴ.
      !
      real(8), dimension(-lm:lm,-km:km)              :: ee_yx
                                                      !(out)  ڥȥǡ
      real(8), dimension(0:jm-1,0:im-1), intent(in)  :: yx
                                                      !(in) ʻǡ

      yx_tmp = yx
      call p2g2sa(lm,km,jm,im,yx_tmp,ee_yx,w,itj,tj,iti,ti)

    end function ee_yx

  !--------------- ʬ׻ -----------------
    function ee_Lapla_ee(ee)
      !
      ! ϥڥȥǡ˥ץ饷(xx+yy)Ѥ.
      !
      ! ڥȥǡΥץ饷Ȥ, бʻǡ
      ! ץ饷ѤǡΥڥȥѴΤȤǤ.
      !
      ! ºݤˤϥڥȥǡȿ (k**2 + l**2) 򤫤
      ! ׻ԤäƤ. 
      !
      real(8), dimension(-lm:lm,-km:km)              :: ee_Lapla_ee
      !(out) ڥȥǡΥץ饷

      real(8), dimension(-lm:lm,-km:km), intent(in)  :: ee
      !(in) ϥڥȥǡ

      integer k,l
      ! ѿ

      do k=-km,km
         do l=-lm,lm
            ee_Lapla_ee(l,k) = -((2*pi*k/xl)**2+(2*pi*l/yl)**2)*ee(l,k)
         enddo
      enddo
    end function ee_Lapla_ee

    function ee_LaplaInv_ee(ee)
      !
      ! ϥڥȥǡ˵եץ饷(xx+yy)**(-1)Ѥ.
      !
      ! ڥȥǡεեץ饷Ȥ, бʻǡ
      ! եץ饷ѤǡΥڥȥѴΤȤǤ.
      !
      ! ºݤˤϥڥȥǡȿ (k**2 + l**2) ǳ
      ! ׻ԤäƤ. k=l=0 ʬˤ 0 Ƥ. 
      !
      real(8), dimension(-lm:lm,-km:km)             :: ee_LaplaInv_ee
      !(out) ڥȥǡεեץ饷

      real(8), dimension(-lm:lm,-km:km), intent(in) :: ee
      !(in) ڥȥǡ

      integer k,l

      do k=-km,km
         do l=-lm,lm
            if ( k.ne.0 .or. l.ne.0 ) then
               ee_LaplaInv_ee(l,k) = -ee(l,k)/((2*pi*k/xl)**2+(2*pi*l/yl)**2)
            else
               ee_LaplaInv_ee(l,k) = 0.0
            endif
         enddo
      enddo
    end function ee_LaplaInv_ee

    function ee_Dx_ee(ee)
      !
      ! ϥڥȥǡ X ʬ(x)Ѥ.
      !
      ! ڥȥǡ X ʬȤ, бʻǡ X ʬ
      ! ѤǡΥڥȥѴΤȤǤ.
      !
      ! ºݤˤϥڥȥǡ X ȿ k 򤫤
      ! sin(kx) <-> cos(kx) ʬ촹׻ԤäƤ.
      !
      real(8), dimension(-lm:lm,-km:km)              :: ee_Dx_ee
      !(out) ڥȥǡ X ʬ

      real(8), dimension(-lm:lm,-km:km), intent(in)  :: ee
      !(in) ϥڥȥǡ

      integer k,l
      ! ѿ

      do k=-km,km
         do l=-lm,lm
            ee_Dx_ee(l,k) = -(2*pi*k/xl)*ee(-l,-k)
         enddo
      enddo
    end function ee_Dx_ee

    function ee_Dy_ee(ee)
      !
      ! ϥڥȥǡ Y ʬ(y)Ѥ.
      !
      ! ڥȥǡ X ʬȤ, бʻǡ Y ʬ
      ! ѤǡΥڥȥѴΤȤǤ.
      !
      ! ºݤˤϥڥȥǡ X ȿ l 򤫤
      ! sin(ky) <-> cos(ky) ʬ촹׻ԤäƤ.
      !
      real(8), dimension(-lm:lm,-km:km)              :: ee_Dy_ee
      !(out) ڥȥǡ Y ʬ

      real(8), dimension(-lm:lm,-km:km), intent(in)  :: ee
      !(in) ϥڥȥǡ

      integer k,l
      ! ѿ

      do k=-km,km
         do l=-lm,lm
            ee_Dy_ee(l,k) = -(2*pi*l/yl)*ee(-l,-k)
         enddo
      enddo

    end function ee_Dy_ee

    function ee_Jacobian_ee_ee(ee_a,ee_b)
      !
      !  2 ĤΥڥȥǡ䥳ӥ
      !
      !     J(A,B)=(xA)(yB)-(yA)(xB)
      !
      !  ׻.
      !
      !  2 ĤΥڥȥǡΥ䥳ӥȤ, б 2 Ĥ
      !  ʻǡΥ䥳ӥΥڥȥѴΤȤǤ.
      !
      real(8), dimension(-lm:lm,-km:km)              :: ee_Jacobian_ee_ee
      !(out) 2 ĤΥڥȥǡΥ䥳ӥ

      real(8), dimension(-lm:lm,-km:km), intent(in)  :: ee_a
      !(in) 1ܤϥڥȥǡ

      real(8), dimension(-lm:lm,-km:km), intent(in)  :: ee_b
      !(in) 2ܤϥڥȥǡ

      call p2ajcb(lm,km,jm,im,ee_a,ee_b,ee_Jacobian_ee_ee,ws,wg,itj,tj,iti,ti)

      ee_Jacobian_ee_ee  = (2*pi/xl)*(2*pi/yl) * ee_Jacobian_ee_ee

    end function ee_Jacobian_ee_ee

    function ee_JacobianZ_ee(ee_zeta)
      !
      ! ٥ڥȥǡ  ήؿȱ٤Υ䥳ӥ
      !
      !     J(,)=(x)(y)-(y)(x)
      !
      !  ׻.   (xx+yy)= ήؿǤ.
      !
      real(8), dimension(-lm:lm,-km:km)              :: ee_JacobianZ_ee
      !(out) ήؿȱ٤Υ䥳ӥ

      real(8), dimension(-lm:lm,-km:km), intent(in)  :: ee_Zeta
      !(in) ٥ڥȥǡ

      call p2ajbs(lm,km,jm,im,yl/xl,ee_Zeta,ee_JacobianZ_ee,ws,wg,itj,tj,iti,ti)

      ee_JacobianZ_ee = (2*pi/xl)*(2*pi/yl)/(2*pi/yl)**2 * ee_JacobianZ_ee

    end function ee_JacobianZ_ee

  !--------------- ʬ׻ -----------------
    function IntYX_yx(yx)
      !
      ! 2 ʻǡΰʬʿ.
      !
      ! ºݤˤϳʻǡ x_X_Weight, y_Y_Weight 򤫤
      ! ¤׻Ƥ. 
      !
      real(8), dimension(0:jm-1,0:im-1)   :: yx          
      !(in)  2 ʻǡ

      real(8)                             :: IntYX_yx
      !(out) ʬ

      integer :: i, j
      ! ѿ

      IntYX_yx = 0.0d0
      do i=0,im-1
         do j=0,jm-1
            IntYX_yx = IntYX_yx + yx(j,i) * y_Y_Weight(j) * x_X_Weight(i)
         enddo
      enddo
    end function IntYX_yx

    function y_IntX_yx(yx)
      !
      ! 2 ʻǡ X ʬ
      !
      ! ºݤˤϳʻǡ x_X_Weight 򤫤¤׻Ƥ. 
      !
      real(8), dimension(0:jm-1,0:im-1)   :: yx
      !(in) 2 ʻǡ

      real(8), dimension(0:jm-1)          :: y_IntX_yx
      !(out) ʬ줿 1 (Y)ʻǡ

      integer :: i
      ! ѿ

      y_IntX_yx = 0.0d0
      do i=0,im-1
         y_IntX_yx(:) = y_IntX_yx(:) + yx(:,i) * x_X_Weight(i)
      enddo
    end function y_IntX_yx

    function x_IntY_yx(yx)
      !
      ! 2 ʻǡ Y ʬ
      !
      ! ºݤˤϳʻǡ y_Y_Weight 򤫤¤׻Ƥ. 
      !
      real(8), dimension(0:jm-1,0:im-1)   :: yx      
      !(in)  2 ʻǡ

      real(8), dimension(0:im-1)        :: x_IntY_yx 
      !(out) ʬ줿 1 (X)ʻǡ

      integer :: j
      ! ѿ

      x_IntY_yx = 0.0d0
      do j=0,jm-1
         x_IntY_yx(:) = x_IntY_yx(:) + yx(j,:) * y_Y_Weight(j)
      enddo
    end function x_IntY_yx

    function IntX_x(x)
      !
      ! 1 (X)ʻǡ X ʬ
      !
      ! ºݤˤϳʻǡ x_X_Weight 򤫤¤׻Ƥ. 
      !
      real(8), dimension(0:im-1)   :: x          !(in)  1 ʻǡ
      real(8)                      :: IntX_x     !(out) ʬ

      IntX_x = sum(x*x_X_Weight)
    end function IntX_x

    function IntY_y(y)      ! Y ʬ
      !
      ! 1 (Y)ʻǡ Y ʬ
      !
      ! ºݤˤϳʻǡ y_Y_Weight 򤫤¤׻Ƥ. 
      !
      real(8), dimension(0:jm-1)   :: y          !(in)  1 ʻǡ
      real(8)                      :: IntY_y     !(out) ʬ

      IntY_y = sum(y*y_Y_Weight)
    end function IntY_y

  !--------------- ʿѷ׻ -----------------
    function AvrYX_yx(yx)
      !
      ! 2 ʻǡΰʿ
      !
      ! ºݤˤϳʻǡ x_X_Weight, y_Y_Weight 򤫤
      ! ¤׻, x_X_Weight*y_Y_Weight ¤ǳ뤳ȤʿѤƤ. 
      !
      real(8), dimension(0:jm-1,0:im-1)   :: yx
      !(in)  2 ʻǡ

      real(8)                             :: AvrYX_yx    
      !(out) ʿ

      AvrYX_yx = IntYX_yx(yx)/(sum(x_X_weight)*sum(y_Y_weight))
    end function AvrYX_yx

    function y_AvrX_yx(yx)
      !
      ! 2 ʻǡ X ʿ
      !
      ! ºݤˤϳʻǡ x_X_Weight 򤫤¤׻, 
      ! x_X_Weight ¤ǳ뤳ȤʿѤƤ. 
      !
      real(8), dimension(0:jm-1,0:im-1)   :: yx
      !(in) 2 ʻǡ

      real(8), dimension(0:jm-1)          :: y_AvrX_yx
      !(out) ʿѤ줿 1 (Y)ʻǡ

      y_AvrX_yx = y_IntX_yx(yx)/sum(x_X_weight)
    end function y_AvrX_yx

    function x_AvrY_yx(yx)
      !
      ! 2 ʻǡ Y ʿ
      !
      ! ºݤˤϳʻǡ y_Y_Weight 򤫤¤׻, 
      ! y_Y_Weight ¤ǳ뤳ȤʿѤƤ. 
      !
      real(8), dimension(0:jm-1,0:im-1)   :: yx
      !(in) 2 ʻǡ

      real(8), dimension(0:im-1)          :: x_AvrY_yx
      !(out) ʿѤ줿 1 (X)ʻǡ

      x_AvrY_yx = x_IntY_yx(yx)/sum(y_Y_weight)
    end function x_AvrY_yx

    function AvrX_x(x)
      !
      ! 1 (X)ʻǡ X ʿ
      !
      ! ºݤˤϳʻǡ x_X_Weight 򤫤¤׻, 
      ! x_X_Weight ¤ǳ뤳ȤʿѤƤ. 
      !
      real(8), dimension(0:im-1)   :: x          !(in)  1 ʻǡ
      real(8)                      :: AvrX_x     !(out) ʿ

      AvrX_x = IntX_x(x)/sum(x_X_weight)
    end function AvrX_x

    function AvrY_y(y)
      !
      ! 1 (Y)ʻǡ Y ʿ
      !
      ! ºݤˤϳʻǡ y_Y_Weight 򤫤¤׻, 
      ! y_Y_Weight ¤ǳ뤳ȤʿѤƤ. 
      !
      real(8), dimension(0:jm-1) :: y          !(in)  1 ʻǡ
      real(8)                    :: AvrY_y     !(out) ʿ

      AvrY_y = IntY_y(y)/sum(y_Y_weight)
    end function AvrY_y

  !--------------- ڥȥ׻ -----------------
    function ee_EnergyFromStreamfunc_ee(ee_StrFunc)
      !
      ! ήؿ饨ͥ륮ڥȥ׻. 
      !
      !   E_kl = (1/2)(k^2+l^2)|\psi_kl|^2
      !
      ! * E_kl ¤ʿѱưͥ륮Ȥʤ. 
      ! * ΰѤ򤫤ưͥ륮Ȥʤ. 
      !
      real(8), dimension(-lm:lm,-km:km)    :: ee_EnergyFromStreamfunc_ee
      ! ͥ륮ڥȥ

      real(8), dimension(-lm:lm,-km:km), intent(in) :: ee_StrFunc
      ! ήؿ

      integer k,l
      ! ѿ

      do k=-km,km
         do l=-lm,lm
            ee_EnergyFromStreamfunc_ee(l,k) &
                 = 0.5 * ( (2*pi*k/xl)**2 + (2*pi*l/yl)**2 ) & 
                          * (ee_StrFunc(l,k)**2 + ee_StrFunc(-l,-k)**2)
         enddo
      enddo

    end function ee_EnergyFromStreamfunc_ee

    function ee_EnstrophyFromStreamfunc_ee(ee_StrFunc)
      !
      ! ήؿ饨󥹥ȥեڥȥ׻. 
      !
      !   Q_kl = (1/2)(k^2+l^2)^2|\psi_kl|^2
      !
      ! * Q_kl ¤ʿѥ󥹥ȥեȤʤ. 
      ! * ΰѤ򤫤󥹥ȥեȤʤ. 
      !

      real(8), dimension(-lm:lm,-km:km)    :: ee_EnstrophyFromStreamfunc_ee
      ! 󥹥ȥեڥȥ

      real(8), dimension(-lm:lm,-km:km), intent(in) :: ee_StrFunc
      ! ήؿ

      integer k,l
      ! ѿ

      do k=-km,km
         do l=-lm,lm
            ee_EnstrophyFromStreamfunc_ee(l,k) &
                 = 0.5 * ( (2*pi*k/xl)**2 + (2*pi*l/yl)**2 )**2 & 
                          * (ee_StrFunc(l,k)**2 + ee_StrFunc(-l,-k)**2)
         enddo
      enddo

    end function ee_EnstrophyFromStreamfunc_ee

  !--------------- ַ׻ -----------------
    function Interpolate_ee( ee_Data, x, y )
      real(8), intent(IN)  :: ee_data(-lm:lm,-km:km)  ! ڥȥǡ
      real(8), intent(IN)  :: x                       ! ֤ x ɸ 
      real(8), intent(IN)  :: y                       ! ֤ y ɸ 
      real(8)              :: Interpolate_ee          ! ֤

      integer :: k, l
      real(8) :: xx, yy

      xx =(2*PI/xl)*(x - x_X(0))
      yy =(2*PI/yl)*(y - y_Y(0))

      Interpolate_ee = ee_Data(0,0)

      ! l=0
      do k=1,km
         Interpolate_ee = Interpolate_ee &
              + 2*( ee_Data(0,k)*cos(k*xx) - ee_Data(0,-k)*sin(k*xx) )
      end do

      ! k=0
      do l=1,lm
         Interpolate_ee = Interpolate_ee &
              + 2*( ee_Data(l,0)*cos(l*yy) - ee_Data(-l,0)*sin(l*yy) )
      end do

      ! k*l > 0
      do l=1,lm
         do k=1,km
            Interpolate_ee = Interpolate_ee &
              + 2*(  ee_Data(l,k)*(   cos(k*xx)*cos(l*yy)   &
                                    - sin(k*xx)*sin(l*yy) ) &
                    -ee_Data(-l,-k)*(   sin(k*xx)*cos(l*yy)   &
                                      + cos(k*xx)*sin(l*yy) ) )
         end do
      end do

      ! k*l < 0
      do l=1,lm
         do k=1,km
            Interpolate_ee = Interpolate_ee &
              + 2*(  ee_Data(-l,k)*(   cos(k*xx)*cos(l*yy)   &
                                     + sin(k*xx)*sin(l*yy) ) &
                    -ee_Data(l,-k)*(   sin(k*xx)*cos(l*yy)   &
                                     - cos(k*xx)*sin(l*yy) ) )
         end do
      end do

    end function Interpolate_ee

end module ee_module
