!--
!----------------------------------------------------------------------
!     Copyright 2008 Shin-ichi Takehiro. All rights reserved.
!----------------------------------------------------------------------
!
!ɽ  eee_module
!
!      spml/eee_module ⥸塼ϼβǤ 3 ΰ
!      ήαư򥹥ڥȥˡˤͷ׻뤿 Fortran90 ؿ
!      󶡤. 
!
!       ISPACK/P3PACK  Fortran77 ֥롼ƤǤ. 
!      ڥȥǡӳʻǡγǼˡˤĤƤ
!      ISPACK/P3PACK Υޥ˥奢򻲾Ȥ줿. 
!
!  2008/05/03  ݹ
!      2008/05/10  ݹ ΰʣб
!      2008/05/11  ݹ xyz_zyx ɲ
!      2009/01/29  ʿ Ȥ RDoc Ѥ˽
!
!++
module eee_module
  !
  != eee_module
  !
  ! Authors:: Shin-ichi Takehiro, Youhei SASAKI
  ! Version:: $Id: eee_module.f90,v 1.3 2009-02-28 21:33:46 uwabami Exp $
  ! Copyright&License:: See COPYRIGHT[link:../COPYRIGHT]
  !
  !== 
  !
  ! spml/eee_module ⥸塼ϼβǤ 3 ΰ
  ! ήαư򥹥ڥȥˡˤͷ׻뤿 Fortran90 ؿ
  ! 󶡤. 
  !
  !  ISPACK/P3PACK  Fortran77 ֥롼ƤǤ. 
  ! ڥȥǡӳʻǡγǼˡˤĤƤ
  ! ISPACK/P3PACK Υޥ˥奢򻲾Ȥ줿. 
  !
  !== ؿѿ̾ȷˤĤ
  !
  !=== ̿̾ˡ
  !  
  ! * ؿ̾Ƭ (eee_, zyx_, x_, y_) , ֤ͤη򼨤Ƥ.
  !   eee_ :: ڥȥǡ( 1,2 3 줾 Z, Y,X ȿ)
  !   eee2 :: 2 ĤΥڥȥǡ¤
  !   zyx_ :; 3 ʻǡ( 1,2 3 줾 Z, Y,X γʻ)
  !   yx_ :: XY  2 ʻǡ 
  !   zy_ :: YZ  2 ʻǡ
  !   zx_ :: XZ  2 ʻǡ
  !   x_ :: X  1 ʻǡ
  !   y_ :: Y  1 ʻǡ
  !   z_ :: Z  1 ʻǡ
  !  
  ! * ؿ̾δ֤ʸ(Dx, Dy, Dz, Lapla, LaplaInv), 
  !   δؿκѤɽƤ.
  !
  ! * ؿ̾κǸ (_eee_eee,_eee,_zyx, _x, _y) , ѿη
  !   ڥȥǡӳʻǡǤ뤳Ȥ򼨤Ƥ.
  !   _eee     :: ڥȥǡ
  !   _eee_eee :: 2 ĤΥڥȥǡ
  !   _eee2    :: 2 ĤΥڥȥǡ¤
  !   _zyx     :: 3 ʻǡ
  !   _x       :: X  1 ʻǡ
  !   _y       :: Y  1 ʻǡ.
  !  
  !=== ƥǡμ
  !  
  ! * zyx : 2 ʻǡ.
  !   * ѿμȼ real(8), dimension(0:km-1,0:jm-1,0:im-1). 
  !   * im, jm, km Ϥ줾 X, Y Z ɸγʻǤ, ֥롼 
  !     eee_initial ˤƤ餫ꤷƤ.
  !   *  1  Z ɸγʻֹ,  2  Y ɸ, 
  !      3  X ɸγʻֹǤ뤳Ȥ.
  !     (X, Y, ZνǤϤʤ)
  !
  ! * eee : ڥȥǡ.
  !   * ѿμȼ real(8), dimension(-nm:nm,-mm:mm,-lm:lm). 
  !   * lm, mm, nm Ϥ줾 X, Y, ZκȿǤ, ֥롼 
  !     eee_initial ˤƤ餫ꤷƤ.
  !     (X, Y, Z ȿνǤϤʤ)Ȥ. 
  !   * ڥȥǡγǼΤˤĤƤ ISPACK/P3PACK 
  !     ޥ˥奢򻲾Ȥ뤳. 
  !
  ! * eee2 : 2 ĤΥڥȥǡΤʤ. 
  !   * ѿμȼ real(8), dimension(-nm:nm,-mm:mm,-lm:lm,2). 
  !
  ! * x, y, z : X, Y, Z  1 ʻǡ.
  !   * ѿμȼϤ줾 
  !     real(8), dimension(0:im-1),
  !     real(8), dimension(0:jm-1), 
  !      real(8), dimension(0:km-1).
  !
  ! * eee_ ǻϤޤؿ֤ͤϥڥȥǡƱ.
  !
  ! * zyx_ ǻϤޤؿ֤ͤ 3 ʻǡƱ.
  !
  ! * x_, y_ z_ ǻϤޤؿ֤ͤ 1 ʻǡƱ.
  !
  ! * ڥȥǡФʬκѤȤ, бʻǡ
  !   ʬʤɤѤǡ򥹥ڥȥѴΤȤǤ.
  !
  !== ѿ³
  !
  !====  
  !
  ! eee_Initial :: ڥȥѴγʻ, ȿ
  ! eee_ChangeResolution :: ѹ
  ! 
  !==== ɸѿ
  !
  ! x_X, y_Y, z_Z    ::  ʻɸ(X,Yɸ)Ǽ 1 
  ! x_X_Weight, y_Y_Weight,  z_Z_Weight ::  ŤߺɸǼ 1 
  ! zyx_X, zyx_Y, zyx_Z  :: ʻǡ XYZ ɸ(X,Y,Z)
  !                         (ʻǡ 3 )
  !
  !==== Ѵ
  !
  ! zyx_eee :: ڥȥǡʻҥǡؤѴ
  ! eee_zyx :: ʻҥǡ饹ڥȥǡؤѴ
  ! xyz_zyx :: ʻǡźѴ
  !
  !==== ʬ
  !
  ! eee_Lapla_eee       :: ڥȥǡ˥ץ饷Ѥ
  ! eee_LaplaInv_eee    :: ڥȥǡ˥ץ饷εѴѤ
  ! eee_Dx_eee          :: ڥȥǡ X ʬѤ
  ! eee_Dy_eee          :: ڥȥǡ Y ʬѤ
  ! eee_Dz_eee          :: ڥȥǡ Z ʬѤ
  !
  !==== ׻
  !
  ! eee2_RotVelxVor_eee2   :: Euler ׻
  ! eee_VorFromZeta_eee2   ::  2 ʬ(_1, _2)鱲٤ 1 ʬ׻
  ! eee_VelFromZeta_eee2   ::  2 ʬ(_1, _2)®٤ 1 ʬ׻
  ! eee2_ZetaFromVor_eee_eee_eee :: ٤鱲 2 ʬ(_1, _2)׻
  !
  !==== ʬʿ
  !
  ! IntZYX_zyx, AvrZYX_zyx   :: 3 ʻǡΰʬʿ
  ! z_IntYX_zyx, z_AvrYX_zyx :: 3 ʻǡ X,Y ʬʿ
  ! x_IntZY_zyx, x_AvrZY_zyx :: 3 ʻǡ Y,Z ʬʿ
  ! y_IntZX_zyx, y_AvrZX_zyx :: 3 ʻǡ Z,X ʬʿ
  ! zy_IntX_zyx, zy_AvrX_zyx :: 3 ʻǡ X ʬʿ
  ! zx_IntY_zyx, zx_AvrY_zyx :: 3 ʻǡ Y ʬʿ
  ! yx_IntZ_zyx, yx_AvrZ_zyx :: 3 ʻǡ Z ʬʿ
  !
  ! IntYX_yx,  AvrYX_yx  :: 2 (XY)ʻǡ X,Y ʬʿ
  ! y_IntX_yx, y_AvrX_yx :: 2 (XY)ʻǡ X ʬʿ
  ! x_IntY_yx, x_AvrY_yx :: 2 (XY)ʻǡ Y ʬʿ
  ! IntZX_zx, AvrZX_zx   :: 2 (ZX)ʻǡ Z,X ʬʿ
  ! z_IntX_zx, z_AvrX_zx :: 2 (ZX)ʻǡ X ʬʿ
  ! x_IntZ_zx, x_AvrZ_zx :: 2 (ZX)ʻǡ Z ʬʿ
  ! IntZY_zy, AvrZY_zy   :: 2 (YZ)ʻǡ Y,Z ʬʿ
  ! y_IntZ_zy, y_AvrZ_zy :: 2 (YZ)ʻǡ Z ʬʿ
  ! z_IntY_zy, z_AvrY_zy :: 2 (YZ)ʻǡ Y ʬʿ
  !
  ! IntX_x, AvrX_x       :: 1 (X)ʻǡ X ʬʿ
  ! IntY_y, AvrY_y       :: 1 (Y)ʻǡ Y ʬʿ
  ! IntZ_z, AvrZ_z       :: 1 (Z)ʻǡ Z ʬʿ
  !
  !==== ڥȥ
  !
  ! EnergyHelicityFromZeta_eee2  :: ͥ륮إꥷƥ׻. 
  ! ESpectralFromZeta            :: ͥ륮ڥȥ׻. 
  !
  use dc_message, only : MessageNotify
  implicit none

  private
  public eee_Initial                                  ! 롼
  public eee_ChangeResolution                         ! ѹ
  public zyx_eee, eee_zyx, xyz_zyx                    ! Ѵ
  public eee_Dx_eee, eee_Dy_eee, eee_Dz_eee           ! ʬ
  public eee_Lapla_eee, eee_LaplaInv_eee              ! ʬ
  public eee2_RotVelxVor_eee2                         ! ׻
  public eee_VorFromZeta_eee2, eee_VelFromZeta_eee2   ! ®ٷ׻
  public eee2_ZetaFromVor_eee_eee_eee                 ! Ѵ

  public IntZYX_zyx, AvrZYX_zyx                       ! ʬʿ
  public z_IntYX_zyx, z_AvrYX_zyx                     ! ʬʿ
  public x_IntZY_zyx, x_AvrZY_zyx                     ! ʬʿ
  public y_IntZX_zyx, y_AvrZX_zyx                     ! ʬʿ
  public zy_IntX_zyx, zy_AvrX_zyx                     ! ʬʿ
  public zx_IntY_zyx, zx_AvrY_zyx                     ! ʬʿ
  public yx_IntZ_zyx, yx_AvrZ_zyx                     ! ʬʿ

  public IntYX_yx,  AvrYX_yx                          ! ʬʿ
  public y_IntX_yx, y_AvrX_yx                         ! ʬʿ
  public x_IntY_yx, x_AvrY_yx                         ! ʬʿ
  public IntZX_zx, AvrZX_zx                           ! ʬʿ
  public z_IntX_zx, z_AvrX_zx                         ! ʬʿ
  public x_IntZ_zx, x_AvrZ_zx                         ! ʬʿ
  public IntZY_zy, AvrZY_zy                           ! ʬʿ
  public y_IntZ_zy, y_AvrZ_zy                         ! ʬʿ
  public z_IntY_zy, z_AvrY_zy                         ! ʬʿ

  public IntX_x, AvrX_x                               ! ʬʿ
  public IntY_y, AvrY_y                               ! ʬʿ
  public IntZ_z, AvrZ_z                               ! ʬʿ

  public EnergyHelicityFromZeta_eee2                  ! ͥ륮إꥷƥ
  public ESpectralFromZeta                            ! ͥ륮ڥȥ

  public x_X, y_Y, z_Z                                ! ɸѿ
  public x_X_Weight, y_Y_Weight, z_Z_Weight           ! ɸѿ
  public zyx_X, zyx_Y, zyx_Z                          ! ɸѿ

  integer   :: im=32, jm=32, km=32                    ! ʻ(X,Y,Z)
  integer   :: lm=10, mm=10, nm=10                    ! ȿ(X,Y,Z)
  real(8)   :: xl=1.0, yl=1.0, zl=1.0                 ! ΰ礭


  integer, dimension(:),   pointer :: itk => null()
  real(8), dimension(:),   pointer :: tk => null()
  integer, dimension(:),   pointer :: itj => null()
  real(8), dimension(:),   pointer :: tj => null()
  integer, dimension(:),   pointer :: iti => null()
  real(8), dimension(:),   pointer :: ti => null()


  real(8), dimension(:),   pointer :: x_X => null()   ! ʻɸ(X)
  real(8), dimension(:),   pointer :: y_Y => null()   ! ʻɸ(Y)
  real(8), dimension(:),   pointer :: z_Z => null()   ! ʻɸ(Y)

  real(8), dimension(:),   pointer :: x_X_Weight => null()
                                         ! ʻŤ(X)
                                         ! X γʻδֳ֤ǼƤ.
  real(8), dimension(:),   pointer :: y_Y_Weight => null()
                                         ! ʻŤ(Y)
                                         ! Y γʻδֳ֤ǼƤ.
  real(8), dimension(:),   pointer :: z_Z_Weight => null()
                                         ! ʻŤ(Y)
                                         ! Z γʻδֳ֤ǼƤ.

  real(8), dimension(:,:,:), pointer :: zyx_X => null()
                          ! ʻ(X)ɸ(3 )
                          ! Ƴʻ(i,j,k)ΰ֤ X ɸǼʻҥǡ
  real(8), dimension(:,:,:), pointer :: zyx_Y => null()
                          ! ʻ(Y)ɸ(3 )
                          ! Ƴʻ(i,j,k)ΰ֤ Y ɸǼʻҥǡ
  real(8), dimension(:,:,:), pointer :: zyx_Z => null()
                          ! ʻ(Z)ɸ(3 )
                          ! Ƴʻ(i,j,k)ΰ֤ Z ɸǼʻҥǡ

  real(8), dimension(:),   pointer :: w => null(), ws => null(), wg => null()
  real(8), dimension(:,:,:), pointer :: zyx_tmp => null()

  integer, parameter :: nparams_max = 10  ! eee_Initial Ƥ٤
  type eee_param                          ! ΰ¤
     integer   :: im, jm, km
     integer   :: lm, mm, nm
     integer, dimension(:),     pointer :: itk
     real(8), dimension(:),     pointer :: tk
     integer, dimension(:),     pointer :: itj
     real(8), dimension(:),     pointer :: tj
     integer, dimension(:),     pointer :: iti
     real(8), dimension(:),     pointer :: ti
     real(8), dimension(:),     pointer :: x_X
     real(8), dimension(:),     pointer :: y_Y
     real(8), dimension(:),     pointer :: z_Z
     real(8), dimension(:),     pointer :: x_X_Weight
     real(8), dimension(:),     pointer :: y_Y_Weight
     real(8), dimension(:),     pointer :: z_Z_Weight
     real(8), dimension(:,:,:), pointer :: zyx_X
     real(8), dimension(:,:,:), pointer :: zyx_Y 
     real(8), dimension(:,:,:), pointer :: zyx_Z
     real(8), dimension(:),     pointer :: w, ws, wg
     real(8), dimension(:,:,:), pointer :: zyx_tmp
  end type eee_param
  type(eee_param) :: params(nparams_max)  ! ΰ
  integer :: nparams                      ! ΰθĿ

  real(8), parameter  :: pi=3.1415926535897932385D0

  save im, jm, km, lm, mm, nm, itk, tk, itj, tj, iti, ti
  save x_X, y_Y, z_Z, x_X_Weight, y_Y_Weight, z_Z_Weight, zyx_X, zyx_Y, zyx_Z
  save params, nparams

  contains
  !---------------  -----------------
    subroutine eee_Initial(i,j,k,l,m,n,id)
      !
      ! ڥȥѴγʻ, ȿꤹ.
      ! ΰϰϤ [0,2pi]x[0,2pi]x[0,2pi] ˷Ǥ
      !
      ! ¾δؿѿƤ, ǽˤΥ֥롼Ƥ
      ! 򤷤ʤФʤʤ.
      !
      ! ץʥ id Ѥưۤʤ, ΰƱ
      ! ȤǤ. eee_Initial , ΰ褴Ȥ˸Ƥ
      !  id 򥭡פ, eee_ChangeResolution ؤ. 
      !
      integer,intent(in) :: i           ! ʻ(X)
      integer,intent(in) :: j           ! ʻ(Y)
      integer,intent(in) :: k           ! ʻ(Z)
      integer,intent(in) :: l           ! ȿ(X)
      integer,intent(in) :: m           ! ȿ(Y)
      integer,intent(in) :: n           ! ȿ(X)

      integer, intent(out), optional :: id  ! ΰֹ

      character(len=3) cid
      integer :: ii, jj, kk

      im = i         ; jm = j         ; km = k
      lm = l         ; mm = m         ; nm = n

      if ( nparams .ge. nparams_max ) then
         call MessageNotify('W','eee_initial',&
              'too many call of eee_Initial, nothing was done.')
         if ( present(id) ) id = -1
         return
      end if

      nparams = nparams + 1

      params(nparams)%im = im
      params(nparams)%jm = jm
      params(nparams)%km = km
      params(nparams)%lm = lm
      params(nparams)%mm = mm
      params(nparams)%nm = nm

      allocate(params(nparams)%itk(5))
      allocate(params(nparams)%itj(5))
      allocate(params(nparams)%iti(5))
      allocate(params(nparams)%tk(km*2))
      allocate(params(nparams)%tj(jm*2))
      allocate(params(nparams)%ti(im*2))
      allocate(params(nparams)%w(km*jm*im))
      allocate(params(nparams)%ws((2*lm+1)*(2*mm+1)*(2*nm+1)))
      allocate(params(nparams)%wg(km*jm*im*4))
      allocate(params(nparams)%zyx_tmp(0:km-1,0:jm-1,0:im-1))

      allocate(params(nparams)%x_X(0:im-1))
      allocate(params(nparams)%x_X_Weight(0:im-1))
      allocate(params(nparams)%y_Y(0:jm-1))
      allocate(params(nparams)%y_Y_Weight(0:jm-1))
      allocate(params(nparams)%z_Z(0:km-1))
      allocate(params(nparams)%z_Z_Weight(0:km-1))
      allocate(params(nparams)%zyx_X(0:km-1,0:jm-1,0:im-1))
      allocate(params(nparams)%zyx_Y(0:km-1,0:jm-1,0:im-1))
      allocate(params(nparams)%zyx_Z(0:km-1,0:jm-1,0:im-1))

      call eee_ChangeResolution(nparams)

      call p3init(km,jm,im,itk,tk,itj,tj,iti,ti)

      do ii=0,im-1
         x_X(ii) = 2*pi/im*ii
      enddo
      x_X_Weight = 2*pi/im

      do jj=0,jm-1
         y_Y(jj) = 2*pi/jm*jj
      enddo
      y_Y_Weight = 2*pi/jm

      do kk=0,km-1
         z_Z(kk) = 2*pi/km*kk
      enddo
      z_Z_Weight = 2*pi/km

      zyx_X = spread(spread(x_X,1,jm),1,km)
      zyx_Y = spread(spread(y_Y,2,im),1,km)
      zyx_Z = spread(spread(z_Z,2,jm),3,im)

      if ( present(id) ) id = nparams

      write(cid,'(I3)') nparams
      call MessageNotify('M','eee_initial','eee_module is initialized')
      call MessageNotify('M','eee_initial',&
           'Resolution ID is '//trim(adjustl(cid)))
    end subroutine eee_initial

  !--------------- id ѹ -----------------
    subroutine eee_ChangeResolution(id)
      !
      ! ѹ. eee_Initial ꤹݤ
      ! äƤ륪ץʥ id ͤѤ. 
      ! 
      integer, intent(in) :: id

      if (id .gt. nparams .or. id .lt. 1) then
         write(*,*)"id is invalid"
      end if

      im = params(id)%im
      jm = params(id)%jm
      km = params(id)%km
      lm = params(id)%lm
      mm = params(id)%mm
      nm = params(id)%nm
      itk => params(id)%itk
      tk => params(id)%tk
      itj => params(id)%itj
      tj => params(id)%tj
      iti => params(id)%iti
      ti => params(id)%ti
      x_X => params(id)%x_X
      y_Y => params(id)%y_Y
      z_Z => params(id)%z_Z
      x_X_Weight => params(id)%x_X_Weight
      y_Y_Weight => params(id)%y_Y_Weight
      z_Z_Weight => params(id)%z_Z_Weight
      zyx_X => params(id)%zyx_X
      zyx_Y => params(id)%zyx_Y
      zyx_Z => params(id)%zyx_Z
      w => params(id)%w
      ws => params(id)%ws
      wg => params(id)%wg
      zyx_tmp => params(id)%zyx_tmp

    end subroutine eee_ChangeResolution

  !--------------- Ѵ -----------------
    function zyx_eee(eee)
      !
      ! ڥȥǡʻҥǡѴ.
      !
      real(8), dimension(0:km-1,0:jm-1,0:im-1)             :: zyx_eee 
                                                        !(out) ʻǡ
      real(8), dimension(-nm:nm,-mm:mm,-lm:lm), intent(in) :: eee
                                                        !(in)  ڥȥǡ

      call p3s2ga(nm,mm,lm,km,jm,im,eee,zyx_eee,w,itk,tk,itj,tj,iti,ti)
    end function zyx_eee

    function eee_zyx(zyx)
      !
      ! ʻҥǡ饹ڥȥǡѴ.
      !
      real(8), dimension(-nm:nm,-mm:mm,-lm:lm)              :: eee_zyx
                                                      !(out)  ڥȥǡ
      real(8), dimension(0:km-1,0:jm-1,0:im-1), intent(in)  :: zyx
                                                      !(in) ʻǡ

      zyx_tmp = zyx
      call p3g2sa(nm,mm,lm,km,jm,im,zyx_tmp,eee_zyx,w,itk,tk,itj,tj,iti,ti)
    end function eee_zyx

    function xyz_zyx(zyx)
      !
      ! ʻҥǡźѹ
      !
      real(8), dimension(0:im-1,0:jm-1,0:km-1)             :: xyz_zyx
                                                        !(out) ʻǡ

      real(8), dimension(0:km-1,0:jm-1,0:im-1), intent(in)  :: zyx
                                                      !(in) ʻǡ
      integer :: i,j,k

      do k=0,km-1
         do j=0,jm-1
            do i=0,im-1
               xyz_zyx(i,j,k) = zyx(k,j,i)
            enddo
         enddo
      enddo

    end function xyz_zyx
    
  !--------------- ʬ׻ -----------------
    function eee_Lapla_eee(eee)
      !
      ! ϥڥȥǡ˥ץ饷(xx+yy+zz)Ѥ.
      !
      ! ڥȥǡΥץ饷Ȥ, бʻǡ
      ! ץ饷ѤǡΥڥȥѴΤȤǤ.
      !
      ! ºݤˤϥڥȥǡȿ (l**2 + m**2 + n**2) 򤫤
      ! ׻ԤäƤ. 
      !
      real(8), dimension(-nm:nm,-mm:mm,-lm:lm)              :: eee_Lapla_eee
      !(out) ڥȥǡΥץ饷

      real(8), dimension(-nm:nm,-mm:mm,-lm:lm), intent(in)  :: eee
      !(in) ϥڥȥǡ

      integer l,m,n
      ! ѿ

         do l=-lm,lm
            do m=-mm,mm
               do n=-nm,nm
                  eee_Lapla_eee(n,m,l) = -(l**2+m**2+n**2)*eee(n,m,l)
               enddo
            enddo
         enddo
    end function eee_Lapla_eee

    function eee_LaplaInv_eee(eee)
      !
      ! ϥڥȥǡ˵եץ饷(xx+yy+zz)**(-1)Ѥ.
      !
      ! ڥȥǡεեץ饷Ȥ, бʻǡ
      ! եץ饷ѤǡΥڥȥѴΤȤǤ.
      !
      ! ºݤˤϥڥȥǡȿ (l**2 + m**2 + n**2) ǳ
      ! ׻ԤäƤ. l=m=n=0 ʬˤ 0 Ƥ. 
      !
      real(8), dimension(-nm:nm,-mm:mm,-lm:lm)             :: eee_LaplaInv_eee
      !(out) ڥȥǡεեץ饷

      real(8), dimension(-nm:nm,-mm:mm,-lm:lm), intent(in) :: eee
      !(in) ڥȥǡ

      integer l,m,n

      do l=-lm,lm
         do m=-mm,mm
            do n=-nm,nm
               if ( l.ne.0 .or. m.ne.0 .or. n.ne.0 ) then
                  eee_LaplaInv_eee(n,m,l) = -eee(n,m,l)/(l**2+m**2+n**2)
               else
                  eee_LaplaInv_eee(n,m,l) = 0.0
               endif
            enddo
         enddo
      enddo
    end function eee_LaplaInv_eee

    function eee_Dx_eee(eee)
      !
      ! ϥڥȥǡ X ʬ(x)Ѥ.
      !
      ! ڥȥǡ X ʬȤ, бʻǡ X ʬ
      ! ѤǡΥڥȥѴΤȤǤ.
      !
      ! ºݤˤϥڥȥǡ X ȿ l 򤫤
      !  <-> ʬ촹׻ԤäƤ.
      !
      real(8), dimension(-nm:nm,-mm:mm,-lm:lm)              :: eee_Dx_eee
      !(out) ڥȥǡ X ʬ

      real(8), dimension(-nm:nm,-mm:mm,-lm:lm), intent(in)  :: eee
      !(in) ϥڥȥǡ

      integer l,m,n
      ! ѿ


      do l=-lm,lm
         do m=-mm,mm
            do n=-nm,nm
               eee_Dx_eee(n,m,l) = -l*eee(-n,-m,-l)
            enddo
         enddo
      enddo
    end function eee_Dx_eee

    function eee_Dy_eee(eee)
      !
      ! ϥڥȥǡ Y ʬ(y)Ѥ.
      !
      ! ڥȥǡ Y ʬȤ, бʻǡ Y ʬ
      ! ѤǡΥڥȥѴΤȤǤ.
      !
      ! ºݤˤϥڥȥǡ Y ȿ m 򤫤
      !  <-> ʬ촹׻ԤäƤ.
      !
      real(8), dimension(-nm:nm,-mm:mm,-lm:lm)              :: eee_Dy_eee
      !(out) ڥȥǡ X ʬ

      real(8), dimension(-nm:nm,-mm:mm,-lm:lm), intent(in)  :: eee
      !(in) ϥڥȥǡ

      integer l,m,n
      ! ѿ


      do l=-lm,lm
         do m=-mm,mm
            do n=-nm,nm
               eee_Dy_eee(n,m,l) = -m*eee(-n,-m,-l)
            enddo
         enddo
      enddo
    end function eee_Dy_eee

    function eee_Dz_eee(eee)
      !
      ! ϥڥȥǡ Z ʬ(z)Ѥ.
      !
      ! ڥȥǡ Z ʬȤ, бʻǡ Z ʬ
      ! ѤǡΥڥȥѴΤȤǤ.
      !
      ! ºݤˤϥڥȥǡ Z ȿ n 򤫤
      !  <-> ʬ촹׻ԤäƤ.
      !
      real(8), dimension(-nm:nm,-mm:mm,-lm:lm)              :: eee_Dz_eee
      !(out) ڥȥǡ X ʬ

      real(8), dimension(-nm:nm,-mm:mm,-lm:lm), intent(in)  :: eee
      !(in) ϥڥȥǡ

      integer l,m,n
      ! ѿ


      do l=-lm,lm
         do m=-mm,mm
            do n=-nm,nm
               eee_Dz_eee(n,m,l) = -n*eee(-n,-m,-l)
            enddo
         enddo
      enddo
    end function eee_Dz_eee

  !--------------- ׻ -----------------

    function eee2_RotVelxVor_eee2(eee2)
      !
      !   2 ʬ(_1, _2)Υڥȥǡ Euler 
      !
      !     x(u x ) 
      !
      !   2 ʬ׻.
      !
      !  (_1, _2) ȱ  Ȥδط ISPACK/P3PACK Υޥ˥奢򻲾
      !
      real(8), dimension(-nm:nm,-mm:mm,-lm:lm,2)     :: eee2_RotVelxVor_eee2
      !(out) Υڥȥǡ 2 Ĥʬ

      real(8), dimension(-nm:nm,-mm:mm,-lm:lm,2), intent(in)  :: eee2
      !(in) ϥڥȥǡ. ٤ 2 ʬ(_1, _2)

      call p3elnl(nm,mm,lm,km,jm,im,eee2,eee2_RotVelxVor_eee2, &
                  ws,wg,itk,tk,itj,tj,iti,ti)

    end function eee2_RotVelxVor_eee2

    function eee_VorFromZeta_eee2(eee2,isw)
      !
      !   2 ʬ(_1, _2)Υڥȥǡ鱲٤Υڥȥ 1 ʬ
      !  ׻.
      !
      !  (_1, _2) ȱ  Ȥδط ISPACK/P3PACK Υޥ˥奢򻲾
      !
      real(8), dimension(-nm:nm,-mm:mm,-lm:lm)     :: eee_VorFromZeta_eee2
      !(out) Υڥȥǡ 2 Ĥʬ

      real(8), dimension(-nm:nm,-mm:mm,-lm:lm,2), intent(in)  :: eee2
      !(in) ϥڥȥǡ. ٤ 2 ʬ(_1, _2)

      integer, intent(IN) :: isw
      !(in) Ϥ뱲٤ʬΥǥå(1,2,3)

      call p3geto(nm,mm,lm,eee2,eee_VorFromZeta_eee2,isw)

    end function eee_VorFromZeta_eee2

    function eee_VelFromZeta_eee2(eee2,isw)
      !
      !   2 ʬ(_1, _2)Υڥȥǡ®٥ڥȥ 1 ʬ
      !  ׻.
      !
      !  (_1, _2) ȱ  Ȥδط ISPACK/P3PACK Υޥ˥奢򻲾
      !
      real(8), dimension(-nm:nm,-mm:mm,-lm:lm)     :: eee_VelFromZeta_eee2
      !(out) Υڥȥǡ 2 Ĥʬ

      real(8), dimension(-nm:nm,-mm:mm,-lm:lm,2), intent(in)  :: eee2
      !(in) ϥڥȥǡ. ٤ 2 ʬ(_1, _2)

      integer, intent(IN) :: isw
      !(in) Ϥ뱲٤ʬΥǥå(1,2,3)

      call p3getu(nm,mm,lm,eee2,eee_VelFromZeta_eee2,isw)

    end function eee_VelFromZeta_eee2

    function eee2_ZetaFromVor_eee_eee_eee(eee_1,eee_2,eee_3)
      !
      !  ٤Υڥȥ뤫鱲 2 ʬ(_1, _2)׻.
      !
      !  (_1, _2) ȱ  Ȥδط ISPACK/P3PACK Υޥ˥奢򻲾
      !
      real(8), dimension(-nm:nm,-mm:mm,-lm:lm,2)     :: eee2_ZetaFromVor_eee_eee_eee
      !(out) ٤ 2 ʬ(_1, _2)

      real(8), dimension(-nm:nm,-mm:mm,-lm:lm), intent(in)  :: eee_1, eee_2, eee_3
      !(in) ٥ڥȥǡγʬ

      integer :: l,m,n

      do l=-lm,lm
         do m=-mm,mm
            do n=-nm,nm
               if ( l /= 0 ) then
                  eee2_ZetaFromVor_eee_eee_eee(n,m,l,1) = eee_2(n,m,l)
                  eee2_ZetaFromVor_eee_eee_eee(n,m,l,2) = eee_3(n,m,l)
               elseif( m /= 0 ) then
                  eee2_ZetaFromVor_eee_eee_eee(n,m,l,1) = eee_3(n,m,l)
                  eee2_ZetaFromVor_eee_eee_eee(n,m,l,2) = eee_1(n,m,l)
               else
                  eee2_ZetaFromVor_eee_eee_eee(n,m,l,1) = eee_1(n,m,l)
                  eee2_ZetaFromVor_eee_eee_eee(n,m,l,2) = eee_2(n,m,l)
               endif
            enddo
         enddo
      enddo

    end function eee2_ZetaFromVor_eee_eee_eee

  !--------------- ʬ׻ -----------------
    function IntZYX_zyx(zyx)
      !
      ! 2 ʻǡΰʬ
      !
      ! ºݤˤϳʻǡ x_X_Weight, y_Y_Weight, z_Z_Weight 򤫤
      ! ¤׻Ƥ. 
      !
      real(8), dimension(0:km-1,0:jm-1,0:im-1), intent(IN)   :: zyx
      !(in)  3 ʻǡ

      real(8)                                    :: IntZYX_zyx
      !(out) ʬ

      integer :: i, j, k
      ! ѿ

      IntZYX_zyx = 0.0d0
      do i=0,im-1
         do j=0,jm-1
            do k=0,km-1
               IntZYX_zyx = IntZYX_zyx &
                    + zyx(k,j,i) * z_Z_Weight(k) * y_Y_Weight(j) * x_X_Weight(i)
            enddo
         enddo
      end do
    end function IntZYX_zyx

    function z_IntYX_zyx(zyx)
      !
      ! 3 ʻǡ X,Y ʬ
      !
      ! ºݤˤϳʻǡ x_X_Weight, y_Y_Weight 򤫤
      ! ¤׻Ƥ. 
      !
      real(8), dimension(0:km-1,0:jm-1,0:im-1), intent(IN)   :: zyx
      !(in) 2 ʻǡ

      real(8), dimension(0:km-1)          :: z_IntYX_zyx
      !(out) ʬ줿 1 (Y)ʻǡ

      integer :: i, j
      ! ѿ

      z_IntYX_zyx = 0.0d0
      do i=0,im-1
         do j=0,jm-1
            z_IntYX_zyx(:) = &
                 z_IntYX_zyx(:) + zyx(:,j,i) * x_X_Weight(i)* y_Y_Weight(j)
         enddo
      enddo
    end function z_IntYX_zyx

    function y_IntZX_zyx(zyx)
      !
      ! 3 ʻǡ X,Z ʬ
      !
      ! ºݤˤϳʻǡ x_X_Weight, z_Z_Weight 򤫤
      ! ¤׻Ƥ. 
      !
      real(8), dimension(0:km-1,0:jm-1,0:im-1), intent(IN)   :: zyx
      !(in) 2 ʻǡ

      real(8), dimension(0:jm-1)          :: y_IntZX_zyx
      !(out) ʬ줿 1 (Y)ʻǡ

      integer :: i, k
      ! ѿ

      y_IntZX_zyx = 0.0d0
      do i=0,im-1
         do k=0,km-1
            y_IntZX_zyx(:) = &
                 y_IntZX_zyx(:) + zyx(k,:,i) * x_X_Weight(i)* z_Z_Weight(k)
         enddo
      enddo
    end function y_IntZX_zyx

    function x_IntZY_zyx(zyx)
      !
      ! 3 ʻǡ Y,Z ʬ
      !
      ! ºݤˤϳʻǡ y_Y_Weight, z_Z_Weight 򤫤
      ! ¤׻Ƥ. 
      !
      real(8), dimension(0:km-1,0:jm-1,0:im-1), intent(IN)   :: zyx
      !(in) 2 ʻǡ

      real(8), dimension(0:im-1)          :: x_IntZY_zyx
      !(out) ʬ줿 1 (Y)ʻǡ

      integer :: j, k
      ! ѿ

      x_IntZY_zyx = 0.0d0
      do j=0,jm-1
         do k=0,km-1
            x_IntZY_zyx(:) = &
                 x_IntZY_zyx(:) + zyx(k,j,:) * y_Y_Weight(j)* z_Z_Weight(k)
         enddo
      enddo
    end function x_IntZY_zyx

    function zy_IntX_zyx(zyx)
      !
      ! 3 ʻǡ X ʬ
      !
      ! ºݤˤϳʻǡ x_X_Weight 򤫤
      ! ¤׻Ƥ. 
      !
      real(8), dimension(0:km-1,0:jm-1,0:im-1), intent(IN)   :: zyx
      !(in) 2 ʻǡ

      real(8), dimension(0:km-1,0:jm-1)          :: zy_IntX_zyx
      !(out) ʬ줿 2 (ZY)ʻǡ

      integer :: i
      ! ѿ

      zy_IntX_zyx = 0.0d0
      do i=0,im-1
         zy_IntX_zyx(:,:) = zy_IntX_zyx(:,:) + zyx(:,:,i) * x_X_Weight(i)
      enddo

    end function zy_IntX_zyx

    function zx_IntY_zyx(zyx)
      !
      ! 3 ʻǡ Y ʬ
      !
      ! ºݤˤϳʻǡ y_Y_Weight 򤫤
      ! ¤׻Ƥ. 
      !
      real(8), dimension(0:km-1,0:jm-1,0:im-1), intent(IN)   :: zyx
      !(in) 2 ʻǡ

      real(8), dimension(0:km-1,0:im-1)          :: zx_IntY_zyx
      !(out) ʬ줿 1 (Y)ʻǡ

      integer :: j
      ! ѿ

      zx_IntY_zyx = 0.0d0
      do j=0,jm-1
         zx_IntY_zyx(:,:) = zx_IntY_zyx(:,:) + zyx(:,j,:) * y_Y_Weight(j)
      enddo
    end function zx_IntY_zyx

    function yx_IntZ_zyx(zyx)
      !
      ! 3 ʻǡ Z ʬ
      !
      ! ºݤˤϳʻǡ z_Z_Weight 򤫤
      ! ¤׻Ƥ. 
      !
      real(8), dimension(0:km-1,0:jm-1,0:im-1), intent(IN)   :: zyx
      !(in) 2 ʻǡ

      real(8), dimension(0:jm-1,0:im-1)          :: yx_IntZ_zyx
      !(out) ʬ줿 1 (YX)ʻǡ

      integer :: k 
      ! ѿ

      yx_IntZ_zyx = 0.0d0
      do k=0,km-1
         yx_IntZ_zyx(:,:) = yx_IntZ_zyx(:,:) + zyx(k,:,:) * z_Z_Weight(k)
      enddo

    end function yx_IntZ_zyx

    function IntYX_yx(yx)
      !
      ! 2 (YX)ʻǡΰʬ
      !
      ! ºݤˤϳʻǡ x_X_Weight, y_Y_Weight 򤫤
      ! ¤׻Ƥ. 
      !
      real(8), dimension(0:jm-1,0:im-1), intent(IN)   :: yx          
      !(in)  2 (YX)ʻǡ

      real(8)                             :: IntYX_yx
      !(out) ʬ

      integer :: i, j
      ! ѿ

      IntYX_yx = 0.0d0
      do i=0,im-1
         do j=0,jm-1
            IntYX_yx = IntYX_yx + yx(j,i) * y_Y_Weight(j) * x_X_Weight(i)
         enddo
      enddo
    end function IntYX_yx

    function y_IntX_yx(yx)
      !
      ! 2 (YX)ʻǡ X ʬ
      !
      ! ºݤˤϳʻǡ x_X_Weight 򤫤¤׻Ƥ. 
      !
      real(8), dimension(0:jm-1,0:im-1), intent(IN)   :: yx
      !(in) 2 (YX)ʻǡ

      real(8), dimension(0:jm-1)          :: y_IntX_yx
      !(out) ʬ줿 1 (Y)ʻǡ

      integer :: i
      ! ѿ

      y_IntX_yx = 0.0d0
      do i=0,im-1
         y_IntX_yx(:) = y_IntX_yx(:) + yx(:,i) * x_X_Weight(i)
      enddo
    end function y_IntX_yx

    function x_IntY_yx(yx)
      !
      ! 2 (YX)ʻǡ Y ʬ
      !
      ! ºݤˤϳʻǡ y_Y_Weight 򤫤¤׻Ƥ. 
      !
      real(8), dimension(0:jm-1,0:im-1), intent(IN)   :: yx      
      !(in)  2 (YX)ʻǡ

      real(8), dimension(0:im-1)        :: x_IntY_yx 
      !(out) ʬ줿 1 (X)ʻǡ

      integer :: j
      ! ѿ

      x_IntY_yx = 0.0d0
      do j=0,jm-1
         x_IntY_yx(:) = x_IntY_yx(:) + yx(j,:) * y_Y_Weight(j)
      enddo
    end function x_IntY_yx

    function IntZY_zy(zy)
      !
      ! 2 (ZY)ʻǡΰʬʿ.
      !
      ! ºݤˤϳʻǡ z_Z_Weight, y_Y_Weight 򤫤
      ! ¤׻Ƥ. 
      !
      real(8), dimension(0:km-1,0:jm-1), intent(IN)   :: zy          
      !(in)  2 (ZY)ʻǡ

      real(8)                             :: IntZY_zy
      !(out) ʬ

      integer :: j, k
      ! ѿ

      IntZY_zy = 0.0d0
      do j=0,jm-1
         do k=0,km-1
            IntZY_zy = IntZY_zy + zy(k,j) * y_Y_Weight(j) * z_Z_Weight(k)
         enddo
      enddo
    end function IntZY_zy

    function y_IntZ_zy(zy)
      !
      ! 2 (ZY)ʻǡ Z ʬ
      !
      ! ºݤˤϳʻǡ z_Z_Weight 򤫤¤׻Ƥ. 
      !
      real(8), dimension(0:km-1,0:jm-1), intent(IN)   :: zy          
      !(in)  2 (ZY)ʻǡ

      real(8), dimension(0:jm-1)          :: y_IntZ_zy
      !(out) ʬ줿 1 (Y)ʻǡ

      integer :: k
      ! ѿ

      y_IntZ_zy = 0.0d0
      do k=0,km-1
         y_IntZ_zy(:) = y_IntZ_zy(:) + zy(k,:) * z_Z_Weight(k)
      enddo
    end function y_IntZ_zy

    function z_IntY_zy(zy)
      !
      ! 2 (ZY)ʻǡ Y ʬ
      !
      ! ºݤˤϳʻǡ y_Y_Weight 򤫤¤׻Ƥ. 
      !
      real(8), dimension(0:km-1,0:jm-1), intent(IN)   :: zy          
      !(in)  2 ʻǡ

      real(8), dimension(0:km-1)        :: z_IntY_zy 
      !(out) ʬ줿 1 (X)ʻǡ

      integer :: j
      ! ѿ

      z_IntY_zy = 0.0d0
      do j=0,jm-1
         z_IntY_zy(:) = z_IntY_zy(:) + zy(:,j) * y_Y_Weight(j)
      enddo
    end function z_IntY_zy

    function IntZX_zx(zx)
      !
      ! 2 (ZX)ʻǡΰʬʿ.
      !
      ! ºݤˤϳʻǡ z_Z_Weight, x_X_Weight 򤫤
      ! ¤׻Ƥ. 
      !
      real(8), dimension(0:km-1,0:im-1), intent(IN)   :: zx          
      !(in)  2 (ZX)ʻǡ

      real(8)                             :: IntZX_zx
      !(out) ʬ

      integer :: i, k
      ! ѿ

      IntZX_zx = 0.0d0
      do i=0,im-1
         do k=0,km-1
            IntZX_zx = IntZX_zx + zx(k,i) * x_X_Weight(i) * z_Z_Weight(k)
         enddo
      enddo
    end function IntZX_zx

    function x_IntZ_zx(zx)
      !
      ! 2 (ZX)ʻǡ Z ʬ
      !
      ! ºݤˤϳʻǡ z_Z_Weight 򤫤¤׻Ƥ. 
      !
      real(8), dimension(0:km-1,0:im-1), intent(IN)   :: zx          
      !(in)  2 (ZX)ʻǡ

      real(8), dimension(0:im-1)          :: x_IntZ_zx
      !(out) ʬ줿 1 (Y)ʻǡ

      integer :: k
      ! ѿ

      x_IntZ_zx = 0.0d0
      do k=0,km-1
         x_IntZ_zx(:) = x_IntZ_zx(:) + zx(k,:) * z_Z_Weight(k)
      enddo
    end function x_IntZ_zx

    function z_IntX_zx(zx)
      !
      ! 2 (ZX)ʻǡ X ʬ
      !
      ! ºݤˤϳʻǡ x_X_Weight 򤫤¤׻Ƥ. 
      !
      real(8), dimension(0:km-1,0:im-1), intent(IN)   :: zx          
      !(in)  2 ʻǡ

      real(8), dimension(0:km-1)        :: z_IntX_zx 
      !(out) ʬ줿 1 (X)ʻǡ

      integer :: i
      ! ѿ

      z_IntX_zx = 0.0d0
      do i=0,im-1
         z_IntX_zx(:) = z_IntX_zx(:) + zx(:,i) * x_X_Weight(i)
      enddo
    end function z_IntX_zx

    function IntX_x(x)
      !
      ! 1 (X)ʻǡ X ʬ
      !
      ! ºݤˤϳʻǡ x_X_Weight 򤫤¤׻Ƥ. 
      !
      real(8), dimension(0:im-1)   :: x          !(in)  1 ʻǡ
      real(8)                      :: IntX_x     !(out) ʬ

      IntX_x = sum(x*x_X_Weight)
    end function IntX_x

    function IntY_y(y)
      !
      ! 1 (Y)ʻǡ Y ʬ
      !
      ! ºݤˤϳʻǡ y_Y_Weight 򤫤¤׻Ƥ. 
      !
      real(8), dimension(0:jm-1)   :: y          !(in)  1 ʻǡ
      real(8)                      :: IntY_y     !(out) ʬ

      IntY_y = sum(y*y_Y_Weight)
    end function IntY_y

    function IntZ_z(z)
      !
      ! 1 (Z)ʻǡ Z ʬ
      !
      ! ºݤˤϳʻǡ z_Z_Weight 򤫤¤׻Ƥ. 
      !
      real(8), dimension(0:km-1)   :: z         !(in)  1 ʻǡ
      real(8)                      :: IntZ_z     !(out) ʬ

      IntZ_z = sum(z*z_Z_Weight)
    end function IntZ_z

  !--------------- ʿѷ׻ -----------------
    function AvrZYX_zyx(zyx)
      !
      ! 2 ʻǡΰʿ.
      !
      ! ºݤˤϳʻǡ x_X_Weight, y_Y_Weight, z_Z_Weight 
      ! ¤׻, x_X_Weight*y_Y_Weight*z_Z_Weight ¤ǳ
      ! ȤʿѤƤ. 
      !
      real(8), dimension(0:km-1,0:jm-1,0:im-1), intent(IN)   :: zyx
      !(in)  3 ʻǡ

      real(8)                                    :: AvrZYX_zyx
      !(out) ʬ

      AvrZYX_zyx = IntZYX_zyx(zyx)/(sum(x_X_weight)*sum(y_Y_weight)*sum(z_Z_weight))

    end function AvrZYX_zyx

    function z_AvrYX_zyx(zyx)
      !
      ! 3 ʻǡ X,Y ʿ
      !
      ! ºݤˤϳʻǡ x_X_Weight, y_Y_Weight 򤫤
      ! ¤׻, x_X_Weight*y_Y_Weight ¤ǳ뤳ȤʿѤƤ. 
      !
      real(8), dimension(0:km-1,0:jm-1,0:im-1), intent(IN)   :: zyx
      !(in) 2 ʻǡ

      real(8), dimension(0:km-1)          :: z_AvrYX_zyx
      !(out) ʬ줿 1 (Y)ʻǡ

      z_AvrYX_zyx = z_IntYX_zyx(zyx)/(sum(x_X_weight)*sum(y_Y_weight))

    end function z_AvrYX_zyx

    function y_AvrZX_zyx(zyx)
      !
      ! 3 ʻǡ X,Z ʿ
      !
      ! ºݤˤϳʻǡ x_X_Weight, z_Z_Weight 򤫤
      ! ¤׻, x_X_Weight*z_Z_Weight ¤ǳ뤳ȤʿѤƤ. 
      !
      real(8), dimension(0:km-1,0:jm-1,0:im-1), intent(IN)   :: zyx
      !(in) 2 ʻǡ

      real(8), dimension(0:jm-1)          :: y_AvrZX_zyx
      !(out) ʬ줿 1 (Y)ʻǡ

      y_AvrZX_zyx = y_IntZX_zyx(zyx)/(sum(x_X_weight)*sum(z_Z_weight))

    end function y_AvrZX_zyx

    function x_AvrZY_zyx(zyx)
      !
      ! 3 ʻǡ Y,Z ʿ
      !
      ! ºݤˤϳʻǡ y_Y_Weight, z_Z_Weight 򤫤
      ! ¤׻, y_Y_Weight*z_Z_Weight ¤ǳ뤳ȤʿѤƤ. 
      !
      real(8), dimension(0:km-1,0:jm-1,0:im-1), intent(IN)   :: zyx
      !(in) 2 ʻǡ

      real(8), dimension(0:im-1)          :: x_AvrZY_zyx
      !(out) ʬ줿 1 (Y)ʻǡ

      x_AvrZY_zyx = x_IntZY_zyx(zyx)/(sum(y_Y_weight)*sum(z_Z_weight))

    end function x_AvrZY_zyx

    function zy_AvrX_zyx(zyx)
      !
      ! 3 ʻǡ X ʿ
      !
      ! ºݤˤϳʻǡ x_X_Weight 򤫤
      ! ¤׻, x_X_Weight ¤ǳ뤳ȤʿѤƤ. 
      !
      real(8), dimension(0:km-1,0:jm-1,0:im-1), intent(IN)   :: zyx
      !(in) 2 ʻǡ

      real(8), dimension(0:km-1,0:jm-1)          :: zy_AvrX_zyx
      !(out) ʬ줿 2 (ZY)ʻǡ

      zy_AvrX_zyx = zy_IntX_zyx(zyx)/sum(x_X_weight)

    end function zy_AvrX_zyx

    function zx_AvrY_zyx(zyx)
      !
      ! 3 ʻǡ Y ʿ
      !
      ! ºݤˤϳʻǡ y_Y_Weight 򤫤
      ! ¤׻, y_Y_Weight ¤ǳ뤳ȤʿѤƤ. 
      !
      real(8), dimension(0:km-1,0:jm-1,0:im-1), intent(IN)   :: zyx
      !(in) 2 ʻǡ

      real(8), dimension(0:km-1,0:im-1)          :: zx_AvrY_zyx
      !(out) ʬ줿 1 (Y)ʻǡ

      zx_AvrY_zyx = zx_IntY_zyx(zyx)/sum(y_Y_weight)

    end function zx_AvrY_zyx

    function yx_AvrZ_zyx(zyx)
      !
      ! 3 ʻǡ Z ʿ
      !
      ! ºݤˤϳʻǡ z_Z_Weight 򤫤
      ! ¤׻, z_Z_Weight ¤ǳ뤳ȤʿѤƤ. 
      !
      real(8), dimension(0:km-1,0:jm-1,0:im-1), intent(IN)   :: zyx
      !(in) 2 ʻǡ

      real(8), dimension(0:jm-1,0:im-1)          :: yx_AvrZ_zyx
      !(out) ʬ줿 1 (YX)ʻǡ

      yx_AvrZ_zyx = yx_IntZ_zyx(zyx)/sum(z_Z_weight)

    end function yx_AvrZ_zyx

    function AvrYX_yx(yx)
      !
      ! 2 ʻǡΰʿ
      !
      ! ºݤˤϳʻǡ x_X_Weight, y_Y_Weight 򤫤
      ! ¤׻, x_X_Weight*y_Y_Weight ¤ǳ뤳ȤʿѤƤ. 
      !
      real(8), dimension(0:jm-1,0:im-1), intent(IN)   :: yx
      !(in)  2 ʻǡ

      real(8)                             :: AvrYX_yx    
      !(out) ʿ

      AvrYX_yx = IntYX_yx(yx)/(sum(x_X_weight)*sum(y_Y_weight))
    end function AvrYX_yx

    function y_AvrX_yx(yx)
      !
      ! 2 ʻǡ X ʿ
      !
      ! ºݤˤϳʻǡ x_X_Weight 򤫤¤׻, 
      ! x_X_Weight ¤ǳ뤳ȤʿѤƤ. 
      !
      real(8), dimension(0:jm-1,0:im-1), intent(IN)   :: yx
      !(in) 2 ʻǡ

      real(8), dimension(0:jm-1)          :: y_AvrX_yx
      !(out) ʿѤ줿 1 (Y)ʻǡ

      y_AvrX_yx = y_IntX_yx(yx)/sum(x_X_weight)
    end function y_AvrX_yx

    function x_AvrY_yx(yx)
      !
      ! 2 ʻǡ Y ʿ
      !
      ! ºݤˤϳʻǡ y_Y_Weight 򤫤¤׻, 
      ! y_Y_Weight ¤ǳ뤳ȤʿѤƤ. 
      !
      real(8), dimension(0:jm-1,0:im-1), intent(IN)   :: yx
      !(in) 2 ʻǡ

      real(8), dimension(0:im-1)          :: x_AvrY_yx
      !(out) ʿѤ줿 1 (X)ʻǡ

      x_AvrY_yx = x_IntY_yx(yx)/sum(y_Y_weight)
    end function x_AvrY_yx

    function AvrZX_zx(zx)
      !
      ! 2 (ZX)ʻǡΰʿ
      !
      ! ºݤˤϳʻǡ x_X_Weight, z_Z_Weight 򤫤
      ! ¤׻, x_X_Weight*z_Z_Weight ¤ǳ뤳ȤʿѤƤ. 
      !
      real(8), dimension(0:km-1,0:im-1), intent(IN)   :: zx
      !(in)  2 (ZX)ʻǡ

      real(8)                             :: AvrZX_zx    
      !(out) ʿ

      AvrZX_zx = IntZX_zx(zx)/(sum(x_X_weight)*sum(z_Z_weight))
    end function AvrZX_zx

    function z_AvrX_zx(zx)
      !
      ! 2 (ZX)ʻǡ X ʿ
      !
      ! ºݤˤϳʻǡ x_X_Weight 򤫤¤׻, 
      ! x_X_Weight ¤ǳ뤳ȤʿѤƤ. 
      !
      real(8), dimension(0:km-1,0:im-1), intent(IN)   :: zx
      !(in) 2 (ZX)ʻǡ

      real(8), dimension(0:km-1)          :: z_AvrX_zx
      !(out) ʿѤ줿 1 (Z)ʻǡ

      z_AvrX_zx = z_IntX_zx(zx)/sum(x_X_weight)
    end function z_AvrX_zx

    function x_AvrZ_zx(zx)
      !
      ! 2 (ZX)ʻǡ Z ʿ
      !
      ! ºݤˤϳʻǡ z_Z_Weight 򤫤¤׻, 
      ! z_Z_Weight ¤ǳ뤳ȤʿѤƤ. 
      !
      real(8), dimension(0:km-1,0:im-1), intent(IN)   :: zx
      !(in) 2 (ZX)ʻǡ

      real(8), dimension(0:im-1)          :: x_AvrZ_zx
      !(out) ʿѤ줿 1 (X)ʻǡ

      x_AvrZ_zx = x_IntZ_zx(zx)/sum(z_Z_weight)
    end function x_AvrZ_zx

    function AvrZY_zy(zy)
      !
      ! 2 (ZY)ʻǡΰʿ
      !
      ! ºݤˤϳʻǡ z_Z_Weight, y_Y_Weight 򤫤
      ! ¤׻, z_Z_Weight*y_Y_Weight ¤ǳ뤳ȤʿѤƤ. 
      !
      real(8), dimension(0:km-1,0:jm-1), intent(IN)   :: zy
      !(in)  2 (ZY)ʻǡ

      real(8)                             :: AvrZY_zy    
      !(out) ʿ

      AvrZY_zy = IntZY_zy(zy)/(sum(y_Y_weight)*sum(z_Z_weight))
    end function AvrZY_zy

    function z_AvrY_zy(zy)
      !
      ! 2 (ZY)ʻǡ Y ʿ
      !
      ! ºݤˤϳʻǡ y_Y_Weight 򤫤¤׻, 
      ! y_Y_Weight ¤ǳ뤳ȤʿѤƤ. 
      !
      real(8), dimension(0:km-1,0:jm-1), intent(IN)   :: zy
      !(in) 2 (ZY)ʻǡ

      real(8), dimension(0:km-1)          :: z_AvrY_zy
      !(out) ʿѤ줿 1 (Z)ʻǡ

      z_AvrY_zy = z_IntY_zy(zy)/sum(y_Y_weight)
    end function z_AvrY_zy

    function y_AvrZ_zy(zy)
      !
      ! 2 (ZY)ʻǡ Z ʿ
      !
      ! ºݤˤϳʻǡ z_Z_Weight 򤫤¤׻, 
      ! z_Z_Weight ¤ǳ뤳ȤʿѤƤ. 
      !
      real(8), dimension(0:km-1,0:jm-1), intent(IN)   :: zy
      !(in) 2 (ZY)ʻǡ

      real(8), dimension(0:jm-1)          :: y_AvrZ_zy
      !(out) ʿѤ줿 1 (X)ʻǡ

      y_AvrZ_zy = y_IntZ_zy(zy)/sum(z_Z_weight)
    end function y_AvrZ_zy

    function AvrX_x(x)
      !
      ! 1 (X)ʻǡ X ʿ
      !
      ! ºݤˤϳʻǡ x_X_Weight 򤫤¤׻, 
      ! x_X_Weight ¤ǳ뤳ȤʿѤƤ. 
      !
      real(8), dimension(0:im-1), intent(IN) :: x       !(in)  1 ʻǡ
      real(8)                                :: AvrX_x  !(out) ʿ

      AvrX_x = IntX_x(x)/sum(x_X_weight)
    end function AvrX_x

    function AvrY_y(y)
      !
      ! 1 (Y)ʻǡ Y ʿ
      !
      ! ºݤˤϳʻǡ y_Y_Weight 򤫤¤׻, 
      ! y_Y_Weight ¤ǳ뤳ȤʿѤƤ. 
      !
      real(8), dimension(0:jm-1), intent(IN) :: y      !(in)  1 ʻǡ
      real(8)                                :: AvrY_y !(out) ʿ

      AvrY_y = IntY_y(y)/sum(y_Y_weight)
    end function AvrY_y

    function AvrZ_z(z)
      !
      ! 1 (Z)ʻǡ Z ʿ
      !
      ! ºݤˤϳʻǡ z_Z_Weight 򤫤¤׻, 
      ! z_Z_Weight ¤ǳ뤳ȤʿѤƤ. 
      !
      real(8), dimension(0:km-1), intent(IN) :: z      !(in)  1 ʻǡ
      real(8)                                :: AvrZ_z !(out) ʿ

      AvrZ_z = IntZ_z(z)/sum(z_Z_weight)
    end function AvrZ_z

  !--------------- ڥȥ׻ -----------------
    function EnergyHelicityFromZeta_eee2(eee2)
      !
      ! ʬ(_1, _2)ΰʿѥͥ륮ȥإꥷƥ׻. 
      !
      real(8), dimension(2)                         :: EnergyHelicityFromZeta_eee2
      ! ͥ륮إꥷƥ

      real(8), dimension(-nm:nm,-mm:mm,-lm:lm,2), intent(in) :: eee2
      ! ʬ(_1, _2)

      real(8) :: E, H           ! ͥ륮, إꥷƥ
      
      call p3cnsv(nm,mm,lm,eee2,E,H)

      EnergyHelicityFromZeta_eee2(1) = E ; EnergyHelicityFromZeta_eee2(2) = H

    end function EnergyHelicityFromZeta_eee2

    subroutine ESpectralFromZeta(esp,eee2)
      !
      ! ʬ(_1, _2)饨ͥ륮ڥȥ׻. 
      !
      !   * esp ΥǵȿϰϤ
      !   * esp ¤ EFFromZeta ǵ륨ͥ륮
      !     (ΰʿ)
      !
      real(8), dimension(:), intent(OUT)  :: esp
      ! ͥ륮ڥȥ

      real(8), dimension(-nm:nm,-mm:mm,-lm:lm,2), intent(in) :: eee2
      ! ʬ(_1, _2)

      integer kmax
      ! ѿ

      kmax=size(esp)
      call p3espt(nm,mm,lm,kmax,eee2,esp)

    end subroutine ESpectralFromZeta

end module eee_module
