!----------------------------------------------------------------------
!     Copyright (c) 2002 Shin-ichi Takehiro. All rights reserved.
!----------------------------------------------------------------------
!ɽ  SNPACK/ISPACK-F90
!
!  2002/02/02  ݹ  ¿Ѥ˲¤
!      2002/03/30  ݹ  ⥸塼̾ѹ
!
!         Ѵʻǡ, ڥȥǡ礭Ϸᤦ
!
module ya_base_module

  use y_base_module, only : im, jm, nm, it, t, y, ip, p, r, ia, a
  implicit none

  integer               :: km=16         ! Ʊ˽ǡ(ؤο)

  integer, allocatable  :: ipk(:,:)            ! Ѵ(¿)
  real(8), allocatable  :: pk(:,:), rk(:,:)    ! Ѵ(¿)

  real(8), allocatable  :: q(:)                ! 
  real(8), allocatable  :: ww(:), ws(:)        ! 

  real(8), parameter    :: pi=3.14159265358979

  private

  public km                                    ! ؿ
  public ya_base_initial                       ! ֥롼
  public gga_ya, ya_gga                        ! Ѵؿ

  save km                                      ! ǡ(ؿ)򵭲
  save ipk, pk, rk                             ! Ѵ򵭲

  contains
  !---------------  -----------------
    subroutine ya_base_initial(k_in)

      integer,intent(in) :: k_in               ! ǡ(ؿ)򵭲

      integer :: iw

      km = k_in

      allocate(ipk(km,((nm+1)/2+nm+1)*2))      ! Ѵ(¿)
      allocate(pk(km,((nm+1)/2+nm+1)*jm))      ! Ѵ(¿)
      allocate(rk(km,((nm+1)/2*2+3)*(nm/2+1))) ! Ѵ(¿)

      allocate(q(km*((nm+1)/2+nm+1)*jm))       ! (¿)
      iw=km*(im+3*(nm+1))*jm
      allocate(ws(iw),ww(iw))                  ! (¿)

      call snkini(nm,jm,km,ip,p,r,ipk,pk,rk)

    end subroutine ya_base_initial

  !--------------- Ѵ -----------------

    function gga_ya(ya,ipow,iflag)    ! Ĵ´ؿڥȥ -> ʻ
      real(8), intent(in)   :: ya(:,:)                    ! ڥȥ
      real(8)               :: gga_ya(im,jm,size(ya,2))   ! ʻ
      integer, intent(in), optional  :: ipow      ! Ѥ 1/cos μ
      integer, intent(in), optional  :: iflag     ! Ѵμ

      integer, parameter  :: ipow_default  = 0
      integer, parameter  :: iflag_default = 0

      integer ipval, ifval
      integer k

      if (present(ipow)) then
         ipval = ipow
      else
         ipval = ipow_default
      endif

      if (present(iflag)) then
         ifval = iflag
      else
         ifval = iflag_default
      endif

      k= size(ya,2)
      if  ( k > km ) then
         call msgdmp('E','gga_ya','Size of 3rd dimension invalid.')
      else
         call snts2g(nm,im,im,jm,jm,size(ya,2),ya,gga_ya,&
              it,t,y,ipk(1:k,:),pk(1:k,:),rk(1:k,:),ia,a,q,ws,ww,ipval,ifval)
      endif

    end function gga_ya

    function ya_gga(gga,ipow,iflag) ! ʻ -> Ĵ´ؿڥȥ
      real(8), intent(in)   :: gga(:,:,:)      ! ʻ(im,jm,*)
      real(8)               :: ya_gga((nm+1)*(nm+1),size(gga,3))  ! ڥȥ
      integer, intent(in), optional  :: ipow        ! Ѥ 1/cos μ
      integer, intent(in), optional  :: iflag       ! Ѵμ

      integer, parameter  :: ipow_default  = 0      ! åǥե
      integer, parameter  :: iflag_default = 0      ! åǥե

      integer ipval, ifval
      integer k

      if (present(ipow)) then
         ipval = ipow
      else
         ipval = ipow_default
      endif

      if (present(iflag)) then
         ifval = iflag
      else
         ifval = iflag_default
      endif

      k = size(gga,3)
      if ( k > km ) then
         call msgdmp('E','ya_gga','Size of 3rd dimension invalid.')
      else
         call sntg2s(nm,im,im,jm,jm,k,gga,ya_gga,&
              it,t,y,ipk(1:k,:),pk(1:k,:),rk(1:k,:),ia,a,q,ws,ww,ipval,ifval)
      endif
    end function ya_gga

  end module ya_base_module


