!----------------------------------------------------------------------
!     Copyright (c) 2005 Shin-ichi Takehiro. All rights reserved.
!----------------------------------------------------------------------
!
!ɽ  at_af_galerkin_MM_test1d
!
!      ӥաݥ顼ˡ
!      ǥꥯ졦Υޥ󺮹維ѥ⥸塼ƥȥץ(1)
!          cfdx1_xmax f'(:,i=0)  + cfdx0_xmax f(:,i=0)  = 0,
!          cfdx1_xmin f'(:,i=im) + cfdx0_xmin f(:,i=im) = 0,
!
!      1 : ξüǥꥯ
!            cfdx1_xmax=0, cfdx0_xmax = 1, cfdx1_xmin=0, cfdx0_xmin = 1
!            f(x) = (x-xmin) * (xmax-x)  
!
!      2 : üǥꥯüΥޥ󶭳
!            cfdx1_xmax=0, cfdx0_xmax = 1, cfdx1_xmin=1, cfdx0_xmin = 0
!            f(x) = (x-xmin)**2 * (xmax-x)
!
!      3 : üΥޥüǥꥯ춭
!            cfdx1_xmax=1, cfdx0_xmax = 0, cfdx1_xmin=0, cfdx0_xmin = 1
!            f(x) = (x-xmin)* (xmax-x)**2
!
!      4 : ǥꥯ졦Υޥ󺮹維
!            cfdx1_xmax=1, cfdx0_xmax = -1, cfdx1_xmin=1, cfdx0_xmin = 1
!            f(x) = x**3 - 2 x**2, 0<x<1
!
!      5 : ξüΥޥ󺮹維
!            cfdx1_xmax=1, cfdx0_xmax = 1, cfdx1_xmin=0, cfdx0_xmin = 0
!            f(x) = (x-xmin)**2 * (xmax-x)**2, 0<x<1
!
!  2006/01/03  ݹ  
!      2006/01/23  ݹ  ⥸塼̾ѹȼ
!      2006/02/15  ݹ   0 ξб
!
program at_af_galerkin_MM_test1d

  use at_af_galerkin_MM
  use at_module

  implicit none

  integer, parameter :: im=8, km=4, ks=2
  real(8), parameter :: xmin=0.0, xmax=1.0

  real(8) :: g_data(0:im)
  real(8) :: g_dataorig(0:im)
  real(8) :: t_data(0:km)
  real(8) :: f_data(ks:km)

  call at_Initial(im,km,xmin,xmax)

  !--- ξüǥꥯ춭 ---
  call at_af_galerkin_MM_Initial(im,km,       &
       cfdx0_xmax=1.0D0, cfdx1_xmax=0.0D0, &
       cfdx0_xmin=1.0D0, cfdx1_xmin=0.0D0  )

  g_data = (g_X-xmin)*(xmax-g_X)
  g_dataorig = g_data
  t_data = t_g(g_data)

  write (6,*) 
  write (6,*) '*** Check both Dirichlt boundary conditions ***'
  write (6,*) 'g_data : (x-xmin)*(xmax-x)'
  write(6,*) g_data
  write (6,*) 't_data'
  write(6,*) t_data

  f_data = f_t(t_data)

  write (6,*) 'f_data'
  write (6,*) f_data

  t_data = t_f(f_data)

  write (6,*) 't_data'
  write (6,*) t_data

  g_data=g_f(f_data)
  write (6,*) 'g_data'
  write (6,*) g_data
  write (6,*) '---- Max. Error of g_data : ', maxval(abs(g_data-g_dataorig))

  !--- üǥꥯüΥޥ󶭳 ---
  call at_af_galerkin_MM_Initial(im,km,       &
       cfdx0_xmax=1.0D0, cfdx1_xmax=0.0D0, &
       cfdx0_xmin=0.0D0, cfdx1_xmin=1.0D0  )

  g_data = (g_X-xmin)**2 * (xmax-g_X)
  g_dataorig = g_data
  t_data = t_g(g_data)

  write (6,*) 
  write (6,*) '*** Check Dirichlt and Neuman boundary conditions ***'
  write (6,*) 'g_data : (x-xmin)**2 * (xmax-x)'
  write(6,*) g_data
  write (6,*) 't_data'
  write(6,*) t_data

  f_data = f_t(t_data)

  write (6,*) 'f_data'
  write (6,*) f_data

  t_data = t_f(f_data)

  write (6,*) 't_data'
  write (6,*) t_data

  g_data=g_f(f_data)
  write (6,*) 'g_data'
  write (6,*) g_data
  write (6,*) '---- Max. Error of g_data : ', maxval(abs(g_data-g_dataorig))

  !--- üΥޥüǥꥯ춭 ---
  call at_af_galerkin_MM_Initial(im,km,       &
       cfdx0_xmax=0.0D0, cfdx1_xmax=1.0D0, &
       cfdx0_xmin=1.0D0, cfdx1_xmin=0.0D0  )

  g_data = (g_X-xmin) * (xmax-g_X)**2
  g_dataorig = g_data
  t_data = t_g(g_data)

  write (6,*) 
  write (6,*) '*** Check Neuman and Dirichlt boundary conditions ***'
  write (6,*) 'g_data : (x-xmin) * (xmax-x)**2'
  write(6,*) g_data
  write (6,*) 't_data'
  write(6,*) t_data

  f_data = f_t(t_data)

  write (6,*) 'f_data'
  write (6,*) f_data

  t_data = t_f(f_data)

  write (6,*) 't_data'
  write (6,*) t_data

  g_data=g_f(f_data)
  write (6,*) 'g_data'
  write (6,*) g_data
  write (6,*) '---- Max. Error of g_data : ', maxval(abs(g_data-g_dataorig))

  !--- ǥꥯ졦Υޥ󺮹維 ---
  call at_af_galerkin_MM_Initial(im,km,        &
       cfdx0_xmax=1.0D0, cfdx1_xmax=-1.0D0, &
       cfdx0_xmin=1.0D0, cfdx1_xmin=1.0D0    )

  g_data = g_X**3 - 2*g_X**2
  g_dataorig = g_data
  t_data = t_g(g_data)

  write (6,*) 
  write (6,*) '*** Check Neuman and Dirichlt mixed boundary conditions ***'
  write (6,*) 'g_data : x**3 - 2 x**2'
  write(6,*) g_data
  write (6,*) 't_data'
  write(6,*) t_data

  f_data = f_t(t_data)

  write (6,*) 'f_data'
  write (6,*) f_data

  t_data = t_f(f_data)

  write (6,*) 't_data'
  write (6,*) t_data

  g_data=g_f(f_data)
  write (6,*) 'g_data'
  write (6,*) g_data
  write (6,*) '---- Max. Error of g_data : ', maxval(abs(g_data-g_dataorig))

  !--- ξüΥޥ󶭳 ---
  call at_af_galerkin_MM_Initial(im,km,       &
       cfdx0_xmax=0.0D0, cfdx1_xmax=1.0D0, &
       cfdx0_xmin=0.0D0, cfdx1_xmin=1.0D0  )

  g_data = (g_X-xmin)**2*(xmax-g_X)**2
  g_dataorig = g_data
  t_data = t_g(g_data)

  write (6,*) 
  write (6,*) '*** Check both Neumann boundary conditions ***'
  write (6,*) 'g_data : (x-xmin)**2*(xmax-x)**2'
  write(6,*) g_data
  write (6,*) 't_data'
  write(6,*) t_data

  f_data = f_t(t_data)

  write (6,*) 'f_data'
  write (6,*) f_data

  t_data = t_f(f_data)

  write (6,*) 't_data'
  write (6,*) t_data

  g_data=g_f(f_data)
  write (6,*) 'g_data'
  write (6,*) g_data
  write (6,*) '---- Max. Error of g_data : ', maxval(abs(g_data-g_dataorig))
end program at_af_galerkin_MM_test1d
