!----------------------------------------------------------------------
!     Copyright (c) 2005 Shin-ichi Takehiro. All rights reserved.
!----------------------------------------------------------------------
!ɽ  w_spectrum_module
!
!  2005/04/23  ݹ 
!      2005/05/16  ݹ ؿ̾û
!
module w_spectrum_module
  use w_base_module, only : nm, l_nm

  implicit none

  private
 
  public nm_EnergyFromStreamfunc_w          ! ͥ륮ڥȥ           
                                            ! (ʿȿ n, Ӿȿ m )
  public n_EnergyFromStreamfunc_w           ! ͥ륮ڥȥ
                                            ! (ʿȿ n ) 
  public nm_EnstrophyFromStreamfunc_w       ! 󥹥ȥեڥȥ     
                                            ! (ʿȿ n, Ӿȿ m )
  public n_EnstrophyFromStreamfunc_w        ! 󥹥ȥեڥȥ  
                                            !  (ʿȿ n )
  public w_spectrum_VMiss                   ! »

  real(8) :: w_spectrum_VMiss = -999.000    ! »ͽ
  integer n,m                               ! DO ѿ


  contains

  !--------------- ͥ륮ڥȥ׻ -----------------
    function nm_EnergyFromStreamfunc_w(w_Strfunc)
      real(8), intent(in)   :: w_Strfunc(:)   ! ήؿ(ڥȥǡ)
      real(8), dimension(0:nm,-nm:nm) &       ! ͥ륮ڥȥ
           :: nm_EnergyFromStreamfunc_w       ! (ʿȿ n, Ӿȿ m )

      nm_EnergyFromStreamfunc_w = w_spectrum_VMiss

      do n=0,nm
         do m=-n,n
            nm_EnergyFromStreamfunc_w(n,m) &
                 = 0.5 * n*(n+1) * w_Strfunc(l_nm(n,m))**2
         enddo
      enddo
    end function nm_EnergyFromStreamfunc_w

    function n_EnergyFromStreamfunc_w(w_Strfunc)
      real(8), intent(in)      :: w_Strfunc(:) ! ήؿ
      real(8), dimension(0:nm) &               ! ͥ륮ڥȥ
           :: n_EnergyFromStreamfunc_w         ! (ʿȿ n ) 

      do n=0,nm
         n_EnergyFromStreamfunc_w(n)  &
              = 0.5 * n*(n+1) &
                * sum(w_StrFunc(l_nm(n,(/(m,m=-n,n)/)))**2,1)
      enddo

    end function n_EnergyFromStreamfunc_w

  !--------------- 󥹥ȥեڥȥ׻ -----------------
    function nm_EnstrophyFromStreamfunc_w(w_Strfunc)
      real(8), intent(in)   :: w_Strfunc(:)   ! ήؿ
      real(8), dimension(0:nm,-nm:nm) &       ! 󥹥ȥեڥȥ     
          :: nm_EnstrophyFromStreamfunc_w     ! (ʿȿ n, Ӿȿ m )

      nm_EnstrophyFromStreamfunc_w = w_spectrum_VMiss

      do n=0,nm
         do m=-n,n
            nm_EnstrophyFromStreamfunc_w(n,m) &
                 = 0.5 * n**2 * (n+1)**2 &
                    * w_Strfunc(l_nm(n,m))**2
         enddo
      enddo
    end function nm_EnstrophyFromStreamfunc_w

    function n_EnstrophyFromStreamfunc_w(w_Strfunc)
      real(8), intent(in)      :: w_Strfunc(:) ! ήؿ(ڥȥǡ)
      real(8), dimension(0:nm) &               ! 󥹥ȥեڥȥ  
           :: n_EnstrophyFromStreamfunc_w      !  (ʿȿ n )        

      do n=0,nm
         n_EnstrophyFromStreamfunc_w(n)  &
              = 0.5 * n**2 * (n+1)**2 &
                * sum(w_StrFunc(l_nm(n,(/(m,m=-n,n)/)))**2,1)
      enddo
    end function n_EnstrophyFromStreamfunc_w

end module w_spectrum_module
