!----------------------------------------------------------------------
!     Copyright (c) 2002 Shin-ichi Takehiro. All rights reserved.
!----------------------------------------------------------------------
!
!$BI=Bj(B  at_module $B%F%9%H%W%m%0%i%`(B
!
!$BMzNr(B  2002/04/10  $BC]9-??0l(B 
!
program at_testweight

  use at_module
  implicit none
  integer, parameter :: im=4, km=2
  real(8), parameter :: xmin=-1.0D0, xmax=1.0D0
  real(8), parameter :: eps=1.0D-14

  real(8), dimension(0:im) :: g_z
  real(8), parameter       :: pi=3.1415926535897932385D0

  integer :: k, i, m

  call at_initial(im,km,xmin,xmax)

  write(6,*) 'x'
  write(6,*) g_x
  write(6,*) 
  write(6,*) 'x weight'
  write(6,*) g_x_weight

  g_z(:) = 1
  write(6,*) 
  write(6,*) 'z = 1, int_-1^1 z dx = 2'
  write(6,*) sum(g_z*g_x_weight)

  g_z(:) = g_x**2
  write(6,*) 
  write(6,*) 'z = x**2, int_-1^1 z dx = 2/3'
  write(6,*) sum(g_z*g_x_weight)

  write(6,*) 
  write(6,*) 'z = cos(pi*x/2), int_-1^1 z dx = 4/pi'
  g_z(:) = cos(pi*g_x/2)
  write(6,*) sum(g_z*g_x_weight)

end program at_testweight


