!----------------------------------------------------------------------
!     Copyright (c) 2002 Shin-ichi Takehiro. All rights reserved.
!----------------------------------------------------------------------
!
!ɽ  ae_module
!
!  2002/01/25  ݹ  ISPACK/ftrpack  Fortran 90 
!      2002/02/06  ݹ  ŤƳ. ̥󥿡եʤ. 
!                            η˱󥿡ե̾
!      2002/03/25  ݹ  ⥸塼̾ѹ
!      2002/08/20  ݹ  ʬʿѴؿɲ
!
module ae_module
  implicit none

  private
  public ae_initial                       ! 롼
  public ag_ae, ae_ag, g_e, e_g           ! Ѵ
  public ae_Dx_ae, e_Dx_e                 ! ʬ
  public a_Int_ag, Int_g, a_Avr_ag, Avr_g ! ʬʿ
  public g_X, g_X_Weight                  ! ɸѿ

  integer            :: im=32             ! ʻ
  integer            :: km=10             ! ȿ
  double precision   :: xl=1.0            ! ΰ礭

  integer,dimension(5)              :: iti
  real(8),dimension(:),allocatable  :: ti
  real(8), parameter                :: pi=3.1415926535897932385D0

  real(8), allocatable :: g_x(:)          ! ʻɸ
  real(8), allocatable :: g_x_weight(:)   ! ʻŤ

  save im, km, iti, ti, xl, g_X, g_X_Weight

  contains
  !---------------  -----------------
    subroutine ae_initial(i,k,xmin,xmax)

      integer,intent(in) :: i           ! ʻ
      integer,intent(in) :: k           ! ȿ

      real(8),intent(in) :: xmin, xmax     ! X ɸϰ

      integer :: ii

      im = i
      km = k
      xl = xmax-xmin

      if ( im <= 0 .or. km <= 0 ) then
         call msgdmp('E','ftrinitial', &
              'Number of grid points and waves should be positive')
      elseif ( mod(im,2) /= 0 ) then
         call msgdmp('E','ftrinitial', &
              'Number of grid points should be even')
      elseif ( km >= im/2 ) then
         call msgdmp('E','ftrinitial', &
              'KM shoud be less than IM/2')
      endif

      allocate(ti(im*2))

      call fttrui(im,iti,ti)

      allocate(g_x(0:im-1))
      do ii=0,im
         g_X(ii) = xmin + xl/im*ii
      enddo

      allocate(g_x_weight(0:im-1))
      g_X_Weight = xl/im

    end subroutine ae_initial

  !--------------- Ѵ -----------------

    function ag_ae(ae) ! ڥȥ -> ʻ
      real(8), dimension(:,-km:), intent(in)  :: ae
      real(8), dimension(size(ae,1),0:im-1)   :: ag_ae

      real(8), dimension(size(ae,1)*im)       :: y
      integer :: m, k

      m=size(ae,1)
      if ( size(ae,2) < 2*km+1 ) then
         call msgdmp('E','ag_ae', &
              'The Fourier dimension of input data too small.')
      elseif ( size(ae,2) > 2*km+1 ) then
         call msgdmp('W','ag_ae', &
              'The Fourier dimension of input data too large.')
      endif

      ag_ae = 0.0D0
      ag_ae(:,0)=ae(:,0)
      ag_ae(:,1)=0
      do k=1,km
         ag_ae(:,2*k)=ae(:,k)
         ag_ae(:,2*k+1)=ae(:,-k)
      enddo
      ag_ae(:,2*km+2:im-1)=0

      call fttrub(m,im,ag_ae,y,iti,ti)
    end function ag_ae

    function g_e(e) ! ڥȥ -> ʻ
      real(8), dimension(0:im-1)             :: g_e
      real(8), dimension(-km:km), intent(in) :: e

      real(8), dimension(1,size(e))  :: ae_work
      real(8), dimension(1,0:im-1)   :: ag_work

      ae_work(1,:) = e
      ag_work = ag_ae(ae_work)
      g_e = ag_work(1,:)

    end function g_e

    function ae_ag(ag)  ! ʻ -> ڥȥ
      real(8), dimension(:,:), intent(in)     :: ag
      real(8), dimension(size(ag,1),-km:km)   :: ae_ag

      real(8), dimension(size(ag,1)*im)     :: y
      real(8), dimension(size(ag,1),0:im-1) :: ag_work
      integer :: m, k

      m = size(ag,1)
      if ( size(ag,2) < im ) then
         call msgdmp('E','ae_ag', &
              'The Grid points of input data too small.')
      elseif ( size(ag,2) > im ) then
         call msgdmp('W','ae_ag', &
              'The Grid points of input data too large.')
      endif
      ag_work = ag

      call fttruf(m,im,ag_work,y,iti,ti)

      do k=1,km
         ae_ag(:,k) = ag_work(:,2*k)
         ae_ag(:,-k) = ag_work(:,2*k+1)
      enddo
      ae_ag(:,0) = ag_work(:,0)

    end function ae_ag

    function e_g(g)  ! ʻ -> ڥȥ
      real(8), dimension(-km:km)              :: e_g
      real(8), dimension(0:im-1), intent(in)  :: g

      real(8), dimension(1,size(g))        :: ag_work
      real(8), dimension(1,-km:km)         :: ae_work

      ag_work(1,:) = g
      ae_work = ae_ag(ag_work)
      e_g = ae_work(1,:)

    end function e_g

  !--------------- ʬ׻ -----------------
    function ae_Dx_ae(ae)   ! ڥȥ˺Ѥ x ʬ黻

      real(8), dimension(:,-km:), intent(in)     :: ae
      real(8), dimension(size(ae,1),-km:km)      :: ae_dx_ae

      integer k

      if ( size(ae,2) < 2*km+1 ) then
         call msgdmp('W','ae_Dx_ae', &
              'The Fourier dimension of input data too small.')
      elseif ( size(ae,2) > 2*km+1 ) then
         call msgdmp('W','ae_Dx_ae', &
              'The Fourier dimension of input data too large.')
      endif

      do k=-km,km
         ae_Dx_ae(:,k) = -(2*pi*k/xl)*ae(:,-k)
      enddo
    end function ae_dx_ae

    function e_Dx_e(e)   ! ڥȥ˺Ѥ x ʬ黻

      real(8), dimension(-km:km), intent(in)     :: e
      real(8), dimension(-km:km)                 :: e_Dx_e

      real(8), dimension(1,-km:km)               :: ae_work

      ae_work(1,:) = e
      ae_work = ae_Dx_ae(ae_work)
      e_Dx_e = ae_work(1,:)

    end function e_Dx_e

  !--------------- ʬ׻ -----------------
    function a_Int_ag(ag)
      real(8), dimension(:,0:), intent(in)     :: ag
      real(8), dimension(size(ag,1))           :: a_Int_ag
      integer :: i

      if ( size(ag,2) < im ) then
         call msgdmp('E','ae_ag', &
              'The Grid points of input data too small.')
      elseif ( size(ag,2) > im ) then
         call msgdmp('W','ae_ag', &
              'The Grid points of input data too large.')
      endif

      a_Int_ag = 0.0d0
      do i=0,im-1
         a_Int_ag(:) = a_Int_ag(:) + ag(:,i)*g_X_Weight(i)
      enddo
    end function a_Int_ag

    function Int_g(g)
      real(8), dimension(0:im-1), intent(in)   :: g
      real(8)                                  :: Int_g

      Int_g = sum(g*g_X_Weight)
    end function Int_g

    function a_Avr_ag(ag)
      real(8), dimension(:,0:), intent(in)     :: ag
      real(8), dimension(size(ag,1))           :: a_Avr_ag

      a_Avr_ag = a_Int_ag(ag)/sum(g_X_Weight)
    end function a_Avr_ag

    function Avr_g(g)
      real(8), dimension(0:im-1), intent(in)   :: g
      real(8)                                  :: Avr_g

      Avr_g = Int_g(g)/sum(g_X_Weight)
    end function Avr_g

  end module ae_module
