!----------------------------------------------------------------------
!     Copyright (c) 2002 Shin-ichi Takehiro. All rights reserved.
!----------------------------------------------------------------------
!ɽ  wa_deriv_module
!
!  2002/02/02  ݹ 
!      2002/02/07  ݹ  ؿ,ѿ̾ѹ
!      2002/03/30  ݹ  ⥸塼̾ѹ
!      2002/05/25  ݹ  ʻɸ̤٤̿̾ˡѹ
!
!      
!         Ѵʻǡ, ڥȥǡ礭Ϸᤦ
!
module wa_deriv_module
  use w_base_module, only : im, jm, nm
  use wa_base_module, only : km, wa_base_initial, xya_wa, wa_xya
  use w_deriv_module, only : rn, irm, w_jacobian_w_w

  implicit none

  private
 
  public wa_deriv_initial                     ! 
  public wa_lapla_wa, wa_laplainv_wa          ! ץ饷ȵձ黻
  public wa_dlon_wa                           ! ʬ
  public xya_gradlon_wa, xya_gradlat_wa       ! ۷ʬ
  public wa_divlon_xya, wa_divlat_xya         ! ȯʬ
  public wa_div_xya_xya                       ! ȯʬ
  public wa_jacobian_wa_wa                    ! 䥳ӥ

  contains

  !---------------  -----------------
    subroutine wa_deriv_initial(k_in)

      integer,intent(in) :: k_in              ! ǡ(ؿ)򵭲

      call wa_base_initial(k_in)

    end subroutine wa_deriv_initial

  !--------------- ʬ׻ -----------------
    function wa_lapla_wa(wa_data)       ! ڥȥ˺Ѥ Laplacian
      real(8), intent(in)  :: wa_data(:,:)
      real(8)              :: wa_lapla_wa((nm+1)*(nm+1),size(wa_data,2))

      integer :: l,k

      do k=1,size(wa_data,2)
         do l=1,(nm+1)*(nm+1)
            wa_lapla_wa(l,k) = rn(l,1)*wa_data(l,k)
         enddo
      enddo
    end function wa_lapla_wa

    function wa_laplainv_wa(wa_data)    ! ڥȥ˺Ѥ Laplacian 黻
      real(8), intent(in)  :: wa_data(:,:)
      real(8)              :: wa_laplainv_wa((nm+1)*(nm+1),size(wa_data,2))

      integer :: l,k

      do k=1,size(wa_data,2)
         do l=1,(nm+1)*(nm+1)
            wa_laplainv_wa(l,k) = rn(l,2)*wa_data(l,k)
         enddo
      enddo
    end function wa_laplainv_wa

    function wa_dlon_wa(wa_data)        ! ڥȥ˺Ѥʬ /ߦ
      real(8), intent(in)  :: wa_data(:,:)
      real(8)              :: wa_dlon_wa((nm+1)*(nm+1),size(wa_data,2))

      integer :: l,k

      do k=1,size(wa_data,2)
         do l=1,(nm+1)*(nm+1)
            wa_dlon_wa(irm(l,1),k) = irm(l,2)*wa_data(l,k)
         enddo
      enddo
    end function wa_dlon_wa

    function xya_gradlon_wa(wa_data) ! ڥȥ˺Ѥ۷ʬ
                                ! 1/cosա/ߦ
      real(8), intent(in)  :: wa_data(:,:)
      real(8)              :: xya_gradlon_wa(im,jm,size(wa_data,2))

      xya_gradlon_wa = xya_wa(wa_data,ipow=1,iflag=-1)
    end function xya_gradlon_wa

    function xya_gradlat_wa(wa_data) ! ڥȥ˺Ѥ۷ʬ, /ߦ
      real(8), intent(in)  :: wa_data(:,:)
      real(8)              :: xya_gradlat_wa(im,jm,size(wa_data,2))

      xya_gradlat_wa = xya_wa(wa_data,ipow=1,iflag=1)
    end function xya_gradlat_wa

    function wa_divlon_xya(xya_data)   ! ʻҤ˺Ѥȯʬ 
                                  ! 1/cosա/ߦ

      real(8), intent(in)  :: xya_data(:,:,:)
      real(8)              :: wa_divlon_xya((nm+1)*(nm+1),size(xya_data,3))

      wa_divlon_xya = wa_xya(xya_data,ipow=1,iflag=-1)
    end function wa_divlon_xya

    function wa_divlat_xya(xya_data)   ! ʻҤ˺Ѥȯʬ
                                  ! 1/cosա(f cos)/ߦ

      real(8), intent(in)  :: xya_data(:,:,:)
      real(8)              :: wa_divlat_xya((nm+1)*(nm+1),size(xya_data,3))

      wa_divlat_xya = wa_xya(xya_data,ipow=1,iflag=1)
    end function wa_divlat_xya

    function wa_div_xya_xya(xya_u,xya_v)     ! ʻҤ˺Ѥȯ
      real(8), intent(in)  :: xya_u(:,:,:)   ! ٥ȥʬ
      real(8), intent(in)  :: xya_v(:,:,:)   ! ٥ȥʬ
      real(8)              :: wa_div_xya_xya((nm+1)*(nm+1),size(xya_u,3))

      wa_div_xya_xya = wa_divlon_xya(xya_u) + wa_divlat_xya(xya_v)
    end function wa_div_xya_xya

    function wa_jacobian_wa_wa(wa_a,wa_b)  ! ڥȥ˺Ѥ䥳ӥ
                             ! J(f,g) = f/ߦˡg/ߦ - g/ߦˡf/ߦ
                             !        = f/ߦˡ1/cosաg/ߦ
                             !           - g/ߦˡ1/cosաf/ߦ

      real(8), intent(in) :: wa_a(:,:)
      real(8), intent(in) :: wa_b(:,:)
      real(8)             :: wa_jacobian_wa_wa((nm+1)*(nm+1),size(wa_a,2))

      integer :: k

      do k=1,size(wa_a,2)
         wa_jacobian_wa_wa(:,k) = w_jacobian_w_w(wa_a(:,k),wa_b(:,k))
      end do
    end function wa_jacobian_wa_wa

  end module wa_deriv_module

