!----------------------------------------------------------------------
!     Copyright (c) 2002 Shin-ichi Takehiro. All rights reserved.
!----------------------------------------------------------------------
!
!  yt_ggg, ggg_yt Υƥ
!  
program yt_test1

  use yt_module
  implicit none

  integer,parameter  :: im=32, jm=16, km=16  ! ʻ(, , ư)
  integer,parameter  :: nm=10, lm=16         ! ȿ(ʿ, ư)
  real(8),parameter  :: ri=0.5, ro=1.5      ! ⳰Ⱦ

  real(8), dimension(im,jm,0:km)     :: ggg_data
  real(8), dimension((nm+1)**2,0:lm) :: yt_data

  real(8), parameter :: eps=1D-10

  integer :: l
  integer :: n=1

  write( 6,* ) 'Test for yt_ggg'

  write(6,*) 'exponent N, of radial dependence for r^N?'
  read(5,*) n

  call yt_initial(im,jm,km,nm,lm,ri,ro)

  !ggg_data = ggg_rad**n * sin(ggg_lat)                  ! (n,m)=(1,0)
  !ggg_data = ggg_rad**n * sin(ggg_lon)*cos(ggg_lat)    ! (n,m)=(1,-1)
  ggg_data = ggg_rad**n * cos(ggg_lon)*cos(ggg_lat)    ! (n,m)=(1,1)

  yt_data = yt_ggg(ggg_data)

  write( 6,* ) 'Non-zero component of yt_data(n,l)'
  write( 6,* ) 'n, nm_l(n),l, data'
  do l=0,lm
     do n=1,(nm+1)**2
        if ( abs(yt_data(n,l)) > eps ) then
           write( 6,* ) n,nm_l(n),l,yt_data(n,l)
        end if
     enddo
  enddo

end program yt_test1
