!----------------------------------------------------------------------
!     Copyright (c) 2002-2005 Shin-ichi Takehiro. All rights reserved.
!----------------------------------------------------------------------
!ɽ  wa_base_module
!
!  2002/02/02  ݹ  ¿Ѥ˲¤
!      2002/03/30  ݹ  ⥸塼̾ѹ
!      2002/05/25  ݹ  ʻɸ̤٤̿̾ˡѹ
!      2005/01/09  ݹ  msgdmp -> MessageNotify ѹ
!
!         Ѵʻǡ, ڥȥǡ礭Ϸᤦ
!
module wa_base_module

  use dc_message
  use w_base_module, only : im, jm, nm, it, t, y, ip, p, r, ia, a
  implicit none

  integer               :: km=16         ! Ʊ˽ǡ(ؤο)

  integer, allocatable  :: ipk(:,:)            ! Ѵ(¿)
  real(8), allocatable  :: pk(:,:), rk(:,:)    ! Ѵ(¿)

  real(8), allocatable  :: q(:)                ! 
  real(8), allocatable  :: ww(:), ws(:)        ! 

  real(8), parameter    :: pi=3.14159265358979

  private

  public km                                    ! ؿ
  public wa_base_Initial                       ! ֥롼
  public xya_wa, wa_xya                        ! Ѵؿ

  save km                                      ! ǡ(ؿ)򵭲
  save ipk, pk, rk                             ! Ѵ򵭲

  contains
  !---------------  -----------------
    subroutine wa_base_initial(k_in)

      integer,intent(in) :: k_in               ! ǡ(ؿ)򵭲

      integer :: iw

      km = k_in

      allocate(ipk(km,((nm+1)/2+nm+1)*2))      ! Ѵ(¿)
      allocate(pk(km,((nm+1)/2+nm+1)*jm))      ! Ѵ(¿)
      allocate(rk(km,((nm+1)/2*2+3)*(nm/2+1))) ! Ѵ(¿)

      allocate(q(km*((nm+1)/2+nm+1)*jm))       ! (¿)
      iw=km*(im+3*(nm+1))*jm
      allocate(ws(iw),ww(iw))                  ! (¿)

      call snkini(nm,jm,km,ip,p,r,ipk,pk,rk)

    end subroutine wa_base_Initial

  !--------------- Ѵ -----------------

    function xya_wa(wa_data,ipow,iflag)    ! Ĵ´ؿڥȥ -> ʻ
      real(8), intent(in)   :: wa_data(:,:)                    ! ڥȥ
      real(8)               :: xya_wa(im,jm,size(wa_data,2))   ! ʻ
      integer, intent(in), optional  :: ipow      ! Ѥ 1/cos μ
      integer, intent(in), optional  :: iflag     ! Ѵμ

      integer, parameter  :: ipow_default  = 0
      integer, parameter  :: iflag_default = 0

      integer ipval, ifval
      integer k

      if (present(ipow)) then
         ipval = ipow
      else
         ipval = ipow_default
      endif

      if (present(iflag)) then
         ifval = iflag
      else
         ifval = iflag_default
      endif

      k= size(wa_data,2)
      if  ( k > km ) then
         call MessageNotify('E','xya_wa','Size of 3rd dimension invalid.')
      else
         call snts2g(nm,im,im,jm,jm,size(wa_data,2),wa_data,xya_wa,&
              it,t,y,ipk(1:k,:),pk(1:k,:),rk(1:k,:),ia,a,q,ws,ww,ipval,ifval)
      endif

    end function xya_wa

    function wa_xya(xya_data,ipow,iflag) ! ʻ -> Ĵ´ؿڥȥ
      real(8), intent(in)   :: xya_data(:,:,:)      ! ʻ(im,jm,*)
      real(8)               :: wa_xya((nm+1)*(nm+1),size(xya_data,3))  ! ڥȥ
      integer, intent(in), optional  :: ipow        ! Ѥ 1/cos μ
      integer, intent(in), optional  :: iflag       ! Ѵμ

      integer, parameter  :: ipow_default  = 0      ! åǥե
      integer, parameter  :: iflag_default = 0      ! åǥե

      integer ipval, ifval
      integer k

      if (present(ipow)) then
         ipval = ipow
      else
         ipval = ipow_default
      endif

      if (present(iflag)) then
         ifval = iflag
      else
         ifval = iflag_default
      endif

      k = size(xya_data,3)
      if ( k > km ) then
         call MessageNotify('E','wa_xya','Size of 3rd dimension invalid.')
      else
         call sntg2s(nm,im,im,jm,jm,k,xya_data,wa_xya,&
              it,t,y,ipk(1:k,:),pk(1:k,:),rk(1:k,:),ia,a,q,ws,ww,ipval,ifval)
      endif
    end function wa_xya

  end module wa_base_module

