      subroutine DDFT(nmax,nmay,mmax,mmay,z,a)
      real z(0:nmax,0:nmay)
      complex a(-mmax/2:mmax/2,-mmay/2:mmay/2)
      complex gfx(-mmax/2:mmax/2,0:nmay)
      complex i, W, V
      real pi

*--  ---
      i=(0.0,1.0)
      pi=3.14159
      W=exp(-2.0*pi*i/(real(nmax+1)))
      V=exp(-2.0*pi*i/(real(nmay+1)))

*-- x μ DFT ---
      do n=0,nmay
         do m=-mmax/2,mmax/2
            gfx(m,n)=z(0,n)
            do j=1,nmax
              gfx(m,n)=gfx(m,n)+z(j,n)*(W**(m*j))
            end do
            gfx(m,n)=gfx(m,n)/(real(nmax+1))
         end do
      end do

*-- y ʣ DFT ---
      do m=-mmax/2,mmax/2
         do n=-mmay/2,mmay/2
            a(m,n)=gfx(m,0)
            do k=0,nmay
               a(m,n)=a(m,n)+gfx(m,k)*(V**(n*k))
            end do
         a(m,n)=a(m,n)/(real(nmay+1))
         end do
      end do

      return
      end
