#include <stdio.h>
#include <math.h>
#include <string.h>

int main(void)
{
  int i, j;
  FILE *fp;
  int nx = 101;
  float cur[nx];
  float pas[nx];
  float c[nx];
  float x[nx];
  float xmin = 0.0;
  float xmax = 1.0;
  float dx = (xmax-xmin)/(nx-1);
  float dt = 1.0e-2;
  int step = 1e3;
  float coe;

/* initial condition */

  for (i=0 ; i<=nx-1; i=i+1){
     x[i]=xmin+dx*i;
     cur[i]=exp(-15.0*pow((x[i]-(xmax-xmin)/2.0),2));
     pas[i]=cur[i];
     c[i]=sin(x[i]);   /* velocity field */
  };

/* calculate time integral */
/* i = time step, j = space step */

  coe=0.5*dt/dx;
  fp=fopen("test.dat", "w");
  for (i=0 ; i<=step ; i=i+1){
     for (j=1 ; j<=nx-2 ; j=j+1){
        cur[j]=pas[j]-coe*
               (c[j]*(pas[j+1]-pas[j-1])-fabs(c[j])*(pas[j+1]-2.0*pas[j]+pas[j-1]));
     }

/* boundary condition */

     cur[0]=cur[1];
     cur[nx-1]=cur[nx-2];

     for (j=0 ; j<=nx-1 ; j=j+1){
        fprintf(fp,"%f %f\n", x[j], pas[j] );
        pas[j]=cur[j];
     };
  };
  fclose(fp);

}
