#include <stdio.h>
#include <math.h>
#include <string.h>

int main(void)
{
  int i, j, k;
  FILE *fp;
  int nx = 101;
  int ny = 101;
  float cur[ny][nx];
  float pas[ny][nx];
  float x[nx];
  float y[ny];
  float xmin = 0.0;
  float xmax = 1.0;
  float ymin = 0.0;
  float ymax = 1.0;
  float dx = (xmax-xmin)/(nx-1);
  float dy = (ymax-ymin)/(ny-1);
  float dt = 1.0e-2;
  float cx[ny][nx];
  float cy[ny][nx];
  int step = 1e3;
  float xmid = (xmax-xmin)/2.0;
  float ymid = (ymax-ymin)/2.0;
  float coe;

/* position */

  for (i=0 ; i<=nx-1; i=i+1){
     x[i]=xmin+dx*i;
  }

  for (i=0 ; i<=ny-1; i=i+1){
     y[i]=ymin+dy*i;
  }

/* initial condition */

  for (j=0 ; j<=ny-1; j=j+1){
  for (i=0 ; i<=nx-1; i=i+1){
     cur[j][i]=exp(-15.0*(pow((x[i]-xmid),2)+pow((y[j]-ymid),2)));
     pas[j][i]=cur[j][i];
     cx[j][i]=cos(x[i]+y[j]);
     cy[j][i]=cos(x[i]+y[j]);
  };
  };

/* calculate time integral */
/* i = time step, j,k = space step */

  coe=0.5*dt;
  fp=fopen("test.dat", "w");
  for (i=0 ; i<=step ; i=i+1){
     for (k=1 ; k<=ny-2 ; k=k+1){
     for (j=1 ; j<=nx-2 ; j=j+1){
        cur[k][j]=pas[k][j]
                 -coe*((cx[k][j]*(pas[k][j+1]-pas[k][j-1])
                  -fabs(cx[k][j])*(pas[k][j+1]-2.0*pas[k][j]+pas[k][j-1]))/dx
                 +(cy[k][j]*(pas[k+1][j]-pas[k-1][j])
                  -fabs(cy[k][j])*(pas[k+1][j]-2.0*pas[k][j]+pas[k-1][j]))/dy);
     };
     };

/* boundary condition */

     for (j=1 ; j<=nx-2 ; j=j+1){
        cur[0][j]=cur[1][j];
        cur[nx-1][j]=cur[nx-2][j];
     };

     for (j=1 ; j<=ny-2 ; j=j+1){
        cur[j][0]=cur[j][1];
        cur[j][ny-1]=cur[j][ny-2];
     };

     cur[0][0]=0.5*(cur[0][1]+cur[1][0]);
     cur[ny-1][0]=0.5*(cur[ny-1][1]+cur[nx-2][0]);
     cur[0][nx-1]=0.5*(cur[1][nx-1]+cur[0][nx-2]);
     cur[ny-1][nx-1]=0.5*(cur[ny-1][nx-2]+cur[ny-2][nx-1]);

     for (k=0 ; k<=ny-1 ; k=k+1){
     for (j=0 ; j<=nx-1 ; j=j+1){
        fprintf(fp,"%f %f %f\n", x[j], y[k], pas[k][j] );
        pas[k][j]=cur[k][j];
     };
     };
  };
  fclose(fp);

}
