! Copyright (C) GFD Dennou Club, 2000.  All rights reserved.

! o͔͈͂܂w
subroutine GTVarSliceAuto(var, compatible)
    use gtdata_types, only: GT_VARIABLE
    use gtdata_generic, only: Inquire, Get_Slice, GTVarSlice
    type(GT_VARIABLE), intent(inout):: var
    type(GT_VARIABLE), intent(in), optional:: compatible
    integer:: nd, i
    integer, allocatable:: start(:), count(:), stride(:)
    call Inquire(var, alldims=nd)
    if (nd <= 0) return
    allocate(start(nd), count(nd), stride(nd))
    if (present(compatible)) then
        call Get_Slice(compatible, start, count, stride)
        do, i = 1, nd
            call GTVarSlice(var, i, start(i), count(i), stride(i))
        enddo
    else
        call Get_Slice(var, start, count, stride)
        do, i = 1, nd
            if (count(i) < 1) count(i) = 1
            call GTVarSlice(var, i, start(i), count(i), stride(i))
        enddo
    endif
    deallocate(start, count, stride)
end subroutine
