module Thermo_Function  ! Ǯϳؤ˴طؿ
  ! Ǯϳѿ֤Ѵؿξ, "..2.."Ȥˤʤ.
  ! ξ, 2 ƤΤ 2 θˤΤѴȤ
  ! Ȥ̣Ƥ.
use Thermo_Const
use Phys_Const

contains

real function tetens(T)  ! ƥƥμ¸Ѥ˰¿׻.
  implicit none
  real, intent(in) :: T  ! 絤β [K]
  real, parameter :: a=7.5, b=237.7, c=9.5, d=265.5
  real, parameter :: t0=273.15
  real :: e0

write(*,*) e0
  if(t<=t0)then
     tetens=e0*10.0**(c*(t-t0)/(t-t0+d))
  else
     tetens=e0*10.0**(a*(t-t0)/(t-t0+b))
  end if

  return
end function

!-----------------------------------------------------
!-----------------------------------------------------

real function es_Bolton(T)  ! Bolton(1980) μˡѤ˰¿׻.
  implicit none
  real, intent(in) :: T  ! 絤β [K]
  real, parameter :: t0=273.15, a=17.67, c=29.65

  es_Bolton=e0*exp(a*((T-t0)/(T-c)))

  return
end function

!-----------------------------------------------------
!-----------------------------------------------------

real function LH(T)  !  T ˤǮη׻
  ! ܴؿ, ǮȤη̤Ȥۤ礭ʺޤʤ.
  ! ܷ׻, ǮβѲ˴ؤ֥ҥۥåդμפѤ.
  ! ޤ, κݤɬפʱο갵Ǯӿ갵Ǯ
  ! ٰ¸ʤΤȲꤷ, 줾
  ! $C_l=4190,\; C_{pv}=1870$ȤͤѤƳФطǤ.
  ! ä, ѤǮͤ䤽βٰ¸θȷѲǽ.
  implicit none
  real, intent(in) :: T  ! 絤β [K]
  real, parameter :: t0=273.15

  LH=LH0-2.32e3*(T-t0)

  return
end function

!-----------------------------------------------------
!-----------------------------------------------------

real function eP_2_qv(e,P)  ! 麮׻
  implicit none
  real, intent(in) :: e  !  [Pa]
  real, intent(in) :: P  ! 絤 [Pa]
  real :: eps

  eps=Rd/Rv
  eP_2_qv=eps*e/(P-e)

  return
end function

!-----------------------------------------------------
!-----------------------------------------------------

real function TP_2_qvs(T,P)  ! ٤˰º׻
  ! Ǥ, es_Bolton Ѥ˰¿׻,
  ! eP_2_qv ѤƺѴ뤳Ȥ˰º׻.
  implicit none
  real, intent(in) :: T  !  [K]
  real, intent(in) :: P  ! 絤 [Pa]
  real :: eps
  real :: eP_2_qv, es

  eps=Rd/Rv
  es=es_Bolton(T)
  TP_2_qvs=eps*es/(P-es)

  return
end function

!-----------------------------------------------------
!-----------------------------------------------------

real function qvP_2_e(qv,P)  ! ׻
  implicit none
  real, intent(in) :: qv  !  [kg / kg]
  real, intent(in) :: P  !  [Pa]
  real :: eps

  eps=Rd/Rv
  qvP_2_e=P*qv/(eps+qv)

  return
end function

!-----------------------------------------------------
!-----------------------------------------------------

real function theta_dry(T,P)  ! 絤ˤ벹̤׻
  ! , 絤ˤƤ, ¬ P ȤƷ׻뤳ȤǤ
  ! η̴̤ؿ theta_moist η̤ȤۤѤʤ.
  implicit none
  real, intent(in) :: T  !  [K]
  real, intent(in) :: P  ! 絤ε(⤷, 絤) [Pa]
  real :: kappa

  kappa=Rd/Cpd
  theta_dry=T*(p0/P)**kappa

  return
end function

!-----------------------------------------------------
!-----------------------------------------------------

real function theta_moist(T,P,qv)  ! 絤ˤ벹̤׻
  implicit none
  real, intent(in) :: T  !  [K]
  real, intent(in) :: P  ! 絤 [Pa]
  real, intent(in) :: qv  !  [kg / kg]
  real :: eps, kappa, CR

  eps=Rd/Rv
  kappa=Rd/Cpd
  CR=Cpv/Cpd

  kappa=kappa*((1.0+qv/eps)/(1.0+qv*CR))  ! kappa ͤ夫񤭤Ƥ뤳Ȥ
  theta_moist=T*(p0/P)**kappa

  return
end function

!-----------------------------------------------------
!-----------------------------------------------------

real function thetaP_2_T(theta,P)  ! , Ϥ鲹٤׻(絤ȤƷ׻)
  implicit none
  real, intent(in) :: theta  !  [K]
  real, intent(in) :: P  ! 絤 [Pa]
  real :: kappa

  kappa=Rd/Cpd

  thetaP_2_T=theta*(P/p0)**kappa

  return
end function

!-----------------------------------------------------
!-----------------------------------------------------

real function thetaT_2_P(theta,T)  ! , ٤鰵Ϥ׻(絤ȤƷ׻)
  implicit none
  real, intent(in) :: theta  !  [K]
  real, intent(in) :: T  !  [T]
  real :: kappa

  kappa=Cpd/Rd

  thetaT_2_P=p0*(T/theta)**kappa

  return
end function

!-----------------------------------------------------
!-----------------------------------------------------

real function TqvP_2_TLCL(T,qv,P)  !! ٤Ⱥ T_LCL ׻
  ! 椫,  T_LCL ׻
  implicit none
  real, intent(in) :: T  !  [K]
  real, intent(in) :: qv  !  [kg / kg]
  real, intent(in) :: P  !  [Pa]
  real, parameter :: coe=2840.0, a=3.5, b=4.805, c=55.0
  real :: e

  e=qvP_2_e(qv,P)
  e=e*1.0e-2
  TqvP_2_TLCL=coe/(a*log(T)-log(e)-b)+55.0

  return
end function

!-----------------------------------------------------
!-----------------------------------------------------

real function thetae_Bolton(T,qv,P)  ! Bolton(1980) ˤˡѤ̤׻.
  ! T_LCL ѤΤ, ΤδؿѤ.
  implicit none
  real, intent(in) :: T  !  [K]
  real, intent(in) :: qv  !  [kg / kg]
  real, intent(in) :: P  !  [Pa]
  real :: T_LCL
  real, parameter :: a=0.2854, b=0.28, c=3376.0, d=0.81

  T_LCL=TqvP_2_TLCL(T,qv,P)
  thetae_Bolton=T*((p0/P)**(a*(1.0-b*qv)))  &
   &            *exp((c/T_LCL-2.54)*qv*(1.0+d*qv))

  return
end function

!-----------------------------------------------------
!-----------------------------------------------------

real function thetaes_Bolton(T,qv,P)  ! Bolton(1980) ˤˡѤ˰̤׻.
  implicit none
  real, intent(in) :: T  !  [K]
  real, intent(in) :: qv  !  [kg / kg]
  real, intent(in) :: P  !  [Pa]
  real, parameter :: a=0.2854, b=0.28, c=3376.0, d=0.81

  thetaes_Bolton=T*((p0/P)**(a*(1.0-b*qv)))  &
   &            *exp((c/T-2.54)*qv*(1.0+d*qv))

  return
end function

!-----------------------------------------------------
!-----------------------------------------------------

real function TqvP_2_thetae(T,qv,P)  ! , , ̤׻.
  ! T_LCL ѤΤ, ΤδؿѤ.
  implicit none
  real, intent(in) :: T  !  [K]
  real, intent(in) :: qv  !  [kg / kg]
  real, intent(in) :: P  !  [Pa]
  real :: T_LCL, kappa, theta_d, e
  real, parameter :: a=0.2854, b=0.28, c=3376.0, d=0.81

  kappa=Rd/Cpd
  e=qvP_2_e(qv,P)
  T_LCL=TqvP_2_TLCL(T,qv,P)
  theta_d=T*(p0/(P-e))**kappa
  TqvP_2_thetae=theta_d*exp(LH(T_LCL)*qv/(Cpd*T_LCL))

  return
end function

!-----------------------------------------------------
!-----------------------------------------------------

real function TqvP_2_thetaes(T,qv,P)  ! , , ˰̤׻.
  ! T_LCL ѤΤ, ΤδؿѤ.
  implicit none
  real, intent(in) :: T  !  [K]
  real, intent(in) :: qv  !  [kg / kg]
  real, intent(in) :: P  !  [Pa]
  real :: kappa, theta_d, e
  real, parameter :: a=0.2854, b=0.28, c=3376.0, d=0.81

  kappa=Rd/Cpd
  e=qvP_2_e(qv,P)
  theta_d=T*(p0/(P-e))**kappa
  TqvP_2_thetaes=theta_d*exp(LH(T)*qv/(Cpd*T))

  return
end function

!-----------------------------------------------------
!-----------------------------------------------------

real function RHT_2_e(RH,T)  ! м٤Ȳ٤׻
  ! $RH=(e/es)\times 100$ Ȥ׻.
  implicit none
  real, intent(in) :: RH  ! м [%]
  real, intent(in) :: T  !  [K]
  real :: es

  es=es_Bolton(T)
  RHT_2_e=RH*es*1.0e-2

  return
end function

!-----------------------------------------------------
!-----------------------------------------------------

real function eT_2_RH(e,T)  ! Ȳ٤м٤׻
  ! $RH=(e/es)\times 100$ Ȥ׻.
  implicit none
  real, intent(in) :: e  !  [Pa]
  real, intent(in) :: T  !  [K]
  real :: es

  es=es_Bolton(T)
  eT_2_RH=100.0*e/es

  return
end function

!-----------------------------------------------------
!-----------------------------------------------------

real function RHTP_2_qv(RH,T,P)  ! м٤Ȳ٤麮׻
  ! RHT_2_e ׻, eP_2_qv 麮׻.
  implicit none
  real, intent(in) :: RH  ! м [%]
  real, intent(in) :: T  !  [K]
  real, intent(in) :: P  !  [Pa]
  real :: e

  e=RHT_2_e(RH,T)
  RHTP_2_qv=eP_2_qv(e,P)

  return
end function

!-----------------------------------------------------
!-----------------------------------------------------

real function qvTP_2_RH(qv,T,P)  ! Ȳ٤м٤׻.
  ! qvP_2_e ׻, м٤Ѥ.
  implicit none
  real, intent(in) :: qv  ! м [kg / kg]
  real, intent(in) :: T  !  [K]
  real, intent(in) :: P  !  [Pa]
  real :: e, es

  e=qvP_2_e(qv,P)
  qvTP_2_RH=eT_2_RH(e,T)

  return
end function

!-----------------------------------------------------
!-----------------------------------------------------

real function exner_func_dry(P)  ! 絤ˤĤƤΥʡؿ׻
  implicit none
  real, intent(in) :: P  !  [Pa]
  real :: kappa

  kappa=Rd/Cpd
  exner_func_dry=(p0/P)**kappa
write(*,*) "exner_func_dry, p0=", p0

  return
end function

!-----------------------------------------------------
!-----------------------------------------------------

real function hypsometric_form(p,z,T,z_t)  ! ٤ȵͿƤ٤ε.
!  ιˤήˤɸ絤βٸΨǤ 6.5 [K/km] Ƿ׻.
  implicit none
  real, intent(in) :: p  ! Ȥʤ٤ˤ밵 [Pa]
  real, intent(in) :: z  ! Ȥʤ [m]
  real, intent(in) :: T  ! Ǥβ [K]
  real, intent(in), optional :: z_t  !  [m] : ǥեȤǤ 0 m.
  real, parameter :: gam = 6.5e-3  ! ɸ絤βٸΨ [K/m]
  real :: z_calc, p_tmp

!write(*,*) "hypsometric, g=", g

  if(present(z_t))then
     z_calc=z_t
  else
     z_calc=0.0
  end if

  p_tmp=p*((T+gam*z)/(T+gam*z_calc))**(g/(gam*Rd))
  hypsometric_form=p_tmp

  return
end function

!-----------------------------------------------------
!-----------------------------------------------------

real function get_gamma_d()  ! ǮΨƤִؿ(δؿɬפ)
  implicit none

  get_gamma_d=-g/Cpd

  return
end function

!-----------------------------------------------------
!-----------------------------------------------------

!real function




!  return
!end function

!-----------------------------------------------------
!-----------------------------------------------------





end module
