subroutine LU_devs( nmax, a, b, x, itermax )
!-- LU ʬ׻륵֥롼 ---
  implicit none
  integer, intent(in) :: nmax  ! ǿ
  real, intent(in) :: a(nmax,nmax)  !  ( 1 ǤԤɽ)
  real, intent(in) :: b(nmax)  ! դΥ٥ȥ
  real, intent(in) :: x(nmax)  ! 
  real :: d(nmax,nmax), r(nmax), y(nmax)
  integer :: ip(nmax)
  real :: scale(nmax), dx(nmax)
  real :: s, t, pivot, xnorm, dxnorm
  real :: s1, s2, s3, s4, s5, t0, t1, t2, t3, t4
  integer :: iter, itermax
  integer :: p, itemp

!-- ȿɤǤ٤ ---
  t4=6.0

!--  x(i) ν ---
  do i=1,nmax
     x(i)=0.0
  end do

  do i=1,nmax
     do j=1,nmax
        d(i,j)=a(i,j)
     end do

     ip(i)=i

!-- ͤ׻롼 ---
     s=d(i,1)
     do j=2,nmax
        if(d(i,j).gt.s)then
           s=d(i,j)
        end if
     end do
     scale(i)=1.0/s
  end do

  do k=1,nmax
     t=d(ip(k),k)*scale(ip(k))
     p=k
     do i=k,nmax
        t0=d(ip(i),k)*scale(ip(i))
        if(t0.gt.t)then
           t=t0
           p=i
        end if
     end do

!-- ip(p)  ip(k) ؤ ---
     if(p.ne.k)then
        itemp=ip(p)
        ip(p)=ip(k)
        ip(k)=itemp
     end if
!---------------
     pivot=d(ip(k),k)
     do i=k+1,nmax
        d(ip(i),k)=d(ip(i),k)/pivot
        do j=k+1,nmax
           d(ip(i),j)=d(ip(i),j)-d(ip(i),k)*d(ip(k),j)
        end do
     end do
     if(k.ge.nmax-1)then
        exit
     end if
  end do

!-- ʾõ ---
  y(1)=b(ip(1))
  do i=2,nmax
     s1=0.0
     do j=1,i-1
        s1=s1+d(ip(i),j)*y(j)
     end do
     y(i)=b(ip(i))-s1
  end do

!--  ---
  x(nmax)=y(nmax)/d(ip(nmax),nmax)
  do i=nmax-1,1,-1
     s2=0.0
     do j=i+1,nmax
        s2=s2+d(ip(i),j)*y(j)
     end do
     x(i)=(y(i)-s2)/d(ip(i),i)
  end do

  t1=x(1)
  xnorm=x(1)

  do i=2,nmax
     if(x(i).gt.t1)then
        t1=x(i)
        xnorm=x(i)
     end if
  end do

!-- ȿ ---
  eps=10**(-t4)                      ! ɸ٤ 10 ʿ t4 Ȥ

  do iter=1,itermax
     if(xnorm==0.0)then
        exit
     end if
!-- ĺη׻ ---
     do i=1,nmax
        s3=0.0
        do j=1,nmax
           s3=s3+a(i,j)*x(j)
        end do
        r(i)=b(i)-s3
     end do

!-- ʾõ ---
     y(1)=r(ip(1))
     do i=2,nmax
        s4=0.0
        do j=1,i-1
           s4=s4+d(ip(i),j)*y(j)
        end do
        y(i)=r(ip(i))-s4
     end do

!--  ---
     dx(nmax)=y(nmax)/d(ip(nmax),nmax)
     do i=nmax-1,1,-1
        s5=0.0
        do j=i+1,nmax
           s5=s5+d(ip(i),j)*y(j)
        end do
        dx(i)=(y(i)-s5)/d(ip(i),i)
     end do

     do i=1,nmax
        x(i)=x(i)+dx(i)
     end do

     t3=dx(1)
     dxnorm=dx(1)
     do i=1,nmax
        if(dx(i).gt.t3)then
           t3=dx(i)
           dxnorm=dx(i)
        end if
     end do

     if(dxnorm/xnorm.le.eps)then
        exit
     end if
  end do

end subroutine LU_devs
