module Trajectory
!  ȥ饸ȥϤԤ롼
  use Statistics

contains


subroutine Forward_Traject_2d( dt, step, ini_x, ini_y, x, y, u, v, trajx, trajy, opt )
! ήϥ롼
! ʬˤĤƤ, ǥեȤǤϥ顼ˡǷ׻.
! 'HO1'= 顼ˡʥۥ󥹥
! 'ME1'= ɥ顼ˡ
! 'RK3'= 3 󥲥å
! 'RK4'= 4 󥲥å
  implicit none
  real, intent(in) :: dt  ! ׻ֳִ [s]
  integer, intent(in) :: step  ! ׻Ԥƥå׿
  real, intent(in) :: ini_x  !  x [m]
  real, intent(in) :: ini_y  !  y [m]
  real, intent(in) :: x(:)  ! x κɸ
  real, intent(in) :: y(:)  ! y κɸ
  real, intent(in) :: u(size(x),size(y))  ! x ®ʬ [m/s]
  real, intent(in) :: v(size(x),size(y))  ! x ®ʬ [m/s]
  real, intent(inout) :: trajx(step)  ! ȥ饸ȥΰֺɸ x [m]
  real, intent(inout) :: trajy(step)  ! ȥ饸ȥΰֺɸ y [m]
  character(*), intent(in), optional :: opt  ! ʬ
  character(3) :: option
!-- ʲ, 
  integer :: i, j, k, l, m, n
  integer :: nx, ny
  real :: k1, k2, k3, k4, l1, l2, l3, l4
  real :: u1, v1, x1, y1
  real :: inter_p(2)  ! Ǥΰֺɸ󹹿
  real :: inter_v(2)  ! Ǥ®٤͡1=u, 2=v

!-- 뤿, x, y ɤΤ褦ϰϤȤäƤ׻ǽʻͤˤ
!-- Τ, x, y ϰϤǤꤹ
!  call (1)
!  call (nx)
!  call (1)
!  call (ny)

  nx=size(x)
  ny=size(y)

  trajx(1)=ini_x
  trajy(1)=ini_y

  if(present(opt))then
     option=opt
  else
     option='EU1'
  end if

  select case (option)
  case ('EU1')
     do i=1,step-1
!-- ֤ˤ®
!-- ֤
        inter_p=(/trajx(i), trajy(i)/)
!-- ֤ζ˵ 4 ׻.
        call interpo_search_2d( x, y, trajx(i), trajy(i), m, n )  
!-- u ʬˤĤƤν
        call interpolation_2d( x(m:m+1), y(n:n+1), u(m:m+1,n:n+1), inter_p, inter_v(1) )  
!-- v ʬˤĤƤν
        call interpolation_2d( x(m:m+1), y(n:n+1), v(m:m+1,n:n+1), inter_p, inter_v(2) )  

        x1=trajx(i)+dt*inter_v(1)
        y1=trajy(i)+dt*inter_v(2)
!-- ׻ traj ΰ¸ߤƤ뤫ǧ
        if(x1<x(1).or.x1>x(nx).or.y1<y(1).or.y1>y(ny))then
           write(*,*) "****** ERROR ******"
           write(*,*) "This point does not exist in the region."
           write(*,*) "Stop.!!"
           exit
        end if
        trajx(i+1)=x1
        trajy(i+1)=y1
     end do

  case ('HO1')
     do i=1,step-1
        inter_p=(/trajx(i), trajy(i)/)
        call interpo_search_2d( x, y, trajx(i), trajy(i), m, n )  
        call interpolation_2d( x(m:m+1), y(n:n+1), u(m:m+1,n:n+1), inter_p, inter_v(1) )  
        call interpolation_2d( x(m:m+1), y(n:n+1), v(m:m+1,n:n+1), inter_p, inter_v(2) )  

        k1=dt*inter_v(1)
        l1=dt*inter_v(2)
!-- Ūήΰ֤׻
        x1=trajx(i)+k1
        y1=trajy(i)+l1
!-- Ǥ®پ
        inter_p=(/x1, y1/)
        call interpo_search_2d( x, y, x1, y1, m, n )  
        call interpolation_2d( x(m:m+1), y(n:n+1), u(m:m+1,n:n+1), inter_p, inter_v(1) )  
        call interpolation_2d( x(m:m+1), y(n:n+1), v(m:m+1,n:n+1), inter_p, inter_v(2) )  

        k2=dt*inter_v(1)
        l2=dt*inter_v(2)
        x1=trajx(i)+0.5*(k1+k2)
        y1=trajy(i)+0.5*(l1+l2)

!-- ׻ traj ΰ¸ߤƤ뤫ǧ
        if(x1<x(1).or.x1>x(nx).or.y1<y(1).or.y1>y(ny))then
           write(*,*) "****** ERROR ******"
           write(*,*) "This point does not exist in the region."
           write(*,*) "Stop.!!"
           exit
        end if
        trajx(i+1)=x1
        trajy(i+1)=y1
     end do


  case ('ME1')
     do i=1,step-1
        inter_p=(/trajx(i), trajy(i)/)
        call interpo_search_2d( x, y, trajx(i), trajy(i), m, n )  
        call interpolation_2d( x(m:m+1), y(n:n+1), u(m:m+1,n:n+1), inter_p, inter_v(1) )  
        call interpolation_2d( x(m:m+1), y(n:n+1), v(m:m+1,n:n+1), inter_p, inter_v(2) )  

        k1=dt*inter_v(1)
        l1=dt*inter_v(2)
!-- Ūήΰ֤׻
        x1=trajx(i)+0.5*k1
        y1=trajy(i)+0.5*l1
!-- Ǥ®پ
        inter_p=(/x1, y1/)
        call interpo_search_2d( x, y, x1, y1, m, n )  
        call interpolation_2d( x(m:m+1), y(n:n+1), u(m:m+1,n:n+1), inter_p, inter_v(1) )  
        call interpolation_2d( x(m:m+1), y(n:n+1), v(m:m+1,n:n+1), inter_p, inter_v(2) )  

        k2=dt*inter_v(1)
        l2=dt*inter_v(2)
        x1=trajx(i)+k2
        y1=trajy(i)+l2

!-- ׻ traj ΰ¸ߤƤ뤫ǧ
        if(x1<x(1).or.x1>x(nx).or.y1<y(1).or.y1>y(ny))then
           write(*,*) "****** ERROR ******"
           write(*,*) "This point does not exist in the region."
           write(*,*) "Stop.!!"
           exit
        end if
        trajx(i+1)=x1
        trajy(i+1)=y1
     end do



  case ('RK3')
     do i=1,step-1
        inter_p=(/trajx(i), trajy(i)/)
        call interpo_search_2d( x, y, trajx(i), trajy(i), m, n )  
        call interpolation_2d( x(m:m+1), y(n:n+1), u(m:m+1,n:n+1), inter_p, inter_v(1) )  
        call interpolation_2d( x(m:m+1), y(n:n+1), v(m:m+1,n:n+1), inter_p, inter_v(2) )  

        k1=dt*inter_v(1)
        l1=dt*inter_v(2)
!-- Ūήΰ֤׻
        x1=trajx(i)+0.5*k1
        y1=trajy(i)+0.5*l1
!-- Ǥ®پ
        inter_p=(/x1, y1/)
        call interpo_search_2d( x, y, x1, y1, m, n )  
        call interpolation_2d( x(m:m+1), y(n:n+1), u(m:m+1,n:n+1), inter_p, inter_v(1) )  
        call interpolation_2d( x(m:m+1), y(n:n+1), v(m:m+1,n:n+1), inter_p, inter_v(2) )  

        k2=dt*inter_v(1)
        l2=dt*inter_v(2)
        x1=trajx(i)-k1+2.0*k2
        y1=trajy(i)-l1+2.0*l2

!-- Ǥ®پ
        inter_p=(/x1, y1/)
        call interpo_search_2d( x, y, x1, y1, m, n )  
        call interpolation_2d( x(m:m+1), y(n:n+1), u(m:m+1,n:n+1), inter_p, inter_v(1) )  
        call interpolation_2d( x(m:m+1), y(n:n+1), v(m:m+1,n:n+1), inter_p, inter_v(2) )  

        k3=dt*inter_v(1)
        l3=dt*inter_v(2)
        x1=trajx(i)+(1.0/6.0)*(k1+4.0*k2+k3)
        y1=trajy(i)+(1.0/6.0)*(l1+4.0*l2+l3)

!-- ׻ traj ΰ¸ߤƤ뤫ǧ
        if(x1<x(1).or.x1>x(nx).or.y1<y(1).or.y1>y(ny))then
           write(*,*) "****** ERROR ******"
           write(*,*) "This point does not exist in the region."
           write(*,*) "Stop.!!"
           exit
        end if
        trajx(i+1)=x1
        trajy(i+1)=y1
     end do


  case ('RK4')
     do i=1,step-1
        inter_p=(/trajx(i), trajy(i)/)
        call interpo_search_2d( x, y, trajx(i), trajy(i), m, n )  
        call interpolation_2d( x(m:m+1), y(n:n+1), u(m:m+1,n:n+1), inter_p, inter_v(1) )  
        call interpolation_2d( x(m:m+1), y(n:n+1), v(m:m+1,n:n+1), inter_p, inter_v(2) )  

        k1=dt*inter_v(1)
        l1=dt*inter_v(2)
!-- Ūήΰ֤׻
        x1=trajx(i)+0.5*k1
        y1=trajy(i)+0.5*l1
!-- Ǥ®پ
        inter_p=(/x1, y1/)
        call interpo_search_2d( x, y, x1, y1, m, n )  
        call interpolation_2d( x(m:m+1), y(n:n+1), u(m:m+1,n:n+1), inter_p, inter_v(1) )  
        call interpolation_2d( x(m:m+1), y(n:n+1), v(m:m+1,n:n+1), inter_p, inter_v(2) )  

        k2=dt*inter_v(1)
        l2=dt*inter_v(2)
        x1=trajx(i)+0.5*k2
        y1=trajy(i)+0.5*l2

!-- Ǥ®پ
        inter_p=(/x1, y1/)
        call interpo_search_2d( x, y, x1, y1, m, n )  
        call interpolation_2d( x(m:m+1), y(n:n+1), u(m:m+1,n:n+1), inter_p, inter_v(1) )  
        call interpolation_2d( x(m:m+1), y(n:n+1), v(m:m+1,n:n+1), inter_p, inter_v(2) )  

        k3=dt*inter_v(1)
        l3=dt*inter_v(2)

        x1=trajx(i)+k3
        y1=trajy(i)+l3

!-- Ǥ®پ
        inter_p=(/x1, y1/)
        call interpo_search_2d( x, y, x1, y1, m, n )  
        call interpolation_2d( x(m:m+1), y(n:n+1), u(m:m+1,n:n+1), inter_p, inter_v(1) )  
        call interpolation_2d( x(m:m+1), y(n:n+1), v(m:m+1,n:n+1), inter_p, inter_v(2) )  

        k4=dt*inter_v(1)
        l4=dt*inter_v(2)
        x1=trajx(i)+(1.0/6.0)*(k1+2.0*k2+2.0*k3+k4)
        y1=trajy(i)+(1.0/6.0)*(l1+2.0*l2+2.0*l3+l4)

!-- ׻ traj ΰ¸ߤƤ뤫ǧ
        if(x1<x(1).or.x1>x(nx).or.y1<y(1).or.y1>y(ny))then
           write(*,*) "****** ERROR ******"
           write(*,*) "This point does not exist in the region."
           write(*,*) "Stop.!!"
           exit
        end if
        trajx(i+1)=x1
        trajy(i+1)=y1
     end do



  end select

end subroutine Forward_Traject_2d


subroutine Forward_Traject_3d( dt, step, ini_x, ini_y, ini_z, x, y, z, u, v, w, trajx, trajy, trajz, opt )
! ήϥ롼
! ʬˤĤƤ, ǥեȤǤϥ顼ˡǷ׻.
! 'HO1'= 顼ˡʥۥ󥹥
! 'ME1'= ɥ顼ˡ
! 'RK3'= 3 󥲥å
! 'RK4'= 4 󥲥å
  implicit none
  real, intent(in) :: dt  ! ׻ֳִ [s]
  integer, intent(in) :: step  ! ׻Ԥƥå׿
  real, intent(in) :: ini_x  !  x [m]
  real, intent(in) :: ini_y  !  y [m]
  real, intent(in) :: ini_z  !  z [m]
  real, intent(in) :: x(:)  ! x κɸ
  real, intent(in) :: y(:)  ! y κɸ
  real, intent(in) :: z(:)  ! y κɸ
  real, intent(in) :: u(size(x),size(y),size(z))  ! x ®ʬ [m/s]
  real, intent(in) :: v(size(x),size(y),size(z))  ! x ®ʬ [m/s]
  real, intent(in) :: w(size(x),size(y),size(z))  ! z ®ʬ [m/s]
  real, intent(inout) :: trajx(step)  ! ȥ饸ȥΰֺɸ x [m]
  real, intent(inout) :: trajy(step)  ! ȥ饸ȥΰֺɸ y [m]
  real, intent(inout) :: trajz(step)  ! ȥ饸ȥΰֺɸ z [m]
  character(*), intent(in), optional :: opt  ! ʬ
  character(3) :: option
!-- ʲ, 
  integer :: i, j, k, l, m, n, nx, ny, nz
  real :: k1, k2, k3, k4, l1, l2, l3, l4
  real :: u1, v1, w1, x1, y1, z1, n1, n2, n3, n4
  real :: inter_p(3)  ! Ǥΰֺɸ󹹿
  real :: inter_v(3)  ! Ǥ®٤͡1=u, 2=v

!-- 뤿, x, y ɤΤ褦ϰϤȤäƤ׻ǽʻͤˤ
!-- Τ, x, y ϰϤǤꤹ
!  call (1)
!  call (nx)
!  call (1)
!  call (ny)

  nx=size(x)
  ny=size(y)
  nz=size(z)

  trajx(1)=ini_x
  trajy(1)=ini_y
  trajz(1)=ini_z

  if(present(opt))then
     option=opt
  else
     option='EU1'
  end if

  select case (option)
  case ('EU1')
     do i=1,step-1
!-- ֤ˤ®
!-- ֤
        inter_p=(/trajx(i), trajy(i), trajz(i)/)
!-- ֤ζ˵ 4 ׻.
        call interpo_search_3d( x, y, z, trajx(i), trajy(i), trajz(i), m, n, l )  
!-- u ʬˤĤƤν
        call interpolation_3d( x(m:m+1), y(n:n+1), z(l:l+1), u(m:m+1,n:n+1,l:l+1), inter_p, inter_v(1) )  
!-- v ʬˤĤƤν
        call interpolation_3d( x(m:m+1), y(n:n+1), z(l:l+1), v(m:m+1,n:n+1,l:l+1), inter_p, inter_v(2) )  
!-- w ʬˤĤƤν
        call interpolation_3d( x(m:m+1), y(n:n+1), z(l:l+1), w(m:m+1,n:n+1,l:l+1), inter_p, inter_v(3) )  

        x1=trajx(i)+dt*inter_v(1)
        y1=trajy(i)+dt*inter_v(2)
        z1=trajz(i)+dt*inter_v(3)
!-- ׻ traj ΰ¸ߤƤ뤫ǧ
        if(x1<x(1).or.x1>x(nx).or.y1<y(1).or.y1>y(ny).or.z1<z(1).or.z1>z(nz))then
           write(*,*) "****** ERROR ******"
           write(*,*) "This point does not exist in the region."
           write(*,*) "Stop.!!"
           exit
        end if
        trajx(i+1)=x1
        trajy(i+1)=y1
        trajz(i+1)=z1
     end do

  case ('HO1')
     do i=1,step-1
        inter_p=(/trajx(i), trajy(i), trajz(i)/)
        call interpo_search_3d( x, y, z, trajx(i), trajy(i), trajz(i), m, n, l )  
        call interpolation_3d( x(m:m+1), y(n:n+1), z(l:l+1), u(m:m+1,n:n+1,l:l+1), inter_p, inter_v(1) )  
        call interpolation_3d( x(m:m+1), y(n:n+1), z(l:l+1), v(m:m+1,n:n+1,l:l+1), inter_p, inter_v(2) )  
        call interpolation_3d( x(m:m+1), y(n:n+1), z(l:l+1), w(m:m+1,n:n+1,l:l+1), inter_p, inter_v(3) )  

        k1=dt*inter_v(1)
        l1=dt*inter_v(2)
        n1=dt*inter_v(3)
!-- Ūήΰ֤׻
        x1=trajx(i)+k1
        y1=trajy(i)+l1
        z1=trajz(i)+n1
!-- Ǥ®پ
        inter_p=(/x1, y1, z1/)
        call interpo_search_3d( x, y, z, x1, y1, z1, m, n, l )  
        call interpolation_3d( x(m:m+1), y(n:n+1), z(l:l+1), u(m:m+1,n:n+1,l:l+1), inter_p, inter_v(1) )  
        call interpolation_3d( x(m:m+1), y(n:n+1), z(l:l+1), v(m:m+1,n:n+1,l:l+1), inter_p, inter_v(2) )  
        call interpolation_3d( x(m:m+1), y(n:n+1), z(l:l+1), w(m:m+1,n:n+1,l:l+1), inter_p, inter_v(3) )  

        k2=dt*inter_v(1)
        l2=dt*inter_v(2)
        n2=dt*inter_v(3)
        x1=trajx(i)+0.5*(k1+k2)
        y1=trajy(i)+0.5*(l1+l2)
        z1=trajz(i)+0.5*(n1+n2)

!-- ׻ traj ΰ¸ߤƤ뤫ǧ
        if(x1<x(1).or.x1>x(nx).or.y1<y(1).or.y1>y(ny).or.z1<z(1).or.z1>z(nz))then
           write(*,*) "****** ERROR ******"
           write(*,*) "This point does not exist in the region."
           write(*,*) "Stop.!!"
           exit
        end if
        trajx(i+1)=x1
        trajy(i+1)=y1
        trajz(i+1)=z1
     end do


  case ('ME1')
     do i=1,step-1
        inter_p=(/trajx(i), trajy(i), trajz(i)/)
        call interpo_search_3d( x, y, z, trajx(i), trajy(i), trajz(i), m, n, l )  
        call interpolation_3d( x(m:m+1), y(n:n+1), z(l:l+1), u(m:m+1,n:n+1,l:l+1), inter_p, inter_v(1) )  
        call interpolation_3d( x(m:m+1), y(n:n+1), z(l:l+1), v(m:m+1,n:n+1,l:l+1), inter_p, inter_v(2) )  
        call interpolation_3d( x(m:m+1), y(n:n+1), z(l:l+1), w(m:m+1,n:n+1,l:l+1), inter_p, inter_v(3) )  

        k1=dt*inter_v(1)
        l1=dt*inter_v(2)
        n1=dt*inter_v(3)
!-- Ūήΰ֤׻
        x1=trajx(i)+0.5*k1
        y1=trajy(i)+0.5*l1
        z1=trajz(i)+0.5*n1
!-- Ǥ®پ
        inter_p=(/x1, y1, z1/)
        call interpo_search_3d( x, y, z, x1, y1, z1, m, n, l )  
        call interpolation_3d( x(m:m+1), y(n:n+1), z(l:l+1), u(m:m+1,n:n+1,l:l+1), inter_p, inter_v(1) )  
        call interpolation_3d( x(m:m+1), y(n:n+1), z(l:l+1), v(m:m+1,n:n+1,l:l+1), inter_p, inter_v(2) )  
        call interpolation_3d( x(m:m+1), y(n:n+1), z(l:l+1), w(m:m+1,n:n+1,l:l+1), inter_p, inter_v(3) )  

        k2=dt*inter_v(1)
        l2=dt*inter_v(2)
        n2=dt*inter_v(3)
        x1=trajx(i)+k2
        y1=trajy(i)+l2
        z1=trajz(i)+n2

!-- ׻ traj ΰ¸ߤƤ뤫ǧ
        if(x1<x(1).or.x1>x(nx).or.y1<y(1).or.y1>y(ny).or.z1<z(1).or.z1>z(nz))then
           write(*,*) "****** ERROR ******"
           write(*,*) "This point does not exist in the region."
           write(*,*) "Stop.!!"
           exit
        end if
        trajx(i+1)=x1
        trajy(i+1)=y1
        trajz(i+1)=z1
     end do



  case ('RK3')
     do i=1,step-1
        inter_p=(/trajx(i), trajy(i), trajz(i)/)
        call interpo_search_3d( x, y, z, trajx(i), trajy(i), trajz(i), m, n, l )  
        call interpolation_3d( x(m:m+1), y(n:n+1), z(l:l+1), u(m:m+1,n:n+1,l:l+1), inter_p, inter_v(1) )  
        call interpolation_3d( x(m:m+1), y(n:n+1), z(l:l+1), v(m:m+1,n:n+1,l:l+1), inter_p, inter_v(2) )  
        call interpolation_3d( x(m:m+1), y(n:n+1), z(l:l+1), w(m:m+1,n:n+1,l:l+1), inter_p, inter_v(3) )  

        k1=dt*inter_v(1)
        l1=dt*inter_v(2)
        n1=dt*inter_v(3)
!-- Ūήΰ֤׻
        x1=trajx(i)+0.5*k1
        y1=trajy(i)+0.5*l1
        z1=trajz(i)+0.5*n1
!-- Ǥ®پ
        inter_p=(/x1, y1, z1/)
        call interpo_search_3d( x, y, z, x1, y1, z1, m, n, l )  
        call interpolation_3d( x(m:m+1), y(n:n+1), z(l:l+1), u(m:m+1,n:n+1,l:l+1), inter_p, inter_v(1) )  
        call interpolation_3d( x(m:m+1), y(n:n+1), z(l:l+1), v(m:m+1,n:n+1,l:l+1), inter_p, inter_v(2) )  
        call interpolation_3d( x(m:m+1), y(n:n+1), z(l:l+1), w(m:m+1,n:n+1,l:l+1), inter_p, inter_v(3) )  

        k2=dt*inter_v(1)
        l2=dt*inter_v(2)
        n2=dt*inter_v(3)
        x1=trajx(i)-k1+2.0*k2
        y1=trajy(i)-l1+2.0*l2
        z1=trajz(i)-n1+2.0*n2

!-- Ǥ®پ
        inter_p=(/x1, y1, z1/)
        call interpo_search_3d( x, y, z, x1, y1, z1, m, n, l )  
        call interpolation_3d( x(m:m+1), y(n:n+1), z(l:l+1), u(m:m+1,n:n+1,l:l+1), inter_p, inter_v(1) )  
        call interpolation_3d( x(m:m+1), y(n:n+1), z(l:l+1), v(m:m+1,n:n+1,l:l+1), inter_p, inter_v(2) )  
        call interpolation_3d( x(m:m+1), y(n:n+1), z(l:l+1), w(m:m+1,n:n+1,l:l+1), inter_p, inter_v(3) )  

        k3=dt*inter_v(1)
        l3=dt*inter_v(2)
        n3=dt*inter_v(3)
        x1=trajx(i)+(1.0/6.0)*(k1+4.0*k2+k3)
        y1=trajy(i)+(1.0/6.0)*(l1+4.0*l2+l3)
        z1=trajz(i)+(1.0/6.0)*(n1+4.0*n2+n3)

!-- ׻ traj ΰ¸ߤƤ뤫ǧ
        if(x1<x(1).or.x1>x(nx).or.y1<y(1).or.y1>y(ny).or.z1<z(1).or.z1>z(nz))then
           write(*,*) "****** ERROR ******"
           write(*,*) "This point does not exist in the region."
           write(*,*) "Stop.!!"
           exit
        end if
        trajx(i+1)=x1
        trajy(i+1)=y1
        trajz(i+1)=z1
     end do


  case ('RK4')
     do i=1,step-1
        inter_p=(/trajx(i), trajy(i), trajz(i)/)
        call interpo_search_3d( x, y, z, trajx(i), trajy(i), trajz(i), m, n, l )  
        call interpolation_3d( x(m:m+1), y(n:n+1), z(l:l+1), u(m:m+1,n:n+1,l:l+1), inter_p, inter_v(1) )  
        call interpolation_3d( x(m:m+1), y(n:n+1), z(l:l+1), v(m:m+1,n:n+1,l:l+1), inter_p, inter_v(2) )  
        call interpolation_3d( x(m:m+1), y(n:n+1), z(l:l+1), w(m:m+1,n:n+1,l:l+1), inter_p, inter_v(3) )  

        k1=dt*inter_v(1)
        l1=dt*inter_v(2)
        n1=dt*inter_v(3)
!-- Ūήΰ֤׻
        x1=trajx(i)+0.5*k1
        y1=trajy(i)+0.5*l1
        z1=trajz(i)+0.5*n1
!-- Ǥ®پ
        inter_p=(/x1, y1, z1/)
        call interpo_search_3d( x, y, z, x1, y1, z1, m, n, l )  
        call interpolation_3d( x(m:m+1), y(n:n+1), z(l:l+1), u(m:m+1,n:n+1,l:l+1), inter_p, inter_v(1) )  
        call interpolation_3d( x(m:m+1), y(n:n+1), z(l:l+1), v(m:m+1,n:n+1,l:l+1), inter_p, inter_v(2) )  
        call interpolation_3d( x(m:m+1), y(n:n+1), z(l:l+1), w(m:m+1,n:n+1,l:l+1), inter_p, inter_v(3) )  

        k2=dt*inter_v(1)
        l2=dt*inter_v(2)
        n2=dt*inter_v(3)
        x1=trajx(i)+0.5*k2
        y1=trajy(i)+0.5*l2
        z1=trajz(i)+0.5*n2

!-- Ǥ®پ
        inter_p=(/x1, y1, z1/)
        call interpo_search_3d( x, y, z, x1, y1, z1, m, n, l )  
        call interpolation_3d( x(m:m+1), y(n:n+1), z(l:l+1), u(m:m+1,n:n+1,l:l+1), inter_p, inter_v(1) )  
        call interpolation_3d( x(m:m+1), y(n:n+1), z(l:l+1), v(m:m+1,n:n+1,l:l+1), inter_p, inter_v(2) )  
        call interpolation_3d( x(m:m+1), y(n:n+1), z(l:l+1), w(m:m+1,n:n+1,l:l+1), inter_p, inter_v(3) )  

        k3=dt*inter_v(1)
        l3=dt*inter_v(2)
        n3=dt*inter_v(3)
        x1=trajx(i)+k3
        y1=trajy(i)+l3
        z1=trajz(i)+n3

!-- Ǥ®پ
        inter_p=(/x1, y1, z1/)
        call interpo_search_3d( x, y, z, x1, y1, z1, m, n, l )  
        call interpolation_3d( x(m:m+1), y(n:n+1), z(l:l+1), u(m:m+1,n:n+1,l:l+1), inter_p, inter_v(1) )  
        call interpolation_3d( x(m:m+1), y(n:n+1), z(l:l+1), v(m:m+1,n:n+1,l:l+1), inter_p, inter_v(2) )  
        call interpolation_3d( x(m:m+1), y(n:n+1), z(l:l+1), w(m:m+1,n:n+1,l:l+1), inter_p, inter_v(3) )  

        k4=dt*inter_v(1)
        l4=dt*inter_v(2)
        n4=dt*inter_v(3)
        x1=trajx(i)+(1.0/6.0)*(k1+2.0*k2+2.0*k3+k4)
        y1=trajy(i)+(1.0/6.0)*(l1+2.0*l2+2.0*l3+l4)
        z1=trajz(i)+(1.0/6.0)*(n1+2.0*n2+2.0*n3+n4)

!-- ׻ traj ΰ¸ߤƤ뤫ǧ
        if(x1<x(1).or.x1>x(nx).or.y1<y(1).or.y1>y(ny).or.z1<z(1).or.z1>z(nz))then
           write(*,*) "****** ERROR ******"
           write(*,*) "This point does not exist in the region."
           write(*,*) "Stop.!!"
           exit
        end if
        trajx(i+1)=x1
        trajy(i+1)=y1
        trajz(i+1)=z1
     end do



  end select

end subroutine Forward_Traject_3d


end module Trajectory
