module val_coord
  implicit none

contains

subroutine val_coordinate()

  use savegloval_define

  implicit none

  integer :: i
  double precision :: dxtmp, dytmp

!-- 各座標径の設定

  x=(/((xmin+(dble(i-1))*dx),i=1,nx)/)
  y=(/((ymin+(dble(i-1))*dy),i=1,ny)/)
  z(1:nz)=z_mbl(1:nz)
  xd=(/((real(xmin)+(real(i-1))*real(dx)),i=1,nx)/)
  yd=(/((real(ymin)+(real(i-1))*real(dy)),i=1,ny)/)
  zd(1:nz)=z_mbl(1:nz)

  dxtmp=dx*dble(nx-1)/dble(jxnt-1)
  dytmp=dy*dble(ny-1)/dble(jynt-1)
  xj=(/(xmin+dble(i-1)*dxtmp,i=1,jxnt)/)
  yj=(/(ymin+dble(i-1)*dytmp,i=1,jynt)/)

  iz_str=MY_RANK*nzp+1
  iz_end=(MY_RANK+1)*nzp
  z_pe(1:nzp)=z(iz_str:iz_end)
  zd_pe(1:nzp)=zd(iz_str:iz_end)

  if(MY_RANK==0)then
     z_pe(0)=0.0d0
     z_pe(nzp+1)=z(iz_end+1)
     zd_pe(0)=0.0
     zd_pe(nzp+1)=zd(iz_end+1)
  else if(MY_RANK==PETOT-1)then
     z_pe(0)=z(iz_str-1)
     z_pe(nzp+1)=z(iz_end)+(z(iz_end)-z(iz_end-1))
     zd_pe(0)=zd(iz_str-1)
     zd_pe(nzp+1)=zd(iz_end)+(zd(iz_end)-zd(iz_end-1))
  else
     z_pe(0)=z(iz_str-1)
     z_pe(nzp+1)=z(iz_end+1)
     zd_pe(0)=zd(iz_str-1)
     zd_pe(nzp+1)=zd(iz_end+1)
  end if

end subroutine

end module val_coord
