module def_val

  implicit none

  integer, save :: nxe   ! 初期環境場の x 方向格子点数
  integer, save :: nye   ! 初期環境場の y 方向格子点数
  integer, save :: nze   ! 初期環境場の z 方向格子点数
  integer, save :: nxv   ! 初期台風渦の x 方向格子点数
  integer, save :: nyv   ! 初期台風渦の y 方向格子点数
  integer, save :: nzv   ! 初期台風渦の z 方向格子点数

  real, save :: xemin    ! 初期環境場の x 方向原点 [m] or [deg]
  real, save :: yemin    ! 初期環境場の y 方向原点 [m] or [deg]
  real, save :: zemin    ! 初期環境場の z 方向原点 [m] or [Pa]
  real, save :: xvmin    ! 初期台風渦の x 方向原点 [m] or [deg]
  real, save :: yvmin    ! 初期台風渦の y 方向原点 [m] or [deg]
  real, save :: zvmin    ! 初期台風渦の z 方向原点 [m] or [Pa]
  real, save :: dxe      ! 初期環境場の x 方向格子点間隔 [m] or [deg]
  real, save :: dye      ! 初期環境場の y 方向格子点間隔 [m] or [deg]
  real, save :: dze      ! 初期環境場の z 方向格子点間隔 [m] or [Pa]
  real, save :: dxv      ! 初期台風渦の x 方向格子点間隔 [m] or [deg]
  real, save :: dyv      ! 初期台風渦の y 方向格子点間隔 [m] or [deg]
  real, save :: dzv      ! 初期台風渦の z 方向格子点間隔 [m] or [Pa]

  real, allocatable, save, dimension(:) :: xe ! 初期環境場の x 座標 [m] or [deg]
  real, allocatable, save, dimension(:) :: ye ! 初期環境場の y 座標 [m] or [deg]
  real, allocatable, save, dimension(:) :: ze ! 初期環境場の z 座標 [m] or [Pa]
  real, allocatable, save, dimension(:) :: xv ! 初期台風渦の x 座標 [m] or [deg]
  real, allocatable, save, dimension(:) :: yv ! 初期台風渦の y 座標 [m] or [deg]
  real, allocatable, save, dimension(:) :: zv ! 初期台風渦の z 座標 [m] or [Pa]

  real, allocatable, save, dimension(:,:,:) :: ue  ! 初期環境場の x 方向風速 [m/s]
  real, allocatable, save, dimension(:,:,:) :: ve  ! 初期環境場の y 方向風速 [m/s]
  real, allocatable, save, dimension(:,:,:) :: we  ! 初期環境場の z 方向風速 [m/s]
  real, allocatable, save, dimension(:,:,:) :: pe  ! 初期環境場の圧力 [Pa]
  real, allocatable, save, dimension(:,:,:) :: pte ! 初期環境場の温位 [K]
  real, allocatable, save, dimension(:,:,:) :: uv  ! 初期台風渦の x 方向風速 [m/s]
  real, allocatable, save, dimension(:,:,:) :: vv  ! 初期台風渦の y 方向風速 [m/s]
  real, allocatable, save, dimension(:,:,:) :: wv  ! 初期台風渦の z 方向風速 [m/s]
  real, allocatable, save, dimension(:,:,:) :: pv  ! 初期台風渦の圧力 [Pa]
  real, allocatable, save, dimension(:,:,:) :: ptv ! 初期台風渦の温位 [K]



end module def_val
