module val_alloc
! 変数の定義
! 変数名の命名規則
! 実数 -> r, 純虚数 -> i, 複素数 -> c
! 平均場 -> b, 擾乱場 -> p
! 時間発展 -> old, new

  use val_define
  use read_namelist

  implicit none

contains

subroutine val_allocate()

  implicit none

  allocate(ri(nri))        ! スカラー動径座標初期値
  allocate(zi(nzi))        ! スカラー動径座標初期値
  allocate(rs(nr+3))       ! スカラー動径座標
  allocate(zs(nz+3))       ! スカラー鉛直座標
  allocate(rv(nr+3))       ! 水平速度動径座標
  allocate(zv(nr+3))       ! 水平速度鉛直座標
  allocate(theta(ntheta))  ! 接線座標
  allocate(epsu(nr+3,nz+3))    ! レイリーダンピング係数 u
  allocate(epsv(nr+3,nz+3))    ! レイリーダンピング係数 v
  allocate(epsh(nr+3,nz+3))    ! レイリーダンピング係数 h

!-- 2d val
  allocate(urs_dmp(nr+3,ntheta,nz+3)) ! 動径風速 dmp (scalar)
  allocate(vrs_dmp(nr+3,ntheta,nz+3)) ! 接線風速 dmp (scalar)
  allocate(wrs_dmp(nr+3,ntheta,nz+3)) ! 鉛直風速 dmp (scalar)
  allocate(hrs_dmp(nr+3,ntheta,nz+3)) ! ジオポテンシャル dmp (scalar)
  allocate(ptsr_dmp(nr+3,ntheta,nz+3))! 温位 dmp (scalar)
  allocate(ur_dmp(nr+3,ntheta,nz+3))  ! 動径風速 dmp
  allocate(vr_dmp(nr+3,ntheta,nz+3))  ! 接線風速 dmp
  allocate(wr_dmp(nr+3,ntheta,nz+3))  ! 鉛直風速 dmp
  allocate(hr_dmp(nr+3,ntheta,nz+3))  ! ジオポテンシャル dmp
  allocate(ptr_dmp(nr+3,ntheta,nz+3)) ! 温位 dmp
  allocate(ur_old(nr+3,ntheta,nz+3))  ! 動径風速 old
  allocate(vr_old(nr+3,ntheta,nz+3))  ! 接線風速 old
  allocate(ptr_old(nr+3,ntheta,nz+3)) ! 温位 old
  allocate(ui_old(nr+3,ntheta,nz+3))  ! 動径風速 old
  allocate(vi_old(nr+3,ntheta,nz+3))  ! 接線風速 old
  allocate(pti_old(nr+3,ntheta,nz+3)) ! 温位 old
  allocate(ur_mid(nr+3,ntheta,nz+3))  ! 動径風速 mid
  allocate(vr_mid(nr+3,ntheta,nz+3))  ! 接線風速 mid
  allocate(ptr_mid(nr+3,ntheta,nz+3)) ! 温位 mid
  allocate(ui_mid(nr+3,ntheta,nz+3))  ! 動径風速 mid
  allocate(vi_mid(nr+3,ntheta,nz+3))  ! 接線風速 mid
  allocate(pti_mid(nr+3,ntheta,nz+3)) ! 温位 mid
  allocate(ur_new(nr+3,ntheta,nz+3))  ! 動径風速 new
  allocate(vr_new(nr+3,ntheta,nz+3))  ! 接線風速 new
  allocate(ptr_new(nr+3,ntheta,nz+3)) ! 温位 new
  allocate(ui_new(nr+3,ntheta,nz+3))  ! 動径風速 new
  allocate(vi_new(nr+3,ntheta,nz+3))  ! 接線風速 new
  allocate(pti_new(nr+3,ntheta,nz+3)) ! 温位 new
  allocate(dval1r(nr+3,ntheta,nz+3))  ! 任意変数の勾配
  allocate(dval2r(nr+3,ntheta,nz+3))  ! 任意変数の勾配
  allocate(dval3r(nr+3,ntheta,nz+3))  ! 任意変数の勾配
  allocate(dval1i(nr+3,ntheta,nz+3))  ! 任意変数の勾配
  allocate(dval2i(nr+3,ntheta,nz+3))  ! 任意変数の勾配
  allocate(dval3i(nr+3,ntheta,nz+3))  ! 任意変数の勾配

!-- complex, save part

  allocate(uc_old(nr+3,ntheta,nz+3))  ! 動径風速 old
  allocate(vc_old(nr+3,ntheta,nz+3))  ! 接線風速 old
  allocate(wc_old(nr+3,ntheta,nz+3))  ! 鉛直風速 old
  allocate(hc_old(nr+3,ntheta,nz+3))  ! ジオポテンシャル old
  allocate(ptc_old(nr+3,ntheta,nz+3)) ! 温位 old
  allocate(uc_mid(nr+3,ntheta,nz+3))  ! 動径風速 mid
  allocate(vc_mid(nr+3,ntheta,nz+3))  ! 接線風速 mid
  allocate(wc_mid(nr+3,ntheta,nz+3))  ! 鉛直風速 mid
  allocate(hc_mid(nr+3,ntheta,nz+3))  ! ジオポテンシャル mid
  allocate(ptc_mid(nr+3,ntheta,nz+3)) ! 温位 mid
  allocate(uc_new(nr+3,ntheta,nz+3))  ! 動径風速 new
  allocate(vc_new(nr+3,ntheta,nz+3))  ! 接線風速 new
  allocate(wc_new(nr+3,ntheta,nz+3))  ! 鉛直風速 new
  allocate(hc_new(nr+3,ntheta,nz+3))  ! ジオポテンシャル new
  allocate(ptc_new(nr+3,ntheta,nz+3)) ! 温位 new
  allocate(ducdr(nr+3,ntheta,nz+3))   ! du/dr
  allocate(dvcdr(nr+3,ntheta,nz+3))   ! dv/dr
  allocate(dptcdr(nr+3,ntheta,nz+3))  ! dtheta/dr
  allocate(ducdz(nr+3,ntheta,nz+3))   ! du/dz
  allocate(dvcdz(nr+3,ntheta,nz+3))   ! dv/dz
  allocate(dptcdz(nr+3,ntheta,nz+3))  ! dtheta/dz
  allocate(forceu(nr+3,ntheta,nz+3))  ! forceu
  allocate(forcev(nr+3,ntheta,nz+3))  ! forcev
  allocate(forcept(nr+3,ntheta,nz+3)) ! forcept

  coril=1.0e-5

end subroutine

end module
