module val_define_shallow
! 変数の定義
! 変数名の命名規則
! 実数 -> r, 純虚数 -> i, 複素数 -> c
! 平均場 -> b, 擾乱場 -> p
! 時間発展 -> old, new
!-- 配列および一貫変数は save 属性をつけて module を読み込んだときに値が
!  保存される仕様にする.

  implicit none

  integer, save :: nx  ! x 方向の配列個数 (namelist)
  integer, save :: ny  ! y 方向の配列個数 (namelist)
  integer, save :: nt  ! 時間ステップ (namelist)
  integer, save :: dmpstp  ! ダンプ間隔 (namelist)
  integer, save :: init_n  ! 初期の波数

  double precision, save :: xmin  ! x 方向内側 [m] (namelist)
  double precision, save :: xmax  ! x 方向外側 [m] (namelist)
  double precision, save :: ymin  ! y 方向原点 [degree]
  double precision, save :: dx    ! x 方向格子間隔 [m]
  double precision, save :: dy    ! y 方向格子間隔 [degree]
  double precision, save :: dt    ! 時間間隔 [s] (namelist)
  double precision, save :: undef  ! 未計算領域の格子点に格納される値.
!  double precision, save :: vbar  ! 平均流の値.
  double precision, save :: eps  ! ポアソン収束条件
  double precision, save :: nu  ! 粘性係数

  character(80), save :: finame  ! 初期値ファイル名
  character(80), save :: foname  ! 結果値ファイル名
  character(1), save :: time_flag  ! 時間スキームに関するフラグ

!-- 2d integer
  integer, save, allocatable, dimension(:,:) :: ibp  ! 境界計算方式指定 (psi)
  integer, save, allocatable, dimension(:,:) :: ibo  ! 境界計算方式指定 (omg)

!-- 2d logical
  logical, save, allocatable, dimension(:,:) :: calc_flag  ! ポアソン計算するか

!-- double precision, save part
  double precision, save :: d2r  ! degree to radian
  double precision, save :: r2d  ! radian to degree

!-- 1d val
  double precision, save, allocatable, dimension(:) :: x      ! ベクトル動径座標
  double precision, save, allocatable, dimension(:) :: y      ! 接線座標
  double precision, save, allocatable, dimension(:) :: x_inv  ! 1/x
  double precision, save, allocatable, dimension(:) :: x2_inv ! 1/x**2

!-- 2d val (prognostic value)
  double precision, save, allocatable, dimension(:,:) :: omega_dmp  ! 渦度 dmp
  double precision, save, allocatable, dimension(:,:) :: omega_old  ! 渦度 old
  double precision, save, allocatable, dimension(:,:) :: omega_new  ! 渦度 new
  double precision, save, allocatable, dimension(:,:) :: omega_tmp  ! 渦度 tmp
  double precision, save, allocatable, dimension(:,:) :: div_dmp    ! 発散 dmp
  double precision, save, allocatable, dimension(:,:) :: div_old    ! 発散 old
  double precision, save, allocatable, dimension(:,:) :: div_new    ! 発散 new
  double precision, save, allocatable, dimension(:,:) :: div_tmp    ! 発散 tmp
  double precision, save, allocatable, dimension(:,:) :: eta_dmp    ! 高度 dmp
  double precision, save, allocatable, dimension(:,:) :: eta_old    ! 高度 old
  double precision, save, allocatable, dimension(:,:) :: eta_new    ! 高度 new
  double precision, save, allocatable, dimension(:,:) :: eta_tmp    ! 高度 tmp

!-- 2d val (diagnostic value)
  double precision, save, allocatable, dimension(:,:) :: psi_dmp  ! 流線関数 dmp
  double precision, save, allocatable, dimension(:,:) :: psi_old  ! 流線関数 old
  double precision, save, allocatable, dimension(:,:) :: psi_new  ! 流線関数 new
  double precision, save, allocatable, dimension(:,:) :: psi_tmp  ! 流線関数 tmp
  double precision, save, allocatable, dimension(:,:) :: chi_dmp  ! 速度ポテンシャル dmp
  double precision, save, allocatable, dimension(:,:) :: chi_old  ! 速度ポテンシャル old
  double precision, save, allocatable, dimension(:,:) :: chi_new  ! 速度ポテンシャル new
  double precision, save, allocatable, dimension(:,:) :: chi_tmp  ! 速度ポテンシャル tmp
  double precision, save, allocatable, dimension(:,:) :: urot_dmp ! x 方向回転速度 dmp
  double precision, save, allocatable, dimension(:,:) :: vrot_dmp ! y 方向回転速度 dmp
  double precision, save, allocatable, dimension(:,:) :: udiv_dmp ! x 方向発散速度 dmp
  double precision, save, allocatable, dimension(:,:) :: vdiv_dmp ! y 方向発散速度 dmp
  double precision, save, allocatable, dimension(:,:) :: u_dmp    ! x 方向速度 dmp
  double precision, save, allocatable, dimension(:,:) :: v_dmp    ! y 方向速度 dmp

!-- 2d val (force term)
  double precision, save, allocatable, dimension(:,:) :: force_omega  ! omega forcing term
  double precision, save, allocatable, dimension(:,:) :: forcea_omega  ! omega forcing term
  double precision, save, allocatable, dimension(:,:) :: ADV
  double precision, save, allocatable, dimension(:,:) :: BETA
  double precision, save, allocatable, dimension(:,:) :: DIFF
  double precision, save, allocatable, dimension(:,:) :: dpdx
  double precision, save, allocatable, dimension(:,:) :: dpdy
  double precision, save, allocatable, dimension(:,:) :: dodx
  double precision, save, allocatable, dimension(:,:) :: dody
  double precision, save, allocatable, dimension(:,:) :: do2dx2
  double precision, save, allocatable, dimension(:,:) :: do2dy2
  double precision, save, allocatable, dimension(:,:) :: dp2dx2
  double precision, save, allocatable, dimension(:,:) :: dp2dy2
  double precision, save, allocatable, dimension(:,:) :: dpdoydx
  double precision, save, allocatable, dimension(:,:) :: dpdoxdy
  double precision, save, allocatable, dimension(:,:) :: dodpxdy
  double precision, save, allocatable, dimension(:,:) :: dodpydx
  double precision, save, allocatable, dimension(:,:) :: pdoy
  double precision, save, allocatable, dimension(:,:) :: pdox
  double precision, save, allocatable, dimension(:,:) :: odpx
  double precision, save, allocatable, dimension(:,:) :: odpy
  double precision, save, allocatable, dimension(:,:) :: pois_force
  double precision, save, allocatable, dimension(:,:) :: bndp  ! boundary condition value for psi
  double precision, save, allocatable, dimension(:,:) :: bndo  ! boundary condition value for omg
  double precision, save, allocatable, dimension(:,:) :: x_inv_2d  ! For 2d in x_inv
  double precision, save, allocatable, dimension(:,:) :: x2_inv_2d ! For 2d in x2_inv

!-- 3d val (force term)
  double precision, save, allocatable, dimension(:,:,:) :: AJ  ! Arakawa Jacobian

!-- character part
!  character(80), save :: inner_file  ! 境界形状ファイル名
  character(10), save :: force_flag  ! 強制項の各効果を入れるためのフラグ
  character(3), save :: init_type  ! 初期値データに入っている変数の種類
  character(4), save :: boundary  ! ポアソン用の 4 軸境界条件
!  character(1), save, allocatable, dimension(:,:) :: cval  ! inner_bound ファイル読み込み用

end module val_define_shallow
