program GMT_surface
! This program behavors as "surface" command with GMT.
  use Ellip_Slv
  use Statistics
  use File_Operate
  use Basis
  use gtool_history
  implicit none

! namelist values
  integer :: nx, ny
  real :: xmin, xmax, ymin, ymax, stp, eps, vbound
  character(1000) :: fname, ord
  character(40) :: xaxis, yaxis
  character(4) :: bound1, bound2

! temporary values
  integer :: i, j, k, i_x, j_y, nl, nc
  real :: dx, dy
  real, allocatable, dimension(:) :: x, y
  real, allocatable, dimension(:) :: xval, yval, vval
  real, allocatable, dimension(:,:) :: val, val2, force, tens1, tens2, bound_opt
  character(20), allocatable, dimension(:,:) :: cval

!-- reading namelist
  namelist /input /nx, ny, xmin, xmax, ymin, ymax, fname, ord, stp,  &
  &                bound1, bound2, eps, xaxis, yaxis, vbound
  read(5,nml=input)

!-- reading reference data file
  nl=line_number_counter( trim(adjustl(fname)) )
  nc=len_trim(ord)
  allocate(cval(nc,nl))
  allocate(xval(nl))
  allocate(yval(nl))
  allocate(vval(nl))

  call read_file_text( trim(fname), nc, nl, cval )

!-- converting cval to real

  do k=1,nc
     select case (ord(k:k))
     case ('1')  ! x-axis
        do j=1,nl
           xval(j)=c2r_convert( trim(adjustl(cval(k,j))) )
        end do
     case ('2')  ! y-axis
        do j=1,nl
           yval(j)=c2r_convert( trim(adjustl(cval(k,j))) )
        end do
     case ('3')  ! value
        do j=1,nl
           vval(j)=c2r_convert( trim(adjustl(cval(k,j))) )
        end do
     end select
  end do

!-- allocate
  allocate(x(nx))
  allocate(y(ny))
  allocate(val(nx,ny))
  allocate(val2(nx,ny))
  allocate(tens1(nx,ny))
  allocate(tens2(nx,ny))
  allocate(force(nx,ny))
  allocate(bound_opt(nx,ny))

!-- setting axises
  dx=(xmax-xmin)/real(nx-1)
  dy=(ymax-ymin)/real(ny-1)

  x=(/((xmin+dx*real(i-1)),i=1,nx)/)
  y=(/((ymin+dy*real(i-1)),i=1,ny)/)

!-- setting force and tens to data and namelist value
  tens1=1.0-stp
  tens2=-stp

  do j=1,ny
     do i=1,nx
        tens2(i,j)=tens2(i,j)*(xmax-xmin)*(ymax-ymin)
     end do
  end do

  force=0.0

  do i=1,nl
     call nearest_search_2d( x, y, xval(i), yval(i), i_x, j_y )
     force(i_x,j_y)=vval(i)*(xmax-xmin)*(ymax-ymin)
  end do

write(*,*) "check", vval
!-- calculating (laplacian z)
  if(stp/=1.0)then
     call Ellip_Jacobi_2d( x, y, force, eps, bound1, val,  &
  &                        a=tens1, c=tens1, f=tens2 )
  else
     do j=1,ny
        do i=1,nx
           val(i,j)=-force(i,j)
        end do
     end do
  end if

!-- calculating z
  bound_opt=vbound

  call Ellip_Jacobi_2d( x, y, val, eps, bound2, val2, bound_opt=bound_opt )

!-- gtool output

  call HistoryCreate( file='result_'//trim(fname), title='GMT surface', &
    & source='test', institution='test',  &
    &   dims=(/trim(xaxis), trim(yaxis)/), dimsizes=(/nx,ny/), &
    & longnames=(/'X-Axis','Y-Axis'/),  &
    & units=(/'m','m'/), origin=0.0, interval=0.0 )

  call HistoryPut( trim(xaxis), x )
  call HistoryPut( trim(yaxis), y )

  call HistoryAddVariable( varname='val',  &
  &    dims=(/trim(xaxis), trim(yaxis)/), &
  &    longname='radial wind', units='m/s', xtype='float')

  call HistoryPut( 'val', val )

  call HistoryAddVariable( varname='val2',  &
  &    dims=(/trim(xaxis), trim(yaxis)/), &
  &    longname='radial wind2', units='m/s', xtype='float')

  call HistoryPut( 'val2', val2 )

end program GMT_surface
