program sound_conv
! 任意のサウンディングデータをメインプログラムが読み込みやすい形に変換する.
! 高度あるいは圧力に未定義が入った場合, その array は変換後のファイルには出力しない.
  use file_operate
  use Basis
  use Math_Const
  use Thermo_Const
  use Thermo_Function

  implicit none

  real, allocatable, dimension(:,:) :: val
  character(1000), allocatable, dimension(:,:) :: cval
  integer :: id, i, j, k, nx, nz, i_undef, skip_num, rh_flag, nf, neg_i
  character(1000) :: sign_flag, tmpc
  character(1000) :: output_name, undef, fname
  character(1000), allocatable, dimension(:) :: iname, oname
  character(10) :: unity(6)  ! unit convert flags
  character(20) :: foma, fomb
  character(1) :: hydro_flag
  real :: conv_undef, hydro_ref, tmp_height
  real, dimension(6) :: sfact
  real :: limit_height, factor, ew_tmp, ww_tmp, snd_height, conv_height, dz_conv
  real, allocatable, dimension(:) :: height, pres, temp, vapor, tmp, ew, ww
  logical :: limit_flag, conv_inter, write_flag, rev_flag

!-- namelist file read

!  call read_namelist()
  namelist /input /fname, undef, sign_flag, skip_num, unity, sfact, limit_height,  &
  &                snd_height, output_name, dz_conv, conv_inter, conv_undef,  &
  &                hydro_ref, rev_flag
  read(5,nml=input)

  i_undef=len_trim(undef)
  foma='(6a15)'
  fomb='(6E15.6)'

!-- list file read

  nf=line_number_counter( trim(fname) )
  allocate(iname(nf))
  allocate(oname(nf))
  call read_file_text( trim(fname), 1, nf, iname )

!-- interpolting data using hydrostatic relation

  hydro_flag='y'
  do i=1,len_trim(adjustl(sign_flag))
     if(sign_flag(i:i)=='1')then
        if(hydro_flag(1:1)=='y')then
           hydro_flag='p'
        else if(hydro_flag(1:1)=='z')then
           hydro_flag='n'
        end if
     end if
     if(sign_flag(i:i)=='3')then
        if(hydro_flag(1:1)=='y')then
           hydro_flag='z'
        else if(hydro_flag(1:1)=='p')then
           hydro_flag='n'
        end if
     end if
  end do

  if(hydro_flag(1:1)=='z')then
     write(*,*) "*** MESSAGE (main) *** : hydrostatic interpolation is active."
     write(*,*) "interpolating for z."
  else if(hydro_flag(1:1)=='p')then
     write(*,*) "*** MESSAGE (main) *** : hydrostatic interpolation is active."
     write(*,*) "interpolating for p."
  end if

  if(rev_flag.eqv..true.)then
     write(*,*) "*** MESSAGE (main) *** : rev_flag is .true."
     write(*,*) "data is reversing (CReSS sounding type)."
  else
     write(*,*) "*** MESSAGE (main) *** : rev_flag is .false."
     write(*,*) "data is not reversing (radio sonde type)."
  end if

!-- do loop counter

  do id=1,nf

     write(*,*) "--- starting to convert Now: ", trim(iname(id)), " ---"

     limit_flag=.false.

!-- column and array set

     nx=len_trim(sign_flag)
     nz=line_number_counter( trim(iname(id)) )-skip_num

     oname(id)="conv-"//iname(id)

     allocate(cval(nx,nz))
     allocate(val(nx,nz))
     allocate(height(nz))
     allocate(temp(nz))
     allocate(pres(nz))
     allocate(vapor(nz))
     allocate(ew(nz))
     allocate(ww(nz))
     allocate(tmp(nz))

     height=conv_undef
     temp=conv_undef
     pres=conv_undef
     vapor=conv_undef
     ew=conv_undef
     ww=conv_undef

!-- reading file

     call read_file_text( trim(iname(id)), nx, nz, cval, skip=skip_num )

!-- type convert

     do j=1,nx
        if(sign_flag(j:j)/='0')then
           do k=1,nz
              if(rev_flag.eqv..false.)then
                 tmpc=trim(cval(j,k))
              else
                 tmpc=trim(cval(j,nz-k+1))
              end if

              if(tmpc(1:len_trim(undef))==trim(undef))then
                 val(j,k)=conv_undef
              else
                 if(rev_flag.eqv..false.)then
                    val(j,k)=c2r_convert( cval(j,k) )
                 else
                    val(j,k)=c2r_convert( cval(j,nz-k+1) )
                 end if
              end if
           end do
        end if
     end do

     neg_i=1

     do i=1,nx
        if(sign_flag(i:i)=='a')then
           do j=1,nz
              if(val(i,j)==0.0)then
                 neg_i=j
                 exit
              end if
           end do
           exit
        end if
     end do

!-- val sign

     do i=1,nx
        select case (sign_flag(i:i))
        case('1')
           if(unity(1)=='m')then
              factor=1.0*sfact(1)
           else
              factor=1000.0*sfact(1)
           end if
           do j=neg_i,nz
              if(val(i,j)/=conv_undef)then
                 height(j)=val(i,j)*factor
              else
                 height(j)=conv_undef
              end if
           end do
           if(height(neg_i)>snd_height.and.neg_i>1)then
              write(*,*) "### convert WARNING ###"
              write(*,*) "1st array height is higher than snd_height"
              write(*,*) "snd_height = ", snd_height, "[m]."
              write(*,*) "1st height = ", height(neg_i), "[m]."
              limit_flag=.true.
           end if
        case('2')
           if(unity(2)=='degC')then
              factor=273.15
           else
              factor=0.0
           end if
           do j=neg_i,nz
              if(val(i,j)/=conv_undef)then
                 temp(j)=val(i,j)*sfact(2)+factor
              else
                 temp(j)=conv_undef
              end if
           end do
        case('3')
           if(unity(3)=='Pa')then
              factor=1.0*sfact(3)
           else
              factor=100.0*sfact(3)
           end if
           do j=neg_i,nz
              if(val(i,j)/=conv_undef)then
                 if(val(i,j)>0.0)then
                    pres(j)=val(i,j)*factor
                 else
                    pres(j)=conv_undef
                 end if
              else
                 pres(j)=conv_undef
              end if
           end do
        case('4')
           if(unity(4)=='g/kg')then
              factor=1.0e-3
           else
              factor=1.0
              rh_flag=i
           end if
           do j=neg_i,nz
              if(val(i,j)/=conv_undef.or.val(i,j)>=0.0)then
                 vapor(j)=val(i,j)*sfact(4)*factor
              else
                 vapor(j)=conv_undef
              end if
           end do
        case('5')
           do j=neg_i,nz
              if(val(i,j)/=conv_undef)then
                 ew(j)=val(i,j)*sfact(5)
              else
                 ew(j)=conv_undef
              end if
           end do
        case('6')
           do j=neg_i,nz
              if(val(i,j)/=conv_undef)then
                 ww(j)=val(i,j)*sfact(6)
              else
                 ww(j)=conv_undef
              end if
           end do
        case('7')
           do j=neg_i,nz
              tmp(j)=val(i,j)
           end do
        case('8')
           do j=neg_i,nz
              tmp(j)=val(i,j)
           end do
        case('9')
           do j=neg_i,nz
              tmp(j)=val(i,j)
           end do
        end select
     end do

!-- interpolating z or p using hydrostatic relation

     select case (hydro_flag(1:1))
     case ('p')
!        pres(neg_i)=exner_func_dry( hydro_ref )
        pres(neg_i)=hydro_ref
        do j=neg_i+1,nz
           if(height(j)/=conv_undef.and.height(j-1)/=conv_undef.and.  &
  &           temp(j)/=conv_undef.and.temp(j-1)/=conv_undef)then  ! Temp.
              if(unity(2)=='K'.or.unity(2)=='degC')then
                 pres(j)=pres(j-1)*exp(-0.5*(g/Rd)*((height(j)-height(j-1))  &
  &                                    *(1.0/temp(j-1)+1.0/temp(j))))
              else if(unity(2)=='PK')then  ! Theta
                 pres(j)=p0*exp((Cpd/Rd)  &
  &                            *log(exner_func_dry(pres(j-1))  &
  &                                -0.5*(g/Cpd)*(height(j)-height(j-1))  &
  &                                    *(1.0/temp(j-1)+1.0/temp(j))))
              end if
           end if
        end do

     case ('z')
        height(neg_i)=hydro_ref
        do j=neg_i+1,nz
           if(pres(j)/=conv_undef.and.pres(j-1)/=conv_undef.and.  &
  &           temp(j)/=conv_undef.and.temp(j-1)/=conv_undef)then  ! Temp.
              if(unity(2)=='K'.or.unity(2)=='degC')then
                 height(j)=height(j-1)-0.5*(Rd/g)*(log(pres(j)/pres(j-1)))  &
  &                                    *(temp(j)+temp(j-1))
              else if(unity(2)=='PK')then  ! Theta
                 height(j)=height(j-1)-0.5*(Cpd/g)*(temp(j)+temp(j-1))*  &
  &                                    (exner_func_dry( pres(j) )  &
  &                                    -exner_func_dry( pres(j-1) ))
              end if
           end if
        end do

     end select

!-- convert theta to temp

     if(unity(2)=='PK')then
        do j=neg_i,nz
           if(temp(j)/=conv_undef)then
              temp(j)=thetaP_2_T( temp(j), pres(j) )
           end if
        end do
     end if

!-- convert check RH

     if(unity(4)=='%')then
        do j=neg_i,nz
           if(vapor(j)/=conv_undef)then
              vapor(j)=RHTP_2_qv( vapor(j), temp(j), pres(j) )
           end if
        end do
     end if

     if(unity(4)=='degC')then  ! TD(degC)
        do j=neg_i,nz
           if(vapor(j)/=conv_undef)then
              vapor(j)=RHTP_2_qv( TTd_2_RH_Bolton( temp(j), vapor(j)+273.15 ),  &
  &                               temp(j), pres(j) )
           end if
        end do
     end if

     if(unity(4)=='K')then  ! TD(K)
        do j=neg_i,nz
           if(vapor(j)/=conv_undef)then
              vapor(j)=RHTP_2_qv( TTd_2_RH_Bolton( temp(j), vapor(j) ),  &
  &                               temp(j), pres(j) )
           end if
        end do
     end if

!-- convert check wind radian

     if(unity(5)=='rad')then
        do j=neg_i,nz
           if(vapor(j)/=conv_undef)then
              ew_tmp=ew(j)
              ww_tmp=ww(j)
              ew(j)=ew_tmp*sin(ww_tmp)
              ww(j)=ew_tmp*cos(ww_tmp)
           end if
        end do
     end if

     if(unity(5)=='degree')then
        do j=neg_i,nz
           if(ew(j)/=conv_undef.and.ww(j)/=conv_undef)then
              ew_tmp=ew(j)
              ww_tmp=ww(j)*pi/180.0
              ew(j)=ew_tmp*sin(ww_tmp)  ! negative sign is wind opposite direction
              ww(j)=ew_tmp*cos(ww_tmp)
           end if
        end do
     end if

!-- direction check

     if(unity(6)=='false')then
        do j=neg_i,nz
           if(ew(j)/=conv_undef.and.ww(j)/=conv_undef)then
              ew(j)=-ew(j)
              ww(j)=-ww(j)
           end if
        end do
     end if

!-- writing file

     write(*,*) "--- writing Now: ", trim(oname(id)), " ---"

     open(unit=11+id,file=trim(oname(id)),status='unknown')
     write(11+id,trim(foma)) "'height'       ", "'pressure'     ", "'temperature'  ", "'vapor'        ", "'E-Wwind'      ", "'N-Swind'      "
     write(11+id,trim(foma)) "'m'            ", "'Pa'           ", "'K'            ", "'kg/kg'        ", "'m/s'          ", " m/s'          "

     if(limit_flag.eqv..true.)then
        write(11+id,trim(fomb)) limit_height, 101325.0,  &
  &                             conv_undef, conv_undef,  &
  &                             conv_undef, conv_undef
     end if

     conv_height=limit_height
     write_flag=.true.
     tmp_height=limit_height

     do j=neg_i,nz
        if((height(j)>=limit_height).and.(height(j)/=conv_undef))then
           !if(height(j)>=0.0.and.pres(j)>0.0)then
           if(height(j)>=0.0)then
              if(height(j)<=tmp_height)then
                 write_flag=.false.
                 exit
              else
                 write_flag=.true.
              end if
              tmp_height=height(j)

              if(write_flag.eqv..true.)then
                 if(conv_inter.eqv..false.)then
                    write(11+id,trim(fomb)) height(j), pres(j), temp(j),  &
  &                                         vapor(j), ew(j), ww(j)
                 else
                    if(conv_height<=height(j))then
                       write(11+id,trim(fomb)) height(j), pres(j), temp(j),  &
  &                                            vapor(j), ew(j), ww(j)
                       conv_height=conv_height+dz_conv
                    end if
                 end if
              end if
           end if
        end if
!        if(j==nz-1)then
!           if(height(j+1)>0.0.and.pres(j+1)>0.0)then
!              write(11+id,'(1000f)') height(j+1), pres(j+1), temp(j+1),  &
!  &                                  vapor(j+1), ew(j+1), ww(j+1)
!           end if
!        end if
     end do
     close(unit=11+id,status='keep')

     deallocate(cval)
     deallocate(val)
     deallocate(height)
     deallocate(temp)
     deallocate(pres)
     deallocate(vapor)
     deallocate(ew)
     deallocate(ww)
     deallocate(tmp)

     write(*,*) "--- finishing to convert Now: ", trim(iname(id)), " ---"

  end do

!-- output list file writing
  open(unit=11,file=trim(output_name),status='unknown')
     do i=1,nf
        write(11,*) trim(oname(i))
     end do
  close(unit=11)

end program
