program local_check
! derivation モジュールの極値検索ルーチンのテスト
  use derivation
  implicit none
  integer, parameter :: nx=100
  integer :: i, pnum
  integer, dimension(nx) :: point
  real, dimension(nx) :: x, val
  logical :: lstat

  x=(/((real(i-1)),i=1,nx)/)
  val=sin(2.0*3.14159*(4.0*x/real(nx)))

  lstat=local_peak_checker_1d( val, '+', point, pnum, undef=-999.0 )

  write(*,'(a59)') "---------- Local Max -----------"
  do i=1,pnum
     write(*,'(a7,i4,1P3E16.8)') "point: ", point(i), val(point(i)-1:point(i)+1)
  end do

  lstat=local_peak_checker_1d( val, '-', point, pnum, undef=-999.0 )

  write(*,'(a59)') "---------- Local Min -----------"
  do i=1,pnum
     write(*,'(a7,i4,1P3E16.8)') "point: ", point(i), val(point(i)-1:point(i)+1)
  end do

end program
