!-----------------------------------------------------------------------
!     Copyright (C) 2009-2015 GFD Dennou Club. All rights reserved.
!-----------------------------------------------------------------------

module Cloud_Const  ! 雲物理定数集
  ! 単位はすべて MKS 単位系
  ! 値は
  ! * Tsuboki and Sakakibara, 2007
  ! * Murakami, 1990
  ! より.
  ! 各セクションは, 落下速度の形状パラメータ, 密度, 切片濃度である.
  implicit none
  real, parameter :: auc=2.98e7
  real, parameter :: buc=2.0
  real, parameter :: cuc=1.0
  real, parameter :: aur=842.0
  real, parameter :: bur=0.8
  real, parameter :: cur=0.5
  real, parameter :: aui=770.0
!  real, parameter :: aui=700.0
  real, parameter :: bui=1.0
  real, parameter :: cui=0.33
  real, parameter :: aus=27.0
!  real, parameter :: aus=17.0
  real, parameter :: bus=0.5
  real, parameter :: cus=0.5
  real, parameter :: aug=132.0
!  real, parameter :: aug=124.0
  real, parameter :: bug=0.64
  real, parameter :: cug=0.5

  real, parameter :: rhoi=5.0e2  ! 氷晶の密度 [kg/m^3]
  real, parameter :: rhos=84.0   ! 雪の密度 [kg/m^3]
  real, parameter :: rhog=3.0e2  ! 霰の密度 [kg/m^3]

  real, parameter :: nr0=8.0e6   ! 雨水の y 切片濃度 [1/m^4]
  real, parameter :: ns0=1.8e6   ! 雪の y 切片濃度 [1/m^4]
  real, parameter :: ng0=1.1e6   ! 霰の y 切片濃度 [1/m^4]

  real, parameter :: mi0=1.0e-12    ! 雲氷の最小質量 [kg]
  real, parameter :: ms0=1.76e-10   ! 雪の最小質量 [kg]
  real, parameter :: mg0=7.0e-10    ! 霰の最小質量 [kg]
  real, parameter :: mi0max=1.4e-10    ! 霰の最小質量 [kg]

  real, parameter :: epi=3.2     ! 氷の誘電率 http://eprints.lib.hokudai.ac.jp/dspace/bitstream/2115/32469/1/P185-212.pdf
  real, parameter :: epw=80.0    ! 水の誘電率

  real, parameter :: Ci=2.0e3    ! 氷の定圧比熱 [J/K kg]
  real, parameter :: Cw=4.17e3    ! 水の定圧比熱 [J/K kg]

  real, parameter :: Ecc=0.55       ! 雲水同士の捕捉率
  real, parameter :: Ess=0.1        ! 雪同士の補足率
  real, parameter :: Eii=0.1        ! 氷晶同士の補足率

  real, parameter :: Nc=1.0e8       ! 雲粒の数濃度 [1/m^3]
  real, parameter :: Dcm=20.0e-6    ! 雲粒の臨界平均直径 [m]

  real, parameter :: Fea1=12.96     ! Ferrier の係数 1
  real, parameter :: Feb1=0.639     ! Ferrier の係数 2
  real, parameter :: HVB=4.5        ! Huffmann and Vail の係数
  real, parameter :: FLT1=1.0e-2    ! Fletcher の係数 1 [1/m^3]
  real, parameter :: FLT2=0.6       ! Fletcher の係数 2 [1/K]
  real, parameter :: Ni01=1.0e3     ! Ferrier の粒子数 1 [1/m^3]
  real, parameter :: Ni02=50.0      ! Ferrier の粒子数 2 [1/m^3]
  real, parameter :: Bigga=0.66     ! Bigg の係数 1 [1/K]
  real, parameter :: Biggb=100.0    ! Bigg の係数 2 [1/m^3s]
  real, parameter :: Na0=2.0e5      ! 接触凍結核の数濃度係数 [1/m^3]
  real, parameter :: AERO=3.0e-7    ! エアロゾル粒子の半径 [m]
  real, parameter :: Sc=0.6         ! シュミット数
  real, parameter :: kappaa=2.4e-2  ! 空気の熱伝導率 [J/m s K]
  real, parameter :: kappaaero=2.4e-1  ! エアロゾルの熱伝導率 [J/m s K]
  real, parameter :: spii=0.25      ! 氷晶の落下速度のスペクトル分散
  real, parameter :: tref=293.15    ! 基準温度 [K]
  real, parameter :: MFP0=6.6e-8    ! p00, tref での平均自由行程 [m]
  real, parameter :: Raero=3.0e-7   ! エアロゾル粒子の半径 [m]

  real, parameter :: qthres=1.0e-12 ! 雲物理計算時の凝結物混合比の閾値 [kg/kg]
  real, parameter :: tscp=233.16    ! 過冷却状態の最低温度 [K]

end module
