module Dcl_Automatic  ! Dclf90 ưǹԤ⥸塼

use dcl

contains

subroutine Dcl_2D_cont_shade( outname,  &
  &  x, y, contour, shade, cont_int, shade_int,  &
  &  axis_title, form_type, viewx_int, viewy_int, c_num,  &
!  &  viewy_min, viewy_max, color_num, cont_num, nongrid,  &
  &  xg, yg, zg, xp, yp, zp,  &
  &  mono, mono_val, mono_lev, trigleg, no_tone, no_frame,  &
  &  l_idx, l_typ, p_idx, p_typ, p_siz )
  ! 2  2 ѿȥ顼ɤ褹.
  use dcl
  implicit none
  character(*), intent(in) :: outname  ! դΥȥ
  real, intent(in) :: x(:)  ! x γʻɸ
  real, intent(in) :: y(:)  ! y γʻɸ
  real, intent(inout) :: contour(size(x),size(y))  ! 
  real, intent(inout) :: shade(size(x),size(y))  ! 顼ɤ
  real, intent(in) :: cont_int(2)  ! ξ岼ü 
                                 ! [cont_int(1)=cont_min, cont_int(2)=cont_max]
  real, intent(in) :: shade_int(2)  ! ξ岼ü [shade_int(1)=shade_min,
                                 ! shade_int(2)=shade_max]
  character(*), intent(in) :: axis_title(2)  ! ɸΥȥ
                                 ! axis_title(1)=x_title, axis_title(2)=y_title
  character(*), intent(in) :: form_type(2)  ! եޥå
                           ! form_type(1)=form_typec, form_type(2)=form_types
  real, intent(in), optional :: viewx_int(2)  ! ӥ塼ݡȤ x ξü
                           ! viewx_int(1)=vx_min, vx_int(2)=vx_max
  real, intent(in), optional :: viewy_int(2)  ! ӥ塼ݡȤ y ξü
                           ! viewy_int(1)=vy_min, vy_int(2)=vy_max
  integer, intent(in), optional :: c_num(2)  ! 󥿡ɤο
                           ! c_num(1)=cont_num, c_num(2)=color_num
!  character(2), intent(in), optional :: nongrid  ! ֳֳʻҤˤ뤫.
                                        ! nongrid = 'ox' Ƚ.
                                        ! 1 ʸܤ, 2 ʸܤļ.
                                        ! o = ֳ, x = ֳ.
                                        ! ǥեȤǤ 'xx'.
  real, intent(in), optional :: xg(:,:)  ! x 륰åκɸ
  real, intent(in), optional :: yg(:,:)  ! y 륰åκɸ
                    ! Ǥΰ֥ǡ, ʣ,
                    ! Ǥ 2 İʾˤ.
                    ! ǡľǤϤʤ, åɤ
                    ! Ȥǽ.
                    ! 3 ܤ, xg(:,1)  yg(:,1)  1 ܤ
                    ! ɽ褦˻ꤹ뤳.
  real, intent(in), optional :: zg(:,:)  ! åͤäƤФ.
                    ! Υץ򤵤줿, ưŪѿ shade 
                    ! Ѥ줺, shade ϢѿϤ٤Ƥͤ
                    ! ե󥹤Ȥƥ顼ޤ⡼ɤ˰ܹԤ.
  real, intent(in), optional :: xp(:,:)  ! x ˥ޡ x ɸ
  real, intent(in), optional :: yp(:,:)  ! y ˥ޡ y ɸ
  real, intent(in), optional :: zp(:,:)  ! ޡͤäƤФ.
                                         ! λˡƱ.
                    ! Υץ򤵤줿, ưŪѿ shade 
                    ! Ѥ줺, shade ϢѿϤ٤Ƥͤ
                    ! ե󥹤Ȥƥ顼ޡ⡼ɤ˰ܹԤ.
  logical, intent(in), optional :: mono  ! ΥȡγĴˤ [.true.]
                                         ! ǥեȤ .false.
  real, intent(in), optional :: mono_val(:)  ! Ĵζ.
                    ! mono=.true. ΤȤɬꤷʤȥ顼֤.
                    ! ͤ mono_lev + 1 ʬ¸ߤʤФʤʤ.
  integer, intent(in), optional :: mono_lev(:)  ! ȡޥåֹ. dcl  3 
                    ! mono=.true. ΤȤꤷʤȥ顼֤.
  character(1), intent(in), optional :: trigleg  ! ȡСλѷץ.
                ! ץͤ, tone_bar 롼 trigle Ʊ.
  logical, intent(in), optional :: no_tone  ! ȡСʤץ
                                   ! .false. = . .true. = ʤ.
                                   ! ǥեȤ .false.
  logical, intent(in), optional :: no_frame  ! NewFrame ƤФʤ
                                   ! .false. = Ƥ. .true. = ƤФ NewFig.
                                   ! ǥեȤ .false.
  integer, intent(in), optional :: l_idx(:)  ! xg, yg Υǥå
                                                      ! ǥեȤ 1.
  integer, intent(in), optional :: l_typ(:)  ! xg, yg Υ.
                                                      ! ǥեȤ 1.
  integer, intent(in), optional :: p_idx(:)  ! xp, yp ޡΥǥå
  integer, intent(in), optional :: p_typ(:)  ! xg, yg ޡΥ.
  real, intent(in), optional :: p_siz(:)  ! xg, yg ޡΥ.
                                                      ! ǥեȤ 0.01.
!-- ʾ, 
  real :: cont_min  ! Ǿ
  real :: cont_max  ! 
  real :: shade_min  ! ɤǾ
  real :: shade_max  ! ɤ
  character(100) :: x_title  ! x Υȥ
  character(100) :: y_title  ! y Υȥ
  character(10) :: form_typec  ! contour ѤΥեޥå
  character(10) :: form_types  ! shade ѤΥեޥå
  real :: vx_min  ! ӥ塼ݡȤ x κǾ
  real :: vx_max  ! ӥ塼ݡȤ x κ
  real :: vy_min  ! ӥ塼ݡȤ y κǾ
  real :: vy_max  ! ӥ塼ݡȤ y κ
  integer :: cont_num  ! ο
  integer :: color_num  ! 顼ο
!-- ʾ, ֤ѿ
  integer :: i, j, k  ! ź
  integer :: nx, ny
  real :: undef, RMISS
  logical :: monoto, no_tone_flag, no_frame_flag

  nx=size(x)
  ny=size(y)

!-- optional ν ---
  if(present(viewx_int))then
     vx_min=viewx_int(1)
     vx_max=viewx_int(2)
  else
     vx_min=0.2
     vx_max=0.8
  end if

  if(present(viewy_int))then
     vy_min=viewy_int(1)
     vy_max=viewy_int(2)
  else
     vy_min=0.2
     vy_max=0.8
  end if

  if(present(c_num))then
     cont_num=c_num(1)
     color_num=c_num(2)
  else
     cont_num=10
     color_num=56
  end if

  if(present(no_tone))then
     no_tone_flag=no_tone
  else
     no_tone_flag=.false.
  end if

  if(present(no_frame))then
     no_frame_flag=no_frame
  else
     no_frame_flag=.false.
  end if

!-- ֤ѿ֤
  cont_min=cont_int(1)
  cont_max=cont_int(2)
  shade_min=shade_int(1)
  shade_max=shade_int(2)
  x_title=trim(axis_title(1))
  y_title=trim(axis_title(2))
  form_typec=trim(form_type(1))
  form_types=trim(form_type(2))

  if(present(mono))then
     if(present(mono_val).and.present(mono_lev))then
        if(size(mono_val)-1==size(mono_lev))then
           monoto=mono
        else
           write(*,*) "*** ERROR ***"
           write(*,*) "[array number] : mono_val = mono_lev + 1"
           write(*,*) "STOP"
           stop
        end if
     else
        write(*,*) "*** ERROR ***"
        write(*,*) "When option MONO is true, MONO_VAL and MONO_LEV must be specified."
        write(*,*) "STOP"
        stop
     end if
  else
     monoto=.false.
  end if

!-- ޤ ---

  call undef_CReSS2Dcl( nx, ny, 1, contour)
  call undef_CReSS2Dcl( nx, ny, 1, shade)

  call UWSGXZ(.FALSE.)
  call UWSGYZ(.FALSE.)

  if(no_frame_flag.eqv..true.)then
     call DclNewFig
  else
     call DclNewFrame
  end if

  call DclSetWindow( x(1), x(nx), y(1), y(ny) )

  if(present(zg))then
     if(size(xg,1)>1)then
        call color_line( 's', xg, yg, zg, color_num,  &
  &                      (/shade_min, shade_max/), subsubidx='l' )
     end if
  else
     if(present(xg))then
        if(size(xg,1)>1)then
           do i=1,size(xg,2)
              call DclScalingPoint( xg(:,i), yg(:,i) )
           end do
        end if
     end if
  end if

  if(present(zp))then
     call color_line( 's', xp, yp, zp, color_num, (/shade_min, shade_max/),  &
  &                   subsubidx='p' )
  else
     if(present(xp))then
        do i=1,size(xp,2)
           call DclScalingPoint( xp(:,i), yp(:,i) )
        end do
     end if
  end if

  call DclSetViewPort( vx_min, vx_max, vy_min, vy_max )
  call DclSetTransFunction

  if(monoto.eqv..true.)then
     call DclSetParm('ENABLE_SOFTFILL',.true.)
     call DclClearShadeLevel
     call DclSetShadeLevel( mono_val, mono_lev )
  else
     call DclSetParm('ENABLE_SOFTFILL',.false.)
!     call DclClearShadeLevel
!     call DclSetShadeLevel( shade_min, shade_max,   &
! &                          (shade_max-shade_min)/s_num )
  end if

!  if(present(nongrid))then
!     if(nongrid(1:1)=='o')then
        call DclSetXGrid( x )
!     end if
!     if(nongrid(2:2)=='o')then
        call DclSetYgrid( y )
!     end if
!  end if

  call DclSetParm( 'GRAPH:LCLIP', .true. )

  if(monoto.eqv..true.)then
     call DclShadeContour( shade )
  else
!     call UETONB( shade, nx, nx, ny )  ! For tiling
     call DclShadeContourEx( shade )
  end if

  CALL UZLSET( 'LABELYL', .TRUE. )
  CALL UZLSET( 'LABELYR', .FALSE. )
  call DclDrawScaledAxis
  call DclDrawTitle( 'b', trim(x_title), 0.0 )
  call DclDrawTitle( 'l', trim(y_title), 0.0 )
  call DclDrawTitle( 't', trim(outname), 0.0, 2 )

  if(DclGetContourLevelNumber()==0)then
     call DclSetContourLabelFormat(trim(form_typec))
     call DclSetContourLevel( cont_min, cont_max, (cont_max-cont_min)/cont_num )
  end if

  call DclDrawContour( contour )

  if(present(zg))then
     if(size(xg,1)>1)then
        call color_line( 'l', xg, yg, zg, color_num, (/shade_min, shade_max/) )
     end if
  else
     if(present(xg))then
        if(size(xg,1)>1)then
           do i=1,size(xg,2)
              if(present(l_idx))then
                 call DclSetLineIndex( l_idx(i) )  ! , ޤǰ뤫
              end if
              if(present(l_typ))then
                 call DclSetLineType( l_typ(i) )
              end if
              call DclDrawLine( xg(:,i), yg(:,i) )
           end do
        end if
     end if
  end if

  if(present(zp))then
     call color_line( 'p', xp, yp, zp, color_num, (/shade_min, shade_max/) )
  else
     if(present(xp))then
        do i=1,size(xp,2)
           if(present(p_idx))then
              call DclSetMarkerIndex( p_idx(i) )  ! , ޤǰ뤫
           end if
           if(present(p_typ))then
              call DclSetMarkerType( p_typ(i) )
           end if
           if(present(p_siz))then
              call DclSetMarkerSize( p_siz(i) )
           end if
           call DclDrawMarker( xp(:,i), yp(:,i) )
        end do
     end if
  end if

  if(no_tone_flag.eqv..false.)then
     if(present(trigleg))then
        call tone_bar( color_num, (/shade_min, shade_max/),  &
  &                  (/vx_max+0.05, vx_max+0.075/),   &
  &                  (/vy_min, vy_max/), trim(form_types), mono_log=monoto,  &
  &                  trigle=trigleg )
     else
        call tone_bar( color_num, (/shade_min, shade_max/),  &
  &                  (/vx_max+0.05, vx_max+0.075/),   &
  &                  (/vy_min, vy_max/), trim(form_types), mono_log=monoto )
     end if
  end if

  call DclClearContourLevel()

end subroutine

!---------------------------------------------------------

subroutine Dcl_2D_cont_shade_MapPro( map_pro, outname,  &
  &  x, y, contour, shade, cont_int, shade_int,  &
  &  axis_title, form_type, viewx_int, viewy_int, c_num,  &
!  &  viewy_max, color_num, cont_num, nongrid,  &
  &  xg, yg, zg, long, latg, xp, yp, zp, lonp, latp,  &
  &  mono, mono_val, mono_lev, trigleg,  &
  &  mlitv, mlidx, coast, border, blidx, bltyp,  &
  &  no_tone, no_frame, l_idx, l_typ, m_idx, m_typ,  &
  &  p_idx, p_typ, p_siz, mp_idx, mp_typ, mp_siz,  &
  &  t_posi, lon_wnd, lat_wnd )
  ! 2  2 ѿȥ顼ɤ褹.
  !  map_pro Ͽֹ, Ͽƥ⡼ɤڤؤ.
  use dcl
  implicit none
  integer, intent(in) :: map_pro  ! DCL ϿѴؿֹ
  character(*), intent(in) :: outname  ! դΥȥ
  real, intent(in) :: x(:)  ! x γʻɸ [deg]
  real, intent(in) :: y(:)  ! y γʻɸ [deg]
  real, intent(inout) :: contour(size(x),size(y))  ! 
  real, intent(inout) :: shade(size(x),size(y))  ! 顼ɤ
  real, intent(in) :: cont_int(2)  ! ξ岼ü 
                                 ! [cont_int(1)=cont_min, cont_int(2)=cont_max]
  real, intent(in) :: shade_int(2)  ! ξ岼ü [shade_int(1)=shade_min,
                                 ! shade_int(2)=shade_max]
  character(*), intent(in) :: axis_title(2)  ! ɸΥȥ
                                 ! axis_title(1)=x_title, axis_title(2)=y_title
  character(*), intent(in) :: form_type(2)  ! եޥå
                           ! form_type(1)=form_typec, form_type(2)=form_types
  real, intent(in), optional :: viewx_int(2)  ! ӥ塼ݡȤ x ξü
                           ! viewx_int(1)=vx_min, vx_int(2)=vx_max
  real, intent(in), optional :: viewy_int(2)  ! ӥ塼ݡȤ y ξü
                           ! viewy_int(1)=vy_min, vy_int(2)=vy_max
  integer, intent(in), optional :: c_num(2)  ! 󥿡ɤο
                           ! c_num(1)=cont_num, c_num(2)=color_num
!  character(2), intent(in), optional :: nongrid  ! ֳֳʻҤˤ뤫.
                                        ! nongrid = 'ox' Ƚ.
                                        ! 1 ʸܤ, 2 ʸܤļ.
                                        ! o = ֳ, x = ֳ.
                                        ! ǥեȤǤ 'xx'.
  real, intent(in), optional :: xg(:,:)  ! x 륰åκɸ
  real, intent(in), optional :: yg(:,:)  ! y 륰åκɸ
                    ! Ǥΰ֥ǡ, ʣ,
                    ! Ǥ 2 İʾˤ.
                    ! ǡľǤϤʤ, åɤ
                    ! Ȥǽ.
                    ! 3 ܤ, xg(:,1)  yg(:,1)  1 ܤ
                    ! ɽ褦˻ꤹ뤳.
  real, intent(in), optional :: zg(:,:)  ! åͤäƤФ.
                    ! Υץ򤵤줿, ưŪѿ shade 
                    ! Ѥ줺, shade ϢѿϤ٤Ƥͤ
                    ! ե󥹤Ȥƥ顼ޤ⡼ɤ˰ܹԤ.
  real, intent(in), optional :: long(:,:)  ! lon ɸ륰å
  real, intent(in), optional :: latg(:,:)  ! lat ɸ륰å
  real, intent(in), optional :: xp(:,:)  ! x ˥ޡ x ɸ
  real, intent(in), optional :: yp(:,:)  ! y ˥ޡ y ɸ
  real, intent(in), optional :: zp(:,:)  ! ޡͤäƤФ.
                                         ! λˡƱ.
                    ! Υץ򤵤줿, ưŪѿ shade 
                    ! Ѥ줺, shade ϢѿϤ٤Ƥͤ
                    ! ե󥹤Ȥƥ顼ޡ⡼ɤ˰ܹԤ.
  logical, intent(in), optional :: mono  ! ΥȡγĴˤ [.true.]
                                         ! ǥեȤ .false.
  real, intent(in), optional :: lonp(:,:)  ! lon ɸޡ
  real, intent(in), optional :: latp(:,:)  ! lat ɸޡ
  real, intent(in), optional :: mono_val(:)  ! Ĵζ.
                    ! mono=.true. ΤȤɬꤷʤȥ顼֤.
                    ! ͤ mono_lev + 1 ʬ¸ߤʤФʤʤ.
  integer, intent(in), optional :: mono_lev(:)  ! ȡޥåֹ. dcl  3 
                    ! mono=.true. ΤȤꤷʤȥ顼֤.
  character(1), intent(in), optional :: trigleg  ! ȡСλѷץ.
                ! ץͤ, tone_bar 롼 trigle Ʊ.
  real, intent(in), optional :: mlitv  ! ᥸㡼饤, ɽֳ [degree]. ǥեȤ 1 degree.
  integer, intent(in), optional :: mlidx  ! ᥸㡼饤, Υǥå.
                                          ! ǥեȤ 1.
  character(5), intent(in), optional :: coast  ! 
                                   ! ['japan'] = ܰܺ
                                   ! ['world'] = 
                                   ! default = 'world'
  character(5), intent(in), optional :: border  ! , , 
                                   ! ['japan'] = ܸ
                                   ! ['world'] = 
                                   ! ['state'] = ƹ񽣶
                                   ! default = 褷ʤ.
  integer, intent(in), optional :: blidx  ! , 񶭤Υǥå.
                                          ! ǥեȤ 3.
  integer, intent(in), optional :: bltyp  ! , 񶭤Υ.
                                          ! ǥեȤ 1.
  logical, intent(in), optional :: no_tone  ! ȡСʤץ
                                   ! .false. = . .true. = ʤ.
                                   ! ǥեȤ .false.
  logical, intent(in), optional :: no_frame  ! NewFrame ƤФʤ
                                   ! .false. = Ƥ. .true. = ƤФ NewFig.
                                   ! ǥեȤ .false.
  integer, intent(in), optional :: l_idx(:)  ! xg, yg Υǥå
                                                      ! ǥեȤ 1.
  integer, intent(in), optional :: l_typ(:)  ! xg, yg Υ.
                                                      ! ǥեȤ 1.
  integer, intent(in), optional :: m_idx(:)  ! long, latg Υǥå
                                                      ! ǥեȤ 1.
  integer, intent(in), optional :: m_typ(:)  ! long, latg Υ.
                                                      ! ǥեȤ 1.
  integer, intent(in), optional :: p_idx(:)  ! xp, yp ޡΥǥå
  integer, intent(in), optional :: p_typ(:)  ! xg, yg ޡΥ.
                                                      ! ǥեȤ 1.
  real, intent(in), optional :: p_siz(:)  ! xg, yg ޡ礭.
                                                      ! ǥեȤ 0.01.
  integer, intent(in), optional :: mp_idx(:)  ! lonp, latp ޡΥǥå
  integer, intent(in), optional :: mp_typ(:)  ! lonp, latp ޡΥǥå
  real, intent(in), optional :: mp_siz(:)  ! lonp, latp ޡΥǥå
  real, intent(in), optional :: t_posi(3)  ! map optiona ٥Ȥξ
                                           ! t_posi=(/lat1, lat2, lon1/) .
                                           ! ñ̤ degree
  real, intent(in), optional :: lon_wnd(:,:)  ! 륫ȥϰʳǶΰ
                   ! γƺɸϷа. ͤꤵȤ, 
                   ! x, y ˤ, ǥȷϤǤεΥͿƤ.
  real, intent(in), optional :: lat_wnd(:,:)  ! 륫ȥϰʳǶΰ
                   ! γƺɸϷа. ͤꤵȤ, 
                   ! x, y ˤ, ǥȷϤǤεΥͿƤ.
!-- ʾ, 
  real :: cont_min  ! Ǿ
  real :: cont_max  ! 
  real :: shade_min  ! ɤǾ
  real :: shade_max  ! ɤ
  character(100) :: x_title  ! x Υȥ
  character(100) :: y_title  ! y Υȥ
  character(10) :: form_typec  ! contour ѤΥեޥå
  character(10) :: form_types  ! shade ѤΥեޥå
  real :: vx_min  ! ӥ塼ݡȤ x κǾ
  real :: vx_max  ! ӥ塼ݡȤ x κ
  real :: vy_min  ! ӥ塼ݡȤ y κǾ
  real :: vy_max  ! ӥ塼ݡȤ y κ
  integer :: cont_num  ! ο
  integer :: color_num  ! 顼ο
!-- ʾ, ֤ѿ
  real, parameter :: pi=3.14159265
  real, parameter :: radius=6.38e6
  integer :: i, j, k  ! ź
  integer :: nx, ny
  real :: uratio
  real :: undef, RMIS
  real :: map_lat_min, map_lat_max, map_lon_min, map_lon_max
  real :: lat_min, lat_max, lon_min, lon_max
  real :: mlat2dis_min, mlat2dis_max, mlon2dis_min, mlon2dis_max, mditv, mid_p
  integer :: mdidx, bdidx, bdtyp
  real, dimension(2) :: vx_new, vy_new
  character(20) :: coast_sel
  character(20) :: border_sel
  logical :: monoto, no_tone_flag, no_frame_flag, bord_flag

  nx=size(x)
  ny=size(y)
  coast_sel=''
  border_sel=''
  bord_flag=.false.

!--  rad ñ̤Ѵ
  map_lon_min=x(1)*pi/180.0
  map_lon_max=x(nx)*pi/180.0
  map_lat_min=y(1)*pi/180.0
  map_lat_max=y(ny)*pi/180.0

  select case (map_pro)
  case (11)
     mlon2dis_min=map_lon_min
     mlon2dis_max=map_lon_max
     mlat2dis_min=log(tan(0.25*pi+0.5*map_lat_min))
     mlat2dis_max=log(tan(0.25*pi+0.5*map_lat_max))
  case (22)
     mlon2dis_min=x(1)
     mlon2dis_max=x(nx)
     mlat2dis_min=y(1)
     mlat2dis_max=y(ny)
  end select

!-- C ɸϤη׻
  if(present(lon_wnd))then
     lon_min=lon_wnd(1,1)
     lon_max=lon_wnd(nx,1)
     lat_min=lat_wnd(1,1)
     lat_max=lat_wnd(1,ny)
  end if

!-- optional ν ---
  if(present(viewx_int))then
     vx_min=viewx_int(1)
     vx_max=viewx_int(2)
  else
     vx_min=0.2
     vx_max=0.8
  end if

  if(present(viewy_int))then
     vy_min=viewy_int(1)
     vy_max=viewy_int(2)
  else
     vy_min=0.2
     vy_max=0.8
  end if

  if(present(c_num))then
     cont_num=c_num(1)
     color_num=c_num(2)
  else
     cont_num=10
     color_num=56
  end if

  if(present(no_tone))then
     no_tone_flag=no_tone
  else
     no_tone_flag=.false.
  end if

  if(present(no_frame))then
     no_frame_flag=no_frame
  else
     no_frame_flag=.false.
  end if

  if(map_pro==22)then
     if(.not.present(t_posi))then
        write(*,*) "*** ERROR (dcl_auto) *** : In case of map_pro = 22,"
        write(*,*) "                           option 't_posi' must be set."
        stop
     end if
  end if

!-- ֤ѿ֤
  cont_min=cont_int(1)
  cont_max=cont_int(2)
  shade_min=shade_int(1)
  shade_max=shade_int(2)
  x_title=trim(axis_title(1))
  y_title=trim(axis_title(2))
  form_typec=trim(form_type(1))
  form_types=trim(form_type(2))

!-- ϿȼΥץ ---
!-- MapFit 롼Ѥ, Ͽޤ vp ŪѹΤ,
!-- νԤ.
!-- u ɸϤǤΥڥȤ, ĹĹ vp ˤ,
!-- û vp .
  uratio=(mlat2dis_max-mlat2dis_min)/(mlon2dis_max-mlon2dis_min)  ! u ɸϤǤ ratio
  if( uratio>1.0 )then
  ! y ĹΤ, vratio  vxmin, vxmax ˽.
  ! ϰʲΤȤ (mid ɸ) : 
  ! vxmax+vxmin=2.0*mid, vxmax-vxmin=(vymax-vymin)/uratio
  ! 򤽤줾򤯤, vymax, vymin ϴϤʤΤǰΤΤѤ,
  ! vxmax=mid+0.5*(vymax-vymin)/uratio
  ! vxmin=mid-0.5*(vymax-vymin)/uratio
     mid_p=0.5*(vx_min+vx_max)
     vx_max=mid_p+0.5*(vy_max-vy_min)/uratio
     vx_min=mid_p-0.5*(vy_max-vy_min)/uratio
  else
  ! x ĹΤ, vratio  vymin, vymax ˽.
  ! ϰʲΤȤ (mid ɸ) : 
  ! vymax+vymin=2.0*mid, vymax-vymin=uratio*(vxmax-vxmin)
  ! 򤽤줾򤯤, vxmax, vxmin ϴϤʤΤǰΤΤѤ,
  ! vymax=mid+0.5*(uratio*(vxmax-vxmin)
  ! vymin=mid-0.5*(uratio*(vxmax-vxmin)
     mid_p=0.5*(vy_min+vy_max)
     vy_max=mid_p+0.5*uratio*(vx_max-vx_min)
     vy_min=mid_p-0.5*uratio*(vx_max-vx_min)
  end if

  if(present(mono))then
     if(present(mono_val).and.present(mono_lev))then
        if(size(mono_val)-1==size(mono_lev))then
           monoto=mono
        else
           write(*,*) "*** ERROR ***"
           write(*,*) "[array number] : mono_val = mono_lev + 1"
           write(*,*) "STOP"
           stop
        end if
     else
        write(*,*) "*** ERROR ***"
        write(*,*) "When option MONO is true, MONO_VAL and MONO_LEV must be specified."
        write(*,*) "STOP"
        stop
     end if
  else
     monoto=.false.
  end if

  if(present(mlitv))then
     mditv=mlitv
  else
     mditv=1.0
  end if

  if(present(mlidx))then
     mdidx=mlidx
  else
     mdidx=1
  end if

  if(present(coast))then
     coast_sel='coast_'//coast
  else
     coast_sel='coast_world'
  end if

  if(present(border))then
     select case (trim(border))
     case ('japan')
        bord_flag=.true.
        border_sel='pref_japan'
     case ('world')
        bord_flag=.true.
        border_sel='border_world'
     case ('state')
        bord_flag=.true.
        border_sel='state_usa'
     end select
  end if

  if(present(blidx))then
     bdidx=blidx
  else
     bdidx=3
  end if

  if(present(bltyp))then
     bdtyp=bltyp
  else
     bdtyp=1
  end if

  if(present(lon_wnd))then
     call udlset('LMSG',.false.)
  end if

!-- ޤ ---

!-- contour  axis Τ,  contour interval ɽʤ
!-- 褦ˤ롼. contour interval .
  call undef_CReSS2Dcl( nx, ny, 1, contour)
  call undef_CReSS2Dcl( nx, ny, 1, shade)

  call UWSGXZ(.FALSE.)
  call UWSGYZ(.FALSE.)

  if(no_frame_flag.eqv..true.)then
     call DclNewFig
  else
     call DclNewFrame
  end if

  call DclSetParm( 'MAP:LGRIDMN', .false. )
  call DclSetParm( 'MAP:INDEXMJ', mdidx )
  call DclSetParm( 'MAP:dgridmj', mditv )
  call DclSetParm( 'MAP:INDEXBND', bdidx )
  call DclSetParm( 'MAP:INDEXOUT', bdidx )
  call DclSetParm( 'MAP:ITYPEOUT', bdtyp )

  write(*,*) "window set", x(1), x(nx), y(1), y(ny)
  call DclSetWindow( x(1), x(nx), y(1), y(ny) )

  if(present(zg))then
     if(size(xg,1)>1)then
        call color_line( 's', xg, yg, zg, color_num,  &
  &                      (/shade_min, shade_max/), subsubidx='l' )
     end if
  else
     if(present(xg))then
        if(size(xg,1)>1)then
           do i=1,size(xg,2)
              call DclScalingPoint( xg(:,i), yg(:,i) )
           end do
        end if
     end if
  end if

  if(present(zp))then
     call color_line( 's', xp, yp, zp, color_num, (/shade_min, shade_max/),  &
  &                   subsubidx='p' )
  else
     if(present(xp))then
        do i=1,size(xp,2)
           call DclScalingPoint( xp(:,i), yp(:,i) )
        end do
     end if
  end if

  write(*,*) "viewport set", vx_min, vx_max, vy_min, vy_max
  call DclSetViewPort( vx_min, vx_max, vy_min, vy_max )
  if(present(lon_wnd))then
     call DclSetTransNumber( 1 )
  else
     call DclSetTransNumber( map_pro )
     call DclFitMapParm
  end if
  call DclSetTransFunction

  if(monoto.eqv..true.)then
     call DclSetParm('ENABLE_SOFTFILL',.true.)
     call DclClearShadeLevel
     call DclSetShadeLevel( mono_val, mono_lev )
  else
     call DclSetParm('ENABLE_SOFTFILL',.false.)
!     call DclClearShadeLevel
!     call DclSetShadeLevel( shade_min, shade_max,   &
! &                          (shade_max-shade_min)/s_num )
  end if

  if(map_pro==11)then
     call DclSetParm( 'GRAPH:LCLIP', .true. )
  end if
!     call DclDrawViewPortFrame( 1 )
!  if(present(nongrid))then
!     if(nongrid(1:1)=='o')then
        call DclSetXGrid( x )
!     end if
!     if(nongrid(2:2)=='o')then
        call DclSetYgrid( y )
!     end if
!  end if

  if(monoto.eqv..true.)then
     call DclShadeContour( shade )
  else
     call DclShadeContourEx( shade )
  end if

  if(present(lon_wnd))then
!     call DclDrawAxis( 'b', mditv, 0.5*mditv )
!     call DclDrawAxis( 'l', mditv, 0.5*mditv )
     call Dcl_Special_Axis( 'bl', map_pro, mditv, (/vx_min, vx_max/),  &
  &                         (/vy_min, vy_max/), t_posi, lon_wnd, lat_wnd,  &
  &                         (/trim(x_title), trim(y_title)/) )
!     call DclDrawTitle( 'b', trim(x_title), 0.0 )
!     call DclDrawTitle( 'l', trim(y_title), 0.0 )
     call DclDrawTitle( 't', trim(outname), 0.0, 2 )

     if(DclGetContourLevelNumber()==0)then
        call DclSetContourLabelFormat(trim(form_typec))
        call DclSetContourLevel( cont_min, cont_max, (cont_max-cont_min)/cont_num )
     end if

     call DclDrawContour( contour )

     if(map_pro/=11)then
        if(present(zg))then
           if(size(xg,1)>1)then
              call color_line( 'l', xg, yg, zg, color_num, (/shade_min, shade_max/) )
           end if
        else
           if(present(xg))then
              if(size(xg,1)>1)then
                 do i=1,size(xg,2)
                    if(present(l_idx))then
                       call DclSetLineIndex( l_idx(i) )  ! , ޤǰ뤫
                    end if
                    if(present(l_typ))then
                       call DclSetLineType( l_typ(i) )
                    end if
                    call DclDrawLine( xg(:,i), yg(:,i) )
                 end do
              end if
           end if
        end if

        if(present(zp))then
           call color_line( 'p', xp, yp, zp, color_num, (/shade_min, shade_max/) )
        else
           if(present(xp))then
              do i=1,size(xp,2)
                 if(present(p_idx))then
                    call DclSetMarkerIndex( p_idx(i) )  ! , ޤǰ뤫
                 end if
                 if(present(p_typ))then
                    call DclSetMarkerType( p_typ(i) )
                 end if
                 if(present(p_siz))then
                    call DclSetMarkerSize( p_siz(i) )
                 end if
                 call DclDrawMarker( xp(:,i), yp(:,i) )
              end do
           end if
        end if
     end if

     call DclNewFig

!     call g2qctm( lon_min, lon_max, lat_min, lat_max )
     if(present(t_posi))then
        call SGRSET( 'STLAT1', t_posi(1) )
        call SGRSET( 'STLAT2', t_posi(2) )
        call UMSCNT( t_posi(3), t_posi(1), 0.0 )
     end if

write(*,*) "window set", lon_min, lon_max, lat_min, lat_max
write(*,*) "viewport set", vx_min, vx_max, vy_min, vy_max
     CALL UMSPNT( 4, (/lon_wnd(1,1), lon_wnd(nx,1), lon_wnd(1,ny), lon_wnd(nx,ny)/),  &
  &               (/lat_wnd(1,1), lat_wnd(nx,1), lat_wnd(1,ny), lat_wnd(nx,ny)/) )
!     call DclSetWindow( lon_min, lon_max, lat_min, lat_max )

     if(present(long))then
        if(size(long,1)>1)then
           do i=1,size(long,2)
              call DclScalingPoint( long(:,i), latg(:,i) )
           end do
        end if
     end if

     if(present(lonp))then
        do i=1,size(lonp,2)
           call DclScalingPoint( lonp(:,i), latp(:,i) )
        end do
     end if

     call DclSetViewPort( vx_min, vx_max, vy_min, vy_max )
     call DclSetTransNumber( map_pro )
     call DclFitMapParm
     call DclSetTransFunction
  end if

  CALL UZLSET( 'LABELYL', .TRUE. )
  CALL UZLSET( 'LABELYR', .FALSE. )

  if(present(lon_wnd))then
!     call DclDrawAxis( 'b', mditv, 0.5*mditv )
!     call DclDrawAxis( 'l', mditv, 0.5*mditv )
     write(*,*) "dummy"
  else
     call DclDrawAxis( 'bt', mditv, 0.5*mditv )
     call DclDrawAxis( 'rl', mditv, 0.5*mditv )
!     call DclDrawScaledAxis
     call DclDrawTitle( 'b', trim(x_title), 0.0 )
     call DclDrawTitle( 'l', trim(y_title), 0.0 )
     call DclDrawTitle( 't', trim(outname), 0.0, 2 )
  end if
  call DclDrawMap( trim(coast_sel) )
  if(present(border))then
     if(bord_flag.eqv..true.)then
        call DclDrawMap( border_sel(1:len_trim(border_sel)) )
     else
        write(*,*) "*** MESSAGE (Dcl_2D_cont_shade_MapPro) ***"
        write(*,*) "'border' argument is invalid."
     end if
  end if
  call DclDrawGlobe()

  if(map_pro==11)then
     if(present(zg))then
        if(size(xg,1)>1)then
           call color_line( 'l', xg, yg, zg, color_num, (/shade_min, shade_max/) )
        end if
     else
        if(present(xg))then
           if(size(xg,1)>1)then
              do i=1,size(xg,2)
                 if(present(l_idx))then
                    call DclSetLineIndex( l_idx(i) )  ! , ޤǰ뤫
                 end if
                 if(present(l_typ))then
                    call DclSetLineType( l_typ(i) )
                 end if
                 call DclDrawLine( xg(:,i), yg(:,i) )
              end do
           end if
        end if
     end if

     if(present(zp))then
        call color_line( 'p', xp, yp, zp, color_num, (/shade_min, shade_max/) )
     else
        if(present(xp))then
           do i=1,size(xp,2)
              if(present(p_idx))then
                 call DclSetMarkerIndex( p_idx(i) )  ! , ޤǰ뤫
              end if
              if(present(p_typ))then
                 call DclSetMarkerType( p_typ(i) )
              end if
              if(present(p_siz))then
                 call DclSetMarkerSize( p_siz(i) )
              end if
              call DclDrawMarker( xp(:,i), yp(:,i) )
           end do
        end if
     end if

  else

     if(present(long))then
        if(size(long,1)>1)then
           do i=1,size(long,2)
              if(present(m_idx))then
                 call DclSetLineIndex( m_idx(i) )  ! , ޤǰ뤫
              end if
              if(present(m_typ))then
                 call DclSetLineType( m_typ(i) )
              end if
              call DclDrawLine( long(:,i), latg(:,i) )
           end do
        end if
     end if

     if(present(lonp))then
        do i=1,size(lonp,2)
           if(present(mp_idx))then
              call DclSetMarkerIndex( mp_idx(i) )  ! , ޤǰ뤫
           end if
           if(present(mp_typ))then
              call DclSetMarkerType( mp_typ(i) )
           end if
           if(present(mp_siz))then
              call DclSetMarkerSize( mp_siz(i) )
           end if
           call DclDrawMarker( lonp(:,i), latp(:,i) )
        end do
     end if

  end if

  if(present(lon_wnd))then
     write(*,*) "contour interval already is written before."
  else
     if(DclGetContourLevelNumber()==0)then
        call DclSetContourLabelFormat(trim(form_typec))
        call DclSetContourLevel( cont_min, cont_max, (cont_max-cont_min)/cont_num )
     end if
     call DclDrawContour( contour )
  end if

  CALL SGQVPT( vx_new(1), vx_new(2), vy_new(1), vy_new(2) )

  if(no_tone_flag.eqv..false.)then
     if(present(trigleg))then
        call tone_bar( color_num, (/shade_min, shade_max/),  &
  &                  (/vx_new(2)+0.05, vx_new(2)+0.075/),   &
  &                  vy_new, trim(form_types), mono_log=monoto,  &
  &                  trigle=trigleg )
     else
        call tone_bar( color_num, (/shade_min, shade_max/),  &
  &                  (/vx_new(2)+0.05, vx_new(2)+0.075/),   &
  &                  vy_new, trim(form_types), mono_log=monoto )
     end if
  end if

end subroutine

!---------------------------------------------------------

subroutine Dcl_2D_cont_shade_MapPro_vec( map_pro, outname,  &
  &  x, y, contour, shade, cont_int, shade_int,  &
  &  axis_title, form_type, viewx_int, viewy_int, c_num,  &
!  &  viewy_max, color_num, cont_num, nongrid,  &
  &  xg, yg, zg, long, latg, xp, yp, zp, lonp, latp,  &
  &  mono, mono_val, mono_lev, trigleg,  &
  &  mlitv, mlidx, coast, border, blidx, bltyp,  &
  &  no_tone, no_frame, l_idx, l_typ, m_idx, m_typ,  &
  &  p_idx, p_typ, p_siz, mp_idx, mp_typ, mp_siz,  &
  &  t_posi, lon_wnd, lat_wnd )
  ! 2  2 ѿȥ顼ɤ褹.
  !  map_pro Ͽֹ, Ͽƥ⡼ɤڤؤ.
  use dcl
  implicit none
  integer, intent(in) :: map_pro  ! DCL ϿѴؿֹ
  character(*), intent(in) :: outname  ! դΥȥ
  real, intent(in) :: x(:)  ! x γʻɸ [deg]
  real, intent(in) :: y(:)  ! y γʻɸ [deg]
  real, intent(inout) :: contour(size(x),size(y))  ! 
  real, intent(inout) :: shade(size(x),size(y))  ! 顼ɤ
  real, intent(in) :: cont_int(2)  ! ξ岼ü 
                                 ! [cont_int(1)=cont_min, cont_int(2)=cont_max]
  real, intent(in) :: shade_int(2)  ! ξ岼ü [shade_int(1)=shade_min,
                                 ! shade_int(2)=shade_max]
  character(*), intent(in) :: axis_title(2)  ! ɸΥȥ
                                 ! axis_title(1)=x_title, axis_title(2)=y_title
  character(*), intent(in) :: form_type(2)  ! եޥå
                           ! form_type(1)=form_typec, form_type(2)=form_types
  real, intent(in), optional :: viewx_int(2)  ! ӥ塼ݡȤ x ξü
                           ! viewx_int(1)=vx_min, vx_int(2)=vx_max
  real, intent(in), optional :: viewy_int(2)  ! ӥ塼ݡȤ y ξü
                           ! viewy_int(1)=vy_min, vy_int(2)=vy_max
  integer, intent(in), optional :: c_num(2)  ! 󥿡ɤο
                           ! c_num(1)=cont_num, c_num(2)=color_num
!  character(2), intent(in), optional :: nongrid  ! ֳֳʻҤˤ뤫.
                                        ! nongrid = 'ox' Ƚ.
                                        ! 1 ʸܤ, 2 ʸܤļ.
                                        ! o = ֳ, x = ֳ.
                                        ! ǥեȤǤ 'xx'.
  real, intent(in), optional :: xg(:,:)  ! x 륰åκɸ
  real, intent(in), optional :: yg(:,:)  ! y 륰åκɸ
                    ! Ǥΰ֥ǡ, ʣ,
                    ! Ǥ 2 İʾˤ.
                    ! ǡľǤϤʤ, åɤ
                    ! Ȥǽ.
                    ! 3 ܤ, xg(:,1)  yg(:,1)  1 ܤ
                    ! ɽ褦˻ꤹ뤳.
  real, intent(in), optional :: zg(:,:)  ! åͤäƤФ.
                    ! Υץ򤵤줿, ưŪѿ shade 
                    ! Ѥ줺, shade ϢѿϤ٤Ƥͤ
                    ! ե󥹤Ȥƥ顼ޤ⡼ɤ˰ܹԤ.
  real, intent(in), optional :: long(:,:)  ! lon ɸ륰å
  real, intent(in), optional :: latg(:,:)  ! lat ɸ륰å
  real, intent(in), optional :: xp(:,:)  ! x ˥ޡ x ɸ
  real, intent(in), optional :: yp(:,:)  ! y ˥ޡ y ɸ
  real, intent(in), optional :: zp(:,:)  ! ޡͤäƤФ.
                                         ! λˡƱ.
                    ! Υץ򤵤줿, ưŪѿ shade 
                    ! Ѥ줺, shade ϢѿϤ٤Ƥͤ
                    ! ե󥹤Ȥƥ顼ޡ⡼ɤ˰ܹԤ.
  logical, intent(in), optional :: mono  ! ΥȡγĴˤ [.true.]
                                         ! ǥեȤ .false.
  real, intent(in), optional :: lonp(:,:)  ! lon ɸޡ
  real, intent(in), optional :: latp(:,:)  ! lat ɸޡ
  real, intent(in), optional :: mono_val(:)  ! Ĵζ.
                    ! mono=.true. ΤȤɬꤷʤȥ顼֤.
                    ! ͤ mono_lev + 1 ʬ¸ߤʤФʤʤ.
  integer, intent(in), optional :: mono_lev(:)  ! ȡޥåֹ. dcl  3 
                    ! mono=.true. ΤȤꤷʤȥ顼֤.
  character(1), intent(in), optional :: trigleg  ! ȡСλѷץ.
                ! ץͤ, tone_bar 롼 trigle Ʊ.
  real, intent(in), optional :: mlitv  ! ᥸㡼饤, ɽֳ [degree]. ǥեȤ 1 degree.
  integer, intent(in), optional :: mlidx  ! ᥸㡼饤, Υǥå.
                                          ! ǥեȤ 1.
  character(5), intent(in), optional :: coast  ! 
                                   ! ['japan'] = ܰܺ
                                   ! ['world'] = 
                                   ! default = 'world'
  character(5), intent(in), optional :: border  ! , , 
                                   ! ['japan'] = ܸ
                                   ! ['world'] = 
                                   ! ['state'] = ƹ񽣶
                                   ! default = 褷ʤ.
  integer, intent(in), optional :: blidx  ! , 񶭤Υǥå.
                                          ! ǥեȤ 3.
  integer, intent(in), optional :: bltyp  ! , 񶭤Υ.
                                          ! ǥեȤ 1.
  logical, intent(in), optional :: no_tone  ! ȡСʤץ
                                   ! .false. = . .true. = ʤ.
                                   ! ǥեȤ .false.
  logical, intent(in), optional :: no_frame  ! NewFrame ƤФʤ
                                   ! .false. = Ƥ. .true. = ƤФ NewFig.
                                   ! ǥեȤ .false.
  integer, intent(in), optional :: l_idx(:)  ! xg, yg Υǥå
                                                      ! ǥեȤ 1.
  integer, intent(in), optional :: l_typ(:)  ! xg, yg Υ.
                                                      ! ǥեȤ 1.
  integer, intent(in), optional :: m_idx(:)  ! long, latg Υǥå
                                                      ! ǥեȤ 1.
  integer, intent(in), optional :: m_typ(:)  ! long, latg Υ.
                                                      ! ǥեȤ 1.
  integer, intent(in), optional :: p_idx(:)  ! xp, yp ޡΥǥå
  integer, intent(in), optional :: p_typ(:)  ! xg, yg ޡΥ.
                                                      ! ǥեȤ 1.
  real, intent(in), optional :: p_siz(:)  ! xg, yg ޡ礭.
                                                      ! ǥեȤ 0.01.
  integer, intent(in), optional :: mp_idx(:)  ! lonp, latp ޡΥǥå
  integer, intent(in), optional :: mp_typ(:)  ! lonp, latp ޡΥǥå
  real, intent(in), optional :: mp_siz(:)  ! lonp, latp ޡΥǥå
  real, intent(in), optional :: t_posi(3)  ! map optiona ٥Ȥξ
                                           ! t_posi=(/lat1, lat2, lon1/) .
                                           ! ñ̤ degree
  real, intent(in), optional :: lon_wnd(:,:)  ! 륫ȥϰʳǶΰ
                   ! γƺɸϷа. ͤꤵȤ, 
                   ! x, y ˤ, ǥȷϤǤεΥͿƤ.
  real, intent(in), optional :: lat_wnd(:,:)  ! 륫ȥϰʳǶΰ
                   ! γƺɸϷа. ͤꤵȤ, 
                   ! x, y ˤ, ǥȷϤǤεΥͿƤ.
!-- ʾ, 
  real :: cont_min  ! Ǿ
  real :: cont_max  ! 
  real :: shade_min  ! ɤǾ
  real :: shade_max  ! ɤ
  character(100) :: x_title  ! x Υȥ
  character(100) :: y_title  ! y Υȥ
  character(10) :: form_typec  ! contour ѤΥեޥå
  character(10) :: form_types  ! shade ѤΥեޥå
  real :: vx_min  ! ӥ塼ݡȤ x κǾ
  real :: vx_max  ! ӥ塼ݡȤ x κ
  real :: vy_min  ! ӥ塼ݡȤ y κǾ
  real :: vy_max  ! ӥ塼ݡȤ y κ
  integer :: cont_num  ! ο
  integer :: color_num  ! 顼ο
!-- ʾ, ֤ѿ
  real, parameter :: pi=3.14159265
  real, parameter :: radius=6.38e6
  integer :: i, j, k  ! ź
  integer :: nx, ny
  real :: uratio
  real :: undef, RMIS
  real :: map_lat_min, map_lat_max, map_lon_min, map_lon_max
  real :: lat_min, lat_max, lon_min, lon_max
  real :: mlat2dis_min, mlat2dis_max, mlon2dis_min, mlon2dis_max, mditv, mid_p
  integer :: mdidx, bdidx, bdtyp
  real, dimension(2) :: vx_new, vy_new
  character(20) :: coast_sel
  character(20) :: border_sel
  logical :: monoto, no_tone_flag, no_frame_flag, bord_flag

  nx=size(x)
  ny=size(y)
  coast_sel=''
  border_sel=''
  bord_flag=.false.

!--  rad ñ̤Ѵ
  map_lon_min=x(1)*pi/180.0
  map_lon_max=x(nx)*pi/180.0
  map_lat_min=y(1)*pi/180.0
  map_lat_max=y(ny)*pi/180.0

  select case (map_pro)
  case (11)
     mlon2dis_min=map_lon_min
     mlon2dis_max=map_lon_max
     mlat2dis_min=log(tan(0.25*pi+0.5*map_lat_min))
     mlat2dis_max=log(tan(0.25*pi+0.5*map_lat_max))
  case (22)
     mlon2dis_min=x(1)
     mlon2dis_max=x(nx)
     mlat2dis_min=y(1)
     mlat2dis_max=y(ny)
  end select

!-- C ɸϤη׻
  if(present(lon_wnd))then
     lon_min=lon_wnd(1,1)
     lon_max=lon_wnd(nx,1)
     lat_min=lat_wnd(1,1)
     lat_max=lat_wnd(1,ny)
  end if

!-- optional ν ---
  if(present(viewx_int))then
     vx_min=viewx_int(1)
     vx_max=viewx_int(2)
  else
     vx_min=0.2
     vx_max=0.8
  end if

  if(present(viewy_int))then
     vy_min=viewy_int(1)
     vy_max=viewy_int(2)
  else
     vy_min=0.2
     vy_max=0.8
  end if

  if(present(c_num))then
     cont_num=c_num(1)
     color_num=c_num(2)
  else
     cont_num=10
     color_num=56
  end if

  if(present(no_tone))then
     no_tone_flag=no_tone
  else
     no_tone_flag=.false.
  end if

  if(present(no_frame))then
     no_frame_flag=no_frame
  else
     no_frame_flag=.false.
  end if

  if(map_pro==22)then
     if(.not.present(t_posi))then
        write(*,*) "*** ERROR (dcl_auto) *** : In case of map_pro = 22,"
        write(*,*) "                           option 't_posi' must be set."
        stop
     end if
  end if

!-- ֤ѿ֤
  cont_min=cont_int(1)
  cont_max=cont_int(2)
  shade_min=shade_int(1)
  shade_max=shade_int(2)
  x_title=trim(axis_title(1))
  y_title=trim(axis_title(2))
  form_typec=trim(form_type(1))
  form_types=trim(form_type(2))

!-- ϿȼΥץ ---
!-- MapFit 롼Ѥ, Ͽޤ vp ŪѹΤ,
!-- νԤ.
!-- u ɸϤǤΥڥȤ, ĹĹ vp ˤ,
!-- û vp .
  uratio=(mlat2dis_max-mlat2dis_min)/(mlon2dis_max-mlon2dis_min)  ! u ɸϤǤ ratio
  if( uratio>1.0 )then
  ! y ĹΤ, vratio  vxmin, vxmax ˽.
  ! ϰʲΤȤ (mid ɸ) : 
  ! vxmax+vxmin=2.0*mid, vxmax-vxmin=(vymax-vymin)/uratio
  ! 򤽤줾򤯤, vymax, vymin ϴϤʤΤǰΤΤѤ,
  ! vxmax=mid+0.5*(vymax-vymin)/uratio
  ! vxmin=mid-0.5*(vymax-vymin)/uratio
     mid_p=0.5*(vx_min+vx_max)
     vx_max=mid_p+0.5*(vy_max-vy_min)/uratio
     vx_min=mid_p-0.5*(vy_max-vy_min)/uratio
  else
  ! x ĹΤ, vratio  vymin, vymax ˽.
  ! ϰʲΤȤ (mid ɸ) : 
  ! vymax+vymin=2.0*mid, vymax-vymin=uratio*(vxmax-vxmin)
  ! 򤽤줾򤯤, vxmax, vxmin ϴϤʤΤǰΤΤѤ,
  ! vymax=mid+0.5*(uratio*(vxmax-vxmin)
  ! vymin=mid-0.5*(uratio*(vxmax-vxmin)
     mid_p=0.5*(vy_min+vy_max)
     vy_max=mid_p+0.5*uratio*(vx_max-vx_min)
     vy_min=mid_p-0.5*uratio*(vx_max-vx_min)
  end if

  if(present(mono))then
     if(present(mono_val).and.present(mono_lev))then
        if(size(mono_val)-1==size(mono_lev))then
           monoto=mono
        else
           write(*,*) "*** ERROR ***"
           write(*,*) "[array number] : mono_val = mono_lev + 1"
           write(*,*) "STOP"
           stop
        end if
     else
        write(*,*) "*** ERROR ***"
        write(*,*) "When option MONO is true, MONO_VAL and MONO_LEV must be specified."
        write(*,*) "STOP"
        stop
     end if
  else
     monoto=.false.
  end if

  if(present(mlitv))then
     mditv=mlitv
  else
     mditv=1.0
  end if

  if(present(mlidx))then
     mdidx=mlidx
  else
     mdidx=1
  end if

  if(present(coast))then
     coast_sel='coast_'//coast
  else
     coast_sel='coast_world'
  end if

  if(present(border))then
     select case (trim(border))
     case ('japan')
        bord_flag=.true.
        border_sel='pref_japan'
     case ('world')
        bord_flag=.true.
        border_sel='border_world'
     case ('state')
        bord_flag=.true.
        border_sel='state_usa'
     end select
  end if

  if(present(blidx))then
     bdidx=blidx
  else
     bdidx=3
  end if

  if(present(bltyp))then
     bdtyp=bltyp
  else
     bdtyp=1
  end if

  if(present(lon_wnd))then
     call udlset('LMSG',.false.)
  end if

!-- ޤ ---

!-- contour  axis Τ,  contour interval ɽʤ
!-- 褦ˤ롼. contour interval .
  call undef_CReSS2Dcl( nx, ny, 1, contour)
  call undef_CReSS2Dcl( nx, ny, 1, shade)

  call UWSGXZ(.FALSE.)
  call UWSGYZ(.FALSE.)

  if(no_frame_flag.eqv..true.)then
     call DclNewFig
  else
     call DclNewFrame
  end if

  call DclSetParm( 'MAP:LGRIDMN', .false. )
  call DclSetParm( 'MAP:INDEXMJ', mdidx )
  call DclSetParm( 'MAP:dgridmj', mditv )
  call DclSetParm( 'MAP:INDEXBND', bdidx )
  call DclSetParm( 'MAP:INDEXOUT', bdidx )
  call DclSetParm( 'MAP:ITYPEOUT', bdtyp )

  write(*,*) "window set", x(1), x(nx), y(1), y(ny)
  call DclSetWindow( x(1), x(nx), y(1), y(ny) )

  if(present(zg))then
     call color_line( 's', xg, yg, zg, color_num,  &
  &                   (/shade_min, shade_max/), subsubidx='l' )
  else
     if(present(xg))then
        do i=1,size(xg,2)
           call DclScalingPoint( xg(:,i), yg(:,i) )
        end do
     end if
  end if

  if(present(zp))then
     call color_line( 's', xp, yp, zp, color_num,  &
  &                   (/shade_min, shade_max/), subsubidx='p' )
  else
     if(present(xp))then
        do i=1,size(xp,2)
           call DclScalingPoint( xp(:,i), yp(:,i) )
        end do
     end if
  end if

  write(*,*) "viewport set", vx_min, vx_max, vy_min, vy_max
  call DclSetViewPort( vx_min, vx_max, vy_min, vy_max )
  if(present(lon_wnd))then
     call DclSetTransNumber( 1 )
  else
     call DclSetTransNumber( map_pro )
     call DclFitMapParm
  end if
  call DclSetTransFunction

  if(monoto.eqv..true.)then
     call DclSetParm('ENABLE_SOFTFILL',.true.)
     call DclClearShadeLevel
     call DclSetShadeLevel( mono_val, mono_lev )
  else
     call DclSetParm('ENABLE_SOFTFILL',.false.)
!     call DclClearShadeLevel
!     call DclSetShadeLevel( shade_min, shade_max,   &
! &                          (shade_max-shade_min)/s_num )
  end if

  if(map_pro==11)then
     call DclSetParm( 'GRAPH:LCLIP', .true. )
  end if
!     call DclDrawViewPortFrame( 1 )
!  if(present(nongrid))then
!     if(nongrid(1:1)=='o')then
        call DclSetXGrid( x )
!     end if
!     if(nongrid(2:2)=='o')then
        call DclSetYgrid( y )
!     end if
!  end if

  if(monoto.eqv..true.)then
     call DclShadeContour( shade )
  else
     call DclShadeContourEx( shade )
  end if

  if(present(lon_wnd))then
!     call DclDrawAxis( 'b', mditv, 0.5*mditv )
!     call DclDrawAxis( 'l', mditv, 0.5*mditv )
     call Dcl_Special_Axis( 'bl', map_pro, mditv, (/vx_min, vx_max/),  &
  &                         (/vy_min, vy_max/), t_posi, lon_wnd, lat_wnd,  &
  &                         (/trim(x_title), trim(y_title)/) )
!     call DclDrawTitle( 'b', trim(x_title), 0.0 )
!     call DclDrawTitle( 'l', trim(y_title), 0.0 )
     call DclDrawTitle( 't', trim(outname), 0.0, 2 )

     if(DclGetContourLevelNumber()==0)then
        call DclSetContourLabelFormat(trim(form_typec))
        call DclSetContourLevel( cont_min, cont_max, (cont_max-cont_min)/cont_num )
     end if

     call DclDrawContour( contour )

     if(map_pro/=11)then
        if(present(zg))then
           call color_line( 'l', xg, yg, zg, color_num, (/shade_min, shade_max/) )
        else
           if(present(xg))then
              do i=1,size(xg,2)
                 if(present(l_idx))then
                    call DclSetLineIndex( l_idx(i) )  ! , ޤǰ뤫
                 end if
                 if(present(l_typ))then
                    call DclSetLineType( l_typ(i) )
                 end if
                 call DclDrawLine( xg(:,i), yg(:,i) )
              end do
           end if
        end if

        if(present(zp))then
           call color_line( 'p', xp, yp, zp, color_num, (/shade_min, shade_max/) )
        else
           if(present(xp))then
              do i=1,size(xp,2)
                 if(present(p_idx))then
                    call DclSetMarkerIndex( p_idx(i) )  ! , ޤǰ뤫
                 end if
                 if(present(p_typ))then
                    call DclSetMarkerType( p_typ(i) )
                 end if
                 if(present(p_siz))then
                    call DclSetMarkerSize( p_siz(i) )
                 end if
                 call DclDrawMarker( xp(:,i), yp(:,i) )
              end do
           end if
        end if
     end if

     call DclNewFig

!     call g2qctm( lon_min, lon_max, lat_min, lat_max )
     if(present(t_posi))then
        call SGRSET( 'STLAT1', t_posi(1) )
        call SGRSET( 'STLAT2', t_posi(2) )
        call UMSCNT( t_posi(3), t_posi(1), 0.0 )
     end if

write(*,*) "window set", lon_min, lon_max, lat_min, lat_max
write(*,*) "viewport set", vx_min, vx_max, vy_min, vy_max
     CALL UMSPNT( 4, (/lon_wnd(1,1), lon_wnd(nx,1), lon_wnd(1,ny), lon_wnd(nx,ny)/),  &
  &               (/lat_wnd(1,1), lat_wnd(nx,1), lat_wnd(1,ny), lat_wnd(nx,ny)/) )
!     call DclSetWindow( lon_min, lon_max, lat_min, lat_max )

     if(present(long))then
        do i=1,size(long,2)
           call DclScalingPoint( long(:,i), latg(:,i) )
        end do
     end if

     if(present(lonp))then
        do i=1,size(lonp,2)
           call DclScalingPoint( lonp(:,i), latp(:,i) )
        end do
     end if

     call DclSetViewPort( vx_min, vx_max, vy_min, vy_max )
     call DclSetTransNumber( map_pro )
     call DclFitMapParm
     call DclSetTransFunction
  end if

  CALL UZLSET( 'LABELYL', .TRUE. )
  CALL UZLSET( 'LABELYR', .FALSE. )

  if(present(lon_wnd))then
!     call DclDrawAxis( 'b', mditv, 0.5*mditv )
!     call DclDrawAxis( 'l', mditv, 0.5*mditv )
     write(*,*) "dummy"
  else
     call DclDrawAxis( 'bt', mditv, 0.5*mditv )
     call DclDrawAxis( 'rl', mditv, 0.5*mditv )
!     call DclDrawScaledAxis
     call DclDrawTitle( 'b', trim(x_title), 0.0 )
     call DclDrawTitle( 'l', trim(y_title), 0.0 )
     call DclDrawTitle( 't', trim(outname), 0.0, 2 )
  end if
  call DclDrawMap( trim(coast_sel) )
  if(present(border))then
     if(bord_flag.eqv..true.)then
        call DclDrawMap( border_sel(1:len_trim(border_sel)) )
     else
        write(*,*) "*** MESSAGE (Dcl_2D_cont_shade_MapPro) ***"
        write(*,*) "'border' argument is invalid."
     end if
  end if
  call DclDrawGlobe()

  if(map_pro==11)then
     if(present(zg))then
        call color_line( 'l', xg, yg, zg, color_num, (/shade_min, shade_max/) )
     else
        if(present(xg))then
           do i=1,size(xg,2)
              if(present(l_idx))then
                 call DclSetLineIndex( l_idx(i) )  ! , ޤǰ뤫
              end if
              if(present(l_typ))then
                 call DclSetLineType( l_typ(i) )
              end if
              call DclDrawLine( xg(:,i), yg(:,i) )
           end do
        end if
     end if

     if(present(zp))then
        call color_line( 'p', xp, yp, zp, color_num, (/shade_min, shade_max/) )
     else
        if(present(xp))then
           do i=1,size(xp,2)
              if(present(p_idx))then
                 call DclSetMarkerIndex( p_idx(i) )  ! , ޤǰ뤫
              end if
              if(present(p_typ))then
                 call DclSetMarkerType( p_typ(i) )
              end if
              if(present(p_siz))then
                 call DclSetMarkerSize( p_siz(i) )
              end if
              call DclDrawMarker( xp(:,i), yp(:,i) )
           end do
        end if
     end if

  else

     if(present(long))then
        do i=1,size(long,2)
           if(present(m_idx))then
              call DclSetLineIndex( m_idx(i) )  ! , ޤǰ뤫
           end if
           if(present(m_typ))then
              call DclSetLineType( m_typ(i) )
           end if
           call DclDrawLine( long(:,i), latg(:,i) )
        end do
     end if

     if(present(lonp))then
        do i=1,size(lonp,2)
           if(present(mp_idx))then
              call DclSetMarkerIndex( mp_idx(i) )  ! , ޤǰ뤫
           end if
           if(present(mp_typ))then
              call DclSetMarkerType( mp_typ(i) )
           end if
           if(present(mp_siz))then
              call DclSetMarkerSize( mp_siz(i) )
           end if
           call DclDrawMarker( lonp(:,i), latp(:,i) )
        end do
     end if

  end if

  if(present(lon_wnd))then
     write(*,*) "contour interval already is written before."
  else
     if(DclGetContourLevelNumber()==0)then
        call DclSetContourLabelFormat(trim(form_typec))
        call DclSetContourLevel( cont_min, cont_max, (cont_max-cont_min)/cont_num )
     end if
     call DclDrawContour( contour )
  end if

  CALL SGQVPT( vx_new(1), vx_new(2), vy_new(1), vy_new(2) )

  if(no_tone_flag.eqv..false.)then
     if(present(trigleg))then
        call tone_bar( color_num, (/shade_min, shade_max/),  &
  &                  (/vx_new(2)+0.05, vx_new(2)+0.075/),   &
  &                  vy_new, trim(form_types), mono_log=monoto,  &
  &                  trigle=trigleg )
     else
        call tone_bar( color_num, (/shade_min, shade_max/),  &
  &                  (/vx_new(2)+0.05, vx_new(2)+0.075/),   &
  &                  vy_new, trim(form_types), mono_log=monoto )
     end if
  end if

end subroutine

!---------------------------------------------------------

subroutine Dcl_2D_cont_shade_terrain( outname,  &
  &  x, y, grid_point, contour, shade, cont_int, shade_int,  &
  &  axis_title, form_type, viewx_int, viewy_int, c_num,  &
!  &  viewy_min, viewy_max, color_num, cont_num, nongrid,  &
  &  xg, yg, zg, xp, yp, zp,  &
  &  mono, mono_val, mono_lev, trigleg, trn_paint, trn_col,  &
  &  layer_line, no_tone, no_frame,  &
  &  l_idx, l_typ, p_idx, p_typ, p_siz )
  ! 2  2 ѿȥ顼ɤ褹.
  ! terrain following 
  use dcl
  implicit none
  character(*), intent(in) :: outname  ! դΥȥ
  real, intent(in) :: x(:)  ! x γʻɸ
  real, intent(in) :: y(:)  ! y γʻɸ
  real, intent(inout) :: grid_point(size(x),size(y))  ! terrain following ɸ
  real, intent(inout) :: contour(size(x),size(y))  ! 
  real, intent(inout) :: shade(size(x),size(y))  ! 顼ɤ
  real, intent(in) :: cont_int(2)  ! ξ岼ü 
                                 ! [cont_int(1)=cont_min, cont_int(2)=cont_max]
  real, intent(in) :: shade_int(2)  ! ξ岼ü [shade_int(1)=shade_min,
                                 ! shade_int(2)=shade_max]
  character(*), intent(in) :: axis_title(2)  ! ɸΥȥ
                                 ! axis_title(1)=x_title, axis_title(2)=y_title
  character(*), intent(in) :: form_type(2)  ! եޥå
                           ! form_type(1)=form_typec, form_type(2)=form_types
  real, intent(in), optional :: viewx_int(2)  ! ӥ塼ݡȤ x ξü
                           ! viewx_int(1)=vx_min, vx_int(2)=vx_max
  real, intent(in), optional :: viewy_int(2)  ! ӥ塼ݡȤ y ξü
                           ! viewy_int(1)=vy_min, vy_int(2)=vy_max
  integer, intent(in), optional :: c_num(2)  ! 󥿡ɤο
                           ! c_num(1)=cont_num, c_num(2)=color_num
!  character(2), intent(in), optional :: nongrid  ! ֳֳʻҤˤ뤫.
                                        ! nongrid = 'ox' Ƚ.
                                        ! 1 ʸܤ, 2 ʸܤļ.
                                        ! o = ֳ, x = ֳ.
                                        ! ǥեȤǤ 'xx'.
  real, intent(in), optional :: xg(:,:)  ! x 륰åκɸ
  real, intent(in), optional :: yg(:,:)  ! y 륰åκɸ
                    ! Ǥΰ֥ǡ, ʣ,
                    ! Ǥ 2 İʾˤ.
                    ! ǡľǤϤʤ, åɤ
                    ! Ȥǽ.
                    ! 3 ܤ, xg(:,1)  yg(:,1)  1 ܤ
                    ! ɽ褦˻ꤹ뤳.
  real, intent(in), optional :: zg(:,:)  ! åͤäƤФ.
                    ! Υץ򤵤줿, ưŪѿ shade 
                    ! Ѥ줺, shade ϢѿϤ٤Ƥͤ
                    ! ե󥹤Ȥƥ顼ޤ⡼ɤ˰ܹԤ.
  real, intent(in), optional :: xp(:,:)  ! x ˥ޡ x ɸ
  real, intent(in), optional :: yp(:,:)  ! y ˥ޡ y ɸ
  real, intent(in), optional :: zp(:,:)  ! ޡͤäƤФ.
                                         ! λˡƱ.
                    ! Υץ򤵤줿, ưŪѿ shade 
                    ! Ѥ줺, shade ϢѿϤ٤Ƥͤ
                    ! ե󥹤Ȥƥ顼ޡ⡼ɤ˰ܹԤ.
  logical, intent(in), optional :: mono  ! ΥȡγĴˤ [.true.]
                                         ! ǥեȤ .false.
  real, intent(in), optional :: mono_val(:)  ! Ĵζ.
                    ! mono=.true. ΤȤɬꤷʤȥ顼֤.
                    ! ͤ mono_lev + 1 ʬ¸ߤʤФʤʤ.
  integer, intent(in), optional :: mono_lev(:)  ! ȡޥåֹ. dcl  3 
                    ! mono=.true. ΤȤꤷʤȥ顼֤.
  character(1), intent(in), optional :: trigleg  ! ȡСλѷץ.
                ! ץͤ, tone_bar 롼 trigle Ʊ.
  logical, intent(in), optional :: trn_paint  ! Ϸ˿ɤ뤫. [def:.false.]
  integer, intent(in), optional :: trn_col  ! Ϸɤ뿧Υ顼ֹ
  logical, intent(in), optional :: layer_line  ! ؤγʻɽ. [def:.false.]
  logical, intent(in), optional :: no_tone  ! ȡСʤץ
                                   ! .false. = . .true. = ʤ.
                                   ! ǥեȤ .false.
  logical, intent(in), optional :: no_frame  ! NewFrame ƤФʤ
                                   ! .false. = Ƥ. .true. = ƤФ NewFig.
                                   ! ǥեȤ .false.
  integer, intent(in), optional :: l_idx(:)  ! xg, yg Υǥå
                                                      ! ǥեȤ 1.
  integer, intent(in), optional :: l_typ(:)  ! xg, yg Υ
                                                      ! ǥեȤ 1.
  integer, intent(in), optional :: p_idx(:)  ! xp, yp ޡΥǥå
  integer, intent(in), optional :: p_typ(:)  ! xp, yp ޡΥ
  real, intent(in), optional :: p_siz(:)  ! xp, yp ޡ礭
!-- ʾ, 
  real :: cont_min  ! Ǿ
  real :: cont_max  ! 
  real :: shade_min  ! ɤǾ
  real :: shade_max  ! ɤ
  character(100) :: x_title  ! x Υȥ
  character(100) :: y_title  ! y Υȥ
  character(10) :: form_typec  ! contour ѤΥեޥå
  character(10) :: form_types  ! shade ѤΥեޥå
  real :: vx_min  ! ӥ塼ݡȤ x κǾ
  real :: vx_max  ! ӥ塼ݡȤ x κ
  real :: vy_min  ! ӥ塼ݡȤ y κǾ
  real :: vy_max  ! ӥ塼ݡȤ y κ
  integer :: cont_num  ! ο
  integer :: color_num  ! 顼ο
!-- ʾ, ֤ѿ
  integer :: i, j, k  ! ź
  integer :: nx, ny
  real :: undef, RMISS, interc
  logical :: monoto, no_tone_flag, no_frame_flag
  real :: cx(size(x),size(y)), cy(size(x),size(y))
  real :: trn(size(x)+2), trn_x(size(x)+2)
  real :: cxmax, cxmin, cymax, cymin
  character(10) :: val_c
  integer :: maxcy, maxcx, trn_color

  nx=size(x)
  ny=size(y)

!-- c ɸϤؤѴ
  do j=1,ny
     do i=1,nx
        cx(i,j)=x(i)
        cy(i,j)=grid_point(i,j)
     end do
  end do

!-- c ɸ϶ͤη׻

  cxmin=x(1)
  cxmax=x(nx)
  cymin=cy(1,1)
  cymax=cy(1,ny)
  do i=2,nx
     if(cymin>cy(i,1))then
        cymin=cy(i,1)
     end if
     if(cymax<cy(i,ny))then
        cymax=cy(i,ny)
     end if
  end do

!-- optional ν ---
  if(present(viewx_int))then
     vx_min=viewx_int(1)
     vx_max=viewx_int(2)
  else
     vx_min=0.2
     vx_max=0.8
  end if

  if(present(viewy_int))then
     vy_min=viewy_int(1)
     vy_max=viewy_int(2)
  else
     vy_min=0.2
     vy_max=0.8
  end if

  if(present(c_num))then
     cont_num=c_num(1)
     color_num=c_num(2)
  else
     cont_num=10
     color_num=56
  end if

  if(present(no_tone))then
     no_tone_flag=no_tone
  else
     no_tone_flag=.false.
  end if

  if(present(no_frame))then
     no_frame_flag=no_frame
  else
     no_frame_flag=.false.
  end if

!-- ֤ѿ֤
  cont_min=cont_int(1)
  cont_max=cont_int(2)
  shade_min=shade_int(1)
  shade_max=shade_int(2)
  x_title=trim(axis_title(1))
  y_title=trim(axis_title(2))
  form_typec=trim(form_type(1))
  form_types=trim(form_type(2))

  if(present(mono))then
     if(present(mono_val).and.present(mono_lev))then
        if(size(mono_val)-1==size(mono_lev))then
           monoto=mono
        else
           write(*,*) "*** ERROR ***"
           write(*,*) "[array number] : mono_val = mono_lev + 1"
           write(*,*) "STOP"
           stop
        end if
     else
        write(*,*) "*** ERROR ***"
        write(*,*) "When option MONO is true, MONO_VAL and MONO_LEV must be specified."
        write(*,*) "STOP"
        stop
     end if
  else
     monoto=.false.
  end if

!-- ޤ ---

!-- contour  axis Τ,  contour interval ɽʤ
!-- 褦ˤ롼. contour interval .
  call udlset('LMSG',.false.)

  call undef_CReSS2Dcl( nx, ny, 1, contour)
  call undef_CReSS2Dcl( nx, ny, 1, shade)

  call UWSGXZ(.FALSE.)
  call UWSGYZ(.FALSE.)

  if(no_frame_flag.eqv..true.)then
     call DclNewFig
  else
     call DclNewFrame
  end if

  call DclSetWindow( x(1), x(nx), y(1), y(ny) )

  if(present(zg))then
     if(size(xg,1)>1)then
        call color_line( 's', xg, yg, zg, color_num,  &
  &                      (/shade_min, shade_max/), subsubidx='l' )
     end if
  else
     if(present(xg))then
        if(size(xg,1)>1)then
           do i=1,size(xg,2)
              call DclScalingPoint( xg(:,i), yg(:,i) )
           end do
        end if
     end if
  end if

  if(present(zp))then
     call color_line( 's', xp, yp, zp, color_num,  &
  &                   (/shade_min, shade_max/), subsubidx='p' )
  else
     if(present(xp))then
        do i=1,size(xp,2)
           call DclScalingPoint( xp(:,i), yp(:,i) )
        end do
     end if
  end if

  call DclSetViewPort( vx_min, vx_max, vy_min, vy_max )
  call DclSetTransNumber(51)
  call g2sctr(nx, ny, x, y, cx, cy )
  call DclSetTransFunction

  if(monoto.eqv..true.)then
     call DclSetParm('ENABLE_SOFTFILL',.true.)
     call DclClearShadeLevel
     call DclSetShadeLevel( mono_val, mono_lev )
  else
     call DclSetParm('ENABLE_SOFTFILL',.false.)
!     call DclSetParm('ENABLE_SOFTFILL',.true.)
!     call DclClearShadeLevel
!     call DclSetShadeLevel( shade_min, shade_max,   &
! &                          (shade_max-shade_min)/s_num )
  end if

  call uelset('ltone',.true.)

!  if(present(nongrid))then
!     if(nongrid(1:1)=='o')then
        call DclSetXGrid( x )
!     end if
!     if(nongrid(2:2)=='o')then
        call DclSetYgrid( y )
!     end if
!  end if

!  if(monoto.eqv..true.)then
!     call DclShadeContour( shade )
!  else
     call DclShadeContour( shade )
!  end if

  if(DclGetContourLevelNumber()==0)then
     call DclSetContourLabelFormat(trim(form_typec))
     call DclSetContourLevel( cont_min, cont_max, (cont_max-cont_min)/cont_num )
  end if

  call DclDrawContour( contour )

  call g2qctm( cxmin, cxmax, cymin, cymax )
  call DclSetWindow( cxmin, cxmax, cymin, cymax )
  call DclSetTransNumber(1)
  call DclSetTransFunction

  CALL UZLSET( 'LABELYL', .TRUE. )
  CALL UZLSET( 'LABELYR', .FALSE. )
  call DclDrawScaledAxis
  call DclDrawTitle( 'b', trim(x_title), 0.0 )
  call DclDrawTitle( 'l', trim(y_title), 0.0 )
  call DclDrawTitle( 't', trim(outname), 0.0, 2 )

!-- Ϸΰ˿ɤ
  if(present(trn_paint))then
     if(trn_paint.eqv..true.)then
        if(present(trn_col))then
           trn_color=trn_col
        else
           trn_color=1999
        end if
        do i=1,nx
           trn(i)=grid_point(i,1)
           trn_x(i)=x(i)
!        if(bot(i)==trn(i))then
!           call DclShadeRegion( )
!        end if
        end do
        trn(nx+1)=cymin
        trn(nx+2)=cymin
        trn_x(nx+1)=x(nx)
        trn_x(nx+2)=x(1)

        call DclShadeRegion( trn_x(1:nx+2), trn(1:nx+2), trn_color)
     end if
  end if

!  call DclSetContourLabelFormat(form_typec)
!  call DclSetContourLevel( cont_min, cont_max, (cont_max-cont_min)/c_num )
!  call DclDrawContour( contour )

  interc=DclGetContourInterval(1)
  write(*,*) interc
  write(val_c,'(E10.3)') interc

  call DclDrawTitle('b','_CONTOUR INTERVAL ='//val_c//'"',0.0,1)

  if(present(zg))then
     if(size(xg,1)>1)then
        call color_line( 'l', xg, yg, zg, color_num, (/shade_min, shade_max/) )
     end if
  else
     if(present(xg))then
        if(size(xg,1)>1)then
           do i=1,size(xg,2)
              if(present(l_idx))then
                 call DclSetLineIndex( l_idx(i) )  ! , ޤǰ뤫
              end if
              if(present(l_typ))then
                 call DclSetLineType( l_typ(i) )
              end if
              call DclDrawLine( xg(:,i), xg(:,i) )
           end do
        end if
     end if
  end if

  if(present(zp))then
     call color_line( 'p', xp, yp, zp, color_num, (/shade_min, shade_max/) )
  else
     if(present(xp))then
        do i=1,size(xp,2)
           if(present(p_idx))then
              call DclSetMarkerIndex( p_idx(i) )  ! , ޤǰ뤫
           end if
           if(present(p_typ))then
              call DclSetMarkerType( p_typ(i) )
           end if
           if(present(p_siz))then
              call DclSetMarkerSize( p_siz(i) )
           end if
           call DclDrawMarker( xp(:,i), yp(:,i) )
        end do
     end if
  end if

  if(present(layer_line))then
     if(layer_line.eqv..true.)then
        do i=1,ny
           call DclDrawLine( x, grid_point(:,i) )
        end do
     end if
  end if

  if(no_tone_flag.eqv..false.)then
     if(present(trigleg))then
        call tone_bar( color_num, (/shade_min, shade_max/),  &
  &                  (/vx_max+0.05, vx_max+0.075/),   &
  &                  (/vy_min, vy_max/), trim(form_types), mono_log=monoto,  &
  &                  trigle=trigleg )
     else
        call tone_bar( color_num, (/shade_min, shade_max/),  &
  &                  (/vx_max+0.05, vx_max+0.075/),   &
  &                  (/vy_min, vy_max/), trim(form_types), mono_log=monoto )
     end if
  end if

end subroutine

!---------------------------------------------------------

subroutine Dcl_2D_cont_shade_calendar( outname,  &
  &  x, y, contour, shade, cont_int, shade_int,  &
  &  axis_title, date, days, form_type, viewx_int, viewy_int, c_num,  &
!  &  viewy_min, viewy_max, color_num, cont_num, nongrid,  &
  &  xg, yg, zg, xp, yp, zp,  &
  &  mono, mono_val, mono_lev, trigleg, no_tone, no_frame,  &
  &  l_idx, l_typ, p_idx, p_typ, p_siz )
  ! 2  2 ѿȥ顼ɤ褹. calender б
  use dcl
  implicit none
  character(*), intent(in) :: outname  ! դΥȥ
  real, intent(in) :: x(:)  ! x γʻɸ
  real, intent(in) :: y(:)  ! y γʻɸ
  real, intent(inout) :: contour(size(x),size(y))  ! 
  real, intent(inout) :: shade(size(x),size(y))  ! 顼ɤ
  real, intent(in) :: cont_int(2)  ! ξ岼ü 
                                 ! [cont_int(1)=cont_min, cont_int(2)=cont_max]
  real, intent(in) :: shade_int(2)  ! ξ岼ü [shade_int(1)=shade_min,
                                 ! shade_int(2)=shade_max]
  character(*), intent(in) :: axis_title(2)  ! ɸΥȥ
                                 ! axis_title(1)=x_title, axis_title(2)=y_title
  type(dcl_date), intent(in) :: date  !  [yyyy:mm:dd]
  integer, intent(in) :: days  !  [day]
  character(*), intent(in) :: form_type(2)  ! եޥå
                           ! form_type(1)=form_typec, form_type(2)=form_types
  real, intent(in), optional :: viewx_int(2)  ! ӥ塼ݡȤ x ξü
                           ! viewx_int(1)=vx_min, vx_int(2)=vx_max
  real, intent(in), optional :: viewy_int(2)  ! ӥ塼ݡȤ y ξü
                           ! viewy_int(1)=vy_min, vy_int(2)=vy_max
  integer, intent(in), optional :: c_num(2)  ! 󥿡ɤο
                           ! c_num(1)=cont_num, c_num(2)=color_num
!  character(2), intent(in), optional :: nongrid  ! ֳֳʻҤˤ뤫.
                                        ! nongrid = 'ox' Ƚ.
                                        ! 1 ʸܤ, 2 ʸܤļ.
                                        ! o = ֳ, x = ֳ.
                                        ! ǥեȤǤ 'xx'.
  real, intent(in), optional :: xg(:,:)  ! x 륰åκɸ
  real, intent(in), optional :: yg(:,:)  ! y 륰åκɸ
                    ! Ǥΰ֥ǡ, ʣ,
                    ! Ǥ 2 İʾˤ.
                    ! ǡľǤϤʤ, åɤ
                    ! Ȥǽ.
                    ! 3 ܤ, xg(:,1)  yg(:,1)  1 ܤ
                    ! ɽ褦˻ꤹ뤳.
  real, intent(in), optional :: zg(:,:)  ! åͤäƤФ.
                    ! Υץ򤵤줿, ưŪѿ shade 
                    ! Ѥ줺, shade ϢѿϤ٤Ƥͤ
                    ! ե󥹤Ȥƥ顼ޤ⡼ɤ˰ܹԤ.
  real, intent(in), optional :: xp(:,:)  ! x ˥ޡ x ɸ
  real, intent(in), optional :: yp(:,:)  ! y ˥ޡ y ɸ
  real, intent(in), optional :: zp(:,:)  ! ޡͤäƤФ.
                                         ! λˡƱ.
                    ! Υץ򤵤줿, ưŪѿ shade 
                    ! Ѥ줺, shade ϢѿϤ٤Ƥͤ
                    ! ե󥹤Ȥƥ顼ޡ⡼ɤ˰ܹԤ.
  logical, intent(in), optional :: mono  ! ΥȡγĴˤ [.true.]
                                         ! ǥեȤ .false.
  real, intent(in), optional :: mono_val(:)  ! Ĵζ.
                    ! mono=.true. ΤȤɬꤷʤȥ顼֤.
                    ! ͤ mono_lev + 1 ʬ¸ߤʤФʤʤ.
  integer, intent(in), optional :: mono_lev(:)  ! ȡޥåֹ. dcl  3 
                    ! mono=.true. ΤȤꤷʤȥ顼֤.
  character(1), intent(in), optional :: trigleg  ! ȡСλѷץ.
                ! ץͤ, tone_bar 롼 trigle Ʊ.
  logical, intent(in), optional :: no_tone  ! ȡСʤץ
                                   ! .false. = . .true. = ʤ.
                                   ! ǥեȤ .false.
  logical, intent(in), optional :: no_frame  ! NewFrame ƤФʤ
                                   ! .false. = Ƥ. .true. = ƤФ NewFig.
                                   ! ǥեȤ .false.
  integer, intent(in), optional :: l_idx(:)  ! xg, yg Υǥå
                                                      ! ǥեȤ 1.
  integer, intent(in), optional :: l_typ(:)  ! xg, yg Υ
                                                      ! ǥեȤ 1.
  integer, intent(in), optional :: p_idx(:)  ! xp, yp ޡΥǥå
  integer, intent(in), optional :: p_typ(:)  ! xp, yp ޡΥ
  real, intent(in), optional :: p_siz(:)  ! xp, yp ޡ礭
!-- ʾ, 
  real :: cont_min  ! Ǿ
  real :: cont_max  ! 
  real :: shade_min  ! ɤǾ
  real :: shade_max  ! ɤ
  character(100) :: x_title  ! x Υȥ
  character(100) :: y_title  ! y Υȥ
  character(10) :: form_typec  ! contour ѤΥեޥå
  character(10) :: form_types  ! shade ѤΥեޥå
  real :: vx_min  ! ӥ塼ݡȤ x κǾ
  real :: vx_max  ! ӥ塼ݡȤ x κ
  real :: vy_min  ! ӥ塼ݡȤ y κǾ
  real :: vy_max  ! ӥ塼ݡȤ y κ
  integer :: cont_num  ! ο
  integer :: color_num  ! 顼ο
!-- ʾ, ֤ѿ
  integer :: i, j, k  ! ź
  integer :: nx, ny
  real :: undef, RMISS
  logical :: monoto, no_tone_flag, no_frame_flag

  nx=size(x)
  ny=size(y)

!-- դͿƤ뤫ɽ
  write(*,*) "start day is", date%year, date%month, date%day

!-- optional ν ---
  if(present(viewx_int))then
     vx_min=viewx_int(1)
     vx_max=viewx_int(2)
  else
     vx_min=0.2
     vx_max=0.8
  end if

  if(present(viewy_int))then
     vy_min=viewy_int(1)
     vy_max=viewy_int(2)
  else
     vy_min=0.2
     vy_max=0.8
  end if

  if(present(c_num))then
     cont_num=c_num(1)
     color_num=c_num(2)
  else
     cont_num=10
     color_num=56
  end if

  if(present(no_tone))then
     no_tone_flag=no_tone
  else
     no_tone_flag=.false.
  end if

  if(present(no_frame))then
     no_frame_flag=no_frame
  else
     no_frame_flag=.false.
  end if

!-- ֤ѿ֤
  cont_min=cont_int(1)
  cont_max=cont_int(2)
  shade_min=shade_int(1)
  shade_max=shade_int(2)
  x_title=trim(axis_title(1))
  y_title=trim(axis_title(2))
  form_typec=trim(form_type(1))
  form_types=trim(form_type(2))

  if(present(mono))then
     if(present(mono_val).and.present(mono_lev))then
        if(size(mono_val)-1==size(mono_lev))then
           monoto=mono
        else
           write(*,*) "*** ERROR ***"
           write(*,*) "[array number] : mono_val = mono_lev + 1"
           write(*,*) "STOP"
           stop
        end if
     else
        write(*,*) "*** ERROR ***"
        write(*,*) "When option MONO is true, MONO_VAL and MONO_LEV must be specified."
        write(*,*) "STOP"
        stop
     end if
  else
     monoto=.false.
  end if

!-- ޤ ---

  call undef_CReSS2Dcl( nx, ny, 1, contour)
  call undef_CReSS2Dcl( nx, ny, 1, shade)

  call UWSGXZ(.FALSE.)
  call UWSGYZ(.FALSE.)

  if(no_frame_flag.eqv..true.)then
     call DclNewFig
  else
     call DclNewFrame
  end if

  call DclSetWindow( 0.0, real(days), y(1), y(ny) )

  if(present(zg))then
     if(size(xg,1)>1)then
        call color_line( 's', xg, yg, zg, color_num,  &
  &                      (/shade_min, shade_max/), subsubidx='l' )
     end if
  else
     if(present(xg))then
        if(size(xg,1)>1)then
           do i=1,size(xg,2)
              call DclScalingPoint( xg(:,i), yg(:,i) )
           end do
        end if
     end if
  end if

  if(present(zp))then
     call color_line( 's', xp, yp, zp, color_num, (/shade_min, shade_max/),  &
  &                   subsubidx='p' )
  else
     if(present(xp))then
        do i=1,size(xp,2)
           call DclScalingPoint( xp(:,i), yp(:,i) )
        end do
     end if
  end if

  call DclSetViewPort( vx_min, vx_max, vy_min, vy_max )
  call DclSetTransFunction

  if(monoto.eqv..true.)then
     call DclSetParm('ENABLE_SOFTFILL',.true.)
     call DclClearShadeLevel
     call DclSetShadeLevel( mono_val, mono_lev )
  else
     call DclSetParm('ENABLE_SOFTFILL',.false.)
!     call DclClearShadeLevel
!     call DclSetShadeLevel( shade_min, shade_max,   &
! &                          (shade_max-shade_min)/s_num )
  end if

!  if(present(nongrid))then
!     if(nongrid(1:1)=='o')then
        call DclSetXGrid( x )
!     end if
!     if(nongrid(2:2)=='o')then
        call DclSetYgrid( y )
!     end if
!  end if

  if(monoto.eqv..true.)then
     call DclShadeContour( shade )
  else
     call DclShadeContourEx( shade )
  end if

  CALL UZLSET( 'LABELYL', .TRUE. )
  CALL UZLSET( 'LABELYR', .FALSE. )
  call DclDrawAxisCalendar( 'bt', date, nd=days )
  call DclDrawScaledAxis( 'lr' )
  call DclDrawTitle( 'l', trim(y_title), 0.0 )
  call DclDrawTitle( 't', trim(outname), 0.0, 2 )

  if(DclGetContourLevelNumber()==0)then
     call DclSetContourLabelFormat(trim(form_typec))
     call DclSetContourLevel( cont_min, cont_max, (cont_max-cont_min)/cont_num )
  end if

  call DclDrawContour( contour )

  if(present(zg))then
     if(size(xg,1)>1)then
        call color_line( 'l', xg, yg, zg, color_num, (/shade_min, shade_max/) )
     end if
  else
     if(present(xg))then
        if(size(xg,1)>1)then
           do i=1,size(xg,2)
              if(present(l_idx))then
                 call DclSetLineIndex( l_idx(i) )  ! , ޤǰ뤫
              end if
              if(present(l_typ))then
                 call DclSetLineType( l_typ(i) )
              end if
              call DclDrawLine( xg(:,i), xg(:,i) )
           end do
        end if
     end if
  end if

  if(present(zp))then
     call color_line( 'p', xp, yp, zp, color_num, (/shade_min, shade_max/) )
  else
     if(present(xp))then
        do i=1,size(xp,2)
           if(present(p_idx))then
              call DclSetMarkerIndex( p_idx(i) )  ! , ޤǰ뤫
           end if
           if(present(p_typ))then
              call DclSetMarkerType( p_typ(i) )
           end if
           if(present(p_siz))then
              call DclSetMarkerSize( p_siz(i) )
           end if
           call DclDrawMarker( xp(:,i), yp(:,i) )
        end do
     end if
  end if

  if(no_tone_flag.eqv..false.)then
     if(present(trigleg))then
        call tone_bar( color_num, (/shade_min, shade_max/),  &
  &                  (/vx_max+0.05, vx_max+0.075/),   &
  &                  (/vy_min, vy_max/), trim(form_types), mono_log=monoto,  &
  &                  trigle=trigleg )
     else
        call tone_bar( color_num, (/shade_min, shade_max/),  &
  &                  (/vx_max+0.05, vx_max+0.075/),   &
  &                  (/vy_min, vy_max/), trim(form_types), mono_log=monoto )
     end if
  end if

end subroutine

!---------------------------------------------------------

subroutine Dcl_2D_cont_shade_vec( outname,  &
  &  x, y, contour, shade, vecx, vecy, vn, cont_int, shade_int,  &
  &  axis_title, form_type, viewx_int, viewy_int, c_num,  &
!  &  viewy_min, viewy_max, color_num, cont_num, nongrid,  &
  &  xg, yg, zg, xp, yp, zp,  &
  &  mono, mono_val, mono_lev, trigleg,  &
  &  unitv, vfact, unit_fact_sign, &
  &  unit_fact, unit_title, unit_posi, no_tone, no_frame,  &
  &  l_idx, l_typ, p_idx, p_typ, p_siz )
  ! 2  3 ѿ, 顼, ٥ȥ褹.
  !  4 ѿƱ褬ǽȤʤ.
  ! Ū˱˥顼СĤΤ, ˥åȥ٥ȥ
  ! 󥿡󥿡Хβʸɽ.
  use dcl
  implicit none
  character(*), intent(in) :: outname  ! դΥȥ
  real, intent(in) :: x(:)  ! x γʻɸ
  real, intent(in) :: y(:)  ! y γʻɸ
  real, intent(inout) :: contour(size(x),size(y))  ! 
  real, intent(inout) :: shade(size(x),size(y))  ! 顼ɤ
  real, intent(inout) :: vecx(size(x),size(y))  ! x Υ٥ȥ
  real, intent(inout) :: vecy(size(x),size(y))  ! x Υ٥ȥ
  integer, intent(in) :: vn(2)  ! ٥ȥʻ (ְ)
                                ! vn(1)=vnx, vn(2)=vny
  real, intent(in) :: cont_int(2)  ! ξ岼ü 
                                 ! [cont_int(1)=cont_min, cont_int(2)=cont_max]
  real, intent(in) :: shade_int(2)  ! ξ岼ü [shade_int(1)=shade_min,
                                 ! shade_int(2)=shade_max]
  character(*), intent(in) :: axis_title(2)  ! ɸΥȥ
                                 ! axis_title(1)=x_title, axis_title(2)=y_title
  character(*), intent(in) :: form_type(2)  ! եޥå
                           ! form_type(1)=form_typec, form_type(2)=form_types
  real, intent(in), optional :: viewx_int(2)  ! ӥ塼ݡȤ x ξü
                           ! viewx_int(1)=vx_min, vx_int(2)=vx_max
  real, intent(in), optional :: viewy_int(2)  ! ӥ塼ݡȤ y ξü
                           ! viewy_int(1)=vy_min, vy_int(2)=vy_max
  integer, intent(in), optional :: c_num(2)  ! 󥿡ɤο
                           ! c_num(1)=cont_num, c_num(2)=color_num
!  character(2), intent(in), optional :: nongrid  ! ֳֳʻҤˤ뤫.
                                        ! nongrid = 'ox' Ƚ.
                                        ! 1 ʸܤ, 2 ʸܤļ.
                                        ! o = ֳ, x = ֳ.
                                        ! ǥեȤǤ 'xx'.
  real, intent(in), optional :: xg(:,:)  ! x 륰åκɸ
  real, intent(in), optional :: yg(:,:)  ! y 륰åκɸ
                    ! Ǥΰ֥ǡ, ʣ,
                    ! Ǥ 2 İʾˤ.
                    ! ǡľǤϤʤ, åɤ
                    ! Ȥǽ.
                    ! 3 ܤ, xg(:,1)  yg(:,1)  1 ܤ
                    ! ɽ褦˻ꤹ뤳.
  real, intent(in), optional :: zg(:,:)  ! åͤäƤФ.
                    ! Υץ򤵤줿, ưŪѿ shade 
                    ! Ѥ줺, shade ϢѿϤ٤Ƥͤ
                    ! ե󥹤Ȥƥ顼ޤ⡼ɤ˰ܹԤ.
  real, intent(in), optional :: xp(:,:)  ! x ˥ޡ x ɸ
  real, intent(in), optional :: yp(:,:)  ! y ˥ޡ y ɸ
  real, intent(in), optional :: zp(:,:)  ! ޡͤäƤФ.
                                         ! λˡƱ.
                    ! Υץ򤵤줿, ưŪѿ shade 
                    ! Ѥ줺, shade ϢѿϤ٤Ƥͤ
                    ! ե󥹤Ȥƥ顼ޡ⡼ɤ˰ܹԤ.
  logical, intent(in), optional :: mono  ! ΥȡγĴˤ [.true.]
                                         ! ǥեȤ .false.
  real, intent(in), optional :: mono_val(:)  ! Ĵζ.
                    ! mono=.true. ΤȤɬꤷʤȥ顼֤.
                    ! ͤ mono_lev + 1 ʬ¸ߤʤФʤʤ.
  integer, intent(in), optional :: mono_lev(:)  ! ȡޥåֹ. dcl  3 
                    ! mono=.true. ΤȤꤷʤȥ顼֤.
  character(1), intent(in), optional :: trigleg  ! ȡСλѷץ.
                ! ץͤ, tone_bar 롼 trigle Ʊ.
  logical, intent(in), optional :: unitv  ! ñ̥٥ȥɤ. default = .true.
  real, intent(in), optional :: vfact(2)  ! x,y Υ󥰥ե
                    ! ͤꤹ, Ū˷ʤΤ, ٥ȥ뤬ʻҰʾ
                    ! Ӥǽ. 
                    ! ꤷʤ, x, y οʿ V ϤΥڥθ
                    ! , vfact Ȱפ褦ˤ.
  logical, intent(in), optional :: unit_fact_sign  ! unitv = .true. ΤȤ,
                    ! .true. = u, v  U ɸϤǤͤ unit_fact Ϳ, 
                    ! unit_fact Ϥͤñ̥٥ȥñ̤Ȥɽ.
                    ! unit  V ɸϤͤ u, v 礭 0.1 Ȥɽ.
  real, intent(in), optional :: unit_fact(2)  ! x,y ñ̥٥ȥ v ɸϤǤĹ
                                              ! default = (0.1,0.1)
  character(*), intent(in), optional :: unit_title(2)  ! x,y ñ̥٥ȥΥȥ
                    ! default = ʤ.
  real, intent(in), optional :: unit_posi(2)  ! ñ̥٥ȥϤ븶ɸ (V )
                    ! default = 顼СκüƱ, ޤαü鳫.
                    ! 顼СϤˤ֤Ĥʤ褦˼ưŪû.
  logical, intent(in), optional :: no_tone  ! ȡСʤץ
                                   ! .false. = . .true. = ʤ.
                                   ! ǥեȤ .false.
  logical, intent(in), optional :: no_frame  ! NewFrame ƤФʤ
                                   ! .false. = Ƥ. .true. = ƤФ NewFig.
                                   ! ǥեȤ .false.
  integer, intent(in), optional :: l_idx(:)  ! xg, yg Υǥå
                                                      ! ǥեȤ 1.
  integer, intent(in), optional :: l_typ(:)  ! xg, yg Υ
                                                      ! ǥեȤ 1.
  integer, intent(in), optional :: p_idx(:)  ! xp, yp ޡΥǥå
  integer, intent(in), optional :: p_typ(:)  ! xp, yp ޡΥ
  real, intent(in), optional :: p_siz(:)  ! xp, yp ޡ礭
!-- ʾ, 
  integer :: vnx  ! x Υ٥ȥʻ (ְ)
  integer :: vny  ! y Υ٥ȥʻ (ְ)
  real :: cont_min  ! Ǿ
  real :: cont_max  ! 
  real :: shade_min  ! ɤǾ
  real :: shade_max  ! ɤ
  character(100) :: x_title  ! x Υȥ
  character(100) :: y_title  ! y Υȥ
  character(10) :: form_typec  ! contour ѤΥեޥå
  character(10) :: form_types  ! shade ѤΥեޥå
  real :: vx_min  ! ӥ塼ݡȤ x κǾ
  real :: vx_max  ! ӥ塼ݡȤ x κ
  real :: vy_min  ! ӥ塼ݡȤ y κǾ
  real :: vy_max  ! ӥ塼ݡȤ y κ
  integer :: cont_num  ! ο
  integer :: color_num  ! 顼ο
!-- ʾ, ֤ѿ
  integer :: i, j, k  ! ź
  integer :: nx, ny
  real :: factx, facty
  real, dimension(size(x),size(y)) :: um, vm  ! ٥ȥְͤ
  real :: vvx_min, vvx_max, vvy_min, vvy_max
  real :: unitvp(2), unitvl(2), unit_auto_fact(2)
  real :: undef, RMISS
  intrinsic :: nint
  logical :: monoto, unitvs, no_tone_flag, no_frame_flag

  nx=size(x)
  ny=size(y)

!-- optional ν ---
  if(present(viewx_int))then
     vx_min=viewx_int(1)
     vx_max=viewx_int(2)
  else
     vx_min=0.2
     vx_max=0.8
  end if

  if(present(viewy_int))then
     vy_min=viewy_int(1)
     vy_max=viewy_int(2)
  else
     vy_min=0.2
     vy_max=0.8
  end if

  if(present(c_num))then
     cont_num=c_num(1)
     color_num=c_num(2)
  else
     cont_num=10
     color_num=56
  end if

  if(present(no_tone))then
     no_tone_flag=no_tone
  else
     no_tone_flag=.false.
  end if

  if(present(no_frame))then
     no_frame_flag=no_frame
  else
     no_frame_flag=.false.
  end if

!-- ֤ѿ֤
  vnx=vn(1)
  vny=vn(2)
  cont_min=cont_int(1)
  cont_max=cont_int(2)
  shade_min=shade_int(1)
  shade_max=shade_int(2)
  x_title=trim(axis_title(1))
  y_title=trim(axis_title(2))
  form_typec=trim(form_type(1))
  form_types=trim(form_type(2))

!-- 顼
  if(nx<vnx.or.ny<vny)then
     write(*,*) "*****ERROR***** : vnx > nx or vny > ny."
     stop
  end if
  if(nx<2.or.vnx<2.or.ny<2.or.vny<2)then
     write(*,*) "*****ERROR***** : nx or ny or vnx or vny is less than 2."
     stop
  end if

!-- ٹ
  if(mod((nx-1),(vnx-1))/=0.and.mod((ny-1),(vny-1))/=0)then
     write(*,*) "****WARNING**** : vnx or vny is not the factor of nx and ny."
  else
     if(mod((nx-1),(vnx-1))/=0.or.mod((ny-1),(vny-1))/=0)then
        if(mod((nx-1),(vnx-1))/=0)then
           write(*,*) "****WARNING**** : vnx is not the factor of nx."
        else
           write(*,*) "****WARNING**** : vny is not the factor of ny."
        end if
     end if
  end if

!-- ٥ȥδְ
  factx=real(nx-1)/real(vnx-1)
  facty=real(ny-1)/real(vny-1)

  um=0.0
  vm=0.0

!--  1 Ϥ
  um(1,1)=vecx(1,1)
  vm(1,1)=vecy(1,1)

  do i=2,vnx
     um(1+nint(factx*(i-1)),1)=vecx(1+nint(factx*(i-1)),1)
     vm(1+nint(factx*(i-1)),1)=vecy(1+nint(factx*(i-1)),1)
  end do

  do j=2,vny
     um(1,1+nint((j-1)*facty))=vecx(1,1+nint((j-1)*facty))
     vm(1,1+nint((j-1)*facty))=vecy(1,1+nint((j-1)*facty))
  end do

  do j=2,vny
     do i=2,vnx
        um(1+nint(factx*(i-1)),1+nint(facty*(j-1)))  &
  &     =vecx(1+nint(factx*(i-1)),1+nint(facty*(j-1)))
        vm(1+nint(factx*(i-1)),1+nint(facty*(j-1)))  &
  &     =vecy(1+nint(factx*(i-1)),1+nint(facty*(j-1)))
     end do
  end do

  if(present(mono))then
     if(present(mono_val).and.present(mono_lev))then
        if(size(mono_val)-1==size(mono_lev))then
           monoto=mono
        else
           write(*,*) "*** ERROR ***"
           write(*,*) "[array number] : mono_val = mono_lev + 1"
           write(*,*) "STOP"
           stop
        end if
     else
        write(*,*) "*** ERROR ***"
        write(*,*) "When option MONO is true, MONO_VAL and MONO_LEV must be specified."
        write(*,*) "STOP"
        stop
     end if
  else
     monoto=.false.
  end if

!-- ޤ ---

  call undef_CReSS2Dcl( nx, ny, 1, contour)
  call undef_CReSS2Dcl( nx, ny, 1, shade)

  call UWSGXZ(.FALSE.)
  call UWSGYZ(.FALSE.)

  if(no_frame_flag.eqv..true.)then
     call DclNewFig
  else
     call DclNewFrame
  end if

  call DclSetWindow( x(1), x(nx), y(1), y(ny) )

  if(present(zg))then
     if(size(xg,1)>1)then
        call color_line( 's', xg, yg, zg, color_num,  &
  &                      (/shade_min, shade_max/), subsubidx='l' )
     end if
  else
     if(present(xg))then
        if(size(xg,1)>1)then
           do i=1,size(xg,2)
              call DclScalingPoint( xg(:,i), yg(:,i) )
           end do
        end if
     end if
  end if

  if(present(zp))then
     call color_line( 's', xp, yp, zp, color_num, (/shade_min, shade_max/),  &
  &                   subsubidx='p' )
  else
     if(present(xp))then
        do i=1,size(xp,2)
           call DclScalingPoint( xp(:,i), yp(:,i) )
        end do
     end if
  end if

!-- ٥ȥ륹ˤĤƤ
  if(present(unit_fact_sign))then
     if(unit_fact_sign.eqv..true.)then
        if(present(unit_fact))then
           unit_auto_fact(1)=unit_fact(1)
           unit_auto_fact(2)=unit_fact(2)
        else
           write(*,*) "### ERROR ### : unit_fact_sign is .true. then,"
           write(*,*) "                unit_fact must configure."
           write(*,*) "STOP."
           stop
        end if
     else
        unit_auto_fact(1)=1.0
        unit_auto_fact(2)=1.0
     end if
  else
     unit_auto_fact(1)=1.0
     unit_auto_fact(2)=1.0
  end if

  if(present(vfact))then
     call DclSetParm( 'VECTOR:LNRMAL', .false. )
     call DclSetParm( 'VECTOR:XFACT1', vfact(1) )
     call DclSetParm( 'VECTOR:YFACT1', vfact(2) )
     unit_auto_fact(1)=unit_auto_fact(1)*vfact(1)
     unit_auto_fact(2)=unit_auto_fact(2)*vfact(2)
  else
     call DclSetParm( 'VECTOR:LNRMAL', .true.)
     call DclSetParm( 'VECTOR:XFACT1', unitvl(1) )
     call DclSetParm( 'VECTOR:YFACT1', unitvl(2) )
     unit_auto_fact(1)=unit_auto_fact(1)*unitvl(1)
     unit_auto_fact(2)=unit_auto_fact(2)*unitvl(2)
     unitvl=0.0
  end if

!-- ˥åȥ٥ȥˤĤƤ
  if(present(unitv))then
     unitvs=unitv
  else
     unitvs=.true.
  end if

  if(unitvs.eqv..true.)then

     call DclSetParm( 'VECTOR:LUNIT', unitvs )

     !-- ñ̥٥ȥĹ
     if(present(unit_fact))then
        if(present(unit_fact_sign))then
           if(unit_fact_sign.eqv..true.)then
              unitvl(:)=unit_auto_fact(:)
           else
              unitvl(:)=unit_fact(:)
           end if
        else
           unitvl(:)=unit_fact(:)
        end if
     else
        unitvl=(/0.1, 0.1/)
     end if

     !-- ñ̥٥ȥν񤭻Ϥΰ
     if(present(unit_posi))then
        vvx_min=unit_posi(1)
        vvy_min=unit_posi(2)
     else
        vvx_min=vx_max+0.05
        vvy_min=vy_min
     end if

     vvy_max=vvy_min+unitvl(2)+0.05

     call DclSetParm( 'VECTOR:VXUNIT', unitvl(1) )
     call DclSetParm( 'VECTOR:VYUNIT', unitvl(2) )
     call DclSetParm( 'VECTOR:VXULOC', vvx_min )
     call DclSetParm( 'VECTOR:VYULOC', vvy_min )

     !-- ȥ񤯤ɤ
     if(present(unit_title))then
        call DclSetUnitVectorTitle( 'X', trim(unit_title(1)) )
        call DclSetUnitVectorTitle( 'Y', trim(unit_title(2)) )
        call DclSetParm( 'VECTOR:LUMSG', .false. )
     else  ! ȥ񤫤ʤʤ, դβ˥󥰥ե
        call DclSetParm( 'VECTOR:LUMSG', .true. )
     end if

  else
     call DclSetParm( 'VECTOR:LUNIT', unitvs )
     vvx_min=0.0
     vvx_max=0.0
     vvy_min=0.0
     vvy_max=vy_min
  end if

  call DclSetViewPort( vx_min, vx_max, vy_min, vy_max )
  call DclSetTransFunction

  if(monoto.eqv..true.)then
     call DclSetParm('ENABLE_SOFTFILL',.true.)
     call DclClearShadeLevel
     call DclSetShadeLevel( mono_val, mono_lev )
  else
     call DclSetParm('ENABLE_SOFTFILL',.false.)
!     call DclClearShadeLevel
!     call DclSetShadeLevel( shade_min, shade_max,   &
! &                          (shade_max-shade_min)/s_num )
  end if

!  if(present(nongrid))then
!     if(nongrid(1:1)=='o')then
        call DclSetXGrid( x )
!     end if
!     if(nongrid(2:2)=='o')then
        call DclSetYgrid( y )
!     end if
!  end if

  if(monoto.eqv..true.)then
     call DclShadeContour( shade )
  else
     call DclShadeContourEx( shade )
  end if

  CALL UZLSET( 'LABELYL', .TRUE. )
  CALL UZLSET( 'LABELYR', .FALSE. )
  call DclDrawScaledAxis
  call DclDrawTitle( 'b', trim(x_title), 0.0 )
  call DclDrawTitle( 'l', trim(y_title), 0.0 )
  call DclDrawTitle( 't', trim(outname), 0.0, 2 )

  if(DclGetContourLevelNumber()==0)then
     call DclSetContourLabelFormat(trim(form_typec))
     call DclSetContourLevel( cont_min, cont_max, (cont_max-cont_min)/cont_num )
  end if

  call DclDrawContour( contour )

  call DclDrawVectors( um, vm )

  if(present(zg))then
     if(size(xg,1)>1)then
        call color_line( 'l', xg, yg, zg, color_num, (/shade_min, shade_max/) )
     end if
  else
     if(present(xg))then
        if(size(xg,1)>1)then
           do i=1,size(xg,2)
              if(present(l_idx))then
                 call DclSetLineIndex( l_idx(i) )  ! , ޤǰ뤫
              end if
              if(present(l_typ))then
                 call DclSetLineType( l_typ(i) )
              end if
              call DclDrawLine( xg(:,i), xg(:,i) )
           end do
        end if
     end if
  end if

  if(present(zp))then
     call color_line( 'p', xp, yp, zp, color_num, (/shade_min, shade_max/) )
  else
     if(present(xp))then
        do i=1,size(xp,2)
           if(present(p_idx))then
              call DclSetMarkerIndex( p_idx(i) )  ! , ޤǰ뤫
           end if
           if(present(p_typ))then
              call DclSetMarkerType( p_typ(i) )
           end if
           if(present(p_siz))then
              call DclSetMarkerSize( p_siz(i) )
           end if
           call DclDrawMarker( xp(:,i), yp(:,i) )
        end do
     end if
  end if

  if(no_tone_flag.eqv..false.)then
     if(present(trigleg))then
!-- ñ̥٥ȥɽͤ, vvy_max ȡСβü
        call tone_bar( color_num, (/shade_min, shade_max/),  &
  &                  (/vx_max+0.05, vx_max+0.075/),   &
  &                  (/vvy_max, vy_max/), trim(form_types), mono_log=monoto,  &
  &                  trigle=trigleg )
     else
        call tone_bar( color_num, (/shade_min, shade_max/),  &
  &                  (/vx_max+0.05, vx_max+0.075/),   &
  &                  (/vvy_max, vy_max/), trim(form_types), mono_log=monoto )
     end if
  end if

end subroutine

!---------------------------------------------------------

subroutine Dcl_2D_cont_shade_vec_calendar( outname,  &
  &  x, y, contour, shade, vecx, vecy, vn, cont_int, shade_int,  &
  &  axis_title, date, days, form_type, viewx_int, viewy_int, c_num,  &
!  &  viewy_min, viewy_max, color_num, cont_num, nongrid,  &
!  &  xg, yg, mono, mono_val, mono_lev, trigleg, no_tone, no_frame )
  &  xg, yg, zg, xp, yp, zp,  &
  &  mono, mono_val, mono_lev, trigleg, unitv, vfact, unit_fact_sign, &
  &  unit_fact, unit_title, unit_posi, no_tone, no_frame,  &
  &  l_idx, l_typ, p_idx, p_typ, p_siz )
  ! 2  3 ѿ, 顼, ٥ȥ褹.
  !  4 ѿƱ褬ǽȤʤ.
  ! Ū˱˥顼СĤΤ, ˥åȥ٥ȥ
  ! 󥿡󥿡Хβʸɽ.
  use dcl
  implicit none
  character(*), intent(in) :: outname  ! դΥȥ
  real, intent(in) :: x(:)  ! x γʻɸ
  real, intent(in) :: y(:)  ! y γʻɸ
  real, intent(inout) :: contour(size(x),size(y))  ! 
  real, intent(inout) :: shade(size(x),size(y))  ! 顼ɤ
  real, intent(inout) :: vecx(size(x),size(y))  ! x Υ٥ȥ
  real, intent(inout) :: vecy(size(x),size(y))  ! x Υ٥ȥ
  integer, intent(in) :: vn(2)  ! ٥ȥʻ (ְ)
                                ! vn(1)=vnx, vn(2)=vny
  real, intent(in) :: cont_int(2)  ! ξ岼ü 
                                 ! [cont_int(1)=cont_min, cont_int(2)=cont_max]
  real, intent(in) :: shade_int(2)  ! ξ岼ü [shade_int(1)=shade_min,
                                 ! shade_int(2)=shade_max]
  character(*), intent(in) :: axis_title(2)  ! ɸΥȥ
                                 ! axis_title(1)=x_title, axis_title(2)=y_title
  type(dcl_date), intent(in) :: date  !  [yyyy:mm:dd]
  integer, intent(in) :: days  !  [day]
  character(*), intent(in) :: form_type(2)  ! եޥå
                           ! form_type(1)=form_typec, form_type(2)=form_types
  real, intent(in), optional :: viewx_int(2)  ! ӥ塼ݡȤ x ξü
                           ! viewx_int(1)=vx_min, vx_int(2)=vx_max
  real, intent(in), optional :: viewy_int(2)  ! ӥ塼ݡȤ y ξü
                           ! viewy_int(1)=vy_min, vy_int(2)=vy_max
  integer, intent(in), optional :: c_num(2)  ! 󥿡ɤο
                           ! c_num(1)=cont_num, c_num(2)=color_num
!  character(2), intent(in), optional :: nongrid  ! ֳֳʻҤˤ뤫.
                                        ! nongrid = 'ox' Ƚ.
                                        ! 1 ʸܤ, 2 ʸܤļ.
                                        ! o = ֳ, x = ֳ.
                                        ! ǥեȤǤ 'xx'.
  real, intent(in), optional :: xg(:,:)  ! x 륰åκɸ
  real, intent(in), optional :: yg(:,:)  ! y 륰åκɸ
                    ! Ǥΰ֥ǡ, ʣ,
                    ! Ǥ 2 İʾˤ.
                    ! ǡľǤϤʤ, åɤ
                    ! Ȥǽ.
                    ! 3 ܤ, xg(:,1)  yg(:,1)  1 ܤ
                    ! ɽ褦˻ꤹ뤳.
  real, intent(in), optional :: zg(:,:)  ! åͤäƤФ.
                    ! Υץ򤵤줿, ưŪѿ shade 
                    ! Ѥ줺, shade ϢѿϤ٤Ƥͤ
                    ! ե󥹤Ȥƥ顼ޤ⡼ɤ˰ܹԤ.
  real, intent(in), optional :: xp(:,:)  ! x ˥ޡ x ɸ
  real, intent(in), optional :: yp(:,:)  ! y ˥ޡ y ɸ
  real, intent(in), optional :: zp(:,:)  ! ޡͤäƤФ.
                                         ! λˡƱ.
                    ! Υץ򤵤줿, ưŪѿ shade 
                    ! Ѥ줺, shade ϢѿϤ٤Ƥͤ
                    ! ե󥹤Ȥƥ顼ޡ⡼ɤ˰ܹԤ.
  logical, intent(in), optional :: mono  ! ΥȡγĴˤ [.true.]
                                         ! ǥեȤ .false.
  real, intent(in), optional :: mono_val(:)  ! Ĵζ.
                    ! mono=.true. ΤȤɬꤷʤȥ顼֤.
                    ! ͤ mono_lev + 1 ʬ¸ߤʤФʤʤ.
  integer, intent(in), optional :: mono_lev(:)  ! ȡޥåֹ. dcl  3 
                    ! mono=.true. ΤȤꤷʤȥ顼֤.
  character(1), intent(in), optional :: trigleg  ! ȡСλѷץ.
                ! ץͤ, tone_bar 롼 trigle Ʊ.
  logical, intent(in), optional :: unitv  ! ñ̥٥ȥɤ. default = .true.
  real, intent(in), optional :: vfact(2)  ! x,y Υ󥰥ե
                    ! ͤꤹ, Ū˷ʤΤ, ٥ȥ뤬ʻҰʾ
                    ! Ӥǽ. 
                    ! ꤷʤ, x, y οʿ V ϤΥڥθ
                    ! , vfact Ȱפ褦ˤ.
  logical, intent(in), optional :: unit_fact_sign  ! unitv = .true. ΤȤ,
                    ! .true. = u, v  U ɸϤǤͤ unit_fact Ϳ, 
                    ! unit_fact Ϥͤñ̥٥ȥñ̤Ȥɽ.
                    ! unit  V ɸϤͤ u, v 礭 0.1 Ȥɽ.
  real, intent(in), optional :: unit_fact(2)  ! x,y ñ̥٥ȥ v ɸϤǤĹ
                                              ! default = (0.1,0.1)
  character(*), intent(in), optional :: unit_title(2)  ! x,y ñ̥٥ȥΥȥ
                    ! default = ʤ.
  real, intent(in), optional :: unit_posi(2)  ! ñ̥٥ȥϤ븶ɸ (V )
                    ! default = 顼СκüƱ, ޤαü鳫.
                    ! 顼СϤˤ֤Ĥʤ褦˼ưŪû.
  logical, intent(in), optional :: no_tone  ! ȡСʤץ
                                   ! .false. = . .true. = ʤ.
                                   ! ǥեȤ .false.
  logical, intent(in), optional :: no_frame  ! NewFrame ƤФʤ
                                   ! .false. = Ƥ. .true. = ƤФ NewFig.
                                   ! ǥեȤ .false.
  integer, intent(in), optional :: l_idx(:)  ! xg, yg Υǥå
                                                      ! ǥեȤ 1.
  integer, intent(in), optional :: l_typ(:)  ! xg, yg Υ
                                                      ! ǥեȤ 1.
  integer, intent(in), optional :: p_idx(:)  ! xp, yp ޡΥǥå
  integer, intent(in), optional :: p_typ(:)  ! xp, yp ޡΥ
  real, intent(in), optional :: p_siz(:)  ! xp, yp ޡ礭
!-- ʾ, 
  integer :: vnx  ! x Υ٥ȥʻ (ְ)
  integer :: vny  ! y Υ٥ȥʻ (ְ)
  real :: cont_min  ! Ǿ
  real :: cont_max  ! 
  real :: shade_min  ! ɤǾ
  real :: shade_max  ! ɤ
  character(100) :: x_title  ! x Υȥ
  character(100) :: y_title  ! y Υȥ
  character(10) :: form_typec  ! contour ѤΥեޥå
  character(10) :: form_types  ! shade ѤΥեޥå
  real :: vx_min  ! ӥ塼ݡȤ x κǾ
  real :: vx_max  ! ӥ塼ݡȤ x κ
  real :: vy_min  ! ӥ塼ݡȤ y κǾ
  real :: vy_max  ! ӥ塼ݡȤ y κ
  integer :: cont_num  ! ο
  integer :: color_num  ! 顼ο
!-- ʾ, ֤ѿ
  integer :: i, j, k  ! ź
  integer :: nx, ny
  real :: factx, facty
  real, dimension(size(x),size(y)) :: um, vm  ! ٥ȥְͤ
  real :: vvx_min, vvx_max, vvy_min, vvy_max
  real :: unitvp(2), unitvl(2), unit_auto_fact(2)
  real :: undef, RMISS
  intrinsic :: nint
  logical :: monoto, unitvs, no_tone_flag, no_frame_flag

  nx=size(x)
  ny=size(y)

 !-- դͿƤ뤫ɽ
  write(*,*) "start day is", date%year, date%month, date%day

!-- optional ν ---
  if(present(viewx_int))then
     vx_min=viewx_int(1)
     vx_max=viewx_int(2)
  else
     vx_min=0.2
     vx_max=0.8
  end if

  if(present(viewy_int))then
     vy_min=viewy_int(1)
     vy_max=viewy_int(2)
  else
     vy_min=0.2
     vy_max=0.8
  end if

  if(present(c_num))then
     cont_num=c_num(1)
     color_num=c_num(2)
  else
     cont_num=10
     color_num=56
  end if

  if(present(no_tone))then
     no_tone_flag=no_tone
  else
     no_tone_flag=.false.
  end if

  if(present(no_frame))then
     no_frame_flag=no_frame
  else
     no_frame_flag=.false.
  end if

!-- ֤ѿ֤
  vnx=vn(1)
  vny=vn(2)
  cont_min=cont_int(1)
  cont_max=cont_int(2)
  shade_min=shade_int(1)
  shade_max=shade_int(2)
  x_title=trim(axis_title(1))
  y_title=trim(axis_title(2))
  form_typec=trim(form_type(1))
  form_types=trim(form_type(2))

!-- 顼
  if(nx<vnx.or.ny<vny)then
     write(*,*) "*****ERROR***** : vnx > nx or vny > ny."
     stop
  end if
  if(nx<2.or.vnx<2.or.ny<2.or.vny<2)then
     write(*,*) "*****ERROR***** : nx or ny or vnx or vny is less than 2."
     stop
  end if

!-- ٹ
  if(mod((nx-1),(vnx-1))/=0.and.mod((ny-1),(vny-1))/=0)then
     write(*,*) "****WARNING**** : vnx or vny is not the factor of nx and ny."
  else
     if(mod((nx-1),(vnx-1))/=0.or.mod((ny-1),(vny-1))/=0)then
        if(mod((nx-1),(vnx-1))/=0)then
           write(*,*) "****WARNING**** : vnx is not the factor of nx."
        else
           write(*,*) "****WARNING**** : vny is not the factor of ny."
        end if
     end if
  end if

!-- ٥ȥδְ
  factx=real(nx-1)/real(vnx-1)
  facty=real(ny-1)/real(vny-1)

  um=0.0
  vm=0.0

!--  1 Ϥ
  um(1,1)=vecx(1,1)
  vm(1,1)=vecy(1,1)

  do i=2,vnx
     um(1+nint(factx*(i-1)),1)=vecx(1+nint(factx*(i-1)),1)
     vm(1+nint(factx*(i-1)),1)=vecy(1+nint(factx*(i-1)),1)
  end do

  do j=2,vny
     um(1,1+nint((j-1)*facty))=vecx(1,1+nint((j-1)*facty))
     vm(1,1+nint((j-1)*facty))=vecy(1,1+nint((j-1)*facty))
  end do

  do j=2,vny
     do i=2,vnx
        um(1+nint(factx*(i-1)),1+nint(facty*(j-1)))  &
  &     =vecx(1+nint(factx*(i-1)),1+nint(facty*(j-1)))
        vm(1+nint(factx*(i-1)),1+nint(facty*(j-1)))  &
  &     =vecy(1+nint(factx*(i-1)),1+nint(facty*(j-1)))
     end do
  end do

  if(present(mono))then
     if(present(mono_val).and.present(mono_lev))then
        if(size(mono_val)-1==size(mono_lev))then
           monoto=mono
        else
           write(*,*) "*** ERROR ***"
           write(*,*) "[array number] : mono_val = mono_lev + 1"
           write(*,*) "STOP"
           stop
        end if
     else
        write(*,*) "*** ERROR ***"
        write(*,*) "When option MONO is true, MONO_VAL and MONO_LEV must be specified."
        write(*,*) "STOP"
        stop
     end if
  else
     monoto=.false.
  end if

!-- ޤ ---

  call undef_CReSS2Dcl( nx, ny, 1, contour)
  call undef_CReSS2Dcl( nx, ny, 1, shade)

  call UWSGXZ(.FALSE.)
  call UWSGYZ(.FALSE.)

  if(no_frame_flag.eqv..true.)then
     call DclNewFig
  else
     call DclNewFrame
  end if

  call DclSetWindow( 0.0, real(days), y(1), y(ny) )

  if(present(zg))then
     if(size(xg,1)>1)then
        call color_line( 's', xg, yg, zg, color_num,  &
  &                      (/shade_min, shade_max/), subsubidx='l' )
     end if
  else
     if(present(xg))then
        if(size(xg,1)>1)then
           do i=1,size(xg,2)
              call DclScalingPoint( xg(:,i), yg(:,i) )
           end do
        end if
     end if
  end if

  if(present(zp))then
     call color_line( 's', xp, yp, zp, color_num, (/shade_min, shade_max/),  &
  &                   subsubidx='p' )
  else
     if(present(xp))then
        do i=1,size(xp,2)
           call DclScalingPoint( xp(:,i), yp(:,i) )
        end do
     end if
  end if

!-- ٥ȥ륹ˤĤƤ
  if(present(unit_fact_sign))then
     if(unit_fact_sign.eqv..true.)then
        if(present(unit_fact))then
           unit_auto_fact(1)=unit_fact(1)
           unit_auto_fact(2)=unit_fact(2)
        else
           write(*,*) "### ERROR ### : unit_fact_sign is .true. then,"
           write(*,*) "                unit_fact must configure."
           write(*,*) "STOP."
           stop
        end if
     else
        unit_auto_fact(1)=1.0
        unit_auto_fact(2)=1.0
     end if
  else
     unit_auto_fact(1)=1.0
     unit_auto_fact(2)=1.0
  end if

  if(present(vfact))then
     call DclSetParm( 'VECTOR:LNRMAL', .false. )
     call DclSetParm( 'VECTOR:XFACT1', vfact(1) )
     call DclSetParm( 'VECTOR:YFACT1', vfact(2) )
     unit_auto_fact(1)=unit_auto_fact(1)*vfact(1)
     unit_auto_fact(2)=unit_auto_fact(2)*vfact(2)
  else
     call DclSetParm( 'VECTOR:LNRMAL', .true.)
     call DclSetParm( 'VECTOR:XFACT1', unitvl(1) )
     call DclSetParm( 'VECTOR:YFACT1', unitvl(2) )
     unit_auto_fact(1)=unit_auto_fact(1)*unitvl(1)
     unit_auto_fact(2)=unit_auto_fact(2)*unitvl(2)
     unitvl=0.0
  end if

!-- ˥åȥ٥ȥˤĤƤ
  if(present(unitv))then
     unitvs=unitv
  else
     unitvs=.true.
  end if

  if(unitvs.eqv..true.)then

     call DclSetParm( 'VECTOR:LUNIT', unitvs )

     !-- ñ̥٥ȥĹ
     if(present(unit_fact))then
        if(present(unit_fact_sign))then
           if(unit_fact_sign.eqv..true.)then
              unitvl(:)=unit_auto_fact(:)
           else
              unitvl(:)=unit_fact(:)
           end if
        else
           unitvl(:)=unit_fact(:)
        end if
     else
        unitvl=(/0.1, 0.1/)
     end if

     !-- ñ̥٥ȥν񤭻Ϥΰ
     if(present(unit_posi))then
        vvx_min=unit_posi(1)
        vvy_min=unit_posi(2)
     else
        vvx_min=vx_max+0.05
        vvy_min=vy_min
     end if

     vvy_max=vvy_min+unitvl(2)+0.05

     call DclSetParm( 'VECTOR:VXUNIT', unitvl(1) )
!     call DclSetParm( 'VECTOR:VYUNIT', unitvl(2) )
     call DclSetParm( 'VECTOR:VYUNIT', 0.0 )  ! y ˤϽ񤫤ʤ
     call DclSetParm( 'VECTOR:VXULOC', vvx_min )
     call DclSetParm( 'VECTOR:VYULOC', vvy_min )

     !-- ȥ񤯤ɤ
     if(present(unit_title))then
        call DclSetUnitVectorTitle( 'X', trim(unit_title(1)) )
!        call DclSetUnitVectorTitle( 'Y', trim(unit_title(2)) )
        call DclSetParm( 'VECTOR:LUMSG', .false. )
     else  ! ȥ񤫤ʤʤ, դβ˥󥰥ե
        call DclSetParm( 'VECTOR:LUMSG', .true. )
     end if

  else
     call DclSetParm( 'VECTOR:LUNIT', unitvs )
     vvx_min=0.0
     vvx_max=0.0
     vvy_min=0.0
     vvy_max=vy_min
  end if

  call DclSetViewPort( vx_min, vx_max, vy_min, vy_max )
  call DclSetTransFunction

  if(monoto.eqv..true.)then
     call DclSetParm('ENABLE_SOFTFILL',.true.)
     call DclClearShadeLevel
     call DclSetShadeLevel( mono_val, mono_lev )
  else
     call DclSetParm('ENABLE_SOFTFILL',.false.)
!     call DclClearShadeLevel
!     call DclSetShadeLevel( shade_min, shade_max,   &
! &                          (shade_max-shade_min)/s_num )
  end if

!  if(present(nongrid))then
!     if(nongrid(1:1)=='o')then
        call DclSetXGrid( x )
!     end if
!     if(nongrid(2:2)=='o')then
        call DclSetYgrid( y )
!     end if
!  end if

  if(monoto.eqv..true.)then
     call DclShadeContour( shade )
  else
     call DclShadeContourEx( shade )
  end if

  CALL UZLSET( 'LABELYL', .TRUE. )
  CALL UZLSET( 'LABELYR', .FALSE. )
  call DclDrawAxisCalendar( 'bt', date, nd=days )
  call DclDrawScaledAxis( 'lr' )
  call DclDrawTitle( 'l', trim(y_title), 0.0 )
  call DclDrawTitle( 't', trim(outname), 0.0, 2 )

  if(DclGetContourLevelNumber()==0)then
     call DclSetContourLabelFormat(trim(form_typec))
     call DclSetContourLevel( cont_min, cont_max, (cont_max-cont_min)/cont_num )
  end if

  call DclDrawContour( contour )

  call DclDrawVectors( um, vm )

  if(present(zg))then
     if(size(xg,1)>1)then
        call color_line( 'l', xg, yg, zg, color_num, (/shade_min, shade_max/) )
     end if
  else
     if(present(xg))then
        if(size(xg,1)>1)then
           do i=1,size(xg,2)
              if(present(l_idx))then
                 call DclSetLineIndex( l_idx(i) )  ! , ޤǰ뤫
              end if
              if(present(l_typ))then
                 call DclSetLineType( l_typ(i) )
              end if
              call DclDrawLine( xg(:,i), xg(:,i) )
           end do
        end if
     end if
  end if

  if(present(zp))then
     call color_line( 'p', xp, yp, zp, color_num, (/shade_min, shade_max/) )
  else
     if(present(xp))then
        do i=1,size(xp,2)
           if(present(p_idx))then
              call DclSetMarkerIndex( p_idx(i) )  ! , ޤǰ뤫
           end if
           if(present(p_typ))then
              call DclSetMarkerType( p_typ(i) )
           end if
           if(present(p_siz))then
              call DclSetMarkerSize( p_siz(i) )
           end if
           call DclDrawMarker( xp(:,i), yp(:,i) )
        end do
     end if
  end if

  if(no_tone_flag.eqv..false.)then
     if(present(trigleg))then
        call tone_bar( color_num, (/shade_min, shade_max/),  &
  &                  (/vx_max+0.05, vx_max+0.075/),   &
  &                  (/vy_min+0.05, vy_max/), trim(form_types), mono_log=monoto,  &
  &                  trigle=trigleg )
     else
        call tone_bar( color_num, (/shade_min, shade_max/),  &
  &                  (/vx_max+0.05, vx_max+0.075/),   &
  &                  (/vy_min+0.05, vy_max/), trim(form_types), mono_log=monoto )
     end if
  end if

end subroutine

!---------------------------------------------------------

subroutine Dcl_2D_cont_shade_polar( outname,  &
  &  x, y, contour, shade, cont_int, shade_int,  &
  &  axis_title, form_type, viewx_int, viewy_int, c_num,  &
!  &  viewy_min, viewy_max, color_num, cont_num, nongrid,  &
  &  xg, yg, rg, tg, xp, yp, rp, tp,  &
  &  mono, mono_val, mono_lev, trigleg, no_tone, no_frame,  &
  &  l_idx, l_typ, r_idx, r_typ, p_idx, p_typ, p_siz,  &
  &  rp_idx, rp_typ, rp_siz )
  ! 2  2 ѿȥ顼ɤ褹.
  use dcl
  implicit none
  character(*), intent(in) :: outname  ! դΥȥ
  real, intent(in) :: x(:)  ! ưγʻɸ
  real, intent(in) :: y(:)  ! Ʊ̳γʻɸ [degree]
  real, intent(inout) :: contour(size(x),size(y))  ! 
  real, intent(inout) :: shade(size(x),size(y))  ! 顼ɤ
  real, intent(in) :: cont_int(2)  ! ξ岼ü 
                                 ! [cont_int(1)=cont_min, cont_int(2)=cont_max]
  real, intent(in) :: shade_int(2)  ! ξ岼ü [shade_int(1)=shade_min,
                                 ! shade_int(2)=shade_max]
  character(*), intent(in) :: axis_title(2)  ! ɸΥȥ
                                 ! axis_title(1)=x_title, axis_title(2)=y_title
  character(*), intent(in) :: form_type(2)  ! եޥå
                           ! form_type(1)=form_typec, form_type(2)=form_types
  real, intent(in), optional :: viewx_int(2)  ! ӥ塼ݡȤ x ξü
                           ! viewx_int(1)=vx_min, vx_int(2)=vx_max
  real, intent(in), optional :: viewy_int(2)  ! ӥ塼ݡȤ y ξü
                           ! viewy_int(1)=vy_min, vy_int(2)=vy_max
  integer, intent(in), optional :: c_num(2)  ! 󥿡ɤο
                           ! c_num(1)=cont_num, c_num(2)=color_num
!  character(2), intent(in), optional :: nongrid  ! ֳֳʻҤˤ뤫.
                                        ! nongrid = 'ox' Ƚ.
                                        ! 1 ʸܤ, 2 ʸܤļ.
                                        ! o = ֳ, x = ֳ.
                                        ! ǥեȤǤ 'xx'.
  real, intent(in), optional :: xg(:,:)  ! x 륰åκɸ
  real, intent(in), optional :: yg(:,:)  ! y 륰åκɸ
                    ! Ǥΰ֥ǡ, ʣ,
                    ! Ǥ 2 İʾˤ.
                    ! ǡľǤϤʤ, åɤ
                    ! Ȥǽ.
                    ! 3 ܤ, xg(:,1)  yg(:,1)  1 ܤ
                    ! ɽ褦˻ꤹ뤳.
  real, intent(in), optional :: rg(:,:)  ! ˺ɸϤˤ r 륰åκɸ
  real, intent(in), optional :: tg(:,:)  ! ˺ɸϤˤ theta 륰åκɸ
                    ! ΥǡͿ xg, yg Ʊ.
  real, intent(in), optional :: xp(:,:)  ! x ˥ޡ x ɸ
  real, intent(in), optional :: yp(:,:)  ! y ˥ޡ y ɸ
  real, intent(in), optional :: rp(:,:)  ! r ˥ޡ r ɸ
  real, intent(in), optional :: tp(:,:)  ! t ˥ޡ t ɸ
  logical, intent(in), optional :: mono  ! ΥȡγĴˤ [.true.]
                                         ! ǥեȤ .false.
  real, intent(in), optional :: mono_val(:)  ! Ĵζ.
                    ! mono=.true. ΤȤɬꤷʤȥ顼֤.
                    ! ͤ mono_lev + 1 ʬ¸ߤʤФʤʤ.
  integer, intent(in), optional :: mono_lev(:)  ! ȡޥåֹ. dcl  3 
                    ! mono=.true. ΤȤꤷʤȥ顼֤.
  character(1), intent(in), optional :: trigleg  ! ȡСλѷץ.
                ! ץͤ, tone_bar 롼 trigle Ʊ.
  logical, intent(in), optional :: no_tone  ! ȡСʤץ
                                   ! .false. = . .true. = ʤ.
                                   ! ǥեȤ .false.
  logical, intent(in), optional :: no_frame  ! NewFrame ƤФʤ
                                   ! .false. = Ƥ. .true. = ƤФ NewFig.
                                   ! ǥեȤ .false.
  integer, intent(in), optional :: l_idx(:)  ! xg, yg Υǥå
                                                      ! ǥեȤ 1.
  integer, intent(in), optional :: l_typ(:)  ! xg, yg Υ
                                                      ! ǥեȤ 1.
  integer, intent(in), optional :: r_idx(:)  ! rg, tg Υǥå
                                                      ! ǥեȤ 1.
  integer, intent(in), optional :: r_typ(:)  ! rg, tg Υ
                                                      ! ǥեȤ 1.
  integer, intent(in), optional :: p_idx(:)  ! xp, yp ޡΥǥå
  integer, intent(in), optional :: p_typ(:)  ! xp, yp ޡΥ
  real, intent(in), optional :: p_siz(:)  ! xp, yp ޡ礭
  integer, intent(in), optional :: rp_idx(:)  ! rp, tp ޡΥǥå
  integer, intent(in), optional :: rp_typ(:)  ! rp, tp ޡΥ
  real, intent(in), optional :: rp_siz(:)  ! rp, tp ޡ礭
!-- ʾ, 
  real :: cont_min  ! Ǿ
  real :: cont_max  ! 
  real :: shade_min  ! ɤǾ
  real :: shade_max  ! ɤ
  character(100) :: x_title  ! x Υȥ
  character(100) :: y_title  ! y Υȥ
  character(10) :: form_typec  ! contour ѤΥեޥå
  character(10) :: form_types  ! shade ѤΥեޥå
  real :: vx_min  ! ӥ塼ݡȤ x κǾ
  real :: vx_max  ! ӥ塼ݡȤ x κ
  real :: vy_min  ! ӥ塼ݡȤ y κǾ
  real :: vy_max  ! ӥ塼ݡȤ y κ
  integer :: cont_num  ! ο
  integer :: color_num  ! 顼ο
!-- ʾ, ֤ѿ
  integer :: i, j, k  ! ź
  integer :: nx, ny
  real :: undef, RMISS
  logical :: monoto, no_tone_flag, no_frame_flag

  nx=size(x)
  ny=size(y)

!-- optional ν ---
  if(present(viewx_int))then
     vx_min=viewx_int(1)
     vx_max=viewx_int(2)
  else
     vx_min=0.2
     vx_max=0.8
  end if

  if(present(viewy_int))then
     vy_min=viewy_int(1)
     vy_max=viewy_int(2)
  else
     vy_min=0.2
     vy_max=0.8
  end if

  if(present(c_num))then
     cont_num=c_num(1)
     color_num=c_num(2)
  else
     cont_num=10
     color_num=56
  end if

  if(present(no_tone))then
     no_tone_flag=no_tone
  else
     no_tone_flag=.false.
  end if

  if(present(no_frame))then
     no_frame_flag=no_frame
  else
     no_frame_flag=.false.
  end if

!-- ֤ѿ֤
  cont_min=cont_int(1)
  cont_max=cont_int(2)
  shade_min=shade_int(1)
  shade_max=shade_int(2)
  x_title=trim(axis_title(1))
  y_title=trim(axis_title(2))
  form_typec=trim(form_type(1))
  form_types=trim(form_type(2))

  if(present(mono))then
     if(present(mono_val).and.present(mono_lev))then
        if(size(mono_val)-1==size(mono_lev))then
           monoto=mono
        else
           write(*,*) "*** ERROR ***"
           write(*,*) "[array number] : mono_val = mono_lev + 1"
           write(*,*) "STOP"
           stop
        end if
     else
        write(*,*) "*** ERROR ***"
        write(*,*) "When option MONO is true, MONO_VAL and MONO_LEV must be specified."
        write(*,*) "STOP"
        stop
     end if
  else
     monoto=.false.
  end if

!-- ޤ ---

  call undef_CReSS2Dcl( nx, ny, 1, contour)
  call undef_CReSS2Dcl( nx, ny, 1, shade)

  call UWSGXZ(.FALSE.)
  call UWSGYZ(.FALSE.)

  if(no_frame_flag.eqv..true.)then
     call DclNewFig
  else
     call DclNewFrame
  end if

  call DclSetWindow( x(1), x(nx), y(1), y(ny) )

  if(present(rg))then
     do i=1,size(rg,2)
        call DclScalingPoint( rg(:,i), tg(:,i) )
     end do
  end if

  if(present(rp))then
     do i=1,size(rp,2)
        call DclScalingPoint( rp(:,i), tp(:,i) )
     end do
  end if

  call DclSetViewPort( vx_min, vx_max, vy_min, vy_max )
  call SGSSIM( 0.5*(vx_max-vx_min)/x(nx), 0.0, 0.0 )
  call DclSetTransNumber(5)  ! ˺ɸѴ
  call DclSetTransFunction

  if(monoto.eqv..true.)then
     call DclSetParm('ENABLE_SOFTFILL',.true.)
     call DclClearShadeLevel
     call DclSetShadeLevel( mono_val, mono_lev )
  else
     call DclSetParm('ENABLE_SOFTFILL',.false.)
!     call DclClearShadeLevel
!     call DclSetShadeLevel( shade_min, shade_max,   &
! &                          (shade_max-shade_min)/s_num )
  end if

!  if(present(nongrid))then
!     if(nongrid(1:1)=='o')then
        call DclSetXGrid( x )
!     end if
!     if(nongrid(2:2)=='o')then
        call DclSetYgrid( y )
!     end if
!  end if

  if(monoto.eqv..true.)then
     call DclShadeContour( shade )
  else
     call DclShadeContourEx( shade )
  end if

  if(DclGetContourLevelNumber()==0)then
     call DclSetContourLabelFormat(trim(form_typec))
     call DclSetContourLevel( cont_min, cont_max, (cont_max-cont_min)/cont_num )
  end if

  call DclDrawContour( contour )

  if(present(rg))then
     do i=1,size(rg,2)
        if(present(r_idx))then
           call DclSetLineIndex( r_idx(i) )  ! , ޤǰ뤫
        end if
        if(present(r_typ))then
           call DclSetLineType( r_typ(i) )
        end if
        call DclDrawLine( rg(:,i), tg(:,i) )
     end do
  end if

  if(present(rp))then
     do i=1,size(rp,2)
        if(present(rp_idx))then
           call DclSetMarkerIndex( rp_idx(i) )  ! , ޤǰ뤫
        end if
        if(present(rp_typ))then
           call DclSetMarkerType( rp_typ(i) )
        end if
        if(present(rp_siz))then
           call DclSetMarkerSize( rp_siz(i) )
        end if
        call DclDrawMarker( rp(:,i), tp(:,i) )
     end do
  end if

!-- ʾǶ˺ɸ轪λ
!-- ʲ, ǥȷϤǺѴ
  CALL GRFIG
  call DclSetWindow( -x(nx), x(nx), -x(nx), x(nx) )

  if(present(xg))then
     if(size(xg,1)>1)then
        do i=1,size(xg,2)
           call DclScalingPoint( xg(:,i), yg(:,i) )
        end do
     end if
  end if

  if(present(xp))then
     do i=1,size(xp,2)
        call DclScalingPoint( xp(:,i), yp(:,i) )
     end do
  end if

  call DclSetViewPort( vx_min, vx_max, vy_min, vy_max )
  call DclSetTransNumber(1)  ! ǥȺɸѴ
  call DclSetTransFunction

  CALL UZLSET( 'LABELYL', .TRUE. )
  CALL UZLSET( 'LABELYR', .FALSE. )
  call DclDrawScaledAxis
  call DclDrawTitle( 'b', trim(x_title), 0.0 )
  call DclDrawTitle( 'l', trim(y_title), 0.0 )
  call DclDrawTitle( 't', trim(outname), 0.0, 2 )

  if(present(xg))then
     if(size(xg,1)>1)then
        do i=1,size(xg,2)
           if(present(l_idx))then
              call DclSetLineIndex( l_idx(i) )  ! , ޤǰ뤫
           end if
           if(present(l_typ))then
              call DclSetLineType( l_typ(i) )
           end if
           call DclDrawLine( xg(:,i), yg(:,i) )
        end do
     end if
  end if

  if(present(xp))then
     do i=1,size(xp,2)
        if(present(p_idx))then
           call DclSetMarkerIndex( p_idx(i) )  ! , ޤǰ뤫
        end if
        if(present(p_typ))then
           call DclSetMarkerType( p_typ(i) )
        end if
        if(present(p_siz))then
           call DclSetMarkerSize( p_siz(i) )
        end if
        call DclDrawMarker( xp(:,i), yp(:,i) )
     end do
  end if

  if(no_tone_flag.eqv..false.)then
     if(present(trigleg))then
        call tone_bar( color_num, (/shade_min, shade_max/),  &
  &                  (/vx_max+0.05, vx_max+0.075/),   &
  &                  (/vy_min, vy_max/), trim(form_types), mono_log=monoto,  &
  &                  trigle=trigleg )
     else
        call tone_bar( color_num, (/shade_min, shade_max/),  &
  &                  (/vx_max+0.05, vx_max+0.075/),   &
  &                  (/vy_min, vy_max/), trim(form_types), mono_log=monoto )
     end if
  end if

end subroutine

!---------------------------------------------------------

subroutine Dcl_2D_cont_shade_polar_Map( outname,  &
  &  x, y, contour, shade, cont_int, shade_int, centp,  &
  &  axis_title, form_type, viewx_int, viewy_int, c_num,  &
!  &  viewy_min, viewy_max, color_num, cont_num, nongrid,  &
  &  xg, yg, rg, tg, xp, yp, rp, tp,  &
  &  mono, mono_val, mono_lev, trigleg, no_tone, no_frame,  &
  &  l_idx, l_typ, r_idx, r_typ, p_idx, p_typ, p_siz,  &
  &  rp_idx, rp_typ, rp_siz )
  ! 2  2 ѿȥ顼ɤ褹.
  ! Ͽ޾.
  use dcl
  implicit none
  character(*), intent(in) :: outname  ! դΥȥ
  real, intent(in) :: x(:)  ! ưγʻɸ [m]  ! ϿƤǻ
  real, intent(in) :: y(:)  ! Ʊ̳γʻɸ [degree]
  real, intent(inout) :: contour(size(x),size(y))  ! 
  real, intent(inout) :: shade(size(x),size(y))  ! 顼ɤ
  real, intent(in) :: cont_int(2)  ! ξ岼ü 
                                 ! [cont_int(1)=cont_min, cont_int(2)=cont_max]
  real, intent(in) :: shade_int(2)  ! ξ岼ü [shade_int(1)=shade_min,
                                 ! shade_int(2)=shade_max]
  real, intent(in) :: centp(2)  ! ˺ɸϤ濴֤ٷ [degree]
                           ! centp(1) = , centp(2) = 
  character(*), intent(in) :: axis_title(2)  ! ɸΥȥ
                                 ! axis_title(1)=x_title, axis_title(2)=y_title
  character(*), intent(in) :: form_type(2)  ! եޥå
                           ! form_type(1)=form_typec, form_type(2)=form_types
  real, intent(in), optional :: viewx_int(2)  ! ӥ塼ݡȤ x ξü
                           ! viewx_int(1)=vx_min, vx_int(2)=vx_max
  real, intent(in), optional :: viewy_int(2)  ! ӥ塼ݡȤ y ξü
                           ! viewy_int(1)=vy_min, vy_int(2)=vy_max
  integer, intent(in), optional :: c_num(2)  ! 󥿡ɤο
                           ! c_num(1)=cont_num, c_num(2)=color_num
!  character(2), intent(in), optional :: nongrid  ! ֳֳʻҤˤ뤫.
                                        ! nongrid = 'ox' Ƚ.
                                        ! 1 ʸܤ, 2 ʸܤļ.
                                        ! o = ֳ, x = ֳ.
                                        ! ǥեȤǤ 'xx'.
  real, intent(in), optional :: xg(:,:)  ! x 륰åκɸ
  real, intent(in), optional :: yg(:,:)  ! y 륰åκɸ
                    ! Ǥΰ֥ǡ, ʣ,
                    ! Ǥ 2 İʾˤ.
                    ! ǡľǤϤʤ, åɤ
                    ! Ȥǽ.
                    ! 3 ܤ, xg(:,1)  yg(:,1)  1 ܤ
                    ! ɽ褦˻ꤹ뤳.
  real, intent(in), optional :: rg(:,:)  ! ˺ɸϤˤ r 륰åκɸ
  real, intent(in), optional :: tg(:,:)  ! ˺ɸϤˤ theta 륰åκɸ
                    ! ΥǡͿ xg, yg Ʊ.
  real, intent(in), optional :: xp(:,:)  ! x ˥ޡ x ɸ
  real, intent(in), optional :: yp(:,:)  ! y ˥ޡ y ɸ
  real, intent(in), optional :: rp(:,:)  ! r ˥ޡ r ɸ
  real, intent(in), optional :: tp(:,:)  ! t ˥ޡ t ɸ
  logical, intent(in), optional :: mono  ! ΥȡγĴˤ [.true.]
                                         ! ǥեȤ .false.
  real, intent(in), optional :: mono_val(:)  ! Ĵζ.
                    ! mono=.true. ΤȤɬꤷʤȥ顼֤.
                    ! ͤ mono_lev + 1 ʬ¸ߤʤФʤʤ.
  integer, intent(in), optional :: mono_lev(:)  ! ȡޥåֹ. dcl  3 
                    ! mono=.true. ΤȤꤷʤȥ顼֤.
  character(1), intent(in), optional :: trigleg  ! ȡСλѷץ.
                ! ץͤ, tone_bar 롼 trigle Ʊ.
  logical, intent(in), optional :: no_tone  ! ȡСʤץ
                                   ! .false. = . .true. = ʤ.
                                   ! ǥեȤ .false.
  logical, intent(in), optional :: no_frame  ! NewFrame ƤФʤ
                                   ! .false. = Ƥ. .true. = ƤФ NewFig.
                                   ! ǥեȤ .false.
  integer, intent(in), optional :: l_idx(:)  ! xg, yg Υǥå
                                                      ! ǥեȤ 1.
  integer, intent(in), optional :: l_typ(:)  ! xg, yg Υ
                                                      ! ǥեȤ 1.
  integer, intent(in), optional :: r_idx(:)  ! rg, tg Υǥå
                                                      ! ǥեȤ 1.
  integer, intent(in), optional :: r_typ(:)  ! rg, tg Υ
                                                      ! ǥեȤ 1.
  integer, intent(in), optional :: p_idx(:)  ! xp, yp ޡΥǥå
  integer, intent(in), optional :: p_typ(:)  ! xp, yp ޡΥ
  real, intent(in), optional :: p_siz(:)  ! xp, yp ޡ礭
  integer, intent(in), optional :: rp_idx(:)  ! rp, tp ޡΥǥå
  integer, intent(in), optional :: rp_typ(:)  ! rp, tp ޡΥ
  real, intent(in), optional :: rp_siz(:)  ! rp, tp ޡ礭
!-- ʾ, 
  real :: cont_min  ! Ǿ
  real :: cont_max  ! 
  real :: shade_min  ! ɤǾ
  real :: shade_max  ! ɤ
  character(100) :: x_title  ! x Υȥ
  character(100) :: y_title  ! y Υȥ
  character(10) :: form_typec  ! contour ѤΥեޥå
  character(10) :: form_types  ! shade ѤΥեޥå
  real :: vx_min  ! ӥ塼ݡȤ x κǾ
  real :: vx_max  ! ӥ塼ݡȤ x κ
  real :: vy_min  ! ӥ塼ݡȤ y κǾ
  real :: vy_max  ! ӥ塼ݡȤ y κ
  integer :: cont_num  ! ο
  integer :: color_num  ! 顼ο
!-- ʾ, ֤ѿ
  integer :: i, j, k  ! ź
  integer :: nx, ny
  real :: undef, RMISS, mditv
  real, parameter :: req=4.0e7  ! ϵȾ
  real, parameter :: pi=3.14159      ! ϵȾ
  real, parameter :: rcoe=pi/180.0
  real, parameter :: mcoe=2.0*pi/req
  logical :: monoto, no_tone_flag, no_frame_flag
  type(map) :: mcenter, msw, mne
  type(cartesian) :: ccenter, csw, cne

  nx=size(x)
  ny=size(y)

!-- optional ν ---
  if(present(viewx_int))then
     vx_min=viewx_int(1)
     vx_max=viewx_int(2)
  else
     vx_min=0.2
     vx_max=0.8
  end if

  if(present(viewy_int))then
     vy_min=viewy_int(1)
     vy_max=viewy_int(2)
  else
     vy_min=0.2
     vy_max=0.8
  end if

  if(present(c_num))then
     cont_num=c_num(1)
     color_num=c_num(2)
  else
     cont_num=10
     color_num=56
  end if

  if(present(no_tone))then
     no_tone_flag=no_tone
  else
     no_tone_flag=.false.
  end if

  if(present(no_frame))then
     no_frame_flag=no_frame
  else
     no_frame_flag=.false.
  end if

!-- ֤ѿ֤
  cont_min=cont_int(1)
  cont_max=cont_int(2)
  shade_min=shade_int(1)
  shade_max=shade_int(2)
  x_title=trim(axis_title(1))
  y_title=trim(axis_title(2))
  form_typec=trim(form_type(1))
  form_types=trim(form_type(2))

  if(present(mono))then
     if(present(mono_val).and.present(mono_lev))then
        if(size(mono_val)-1==size(mono_lev))then
           monoto=mono
        else
           write(*,*) "*** ERROR ***"
           write(*,*) "[array number] : mono_val = mono_lev + 1"
           write(*,*) "STOP"
           stop
        end if
     else
        write(*,*) "*** ERROR ***"
        write(*,*) "When option MONO is true, MONO_VAL and MONO_LEV must be specified."
        write(*,*) "STOP"
        stop
     end if
  else
     monoto=.false.
  end if

!-- ޤ ---

  call undef_CReSS2Dcl( nx, ny, 1, contour)
  call undef_CReSS2Dcl( nx, ny, 1, shade)

  call UWSGXZ(.FALSE.)
  call UWSGYZ(.FALSE.)

  if(no_frame_flag.eqv..true.)then
     call DclNewFig
  else
     call DclNewFrame
  end if

  call DclSetWindow( x(1), x(nx), y(1), y(ny) )

  if(present(rg))then
     do i=1,size(rg,2)
        call DclScalingPoint( rg(:,i), tg(:,i) )
     end do
  end if

  if(present(rp))then
     do i=1,size(rp,2)
        call DclScalingPoint( rp(:,i), tp(:,i) )
     end do
  end if

  call DclSetViewPort( vx_min, vx_max, vy_min, vy_max )
  call SGSSIM( 0.5*(vx_max-vx_min)/x(nx), 0.0, 0.0 )
  call DclSetTransNumber(5)  ! ˺ɸѴ
  call DclSetTransFunction

  if(monoto.eqv..true.)then
     call DclSetParm('ENABLE_SOFTFILL',.true.)
     call DclClearShadeLevel
     call DclSetShadeLevel( mono_val, mono_lev )
  else
     call DclSetParm('ENABLE_SOFTFILL',.false.)
!     call DclClearShadeLevel
!     call DclSetShadeLevel( shade_min, shade_max,   &
! &                          (shade_max-shade_min)/s_num )
  end if

!  if(present(nongrid))then
!     if(nongrid(1:1)=='o')then
        call DclSetXGrid( x )
!     end if
!     if(nongrid(2:2)=='o')then
        call DclSetYgrid( y )
!     end if
!  end if

  if(monoto.eqv..true.)then
     call DclShadeContour( shade )
  else
     call DclShadeContourEx( shade )
  end if

  if(DclGetContourLevelNumber()==0)then
     call DclSetContourLabelFormat(trim(form_typec))
     call DclSetContourLevel( cont_min, cont_max, (cont_max-cont_min)/cont_num )
  end if

  call DclDrawContour( contour )

  if(present(rg))then
     do i=1,size(rg,2)
        if(present(r_idx))then
           call DclSetLineIndex( r_idx(i) )  ! , ޤǰ뤫
        end if
        if(present(r_typ))then
           call DclSetLineType( r_typ(i) )
        end if
        call DclDrawLine( rg(:,i), tg(:,i) )
     end do
  end if

  if(present(rp))then
     do i=1,size(rp,2)
        if(present(rp_idx))then
           call DclSetMarkerIndex( rp_idx(i) )  ! , ޤǰ뤫
        end if
        if(present(rp_typ))then
           call DclSetMarkerType( rp_typ(i) )
        end if
        if(present(rp_siz))then
           call DclSetMarkerSize( rp_siz(i) )
        end if
        call DclDrawMarker( rp(:,i), tp(:,i) )
     end do
  end if

!-- ʾǶ˺ɸ轪λ
!-- ʲ, 륫ȥϤǺѴ
!-- , 륫ȥѴ , ٤ rad, Υƻ 4  km 
!-- 2 pi rad ѴƤΤ, ʲǤϤѴԤ.
!-- ѴϵΥˤĤƤ 
!-- (1) 濴ΰٷ٤ǥȷϺɸФ.
  mcenter%lat=centp(1)*rcoe
  mcenter%lon=centp(2)*rcoe
  ccenter=DclMercator_F(mcenter)
!-- (2) 濴ΥǥȺɸ  -x(nx),  -x(nx) ü
!        x(nx), ̤ x(nx) üˤ륫ȥΰٷ٤Ф.
  csw%x=ccenter%x-x(nx)*mcoe
  csw%y=ccenter%y-x(nx)*mcoe
  cne%x=ccenter%x+x(nx)*mcoe
  cne%y=ccenter%y+x(nx)*mcoe

  msw=DclMercator_B(csw)
  mne=DclMercator_B(cne)

  msw%lon=msw%lon/rcoe
  msw%lat=msw%lat/rcoe
  mne%lon=mne%lon/rcoe
  mne%lat=mne%lat/rcoe

  CALL GRFIG
  call DclSetWindow( msw%lon, mne%lon, msw%lat, mne%lat )

  if(present(xg))then
     if(size(xg,1)>1)then
       do i=1,size(xg,2)
          call DclScalingPoint( xg(:,i), yg(:,i) )
       end do
     end if
  end if

  if(present(xp))then
     do i=1,size(xp,2)
        call DclScalingPoint( xp(:,i), yp(:,i) )
     end do
  end if

  call DclSetViewPort( vx_min, vx_max, vy_min, vy_max )
  call DclSetTransNumber(11)  ! 륫ȥѴ. ϸ. 
                             ! ʳϿޤˤбʤ. ݤ.
  call DclFitMapParm
  call DclSetTransFunction

  call DclSetParm( 'GRAPH:LCLIP', .true. )

  CALL UZLSET( 'LABELYL', .TRUE. )
  CALL UZLSET( 'LABELYR', .FALSE. )
!  call DclDrawScaledAxis
  mditv=1.0  ! Ȥꤢ.
  call DclDrawAxis( 'bt', mditv, 0.5*mditv )
  call DclDrawAxis( 'rl', mditv, 0.5*mditv )
  call DclDrawMap( 'coast_japan' )
!  call DclDrawGlobe()

  call DclDrawTitle( 'b', trim(x_title), 0.0 )
  call DclDrawTitle( 'l', trim(y_title), 0.0 )
  call DclDrawTitle( 't', trim(outname), 0.0, 2 )

  if(present(xg))then
     if(size(xg,1)>1)then
        do i=1,size(xg,2)
           if(present(l_idx))then
              call DclSetLineIndex( l_idx(i) )  ! , ޤǰ뤫
           end if
           if(present(l_typ))then
              call DclSetLineType( l_typ(i) )
           end if
           call DclDrawLine( xg(:,i), yg(:,i) )
        end do
     end if
  end if

  if(present(xp))then
     do i=1,size(xp,2)
        if(present(p_idx))then
           call DclSetMarkerIndex( p_idx(i) )  ! , ޤǰ뤫
        end if
        if(present(p_typ))then
           call DclSetMarkerType( p_typ(i) )
        end if
        if(present(p_siz))then
           call DclSetMarkerSize( p_siz(i) )
        end if
        call DclDrawMarker( xp(:,i), yp(:,i) )
     end do
  end if

  if(no_tone_flag.eqv..false.)then
     if(present(trigleg))then
        call tone_bar( color_num, (/shade_min, shade_max/),  &
  &                  (/vx_max+0.05, vx_max+0.075/),   &
  &                  (/vy_min, vy_max/), trim(form_types), mono_log=monoto,  &
  &                  trigle=trigleg )
     else
        call tone_bar( color_num, (/shade_min, shade_max/),  &
  &                  (/vx_max+0.05, vx_max+0.075/),   &
  &                  (/vy_min, vy_max/), trim(form_types), mono_log=monoto )
     end if
  end if

end subroutine

!---------------------------------------------------------

subroutine Dcl_PL( judge, outname,  &
  &  xline, yline, xpoint, ypoint, axis_title,  &
  &  viewx_int, viewy_int, x_int, y_int, no_frame,  &
  &  xylog, l_idx, l_typ, p_idx, p_typ, p_siz,  &
  &  zline, zpoint, cl_val, cl_idx, cp_val, cp_idx )
  ! 2 ʿˤʣζ, ݥȤ褹.
  ! ͿȥݥȤϤ줾̸ĤƤ,
  ! ˤĤƤ, x, y ɸ 2 , ݥȤˤĤƤƱͤ 2 ,
  ! ˶ x, y ɸǤ 1 ܤζϢ³
  ! ǤǶܿ. ݥȤˤĤƤƱ.
  ! Ĥޤ, ȤưʲΤ褦Ѱդ.
  ! 3 ܤζ, 5 ΥݥȤ, ˤĤƤ 1 ܤζ
  ! ˤ 1000 ĤϢ³, ݥȤˤĤƤ 1 
  ! ݥȤ 100 Ȥ,
  ! xline(1000, 3), yline(1000, 3), xpoint(100, 5), y(100, 5)
  ! Ȥưɤ߹ޤФ褤.
  ! ΤȤ, ΰбطϰʲΤȤǤ.
  ! lnum = 3, pnum = 5, lstep = 1000, pstep = 100
  use dcl
  implicit none
  character(1), intent(in) :: judge  ! դμ
                ! 'p' = ݥȤΤ, 'l' = 饤Τ, 'a' = ξ.
                ! 褷ʤǤ, ߡɤ߹ޤɬפ.
  character(*), intent(in) :: outname  ! դΥȥ
  real, intent(in) :: xline(:,:)  !  x ɸ
  real, intent(in) :: yline(size(xline,1),size(xline,2))  !  y ɸ
  real, intent(in) :: xpoint(:,:)  ! ݥȷ x ɸ
  real, intent(in) :: ypoint(size(xpoint,1),size(xpoint,2))  ! ݥȷ y ɸ
  character(*), intent(in) :: axis_title(2)  ! ɸΥȥ
                              ! axis_title(1)=x_title,axis_title(2)=y_title
  real, intent(in), optional :: viewx_int(2)  ! ӥ塼ݡȤ x ξü
                           ! viewx_int(1)=vx_min, vx_int(2)=vx_max
  real, intent(in), optional :: viewy_int(2)  ! ӥ塼ݡȤ y ξü
                           ! viewy_int(1)=vy_min, vy_int(2)=vy_max
  real, intent(in), optional :: x_int(2)  ! x Υξü
                           ! x_int(1)=xmin, x_int(2)=xmax
  real, intent(in), optional :: y_int(2)  ! y Υξü
                           ! y_int(1)=ymin, y_int(2)=ymax
  logical, intent(in), optional :: no_frame  ! NewFrame ƤФʤ
                                   ! .false. = Ƥ. .true. = ƤФ NewFig.
                                   ! ǥեȤ .false.
  logical, intent(in), optional :: xylog(2)  ! пǼ񤯥ե饰.
                                             ! .true. , default Ϥɤ .false.
  integer, intent(in), optional :: l_idx(size(xline,2))  ! μŪͿ.
  integer, intent(in), optional :: l_typ(size(xline,2))  ! μŪͿ.
  integer, intent(in), optional :: p_idx(size(xpoint,2))  ! μŪͿ.
  integer, intent(in), optional :: p_typ(size(xpoint,2))  ! μŪͿ.
  real, intent(in), optional :: p_siz(size(xpoint,2))  ! μŪͿ.
  real, intent(in), optional :: zline(size(xline,1),size(xline,2))
                                ! 顼饤⡼ɤ xline, yline ȼ.
  real, intent(in), optional :: zpoint(size(xpoint,1),size(xpoint,2))
                                ! 顼饤⡼ɤ xpoint, ypoint ȼ.
  real, intent(in), optional :: cl_val(:)  ! 顼 (饤)
  integer, intent(in), optional :: cl_idx(:)  ! 顼ֹ (饤)
  real, intent(in), optional :: cp_val(:)  ! 顼 (ޡ)
  integer, intent(in), optional :: cp_idx(:)  ! 顼ֹ (ޡ)
  
!-- ʾ, 
  character(100) :: x_title  ! x Υȥ
  character(100) :: y_title  ! y Υȥ
  real :: vx_min  ! ӥ塼ݡȤ x κǾ
  real :: vx_max  ! ӥ塼ݡȤ x κ
  real :: vy_min  ! ӥ塼ݡȤ y κǾ
  real :: vy_max  ! ӥ塼ݡȤ y κ
!-- ʾ, ֤ѿ
  integer :: i, j, k  ! ź
  integer, parameter :: lim=890  ! 饤󥤥ǥåκ
  integer :: nnum, lstep, pstep, lnum, pnum
  integer :: trans_num
  logical :: no_frame_flag
  logical :: xlogf, ylogf

  lstep=size(xline,1)
  pstep=size(xpoint,1)
  lnum=size(xline,2)
  pnum=size(xpoint,2)

!-- optional ν ---
  if(present(viewx_int))then
     vx_min=viewx_int(1)
     vx_max=viewx_int(2)
  else
     vx_min=0.2
     vx_max=0.8
  end if

  if(present(viewy_int))then
     vy_min=viewy_int(1)
     vy_max=viewy_int(2)
  else
     vy_min=0.2
     vy_max=0.8
  end if

  if(present(no_frame))then
     no_frame_flag=no_frame
  else
     no_frame_flag=.false.
  end if

  if(present(xylog))then
     xlogf=xylog(1)
     ylogf=xylog(2)
  else
     xlogf=.false.
     ylogf=.false.
  end if

!-- ֤ѿ֤
  x_title=trim(axis_title(1))
  y_title=trim(axis_title(2))

!-- ޤ ---

  call UWSGXZ(.FALSE.)
  call UWSGYZ(.FALSE.)

  if(no_frame_flag.eqv..true.)then
     call DclNewFig
  else
     call DclNewFrame
  end if

  if(present(x_int).and.present(y_int))then
     call DclSetWindow( x_int(1), x_int(2), y_int(1), y_int(2) )
  else
     if(judge=='p'.or.judge=='a')then
        if(present(zpoint))then
           call color_line( 's', xpoint, ypoint, zpoint,  &
  &                         0, (/0.0, 0.0/),  &
  &                         col_val=cp_val, col_idx=cp_idx )
        else
           do j=1,pnum
              call DclScalingPoint( xpoint(:,j), ypoint(:,j) )
           end do
        end if
     end if

     if(judge=='l'.or.judge=='a')then
        if(present(zline))then
           call color_line( 's', xline, yline, zline,  &
  &                         0, (/0.0, 0.0/), col_val=cl_val, col_idx=cl_idx )
        else
           do j=1,lnum
              call DclScalingPoint( xline(:,j), yline(:,j) )
           end do
        end if
     end if
     call DclFitScalingParm
  end if
  call DclSetViewPort( vx_min, vx_max, vy_min, vy_max )

  if(xlogf.eqv..true.)then
     if(ylogf.eqv..true.)then
        trans_num=4
     else
        trans_num=3
     end if
  else
     if(ylogf.eqv..true.)then
        trans_num=2
     else
        trans_num=1
     end if
  end if

  call DclSetTransNumber(trans_num)
  call DclSetTransFunction

 ! call DclShadeContourEx( shade )
  CALL UZLSET( 'LABELYL', .TRUE. )
  CALL UZLSET( 'LABELYR', .FALSE. )
  call DclDrawScaledAxis
  call DclDrawTitle( 'b', trim(x_title), 0.0 )
  call DclDrawTitle( 'l', trim(y_title), 0.0 )
  call DclDrawTitle( 't', trim(outname), 0.0, 2 )

!-- ݥȤȶ ---
!-- num ˱ do 롼פǲ󤹤Τ, num Ǥդ OK.
!-- num = 1 ξϹǸ
  if(present(zpoint))then
     call color_line( 'p', xpoint, ypoint, zpoint,  &
  &                   0, (/0.0, 0.0/), col_val=cp_val, col_idx=cp_idx )
  else
     if(judge=='p'.or.judge=='a')then
        do j=1,pnum
           if(present(p_idx))then
              call DclSetMarkerIndex( p_idx(j) )  ! , ޤǰ뤫
           end if
           if(present(p_typ))then
              call DclSetMarkerType( p_typ(j) )
           else
              if(pnum==1)then
                 call DclDrawMarker( xpoint(:,1), ypoint(:,1) )
                 call DclSetMarkerType( 1 )
              else
                 call DclSetMarkerType( j )
              end if
           end if
           if(present(p_siz))then
              call DclSetMarkerSize( p_siz(j) )
           end if

           call DclDrawMarker( xpoint(:,j), ypoint(:,j) )
        end do
     end if
  end if

  if(present(zline))then
     call color_line( 'l', xline, yline, zline,  &
  &                   0, (/0.0, 0.0/), col_val=cl_val, col_idx=cl_idx )
  else
     if(judge=='l'.or.judge=='a')then
        do j=1,lnum
           if(present(l_idx))then
              call DclSetLineIndex( l_idx(j) )
           else
              if(lnum/=1)then
                 nnum=lim/lnum
                 call DclSetLineIndex( 100+nnum*(j-1)+1 )
              end if
           end if
           if(present(l_typ))then
              call DclSetLineType( l_typ(j) )
           end if
           call DclDrawLine( xline(:,j), yline(:,j) )
        end do
     end if
  end if

!  call DclSetContourLabelFormat(form_typec)
!  call DclSetContourLevel( cont_min, cont_max, (cont_max-cont_min)/10 )
!  call DclDrawContour( contour )

!  call DclDrawVectors( um, vm )

end subroutine

!---------------------------------------------------------

subroutine Dcl_PL_vec( judge, outname,  &
  &  x, y, xline, yline, xpoint, ypoint,  & 
  &  vecx, vecy, vn, axis_title,  &
  &  viewx_int, viewy_int, no_frame,  &
  &  xylog, l_idx, l_typ, p_idx, p_typ, p_siz,  &
  &  zline, zpoint, cl_val, cl_idx, cp_val, cp_idx )
  ! 2 ʿˤƥ٥ȥʣζ, ݥȤ褹.
  ! ͿȥݥȤϤ줾̸ĤƤ,
  ! ˤĤƤ, x, y ɸ 2 , ݥȤˤĤƤƱͤ 2 ,
  ! ˶ x, y ɸǤ 1 ܤζϢ³
  ! ǤǶܿ. ݥȤˤĤƤƱ.
  ! Ĥޤ, ȤưʲΤ褦Ѱդ.
  ! 3 ܤζ, 5 ΥݥȤ, ˤĤƤ 1 ܤζ
  ! ˤ 1000 ĤϢ³, ݥȤˤĤƤ 1 
  ! ݥȤ 100 Ȥ,
  ! xline(1000, 3), yline(1000, 3), xpoint(100, 5), y(100, 5)
  ! Ȥưɤ߹ޤФ褤.
  ! ΤȤ, ΰбطϰʲΤȤǤ.
  ! lnum = 3, pnum = 5, lstep = 1000, pstep = 100
  use dcl
  implicit none
  character(1), intent(in) :: judge  ! դμ
                ! 'p' = ݥȤΤ, 'l' = 饤Τ, 'a' = ξ.
                ! 褷ʤǤ, ߡɤ߹ޤɬפ.
  character(*), intent(in) :: outname  ! դΥȥ
  real, intent(in) :: x(:)  ! x γʻɸ
  real, intent(in) :: y(:)  ! y γʻɸ
  real, intent(in) :: xline(:,:)  !  x ɸ
  real, intent(in) :: yline(size(xline,1),size(xline,2))  !  y ɸ
  real, intent(in) :: xpoint(:,:)  ! ݥȷ x ɸ
  real, intent(in) :: ypoint(size(xpoint,1),size(xpoint,2))  ! ݥȷ y ɸ
  real, intent(in) :: vecx(size(x),size(y))  ! x Υ٥ȥ
  real, intent(in) :: vecy(size(x),size(y))  ! x Υ٥ȥ
  integer, intent(in) :: vn(2)  ! ٥ȥʻ (ְ)
                                ! vn(1)=vnx, vn(2)=vny
  character(*), intent(in) :: axis_title(2)  ! ɸΥȥ
                              ! axis_title(1)=x_title,axis_title(2)=y_title
  real, intent(in), optional :: viewx_int(2)  ! ӥ塼ݡȤ x ξü
                           ! viewx_int(1)=vx_min, vx_int(2)=vx_max
  real, intent(in), optional :: viewy_int(2)  ! ӥ塼ݡȤ y ξü
                           ! viewy_int(1)=vy_min, vy_int(2)=vy_max
  logical, intent(in), optional :: no_frame  ! NewFrame ƤФʤ
                                   ! .false. = Ƥ. .true. = ƤФ NewFig.
                                   ! ǥեȤ .false.
  logical, intent(in), optional :: xylog(2)  ! пǼ񤯥ե饰.
                                             ! .true. , default Ϥɤ .false.
  integer, intent(in), optional :: l_idx(size(xline,2))  ! μŪͿ.
  integer, intent(in), optional :: l_typ(size(xline,2))  ! μŪͿ.
  integer, intent(in), optional :: p_idx(size(xpoint,2))  ! μŪͿ.
  integer, intent(in), optional :: p_typ(size(xpoint,2))  ! μŪͿ.
  real, intent(in), optional :: p_siz(size(xpoint,2))  ! μŪͿ.
  real, intent(in), optional :: zline(size(xline,1),size(xline,2))
                                ! 顼饤⡼ɤ xpoint, ypoint ȼ.
  real, intent(in), optional :: zpoint(size(xpoint,1),size(xpoint,2))
                                ! 顼饤⡼ɤ xpoint, ypoint ȼ.
  real, intent(in), optional :: cl_val(:)  ! 顼 (饤)
  integer, intent(in), optional :: cl_idx(:)  ! 顼ֹ (饤)
  real, intent(in), optional :: cp_val(:)  ! 顼 (ޡ)
  integer, intent(in), optional :: cp_idx(:)  ! 顼ֹ (ޡ)
!-- ʾ, 
  integer :: vnx  ! x Υ٥ȥʻ (ְ)
  integer :: vny  ! y Υ٥ȥʻ (ְ)
  character(100) :: x_title  ! x Υȥ
  character(100) :: y_title  ! y Υȥ
  real :: vx_min  ! ӥ塼ݡȤ x κǾ
  real :: vx_max  ! ӥ塼ݡȤ x κ
  real :: vy_min  ! ӥ塼ݡȤ y κǾ
  real :: vy_max  ! ӥ塼ݡȤ y κ
!-- ʾ, ֤ѿ
  integer :: i, j, k  ! ź
  integer :: nx, ny
  integer, parameter :: lim=890
  integer :: lstep, pstep, lnum, pnum, nnum
  integer :: trans_num
  real :: factx, facty
  real, dimension(size(x),size(y)) :: um, vm  ! ٥ȥְͤ
  real :: undef, RMISS
  logical :: no_frame_flag
  logical :: xlogf, ylogf

  nx=size(x)
  ny=size(y)

  lstep=size(xline,1)
  pstep=size(xpoint,1)
  lnum=size(xline,2)
  pnum=size(xpoint,2)

!-- optional ν ---
  if(present(viewx_int))then
     vx_min=viewx_int(1)
     vx_max=viewx_int(2)
  else
     vx_min=0.2
     vx_max=0.8
  end if

  if(present(viewy_int))then
     vy_min=viewy_int(1)
     vy_max=viewy_int(2)
  else
     vy_min=0.2
     vy_max=0.8
  end if

  if(present(no_frame))then
     no_frame_flag=no_frame
  else
     no_frame_flag=.false.
  end if

  if(present(xylog))then
     xlogf=xylog(1)
     ylogf=xylog(2)
  else
     xlogf=.false.
     ylogf=.false.
  end if

!-- ֤ѿ֤
  vnx=vn(1)
  vny=vn(2)
  x_title=trim(axis_title(1))
  y_title=trim(axis_title(2))

!-- 顼
  if(nx<vnx.or.ny<vny)then
     write(*,*) "*****ERROR***** : vnx > nx or vny > ny."
     stop
  end if
!-- ٹ
  if(mod(nx,(vnx-1))/=0.or.mod(ny,(vny-1))/=0)then
     write(*,*) "****WARNING**** : vnx or vny is not the factor of nx or ny."
  end if

!-- ٥ȥδְ
  factx=real(nx)/real(vnx-1)
  facty=real(ny)/real(vny-1)

  um=0.0
  vm=0.0

!--  1 Ϥ
  um(1,1)=vecx(1,1)
  vm(1,1)=vecy(1,1)

  do i=2,vnx
     um(1+nint(factx*(i-1)),1)=vecx(1+nint(factx*(i-1)),1)
     vm(1+nint(factx*(i-1)),1)=vecy(1+nint(factx*(i-1)),1)
  end do

  do j=2,vny
     um(1,1+nint((j-1)*facty))=vecx(1,1+nint((j-1)*facty))
     vm(1,1+nint((j-1)*facty))=vecy(1,1+nint((j-1)*facty))
  end do

  do j=2,vny
     do i=2,vnx
        um(1+nint(factx*(i-1)),1+nint(facty*(j-1)))  &
  &     =vecx(1+nint(factx*(i-1)),1+nint(facty*(j-1)))
        vm(1+nint(factx*(i-1)),1+nint(facty*(j-1)))  &
  &     =vecy(1+nint(factx*(i-1)),1+nint(facty*(j-1)))
     end do
  end do

!-- ޤ ---

!  call undef_CReSS2Dcl( nx, ny, 1, contour)
!  call undef_CReSS2Dcl( nx, ny, 1, shade)

  call UWSGXZ(.FALSE.)
  call UWSGYZ(.FALSE.)

  if(no_frame_flag.eqv..true.)then
     call DclNewFig
  else
     call DclNewFrame
  end if

  call DclSetWindow( x(1), x(nx), y(1), y(ny) )
  call DclSetViewPort( vx_min, vx_max, vy_min, vy_max )

  if(xlogf.eqv..true.)then
     if(ylogf.eqv..true.)then
        trans_num=4
     else
        trans_num=3
     end if
  else
     if(ylogf.eqv..true.)then
        trans_num=2
     else
        trans_num=1
     end if
  end if

  call DclSetTransNumber(trans_num)
  call DclSetTransFunction

 ! call DclShadeContourEx( shade )
  CALL UZLSET( 'LABELYL', .TRUE. )
  CALL UZLSET( 'LABELYR', .FALSE. )
  call DclDrawScaledAxis
  call DclDrawTitle( 'b', trim(x_title), 0.0 )
  call DclDrawTitle( 'l', trim(y_title), 0.0 )
  call DclDrawTitle( 't', trim(outname), 0.0, 2 )

!-- ݥȤȶ ---
!-- num ˱ do 롼פǲ󤹤Τ, num Ǥդ OK.
!-- num = 1 ξϹǸ
  if(present(zpoint))then
     call color_line( 'p', xpoint, ypoint, zpoint,  &
  &                   0, (/0.0, 0.0/), col_val=cp_val, col_idx=cp_idx )
  else
     if(judge=='p'.or.judge=='a')then
        do j=1,pnum
           if(present(p_idx))then
              call DclSetMarkerIndex( p_idx(j) )  ! , ޤǰ뤫
           end if
           if(present(p_typ))then
              call DclSetMarkerType( p_typ(j) )
           else
              if(pnum==1)then
                 call DclDrawMarker( xpoint(:,1), ypoint(:,1) )
                 call DclSetMarkerType( 1 )
              else
                 call DclSetMarkerType( j )
              end if
           end if
           if(present(p_siz))then
              call DclSetMarkerSize( p_siz(j) )
           end if

           call DclDrawMarker( xpoint(:,j), ypoint(:,j) )
        end do
     end if
  end if

  if(present(zline))then
     call color_line( 'l', xline, yline, zline,  &
  &                   0, (/0.0, 0.0/), col_val=cl_val, col_idx=cl_idx )
  else
     if(judge=='l'.or.judge=='a')then
        do j=1,lnum
           if(present(l_idx))then
              call DclSetLineIndex( l_idx(j) )
           else
              if(lnum/=1)then
                 nnum=lim/lnum
                 call DclSetLineIndex( 100+nnum*(j-1)+1 )
              end if
           end if
           if(present(l_typ))then
              call DclSetLineType( l_typ(j) )
           end if
           call DclDrawLine( xline(:,j), yline(:,j) )
        end do
     end if
  end if

!  call DclSetContourLabelFormat(form_typec)
!  call DclSetContourLevel( cont_min, cont_max, (cont_max-cont_min)/10 )
!  call DclDrawContour( contour )

  call DclDrawVectors( um, vm )

end subroutine

!---------------------------------------------------------

subroutine Dcl_PL_calendar( judge, outname,  &
  &  xline, yline, xpoint, ypoint, axis_title, date, days,  &
  &  viewx_int, viewy_int, x_int, y_int, no_frame,  &
  &  l_idx, l_typ, p_idx, p_typ, p_siz, zline, zpoint,  &
  &  cl_val, cl_idx, cp_val, cp_idx )
  ! 2 ʿˤʣζ, ݥȤ褹.
  ! ͿȥݥȤϤ줾̸ĤƤ,
  ! ˤĤƤ, x, y ɸ 2 , ݥȤˤĤƤƱͤ 2 ,
  ! ˶ x, y ɸǤ 1 ܤζϢ³
  ! ǤǶܿ. ݥȤˤĤƤƱ.
  ! Ĥޤ, ȤưʲΤ褦Ѱդ.
  ! 3 ܤζ, 5 ΥݥȤ, ˤĤƤ 1 ܤζ
  ! ˤ 1000 ĤϢ³, ݥȤˤĤƤ 1 
  ! ݥȤ 100 Ȥ,
  ! xline(1000, 3), yline(1000, 3), xpoint(100, 5), y(100, 5)
  ! Ȥưɤ߹ޤФ褤.
  ! ΤȤ, ΰбطϰʲΤȤǤ.
  ! lnum = 3, pnum = 5, lstep = 1000, pstep = 100
  use dcl
  implicit none
  character(1), intent(in) :: judge  ! դμ
                ! 'p' = ݥȤΤ, 'l' = 饤Τ, 'a' = ξ.
                ! 褷ʤǤ, ߡɤ߹ޤɬפ.
  character(*), intent(in) :: outname  ! դΥȥ
  real, intent(in) :: xline(:,:)  !  x ɸ
  real, intent(in) :: yline(size(xline,1),size(xline,2))  !  y ɸ
  real, intent(in) :: xpoint(:,:)  ! ݥȷ x ɸ
  real, intent(in) :: ypoint(size(xpoint,1),size(xpoint,2))  ! ݥȷ y ɸ
  character(*), intent(in) :: axis_title(2)  ! ɸΥȥ
                              ! axis_title(1)=x_title,axis_title(2)=y_title
  type(dcl_date), intent(in) :: date  !  [yyyy:mm:dd]
  integer, intent(in) :: days  !  [day]
  real, intent(in), optional :: viewx_int(2)  ! ӥ塼ݡȤ x ξü
                           ! viewx_int(1)=vx_min, vx_int(2)=vx_max
  real, intent(in), optional :: viewy_int(2)  ! ӥ塼ݡȤ y ξü
                           ! viewy_int(1)=vy_min, vy_int(2)=vy_max
  real, intent(in), optional :: x_int(2)  ! x Υξü
                           ! x_int(1)=xmin, x_int(2)=xmax
  real, intent(in), optional :: y_int(2)  ! y Υξü
                           ! y_int(1)=ymin, y_int(2)=ymax
  logical, intent(in), optional :: no_frame  ! NewFrame ƤФʤ
                                   ! .false. = Ƥ. .true. = ƤФ NewFig.
                                   ! ǥեȤ .false.
  integer, intent(in), optional :: l_idx(size(xline,2))  ! μŪͿ.
  integer, intent(in), optional :: l_typ(size(xline,2))  ! μŪͿ.
  integer, intent(in), optional :: p_idx(size(xpoint,2))  ! μŪͿ.
  integer, intent(in), optional :: p_typ(size(xpoint,2))  ! μŪͿ.
  real, intent(in), optional :: p_siz(size(xpoint,2))  ! μŪͿ.
  real, intent(in), optional :: zline(size(xline,1),size(xline,2))
                                ! 顼饤⡼ɤ xline, yline ȼ.
  real, intent(in), optional :: zpoint(size(xpoint,1),size(xpoint,2))
                                ! 顼饤⡼ɤ xpoint, ypoint ȼ.
  real, intent(in), optional :: cl_val(:)  ! 顼 (饤)
  integer, intent(in), optional :: cl_idx(:)  ! 顼ֹ (饤)
  real, intent(in), optional :: cp_val(:)  ! 顼 (ޡ)
  integer, intent(in), optional :: cp_idx(:)  ! 顼ֹ (ޡ)
!-- ʾ, 
  character(100) :: x_title  ! x Υȥ
  character(100) :: y_title  ! y Υȥ
  real :: vx_min  ! ӥ塼ݡȤ x κǾ
  real :: vx_max  ! ӥ塼ݡȤ x κ
  real :: vy_min  ! ӥ塼ݡȤ y κǾ
  real :: vy_max  ! ӥ塼ݡȤ y κ
!-- ʾ, ֤ѿ
  integer :: i, j, k  ! ź
  integer, parameter :: lim=890  ! 饤󥤥ǥåκ
  integer :: nnum
  integer :: lstep, pstep, lnum, pnum
  logical :: no_frame_flag

  lstep=size(xline,1)
  pstep=size(xpoint,1)
  lnum=size(xline,2)
  pnum=size(xpoint,2)

!-- optional ν ---
  if(present(viewx_int))then
     vx_min=viewx_int(1)
     vx_max=viewx_int(2)
  else
     vx_min=0.2
     vx_max=0.8
  end if

  if(present(viewy_int))then
     vy_min=viewy_int(1)
     vy_max=viewy_int(2)
  else
     vy_min=0.2
     vy_max=0.8
  end if

  if(present(no_frame))then
     no_frame_flag=no_frame
  else
     no_frame_flag=.false.
  end if

!-- ֤ѿ֤
  x_title=trim(axis_title(1))
  y_title=trim(axis_title(2))

!-- ޤ ---

  call UWSGXZ(.FALSE.)
  call UWSGYZ(.FALSE.)

  if(no_frame_flag.eqv..true.)then
     call DclNewFig
  else
     call DclNewFrame
  end if

  if(present(x_int).and.present(y_int))then
     call DclSetWindow( x_int(1), x_int(2), y_int(1), y_int(2) )
  else
     if(judge=='p'.or.judge=='a')then
        if(present(zpoint))then
           call color_line( 's', xpoint, ypoint, zpoint,  &
  &                         0, (/0.0, 0.0/), col_val=cp_val, col_idx=cp_idx )
        else
           do i=1,pnum
              call DclScalingPoint( xpoint(:,j), ypoint(:,j) )
           end do
        end if
     end if

     if(judge=='l'.or.judge=='a')then
        if(present(zline))then
           call color_line( 's', xline, yline, zline,  &
  &                         0, (/0.0, 0.0/), col_val=cl_val, col_idx=cl_idx )
        else
           do j=1,lnum
              call DclScalingPoint( xline(:,j), yline(:,j) )
           end do
        end if
     end if
     call DclFitScalingParm
  end if
  call DclSetViewPort( vx_min, vx_max, vy_min, vy_max )

  call DclSetTransFunction

 ! call DclShadeContourEx( shade )
  CALL UZLSET( 'LABELYL', .TRUE. )
  CALL UZLSET( 'LABELYR', .FALSE. )
  call DclDrawAxisCalendar( 'bt', date, nd=days )
  call DclDrawScaledAxis( 'lr' )
  call DclDrawTitle( 'l', trim(y_title), 0.0 )
  call DclDrawTitle( 't', trim(outname), 0.0, 2 )

!-- ݥȤȶ ---
!-- num ˱ do 롼פǲ󤹤Τ, num Ǥդ OK.
!-- num = 1 ξϹǸ
  if(present(zpoint))then
     call color_line( 'p', xpoint, ypoint, zpoint,  &
  &                   0, (/0.0, 0.0/), col_val=cp_val, col_idx=cp_idx )
  else
     if(judge=='p'.or.judge=='a')then
        do j=1,pnum
           if(present(p_idx))then
              call DclSetMarkerIndex( p_idx(j) )  ! , ޤǰ뤫
           end if
           if(present(p_typ))then
              call DclSetMarkerType( p_typ(j) )
           else
              if(pnum==1)then
                 call DclDrawMarker( xpoint(:,1), ypoint(:,1) )
                 call DclSetMarkerType( 1 )
              else
                 call DclSetMarkerType( j )
              end if
           end if
           if(present(p_siz))then
              call DclSetMarkerSize( p_siz(j) )
           end if

           call DclDrawMarker( xpoint(:,j), ypoint(:,j) )
        end do
     end if
  end if

  if(present(zline))then
     call color_line( 'l', xline, yline, zline,  &
  &                   0, (/0.0, 0.0/), col_val=cl_val, col_idx=cl_idx )
  else
     if(judge=='l'.or.judge=='a')then
        do j=1,lnum
           if(present(l_idx))then
              call DclSetLineIndex( l_idx(j) )
           else
              if(lnum/=1)then
                 nnum=lim/lnum
                 call DclSetLineIndex( 100+nnum*(j-1)+1 )
              end if
           end if
           if(present(l_typ))then
              call DclSetLineType( l_typ(j) )
           end if
           call DclDrawLine( xline(:,j), yline(:,j) )
        end do
     end if
  end if

!  call DclSetContourLabelFormat(form_typec)
!  call DclSetContourLevel( cont_min, cont_max, (cont_max-cont_min)/10 )
!  call DclDrawContour( contour )

!  call DclDrawVectors( um, vm )

end subroutine

!---------------------------------------------------------

subroutine auto_title( head, time, title, forma, factor, unite )
!  ȯŸ, ưŪ˥դΥȥ
  implicit none
  character(*), intent(in) :: head  ! ȥإå
  integer, intent(in) :: time  ! 
  character(*), intent(inout) :: title  ! 륿ȥ
  character(6), intent(in), optional :: forma  ! ץȤƥեޥå
  integer, intent(in), optional :: factor  ! time factor
  character(*), intent(in), optional :: unite  ! unit
  character(6) :: formb
  character(8) :: tmpname
  integer :: facttime, len_num
  real :: facttime_f

  if(present(forma))then
     formb=forma
  else
     formb='(i8.8)'
  end if

  if(present(factor))then
     if(mod(time,factor)/=0)then
        facttime_f=real(time)/real(factor)
        write(tmpname,formb) facttime_f
write(*,*) "######## facttime", tmpname, facttime_f
     else
        if(formb(2:2)=='f')then  ! եޥåȤ¿ͿƤ
           facttime=time/factor
           write(tmpname,formb) real(facttime)
        else
           facttime=time/factor
           write(tmpname,formb) facttime
        end if
     end if
  else

     facttime=time
write(*,*) "facttiem", facttime, time, formb
     write(tmpname,formb) time

  end if

  len_num=len_trim(tmpname)

  if(present(unite))then
     title=trim(head)//'_(t='//tmpname(1:len_num)//trim(unite)//')"'
  else
     title=trim(head)//'_(t='//tmpname(1:len_num)//'[s])"'
  end if

end subroutine

!---------------------------------------------------------

subroutine tone_bar( color_num, shade_int, vx_int, vy_int,  &
  &                  form_types, mono_log, trigle,  &
  &                  tricmin, tricmax, trifact, col_mem_num, log_flag,  &
  &                  val_spec, dir, title, titles, titlep )
  ! ȡСư.
  use dcl
  implicit none
  integer, intent(in) :: color_num  ! Ѥ뿧ο
  real, intent(in) :: shade_int(2)  ! 顼ξ岼ü
                              ! shade_int(1)=shade_min, shade_int(2)=shade_max
  real, intent(in) :: vx_int(2)  ! ӥ塼ݡȤ x ξü
                                 ! vx_int(1)=vx_min, vx_int(2)=vx_max
  real, intent(in) :: vy_int(2)  ! ӥ塼ݡȤ y ξü
                                 ! vy_int(1)=vy_min, vy_int(2)=vy_max
  character(6), intent(in) :: form_types  ! ٥եޥå
  logical, intent(in), optional :: mono_log
  character(1), intent(in), optional :: trigle  ! grads ʻѷФɤ
                ! [u] = , [d] = , [a] = ξ, ǥեȤǤʤ
  integer, intent(in), optional :: tricmin  ! üѤ顼ޥåֹ 5 
  integer, intent(in), optional :: tricmax  ! üѤ顼ޥåֹ 5 
                ! οꤵƤʤ, color_setting ǥåȤƤ뿧Ȥ褦ˤ.
  real, intent(in), optional :: trifact  ! ѷι⤵ (դƱĹ 1 ȤƤ factor ܤΨ. ǥեȤ 1.)
  integer, intent(in), optional :: col_mem_num  ! ȡСο
  logical, intent(in), optional :: log_flag ! п뤫. ǥեȤ .false.
  real, intent(in), optional :: val_spec(color_num+1)  ! 顼бͤŪ˻ꤹ.
  character(1), intent(in), optional :: dir  ! ȡСθ
                                     ! 'y' = , 't' = ĸ.
                                     ! ǥե = 't'.
  character(*), intent(in), optional :: title  ! 顼Сȥ.
  character(1), intent(in), optional :: titles  ! ȥ¦.
                                     ! 't', 'b', 'r', 'l' = , , , 
                                     ! ǥեȤ Ĥξϱ, ξϲ.
  real, intent(in), optional :: titlep  ! ȥ.
                                     ! dcl Υȥ֤ͤƱ.

!-- ʾ, 
  real :: shade_min  ! Ǿ
  real :: shade_max  ! 
  real :: vx_min  ! ӥ塼ݡȤ x κǾ
  real :: vx_max  ! ӥ塼ݡȤ x κ
  real :: vy_min  ! ӥ塼ݡȤ y κǾ
  real :: vy_max  ! ӥ塼ݡȤ y κ
!-- ʾ, ֤ѿ
  real, parameter :: RMISS=999.0
  integer :: k
  real :: pi(2,color_num+1), pir(color_num+1,2)
  real :: dp, dp_mem
  real :: coldim1(color_num+1), coldim2(color_num/2+1)
  real, allocatable :: col_mem_dim1(:), col_mem_dim2(:)
  logical :: monoto  ! Υȡν
  real, dimension(4) :: triux, triuy, tridx, tridy
  real :: factoru, clev1, clev2
  integer :: tricmin_num, tricmax_num
          ! ¿ѷΰλǤ, ѷĺֺɸ狼Ф褤Τ,
          ! ƺɸ 3 ɬ
  real :: vpx_min, vpx_max, vpy_min, vpy_max  ! ºݤˤȤ viewport, trigle ѥХåե.
  real :: bart
  logical :: log_f
  character(1) :: direction, barp

  call DclSetParm( 'GRAPH:LCLIP', .false. )
!-- ֤ѿ֤
  shade_min=shade_int(1)
  shade_max=shade_int(2)
  vx_min=vx_int(1)
  vx_max=vx_int(2)
  vy_min=vy_int(1)
  vy_max=vy_int(2)

!-- ץν
  if(present(mono_log))then
     monoto=mono_log
  else
     monoto=.false.
  end if

  if(present(dir))then
     direction(1:1)=dir(1:1)
  else
     direction(1:1)='t'
  end if

  if(present(trigle))then
     if(present(trifact))then
        factoru=trifact
     else
        factoru=1.0
     end if

     if(present(tricmin))then
        tricmin_num=tricmin
     else
        CALL DclGetShadeLevel( 1, clev1, clev2, tricmin_num )
        write(*,*) "### downer color is", tricmin_num
     end if

     if(present(tricmax))then
        tricmax_num=tricmax
     else
        CALL DclGetShadeLevel( color_num+2, clev1, clev2, tricmax_num )
        write(*,*) "### upper color is", tricmax_num
     end if

     if(direction=='t')then
        select case(trigle)
        case('a')
           triux(1)=vx_min
           triux(2)=(vx_max+vx_min)*0.5
           triux(3)=vx_max
           triux(4)=triux(1)
           triuy(1)=vy_max-factoru*(vx_max-vx_min)
           triuy(2)=vy_max
           triuy(3)=triuy(1)
           triuy(4)=triuy(1)
           tridx=triux
           tridy(1)=vy_min+factoru*(vx_max-vx_min)
           tridy(2)=vy_min
           tridy(3)=tridy(1)
           tridy(4)=tridy(1)
           vpy_min=tridy(1)
           vpy_max=triuy(1)
        case('u')
           triux(1)=vx_min
           triux(2)=(vx_max+vx_min)*0.5
           triux(3)=vx_max
           triux(4)=triux(1)
           triuy(1)=vy_max-factoru*(vx_max-vx_min)
           triuy(2)=vy_max
           triuy(3)=triuy(1)
           triuy(4)=triuy(1)
           vpy_min=vy_min
           vpy_max=triuy(1)
        case('d')
           tridx(1)=vx_min
           tridx(2)=(vx_max+vx_min)*0.5
           tridx(3)=vx_max
           tridx(4)=tridx(1)
           tridy(1)=vy_min+factoru*(vx_max-vx_min)
           tridy(2)=vy_min
           tridy(3)=tridy(1)
           tridy(4)=tridy(1)
           vpy_min=tridy(1)
           vpy_max=vy_max
        case default
           vpy_min=vy_min
           vpy_max=vy_max
        end select

        vpx_min=vx_min
        vpx_max=vx_max

     else
        select case(trigle)
        case('a')
           triuy(1)=vy_min
           triuy(2)=(vy_max+vy_min)*0.5
           triuy(3)=vy_max
           triuy(4)=triuy(1)
           triux(1)=vx_max-factoru*(vy_max-vy_min)
           triux(2)=vx_max
           triux(3)=triux(1)
           triux(4)=triux(1)
           tridy=triuy
           tridx(1)=vx_min+factoru*(vy_max-vy_min)
           tridx(2)=vx_min
           tridx(3)=tridx(1)
           tridx(4)=tridx(1)
           vpx_min=tridx(1)
           vpx_max=triux(1)
        case('u')
           triuy(1)=vy_min
           triuy(2)=(vy_max+vy_min)*0.5
           triuy(3)=vy_max
           triuy(4)=triuy(1)
           triux(1)=vx_max-factoru*(vy_max-vy_min)
           triux(2)=vx_max
           triux(3)=triux(1)
           triux(4)=triux(1)
           vpx_min=vx_min
           vpx_max=triux(1)
        case('d')
           tridy(1)=vy_min
           tridy(2)=(vy_max+vy_min)*0.5
           tridy(3)=vy_max
           tridy(4)=tridy(1)
           tridx(1)=vx_min+factoru*(vy_max-vy_min)
           tridx(2)=vx_min
           tridx(3)=tridx(1)
           tridx(4)=tridx(1)
           vpx_min=tridx(1)
           vpx_max=vx_max
        case default
           vpx_min=vx_min
           vpx_max=vx_max
        end select

        vpy_min=vy_min
        vpy_max=vy_max

     end if

  else

     vpx_min=vx_min
     vpx_max=vx_max
     vpy_min=vy_min
     vpy_max=vy_max

  end if

  if(present(log_flag))then
     log_f=log_flag
  else
     log_f=.false.
  end if

  if(present(dir))then
     direction=dir(1:1)
  else
     direction='t'
  end if

  if(present(titles))then
     barp=titles(1:1)
  else
     if(direction=='t')then
        barp='l'
     else
        barp='b'
     end if
  end if

  if(present(titlep))then
     bart=titlep
  else
     bart=0.0
  end if

!-- ޤ

  call DclNewFig
  if(direction=='t')then
     call DclSetWindow( 0.0, 1.0, shade_min, shade_max )
  else
     call DclSetWindow( shade_min, shade_max, 0.0, 1.0 )
  end if
  call DclSetViewPort( vpx_min, vpx_max, vpy_min, vpy_max )
  if(log_f.eqv..true.)then
     if(direction=='t')then
        call GRSTRN(2)  ! Ĥξ y п
     else
        call GRSTRN(3)  ! ξ x п
     end if
  !-- ۿ
     dp = (log10(shade_max)-log10(shade_min))/color_num
     do k=1,color_num+1
        PI(1,K) = shade_min * 10.0**(DP*(K-1))
        PI(2,K) = PI(1,K)
     end do
  else
     call GRSTRN(1)
  !-- ۿ
     dp = (shade_max-shade_min)/color_num
     do k=1,color_num+1
        PI(1,K) = shade_min + DP * (K-1)
        PI(2,K) = PI(1,K)
     end do
  end if

  if(present(val_spec))then
     do k=1,color_num+1
        PI(1,k)=val_spec(k)
        PI(2,k)=val_spec(k)
     end do
  end if

  call DclSetTransFunction

  if(direction=='y')then  ! ξ, ؤ
     PIr(:,1)=PI(1,:)
     PIr(:,2)=PI(2,:)
  end if

  if(direction=='t')then
     call DclSetXGrid( (/0.0,1.0/) )
     call DclSetYGrid( PI(1,:) )
  else
     call DclSetXGrid( PI(1,:) )
     call DclSetYGrid( (/0.0,1.0/) )
  end if

  if(monoto.eqv..true.)then
     call DclSetParm('ENABLE_SOFTFILL',.true.)
     if(direction=='t')then
        call DclShadeContour( PI )
     else
        call DclShadeContour( PIr )
     end if
  else
     call DclSetParm('ENABLE_SOFTFILL',.false.)
     if(direction=='t')then
        call DclShadeContourEx( PI )
     else
        call DclShadeContourEx( PIr )
     end if
  end if

  CALL SLPVPR( 3 )
  CALL UZLSET( 'LABELYR', .TRUE. )
  CALL UZLSET( 'LABELYL', .FALSE. )
  CALL UYSFMT( form_types )

!-- ȡĴ.
  if(present(col_mem_num))then

     allocate(col_mem_dim1(col_mem_num+1))
     allocate(col_mem_dim2(col_mem_num/2+1))

     if(log_f.eqv..true.)then
        dp_mem=(log10(shade_max)-log10(shade_min))/col_mem_num
        do k=1,col_mem_num+1
           col_mem_dim1(k)=shade_min*10.0**(dp_mem*(k-1))
        end do
        do k=1,col_mem_num/2+1
           col_mem_dim2(k)=shade_min*10.0**(dp_mem*(2*(k-1)))
        end do
     else
        dp_mem=(shade_max-shade_min)/col_mem_num
        do k=1,col_mem_num+1
           col_mem_dim1(k)=shade_min+(k-1)*dp_mem
        end do
        do k=1,col_mem_num/2+1
           col_mem_dim2(k)=shade_min+2*(k-1)*dp_mem
        end do
     end if

     if(direction=='t')then
        CALL UYAXNM( 'R', col_mem_dim1, col_mem_num+1, col_mem_dim2,  &
  &                  col_mem_num/2+1 )
        CALL UYAXNM( 'L', col_mem_dim1, col_mem_num+1, col_mem_dim2,  &
  &                  col_mem_num/2+1 )
     else
        CALL UXAXNM( 'T', col_mem_dim1, col_mem_num+1, col_mem_dim2,  &
  &                  col_mem_num/2+1 )
        CALL UXAXNM( 'B', col_mem_dim1, col_mem_num+1, col_mem_dim2,  &
  &                  col_mem_num/2+1 )
     end if

     deallocate(col_mem_dim1)
     deallocate(col_mem_dim2)

  else

     if(present(val_spec))then
        do k=1,color_num+1
           coldim1(k)=val_spec(k)
        end do
        do k=1,color_num/2+1
           coldim2(k)=val_spec(2*k-1)
        end do
     else
        do k=1,color_num+1
           coldim1(k)=PI(1,k)
        end do
        do k=1,color_num/2+1
           coldim2(k)=PI(1,2*k-1)
        end do
     end if

     if(direction=='t')then
        CALL UYAXNM( 'R', coldim1, color_num+1, coldim2, color_num/2+1 )
        CALL UYAXNM( 'L', coldim1, color_num+1, coldim2, color_num/2+1 )
     else
        CALL UXAXNM( 'T', coldim1, color_num+1, coldim2, color_num/2+1 )
        CALL UXAXNM( 'B', coldim1, color_num+1, coldim2, color_num/2+1 )
     end if

  end if

!-- ºݤ˻ѷΰ
  if(present(trigle))then
     select case(trigle)
     case('a')
        call DclShadeRegionNormalized( triux, triuy, tricmax_num )
        call DclShadeRegionNormalized( tridx, tridy, tricmin_num )
        call DclDrawLineNormalized( triux, triuy, index=13 )
        call DclDrawLineNormalized( tridx, tridy, index=13 )
     case('u')
        call DclShadeRegionNormalized( triux, triuy, tricmax_num )
        call DclDrawLineNormalized( triux, triuy, index=13 )
     case('d')
        call DclShadeRegionNormalized( tridx, tridy, tricmin_num )
        call DclDrawLineNormalized( tridx, tridy, index=13 )
     end select
write(*,*) "Map case check, triux, triuy, tridx, tridy"
write(*,*) triux, triuy, tridx, tridy 
  end if

  if(present(title))then
     call DclDrawTitle( barp, trim(title), bart )
  end if

!  CALL UYAXDV( 'R', (shade_max-shade_min)/real(color_num), (shade_max-shade_min)/real(0.5*color_num) )
!  CALL UYAXDV( 'L', (shade_max-shade_min)/real(color_num), (shade_max-shade_min)/real(0.5*color_num) )

end subroutine

!---------------------------------------------------------

!!!!!!!!!!!! ʲ 1 롼Ϲ
subroutine tone_bar_manual( color_num, shade_int, vx_int, vy_int,  &
  &                         form_types, mono_log, trigle,  &
  &                         tricmin, tricmax, trifact, col_mem_num,  &
  &                         val_spec, dir, title, titles, titlep, frame )
  ! ȡСư.
  use dcl
  implicit none
  integer, intent(in) :: color_num  ! Ѥ뿧ο
  real, intent(in) :: shade_int(2)  ! 顼ξ岼ü
                              ! shade_int(1)=shade_min, shade_int(2)=shade_max
  real, intent(in) :: vx_int(2)  ! ӥ塼ݡȤ x ξü
                                 ! vx_int(1)=vx_min, vx_int(2)=vx_max
  real, intent(in) :: vy_int(2)  ! ӥ塼ݡȤ y ξü
                                 ! vy_int(1)=vy_min, vy_int(2)=vy_max
  character(6), intent(in) :: form_types  ! ٥եޥå
  logical, intent(in), optional :: mono_log
  character(1), intent(in), optional :: trigle  ! grads ʻѷФɤ
                ! [u] = , [d] = , [a] = ξ, ǥեȤǤʤ
  integer, intent(in), optional :: tricmin  ! üѤ顼ޥåֹ 5 
  integer, intent(in), optional :: tricmax  ! üѤ顼ޥåֹ 5 
                ! οꤵƤʤ, color_setting ǥåȤƤ뿧Ȥ褦ˤ.
  real, intent(in), optional :: trifact  ! ѷι⤵ (դƱĹ 1 ȤƤ factor ܤΨ. ǥեȤ 1.)
  integer, intent(in), optional :: col_mem_num  ! ȡСο
  real, intent(in), optional :: val_spec(color_num+1)  ! 顼бͤŪ˻ꤹ.
  character(1), intent(in), optional :: dir  ! ȡСθ
                                     ! 'y' = , 't' = ĸ.
                                     ! ǥե = 't'.
  character(*), intent(in), optional :: title  ! 顼Сȥ.
  character(1), intent(in), optional :: titles  ! ȥ¦.
                                     ! 't', 'b', 'r', 'l' = , , , 
                                     ! ǥեȤ Ĥξϱ, ξϲ.
  real, intent(in), optional :: titlep  ! ȥ.
                                     ! dcl Υȥ֤ͤƱ.
  logical, intent(in), optional :: frame  ! СȤ뤫ɤ.
                                     ! ǥեȤ .true. .

!-- ʾ, 
  real :: shade_min  ! Ǿ
  real :: shade_max  ! 
  real :: vx_min  ! ӥ塼ݡȤ x κǾ
  real :: vx_max  ! ӥ塼ݡȤ x κ
  real :: vy_min  ! ӥ塼ݡȤ y κǾ
  real :: vy_max  ! ӥ塼ݡȤ y κ
!-- ʾ, ֤ѿ
  real, parameter :: RMISS=999.0
  integer :: k
  real :: pi(2,color_num+1), pir(color_num+1,2)
  real :: dp, dp_mem
  real :: coldim1(color_num+1), coldim2(color_num/2+1)
  real, allocatable :: col_mem_dim1(:), col_mem_dim2(:)
  logical :: monoto  ! Υȡν
  real, dimension(4) :: triux, triuy, tridx, tridy
  real, dimension(4) :: cvx, cvy
  real :: factoru, clev1, clev2
  integer :: tricmin_num, tricmax_num
          ! ¿ѷΰλǤ, ѷĺֺɸ狼Ф褤Τ,
          ! ƺɸ 3 ɬ
  real :: vpx_min, vpx_max, vpy_min, vpy_max  ! ºݤˤȤ viewport, trigle ѥХåե.
  real :: bart
  logical :: frame_log
  character(1) :: direction, barp

  call DclSetParm( 'GRAPH:LCLIP', .false. )
!-- ֤ѿ֤
  shade_min=shade_int(1)
  shade_max=shade_int(2)
  vx_min=vx_int(1)
  vx_max=vx_int(2)
  vy_min=vy_int(1)
  vy_max=vy_int(2)

!-- ץν
  if(present(mono_log))then
     monoto=mono_log
  else
     monoto=.false.
  end if

  if(present(dir))then
     direction(1:1)=dir(1:1)
  else
     direction(1:1)='t'
  end if

  if(present(frame))then
     frame_log=frame
  else
     frame_log=.true.
  end if

  if(present(trigle))then
     if(present(trifact))then
        factoru=trifact
     else
        factoru=1.0
     end if

     if(present(tricmin))then
        tricmin_num=tricmin
     else
        CALL DclGetShadeLevel( 1, clev1, clev2, tricmin_num )
        write(*,*) "### downer color is", tricmin_num
     end if

     if(present(tricmax))then
        tricmax_num=tricmax
     else
        CALL DclGetShadeLevel( color_num+2, clev1, clev2, tricmax_num )
        write(*,*) "### upper color is", tricmax_num
     end if

     if(direction=='t')then
        select case(trigle)
        case('a')
           triux(1)=vx_min
           triux(2)=(vx_max+vx_min)*0.5
           triux(3)=vx_max
           triux(4)=triux(1)
           triuy(1)=vy_max-factoru*(vx_max-vx_min)
           triuy(2)=vy_max
           triuy(3)=triuy(1)
           triuy(4)=triuy(1)
           tridx=triux
           tridy(1)=vy_min+factoru*(vx_max-vx_min)
           tridy(2)=vy_min
           tridy(3)=tridy(1)
           tridy(4)=tridy(1)
           vpy_min=tridy(1)
           vpy_max=triuy(1)
        case('u')
           triux(1)=vx_min
           triux(2)=(vx_max+vx_min)*0.5
           triux(3)=vx_max
           triux(4)=triux(1)
           triuy(1)=vy_max-factoru*(vx_max-vx_min)
           triuy(2)=vy_max
           triuy(3)=triuy(1)
           triuy(4)=triuy(1)
           vpy_min=vy_min
           vpy_max=triuy(1)
        case('d')
           tridx(1)=vx_min
           tridx(2)=(vx_max+vx_min)*0.5
           tridx(3)=vx_max
           tridx(4)=tridx(1)
           tridy(1)=vy_min+factoru*(vx_max-vx_min)
           tridy(2)=vy_min
           tridy(3)=tridy(1)
           tridy(4)=tridy(1)
           vpy_min=tridy(1)
           vpy_max=vy_max
        case default
           vpy_min=vy_min
           vpy_max=vy_max
        end select

        vpx_min=vx_min
        vpx_max=vx_max

     else
        select case(trigle)
        case('a')
           triuy(1)=vy_min
           triuy(2)=(vy_max+vy_min)*0.5
           triuy(3)=vy_max
           triuy(4)=triuy(1)
           triux(1)=vx_max-factoru*(vy_max-vy_min)
           triux(2)=vx_max
           triux(3)=triux(1)
           triux(4)=triux(1)
           tridy=triuy
           tridx(1)=vx_min+factoru*(vy_max-vy_min)
           tridx(2)=vx_min
           tridx(3)=tridx(1)
           tridx(4)=tridx(1)
           vpx_min=tridx(1)
           vpx_max=triux(1)
        case('u')
           triuy(1)=vy_min
           triuy(2)=(vy_max+vy_min)*0.5
           triuy(3)=vy_max
           triuy(4)=triuy(1)
           triux(1)=vx_max-factoru*(vy_max-vy_min)
           triux(2)=vx_max
           triux(3)=triux(1)
           triux(4)=triux(1)
           vpx_min=vx_min
           vpx_max=triux(1)
        case('d')
           tridy(1)=vy_min
           tridy(2)=(vy_max+vy_min)*0.5
           tridy(3)=vy_max
           tridy(4)=tridy(1)
           tridx(1)=vx_min+factoru*(vy_max-vy_min)
           tridx(2)=vx_min
           tridx(3)=tridx(1)
           tridx(4)=tridx(1)
           vpx_min=tridx(1)
           vpx_max=vx_max
        case default
           vpx_min=vx_min
           vpx_max=vx_max
        end select

        vpy_min=vy_min
        vpy_max=vy_max

     end if

  else

     vpx_min=vx_min
     vpx_max=vx_max
     vpy_min=vy_min
     vpy_max=vy_max

  end if

  if(present(dir))then
     direction=dir(1:1)
  else
     direction='t'
  end if

  if(present(titles))then
     barp=titles(1:1)
  else
     if(direction=='t')then
        barp='l'
     else
        barp='b'
     end if
  end if

  if(present(titlep))then
     bart=titlep
  else
     bart=0.0
  end if

!-- ޤ

  call DclNewFig
  if(direction=='t')then
     call DclSetWindow( 0.0, 1.0, shade_min, shade_max )
  else
     call DclSetWindow( shade_min, shade_max, 0.0, 1.0 )
  end if
  call DclSetViewPort( vpx_min, vpx_max, vpy_min, vpy_max )
     if(direction=='t')then
        call GRSTRN(2)  ! Ĥξ y п
     else
        call GRSTRN(3)  ! ξ x п
     end if
  !-- ۿ
     dp = (log10(shade_max)-log10(shade_min))/color_num
     do k=1,color_num+1
        PI(1,K) = shade_min * 10.0**(DP*(K-1))
        PI(2,K) = PI(1,K)
     end do

  if(present(val_spec))then
     do k=1,color_num+1
        PI(1,k)=val_spec(k)
        PI(2,k)=val_spec(k)
     end do
  end if

  call DclSetTransFunction

  if(direction=='y')then  ! ξ, ؤ
     PIr(:,1)=PI(1,:)
     PIr(:,2)=PI(2,:)
  end if

  if(direction=='t')then
     call DclSetXGrid( (/0.0,1.0/) )
     call DclSetYGrid( PI(1,:) )
  else
     call DclSetXGrid( PI(1,:) )
     call DclSetYGrid( (/0.0,1.0/) )
  end if

  if(monoto.eqv..true.)then
     call DclSetParm('ENABLE_SOFTFILL',.true.)
     if(direction=='t')then
        call DclShadeContour( PI )
     else
        call DclShadeContour( PIr )
     end if
  else
     call DclSetParm('ENABLE_SOFTFILL',.false.)
     if(direction=='t')then
        call DclShadeContourEx( PI )
     else
        call DclShadeContourEx( PIr )
     end if
  end if

  CALL SLPVPR( 3 )
  CALL UZLSET( 'LABELYR', .TRUE. )
  CALL UZLSET( 'LABELYL', .FALSE. )
  CALL UYSFMT( form_types )

!-- ȡĴ.
  if(present(col_mem_num))then

     allocate(col_mem_dim1(col_mem_num+1))
     allocate(col_mem_dim2(col_mem_num/2+1))

        dp_mem=(shade_max-shade_min)/col_mem_num
        do k=1,col_mem_num+1
           col_mem_dim1(k)=shade_min+(k-1)*dp_mem
        end do
        do k=1,col_mem_num/2+1
           col_mem_dim2(k)=shade_min+2*(k-1)*dp_mem
        end do

     if(direction=='t')then
        CALL UYAXNM( 'R', col_mem_dim1, col_mem_num+1, col_mem_dim2,  &
  &                  col_mem_num/2+1 )
        CALL UYAXNM( 'L', col_mem_dim1, col_mem_num+1, col_mem_dim2,  &
  &                  col_mem_num/2+1 )
     else
        CALL UXAXNM( 'T', col_mem_dim1, col_mem_num+1, col_mem_dim2,  &
  &                  col_mem_num/2+1 )
        CALL UXAXNM( 'B', col_mem_dim1, col_mem_num+1, col_mem_dim2,  &
  &                  col_mem_num/2+1 )
     end if

     deallocate(col_mem_dim1)
     deallocate(col_mem_dim2)

  else

     if(present(val_spec))then
        do k=1,color_num+1
           coldim1(k)=val_spec(k)
        end do
        do k=1,color_num/2+1
           coldim2(k)=val_spec(2*k-1)
        end do
     else
        do k=1,color_num+1
           coldim1(k)=PI(1,k)
        end do
        do k=1,color_num/2+1
           coldim2(k)=PI(1,2*k-1)
        end do
     end if

     if(direction=='t')then
        CALL UYAXNM( 'R', coldim1, color_num+1, coldim2, color_num/2+1 )
        CALL UYAXNM( 'L', coldim1, color_num+1, coldim2, color_num/2+1 )
     else
        CALL UXAXNM( 'T', coldim1, color_num+1, coldim2, color_num/2+1 )
        CALL UXAXNM( 'B', coldim1, color_num+1, coldim2, color_num/2+1 )
     end if

  end if

!-- ºݤ˻ѷΰ
  if(present(trigle))then
     select case(trigle)
     case('a')
        call DclShadeRegionNormalized( triux, triuy, tricmax_num )
        call DclShadeRegionNormalized( tridx, tridy, tricmin_num )
        if(frame_log.eqv..true.)then
           call DclDrawLineNormalized( triux, triuy, index=13 )
           call DclDrawLineNormalized( tridx, tridy, index=13 )
        end if
     case('u')
        call DclShadeRegionNormalized( triux, triuy, tricmax_num )
        if(frame_log.eqv..true.)then
           call DclDrawLineNormalized( triux, triuy, index=13 )
        end if
     case('d')
        call DclShadeRegionNormalized( tridx, tridy, tricmin_num )
        if(frame_log.eqv..true.)then
           call DclDrawLineNormalized( tridx, tridy, index=13 )
        end if
     end select
write(*,*) "Map case check, triux, triuy, tridx, tridy"
write(*,*) triux, triuy, tridx, tridy 
  end if

  if(present(title))then
     call DclDrawTitle( barp, trim(title), bart )
  end if

!  CALL UYAXDV( 'R', (shade_max-shade_min)/real(color_num), (shade_max-shade_min)/real(0.5*color_num) )
!  CALL UYAXDV( 'L', (shade_max-shade_min)/real(color_num), (shade_max-shade_min)/real(0.5*color_num) )

end subroutine

!-----------------------------------------------------------

subroutine undef_CReSS2Dcl( nx, ny, nz, val )  ! CReSS ̤ͤ Dcl ̤ͤѴ롼
  !  3 Ǥ뤬, ǿ 1 ʤɤꤹ뤳Ȥ,
  ! 1, 2 ФƤѴǽ.
  use dcl
  implicit none
  integer, intent(in) :: nx  !  1 Ǥǿ
  integer, intent(in) :: ny  !  2 Ǥǿ
  integer, intent(in) :: nz  !  3 Ǥǿ
  real, intent(inout) :: val(nx,ny,nz)  ! Ѵ
  integer :: i, j, k  ! 
  real :: RMISS, undef  ! ̤

!-- »ͽ ---
!-- Dcl ¦ undef ͥå
      CALL GLRGET( 'RMISS', RMISS )
      CALL GLLSET( 'LMISS', .TRUE. )

!-- CReSS ¦ undef ͥå
      call undef_get( undef )
!write(*,*) "undef=", undef

  do k=1,nz
  do j=1,ny
     do i=1,nx
        if(val(i,j,k)/=val(i,j,k))then
           val(i,j,k)=-999.0
        else if(val(i,j,k)==undef)then
           val(i,j,k)=-999.0
!           val(i,j,k)=RMISS
        end if
     end do
  end do
  end do
    

end subroutine

!--------------------------------------------------------

subroutine nan_val( nx, ny, nz, undef, val )  ! val  nan ͤ undef ؤ.
  !  3 Ǥ뤬, ǿ 1 ʤɤꤹ뤳Ȥ,
  ! 1, 2 ФƤѴǽ.
  implicit none
  integer, intent(in) :: nx  !  1 Ǥǿ
  integer, intent(in) :: ny  !  2 Ǥǿ
  integer, intent(in) :: nz  !  3 Ǥǿ
  real, intent(in) :: undef  ! ̤
  real, intent(inout) :: val(nx,ny,nz)  ! Ѵ
  integer :: i, j, k  ! 

  do k=1,nz
     do j=1,ny
        do i=1,nx
!!           if(isnan(val(i,j,k)))then
           if(val(i,j,k)/=val(i,j,k))then   ! isnan ؿʤȤθ.
              val(i,j,k)=undef
           end if
        end do
     end do
  end do
    

end subroutine

!--------------------------------------------------------

subroutine color_setting( color_num, val_int, col_tab,   &
  &                       col_max, col_min, col_bg, reverse,  &
  &                       min_tab, max_tab, log_flag,  &
  &                       col_spec, val_spec )
  ! 顼ޥåפοȿͤб뼫ư롼
  use dcl
  implicit none
  integer, intent(in) :: color_num  ! Ѥ륫顼μ
  real, intent(in) :: val_int(2)  ! 顼ξ岼ü
                      ! val_int(1)=val_min, val_int(2)=val_max
  integer, intent(in), optional :: col_tab  ! dcl Υ顼ơ֥
  integer, intent(in), optional :: col_min  ! Ѥ륫顼ֹκǾ(2)
  integer, intent(in), optional :: col_max  ! Ѥ륫顼ֹκ(2)
  logical, intent(in), optional :: col_bg  ! طʿؤ ǥեȤʤ.
  integer :: map_num  ! 顼ޥåפΥޥåֹ (optional °Ĥ뤳)
  integer :: i, j, k  ! ź
  logical, intent(in), optional :: reverse  ! 顼ֹȿž.
  integer, intent(in), optional :: min_tab  ! val_min ʲͤб륫顼ֹ, ǥեȤϹ
  integer, intent(in), optional :: max_tab  ! val_max ʾͤб륫顼ֹ, ǥեȤϹ
  logical, intent(in), optional :: log_flag ! п뤫. ǥեȤ .false.
  integer, intent(in), optional :: col_spec(color_num)  ! val_spec ǻꤵ줿ͤб顼ֹ
  real, intent(in), optional :: val_spec(color_num+1)  ! 顼бͤŪ˻ꤹ.
!-- ʾ, 
  real :: val_min  ! 顼κǾ
  real :: val_max  ! 顼κ
!-- ʾ, ֤ѿ
  integer :: ipat, iws
  real :: dv  ! 顼ޥåפбͤ
  integer :: cmap_min, cmap_max
  real :: tlev1, tlev2
  logical :: rev, log_f, lfcart
  real :: white_min, black_max
  real :: RMISS
  integer :: white, black, ITON

!-- ֤ѿ֤
  val_min=val_int(1)
  val_max=val_int(2)

!-- Dcl ¦ undef ͥå
  CALL GLRGET( 'RMISS', RMISS )
  CALL GLLSET( 'LMISS', .TRUE. )

!-- 顼ޥåץ󥸤Υե饰
  CALL SWLSET( 'LCMCH', .TRUE. )

  if(present(col_tab))then
     map_num=col_tab
  else
     map_num=1
  end if

  if(present(col_min))then
     cmap_min=col_min
  else
     cmap_min=14
  end if

  if(present(col_max))then
     cmap_max=col_max
  else
     cmap_max=85
  end if

  if(present(col_bg))then
     call SWpSET( 'LFGBG', col_bg )     
  end if

  if(present(reverse))then
     rev=reverse
  else
     rev=.false.
  end if

  if(present(min_tab))then
     white=min_tab
  else
     white=999
  end if

  if(present(max_tab))then
     black=max_tab
  else
     black=1999
  end if

!-- back color is white flag. Ver.5.4.2

!  if(black==999.or.white==999)then
!     call DclSetParm( 'LCLCNV' , .FALSE. )
!  end if

!!-- back color is white flag. Ver.6.0.0
!!  if(black==999)then
!!     call SGIGET( 'IBGCLI', black )
!!     black=black*1000+999
!!  end if
!!  if(white==999)then
!!     call SGIGET( 'IBGCLI', white )
!!     white=white*1000+999
!!  end if

  if(black==999)then
     call SGIGET( 'IBGCLI', black )
     black=black*1000+999
  end if
  if(white==999)then
     call SGIGET( 'IBGCLI', white )
     white=white*1000+999
  end if

  call sgscmn(map_num)

  call UEITLV

!-- п뤫Υե饰
  if(present(log_flag))then
     log_f=log_flag
  else
     log_f=.false.
  end if
  if(log_f.eqv..true.)then
     if(val_min<0.0.or.val_max<0.0)then
        write(*,*) "### ERROR ### (color_setting)"
        write(*,*) "val_min and val_max must be more than zero."
        write(*,*) "STOP"
        stop
     end if
  end if

!-- val_max ʾ black ɤ
  TLEV1=RMISS
  TLEV2=val_min
  IPAT=white

!!  CALL DclSetShadeLevel( TLEV1, TLEV2, 999 )
  CALL DclSetShadeLevel( TLEV1, TLEV2, IPAT )
!  CALL UEQTLV( TLEV1, TLEV2, IPAT, color_num+2 )
!  write(*,*) TLEV1, TLEV2, IPAT

  if(log_f.eqv..true.)then
     dv=(log10(val_max)-log10(val_min))/color_num
  else
     dv=(val_max-val_min)/color_num
  end if

  if(rev.eqv..true.)then
     do k=1,color_num
        if(log_f.eqv..true.)then
           TLEV1=val_min*10.0**(dv*(k-1))
           TLEV2=val_min*10.0**(dv*(k))
!           TLEV2=TLEV1*dv
        else
           TLEV1=val_min+(k-1)*dv
           TLEV2=TLEV1+dv
        end if
        IPAT=(cmap_min+int((color_num-k)*(real(cmap_max-cmap_min)/real(color_num-1))))*1000+999
        CALL DclSetShadeLevel( TLEV1, TLEV2, IPAT )
!        CALL UEQTLV( TLEV1, TLEV2, IPAT, k )
!        write(*,*) TLEV1, TLEV2, IPAT
     end do
  else
     do k=1,color_num
        if(present(val_spec))then
           TLEV1=val_spec(k)
           TLEV2=val_spec(k+1)
           if(present(col_spec))then
              IPAT=col_spec(k)
           else
              IPAT=(cmap_min+int((k-1)*(real(cmap_max-cmap_min)/real(color_num-1))))*1000+999
           end if
        else
           if(log_f.eqv..true.)then
              TLEV1=val_min*10.0**(dv*(k-1))
              TLEV2=val_min*10.0**(dv*(k))
!              TLEV2=TLEV1*dv
           else
              TLEV1=val_min+(k-1)*dv
              TLEV2=TLEV1+dv
           end if
           IPAT=(cmap_min+int((k-1)*(real(cmap_max-cmap_min)/real(color_num-1))))*1000+999
        end if

        CALL DclSetShadeLevel( TLEV1, TLEV2, IPAT )
!        CALL UEQTLV( TLEV1, TLEV2, IPAT, k )
!        write(*,*) TLEV1, TLEV2, IPAT
     end do
  end if

  TLEV1=val_max
  TLEV2=RMISS
  IPAT=black
  CALL DclSetShadeLevel( TLEV1, TLEV2, IPAT )
!  CALL UEQTLV( TLEV1, TLEV2, IPAT, color_num+1 )
  write(*,*) TLEV1, TLEV2, IPAT

end subroutine

!---------------------------------------------------

subroutine contour_setting( contour_num, val_int, col_tab,   &
  &                         col_max, col_min,  &
  &                         log_flag, col_spec, val_spec, formc )
  ! 󥿡ȿͤб뼫ư롼
  use dcl
  implicit none
  integer, intent(in) :: contour_num  ! Ѥο
  real, intent(in) :: val_int(2)  ! ξ岼ü
                      ! val_int(1)=val_min, val_int(2)=val_max
  integer, intent(in), optional :: col_tab  ! dcl Υ顼ơ֥
  integer, intent(in), optional :: col_min  ! Ѥ륫顼ֹκǾ(2)
  integer, intent(in), optional :: col_max  ! Ѥ륫顼ֹκ(2)
  logical, intent(in), optional :: log_flag ! п뤫. ǥեȤ .false.
  integer, intent(in), optional :: col_spec(contour_num)  ! val_spec ǻꤵ줿ͤб顼ֹ
  real, intent(in), optional :: val_spec(contour_num+1)  ! бͤŪ˻ꤹ.
  character(*), intent(in), optional :: formc  ! Υ٥եޥå.
!-- ʾ, 
  integer :: map_num  ! 顼ޥåפΥޥåֹ (optional °Ĥ뤳)
  integer :: i, j, k  ! ź
  real :: val_min  ! 顼κǾ
  real :: val_max  ! 顼κ
!-- ʾ, ֤ѿ
  integer :: ipat, iws
  integer :: cmap_min, cmap_max
  real :: dv  ! 顼ޥåפбͤ
  real :: tlev1, tlev2, tmpsiz
  logical :: log_f, lfcart
  integer :: aidx, ptype, ntype, tmptyp
  character(8) :: labelc, forma

!-- ֤ѿ֤
  val_min=val_int(1)
  val_max=val_int(2)

!-- Dcl ¦ undef ͥå
!  CALL GLRGET( 'RMISS', RMISS )
!  CALL GLLSET( 'LMISS', .TRUE. )

!-- 顼ޥåץ󥸤Υե饰
  CALL SWLSET( 'LCMCH', .TRUE. )

  if(present(col_tab))then
     map_num=col_tab
  else
     map_num=1
  end if

  if(present(col_min))then
     cmap_min=col_min
  else
     cmap_min=14
  end if

  if(present(col_max))then
     cmap_max=col_max
  else
     cmap_max=85
  end if

  if(present(formc))then
     forma=trim(adjustl(formc))
  else
     forma='(f8.1)'
  end if

  aidx=DclGetLineIndex()

  ptype=DclGetLineType( )
  call DclGetParm( 'IDASH', ntype )
  call DclGetParm( 'RSIZEL', tmpsiz )

  call sgscmn(map_num)

!  call UEITLV

!-- п뤫Υե饰
  if(present(log_flag))then
     log_f=log_flag
  else
     log_f=.false.
  end if
  if(log_f.eqv..true.)then
     if(val_min<0.0.or.val_max<0.0)then
        write(*,*) "### ERROR ### (color_setting)"
        write(*,*) "val_min and val_max must be more than zero."
        write(*,*) "STOP"
        stop
     end if
  end if

  if(log_f.eqv..true.)then
     dv=(log10(val_max)-log10(val_min))/contour_num
  else
     dv=(val_max-val_min)/contour_num
  end if

  do k=1,contour_num+1
     if(present(val_spec))then
        TLEV1=val_spec(k)
        if(present(col_spec))then
           IPAT=col_spec(k)
        else
           IPAT=(cmap_min+int((k-1)*(real(cmap_max-cmap_min)/real(contour_num-1))))*10+aidx
        end if
     else
        if(log_f.eqv..true.)then
           TLEV1=val_min*10.0**(dv*(k-1))
        else
           TLEV1=val_min+(k-1)*dv
        end if
        if(present(col_spec))then
           IPAT=col_spec(k)
        else
           IPAT=(cmap_min+int((k-1)*(real(cmap_max-cmap_min)/real(contour_num-1))))*10+aidx
        end if
     end if

!-- [NOTE] : DclSetContourLine  label, height Ȥ˥ץΥǥեͤ
!            ''  0.0 ʤΤ, Υץ"ξ"ꤷʤ,
!            ˥٥뤬ʤ.
     write(labelc,trim(adjustl(forma))) TLEV1
     if(TLEV1<0.0)then
        tmptyp=ntype
     else
        tmptyp=ptype
     end if
     call DclSetContourLine( TLEV1, index=IPAT, type=tmptyp,  &
  &                          label=labelc(1:8), height=tmpsiz )
  end do

end subroutine

!---------------------------------------------------

subroutine monotone_setting( ton_tab, val_int, nega_ton_tab,  &
  &                          full_tone )
! color_setting ΥΥȡС
! ȡơ֥ȴ 5 षʤΤ, val_min, val_max Ū 5 ʬ䤷, ȡƤϤ.
! ޤ, nega_ton_tab ꤵƤ, 10 ʬ䤹.
  use dcl
  implicit none
  integer, intent(in), optional :: ton_tab  ! dcl Υȡơ֥
  real, intent(in) :: val_int(2)  ! 顼ξ岼ü
                      ! val_int(1)=val_min, val_int(2)=val_max
  integer, intent(in), optional :: nega_ton_tab  ! ȡơ֥ 2 ȤȤ, ͤξΰ˸äǻƤ˻. Υȡ 0 ǻƤ.
  logical, intent(in), optional :: full_tone  ! 碌, ƥȡ 6 ʳΤ, val_min, val_max κŪ 6 ʬ䤷ƥȡƤ. , 򤹤, ȡζͤڤΤ褤ͤˤʤʤ. ͤ .true. ͭȤʤ.
!-- ʾ, 
  real :: val_min  ! 顼κǾ
  real :: val_max  ! 顼κ
!-- ʾ, ֤ѿ
  integer :: map_num  ! 顼ޥåפΥޥåֹ (optional °Ĥ뤳)
  integer :: i, j, k  ! ź
  integer :: ipat, itvtone, tone_mapping
  real :: dv  ! 顼ޥåפбͤ
  integer :: cmap_min, cmap_max
  real :: tlev1, tlev2

!-- ֤ѿ֤
  val_min=val_int(1)
  val_max=val_int(2)

  call UEITLV

  if(present(nega_ton_tab))then
     if(present(full_tone))then
        if(full_tone.eqv..true.)then
           itvtone=12
        else
           itvtone=10
        end if
     else
        itvtone=10
     end if
  else
     if(present(full_tone))then
        if(full_tone.eqv..true.)then
           itvtone=6
        else
           itvtone=5
        end if
     else
        itvtone=5
     end if
  end if

  dv=(val_max-val_min)/real(itvtone)

  if(itvtone==10.or.itvtone==12)then
     tone_mapping=itvtone/2
  else
     tone_mapping=itvtone
  end if

  if(itvtone==tone_mapping)then
     do k=1,tone_mapping
        TLEV1=val_min+(k-1)*dv
        TLEV2=TLEV1+dv
        IPAT=100*ton_tab+k
        CALL UESTLV( TLEV1, TLEV2, IPAT )
     end do
  else
     do k=1,tone_mapping
        TLEV1=0.5*(val_max+val_min)+(k-1)*dv
        TLEV2=TLEV1+dv
        IPAT=100*ton_tab+k
        CALL UESTLV( TLEV1, TLEV2, IPAT )
write(*,*) "tlev", tlev1, tlev2
     end do
     do k=1,tone_mapping
        TLEV1=0.5*(val_max+val_min)-k*dv
        TLEV2=TLEV1+dv
        IPAT=100*nega_ton_tab+k
        CALL UESTLV( TLEV1, TLEV2, IPAT )
write(*,*) "bgtlev", tlev1, tlev2
     end do
  end if


end subroutine

!---------------------------------------------------
!---------------------------------------------------

subroutine Dcl_Square_Normal( viewx_int, viewy_int, line, color )
! ɸϤˤ, ͳΰ, ǤդοɤĤ֤.
! color = 0 ʤɤĤ֤, Ȥ񤯤.
  use dcl
  implicit none
  real, intent(in) :: viewx_int(2)  ! x ɸ
  real, intent(in) :: viewy_int(2)  ! x ɸ
  integer, intent(in) :: line       ! ο(DCL  index, type ˽)
  integer, intent(in) :: color      ! ͳѤɤĤ֤(DCL Υ顼ޥåפ˽)
  real :: vx(5), vy(5)

  vx(:)=(/viewx_int(1), viewx_int(2), viewx_int(2), viewx_int(1), viewx_int(1)/)
  vy(:)=(/viewy_int(1), viewy_int(1), viewy_int(2), viewy_int(2), viewy_int(1)/)

  if(color/=0)then
     call DclShadeRegionNormalized( vx, vy, color )
  end if
  call DclDrawLineNormalized( vx, vy, index=line )

end subroutine

!---------------------------------------------------
!---------------------------------------------------

subroutine undef_get( undef )  ! CReSS ΥǥեȤ̤ͤ롼
  implicit none
  real, intent(inout) :: undef  ! ̤

  undef = -1.0e+35

end subroutine

!---------------------------------------------------
!---------------------------------------------------

subroutine Dcl_Special_Axis( space, map_pro, mlitv, vx_int, vy_int, t_posi,  &
  &                          lon_int, lat_int, axis_title, labi, labh )
! ľ򤷤ʤϿ޺ɸˤ, ľɸϤǤϿ޼褹롼
! ǥեȤ DCL ξ, 륫ȥʳϿǤ,
! 롼, ٷ٤ǤǤʤΤ, ǥȷϤ
! ϿƤϿޤٿΤ.
  use dcl
  implicit none
  character(*), intent(in) :: space  ! ɸ "btrl" ɽ.
  integer, intent(in) :: map_pro  ! ѤƤϿֹ
  real, intent(in) :: mlitv  ! ˥٥ŽȤδֳ [degree]
  real, intent(in) :: vx_int(2)  ! x  v ɸ
  real, intent(in) :: vy_int(2)  ! y  v ɸ
  real, intent(in) :: t_posi(3)  ! Ͽƻ t_posi=(/lat1, lat2, lon/)
  real, intent(in) :: lon_int(:,:)  ! ǥȷϤγƳʻͿƤ
  real, intent(in) :: lat_int(:,:)  ! ǥȷϤγƳʻͿƤ
                                    ! Ȥ [degree]
  character(*), intent(in) :: axis_title(2)  ! axis title
  integer, intent(in), optional :: labi   ! label's index
  real, intent(in), optional :: labh   ! label's height

  real, allocatable, dimension(:) :: lon_tranc, lat_tranc
  integer :: i, j, k, i_lon, i_lat
  integer :: nc, nx, ny, nlon, nlat, nlonb, nlatb
  integer :: label_index
  real :: map_min_lon, map_max_lon, map_min_lat, map_max_lat
  real :: uratio, vratio
  real :: tmp_x(2), tmp_y(2), label_v
  real :: ref_x_min, ref_x_max, ref_y_min, ref_y_max, rho0
  real :: label_height
  character(10) :: label

!-- ʸؿѿ
  real :: rho, rhon, var, var1, var2, s, sn
  real, parameter :: pi=3.141592

!-- function
  rho(var,var1,s)=cos(var1*pi/180.0)*(tan(0.25*pi-0.5*var*pi/180.0))**s  &
  &               /(s*(tan(0.25*pi-0.5*var1*pi/180.0))**s)
  rhon(var1,var2)=log(cos(var1*pi/180.0)/cos(var2*pi/180.0))  &
  &               /log(tan(0.25*pi-0.5*var1*pi/180.0)/tan(0.25*pi-0.5*var2*pi/180.0))

!-- optional variable's operation
  if(present(labh))then
     label_height=labh
  else
     label_height=DclGetTextHeight()
  end if

  if(present(labi))then
     label_index=labi
  else
     label_index=DclGetTextIndex()
  end if

!-- ϿޤǥȷϤǻͳѤ˰Ϥ

  call Dcl_Square_Normal( vx_int, vy_int, 4, 0 )

  nc=len_trim(adjustl(space))
  nx=size(lon_int,1)
  ny=size(lon_int,2)

!-- ɸǤΥѥ᡼׻

  sn=rhon(t_posi(1),t_posi(2))
  rho0=cos(t_posi(1))/sn

!-- ɸǤ v ɸϤа
!-- Ѥ, ǽŪʿ԰ư.

  ref_x_min=rho(lat_int(1,1),t_posi(1),sn)*sin(sn*(lon_int(1,1)-t_posi(3))*pi/180.0)
  ref_x_max=rho(lat_int(nx,1),t_posi(1),sn)*sin(sn*(lon_int(nx,1)-t_posi(3))*pi/180.0)
  ref_y_min=rho0-rho(lat_int(1,1),t_posi(1),sn)*cos(sn*(lon_int(1,1)-t_posi(3))*pi/180.0)
  ref_y_max=rho0-rho(lat_int(1,ny),t_posi(1),sn)*cos(sn*(lon_int(1,ny)-t_posi(3))*pi/180.0)
  uratio=(vx_int(2)-vx_int(1))/(ref_x_max-ref_x_min)
  vratio=(vy_int(2)-vy_int(1))/(ref_y_max-ref_y_min)

!-- map ˤ٥νü֤η׻

  map_min_lon=(aint(lon_int(1,1)/mlitv)+1.0)*mlitv
  map_min_lat=(aint(lat_int(1,1)/mlitv)+1.0)*mlitv
  map_max_lon=(aint(lon_int(nx,1)/mlitv))*mlitv
  map_max_lat=(aint(lat_int(1,ny)/mlitv))*mlitv

  if(map_min_lon-mlitv>=lon_int(1,1))then
     map_min_lon=map_min_lon-mlitv
  end if
  if(map_min_lat-mlitv>=lat_int(1,1))then
     map_min_lat=map_min_lat-mlitv
  end if
  if(map_max_lon+mlitv<=lon_int(nx,1))then
     map_max_lon=map_max_lon+mlitv
  end if
  if(map_max_lat+mlitv<=lat_int(1,ny))then
     map_max_lat=map_max_lat+mlitv
  end if

!-- ޤǽü֤η׻

!-- ٥ΤɬפǤο

  nlon=int((map_max_lon-map_min_lon)/mlitv)+1
  nlat=int((map_max_lat-map_min_lat)/mlitv)+1

  allocate(lon_tranc(nlon))
  allocate(lat_tranc(nlat))

!-- ºݤγƥ٥Ǥη׻
!-- ׻νϰʲΤȤ.
! (1) ǥ٥. ΤȤμصּ1פȤ.
! (2) Ǥ v ɸϤͤˤ, ηа٤ɬ.
! (3) ٥1 ϼͳ˷뤬ΤȤ⤦μ2 ٤
!     ʤΤ, 1 μ1 ˤĤƤޤ.
!      2 ǡͿа٤ʤΤ, ͤ
!     v ɸΤ, Ȥ, v ϤޤԤ.
! Ȼפä,  lon, lat 줿 v ϤͤޤƤ
! ۤѲʤΤǤϤʤȻפäΤ, ϤˡǷ׻Ƥ.

  call DclSetParm( 'GRAPH:LCLIP', .false. )
  select case (map_pro)
  case (22)  ! conical
     do j=1,nc
        select case (space(j:j))
        case ('b')
           nlonb=1
           nlatb=1
           do i=1,nlon
              lon_tranc(i)=map_min_lon+(i-1)*mlitv
              call val_estimate( lon_int(:,nlatb), lon_tranc(i), i_lon )
              tmp_x(1)=rho(lat_int(i_lon,nlatb), t_posi(1),sn)  &
  &                    *sin(sn*(lon_int(i_lon,nlatb)-t_posi(3))*pi/180.0)
              tmp_x(2)=rho(lat_int(i_lon+1,nlatb), t_posi(1),sn)  &
  &                    *sin(sn*(lon_int(i_lon+1,nlatb)-t_posi(3))*pi/180.0)
              label_v=(tmp_x(1)-ref_x_min+(tmp_x(2)-tmp_x(1))  &
  &                   /(lon_int(i_lon+1,nlatb)-lon_int(i_lon,nlatb))  &
  &                   *(lon_tranc(i)-lon_int(i_lon,nlatb)))*uratio+vx_int(1)
              write(label,'(f5.1)') lon_tranc(i)
              call DclDrawTextNormalized( label_v, vy_int(1)-0.015,  &
  &                                       trim(adjustl(label)),  &
  &                                       height=0.75*label_height,  &
  &                                       index=label_index )
           end do
           call DclDrawTextNormalized( (vx_int(1)+vx_int(2))*0.5,  &
  &                                    vy_int(1)-0.75*label_height-0.015,  &
  &                                    trim(axis_title(1)),  &
  &                                    height=label_height,  &
  &                                    index=label_index )
        case ('t')
           nlonb=1
           nlatb=ny
           do i=1,nlon
              lon_tranc(i)=map_min_lon+(i-1)*mlitv
              call val_estimate( lon_int(:,nlatb), lon_tranc(i), i_lon )
              tmp_x(1)=rho(lat_int(i_lon,nlatb), t_posi(1),sn)  &
  &                    *sin(sn*(lon_int(i_lon,nlatb)-t_posi(3))*pi/180.0)
              tmp_x(2)=rho(lat_int(i_lon+1,nlatb), t_posi(1),sn)  &
  &                    *sin(sn*(lon_int(i_lon+1,nlatb)-t_posi(3))*pi/180.0)
              label_v=(tmp_x(1)-ref_x_min+(tmp_x(2)-tmp_x(1))  &
  &                   /(lon_int(i_lon+1,nlatb)-lon_int(i_lon,nlatb))  &
  &                   *(lon_tranc(i)-lon_int(i_lon,nlatb)))*uratio+vx_int(1)
              write(label,'(f5.1)') lon_tranc(i)
              call DclDrawTextNormalized( lon_tranc(i), vy_int(2)+0.015,  &
  &                                       trim(adjustl(label)),  &
  &                                       height=0.75*label_height,  &
  &                                       index=label_index )
           end do
        case ('l')
           nlonb=1
           nlatb=1
           do i=1,nlat
              lat_tranc(i)=map_min_lat+(i-1)*mlitv
              call val_estimate( lat_int(nlonb,:), lat_tranc(i), i_lat )
              tmp_y(1)=-rho(lat_int(nlonb,i_lat), t_posi(1),sn)  &
  &                    *cos(sn*(lon_int(nlonb,i_lat)-t_posi(3))*pi/180.0)
              tmp_y(2)=-rho(lat_int(nlonb,i_lat+1), t_posi(1),sn)  &
  &                    *cos(sn*(lon_int(nlonb,i_lat+1)-t_posi(3))*pi/180.0)
              label_v=(rho0+tmp_y(1)-ref_y_min+(tmp_y(2)-tmp_y(1))  &
  &                   /(lat_int(nlonb,i_lat+1)-lat_int(nlonb,i_lat))  &
  &                   *(lat_tranc(i)-lat_int(nlonb,i_lat)))*vratio+vy_int(1)
              write(label,'(f5.1)') lat_tranc(i)
              call DclDrawTextNormalized( vx_int(1)-0.01, label_v,  &
  &                                       trim(adjustl(label)),  &
  &                                       height=0.75*label_height,  &
  &                                       index=label_index, centering=1 )
           end do
           call DclDrawTextNormalized( vx_int(1)-5.0*0.75*label_height-0.01,  &
  &                                    (vy_int(2)+vy_int(1))*0.5,  &
  &                                    trim(axis_title(2)), angle=90.0,  &
  &                                    height=label_height,  &
  &                                    index=label_index )
        end select
     end do
  end select
  call DclSetParm( 'GRAPH:LCLIP', .true. )

end subroutine

!---------------------------------------------------
!---------------------------------------------------

subroutine color_line( sub_idx, linex, liney, valz, c_num,  &
  &                    c_itv, tri_col, col_val, col_idx, subsubidx )
! ľ valz Ȥ˥顼ɽ롼
  use dcl
  implicit none
  character(1), intent(in) :: sub_idx  ! ɤΥ롼ƤӽФ.
                      ! [s] = DclScalingPoint
                      ! [l] = DclDrawLine
                      ! [p] = DclDrawMark
  real, intent(in) :: linex(:,:)  ! x ľɸ
  real, intent(in) :: liney(size(linex,1),size(linex,2))  ! y ľɸ
  real, intent(in) :: valz(size(linex,1),size(linex,2))  ! ľǤ
  integer, intent(in) :: c_num  ! Ѥ륫顼
  real, intent(in) :: c_itv(2)  ! ư顼ꤹȤκǾ.
  integer, intent(in), optional :: tri_col(2)  ! valz  c_itv ۤȤ
                                   ! ꥫ顼ֹ
  real, intent(in), optional :: col_val(:)  ! valz ˴Ϣդ륫顼ζ
  integer, intent(in), optional :: col_idx(:)  ! c_val б륫顼ֹ
  character(1), intent(in), optional :: subsubidx  ! sub_idx = 's' ξ,
                                        ! line Ѥ mark ѤΤɤˤĤ
                                        ! ƤӽФƤ뤫 ('l' or 'p')
  integer :: nlx, nly, ncl, itmp, tmp_i, i, j, counter
  real, allocatable, dimension(:) :: c_val
  integer, allocatable, dimension(:) :: c_idx
  integer :: ci_itv(2), over_col(2), ccnum, tmpci
  real :: tmp1_itv(2), tmp2_itv(2)
  real :: defun, tmpcmin, tmpcmax
  integer :: ci_min, ci_max, aidx, ltyp, mtyp
  real :: msiz
  logical :: overcol_flag(2)

  call GLRGET( 'RMISS', defun )

  nlx=size(linex,1)
  nly=size(linex,2)

  overcol_flag=.false.

  if(sub_idx=='s')then
     if(.not.present(subsubidx))then
        write(*,*) "*** ERROR (color_line:dcl_automatic) ***"
        write(*,*) "When sub_idx == s, subsubidx must be set. Stop."
        stop
     end if
  end if

  if(present(col_val))then
     select case (sub_idx)
     case('s')   ! ǤͤϻȤʤ.
        aidx=DclGetLineIndex()
     case('l')
        aidx=DclGetLineIndex()
     case('p')
        aidx=DclGetMarkerIndex()
     end select
     if(aidx<=0)then   ! Ƥʤ 1.
        aidx=1
     end if

     ncl=size(col_val)-1

     allocate(c_val(ncl+1))
     allocate(c_idx(ncl+1))

     do i=1,ncl+1
        c_val(i)=col_val(i)
        c_idx(i)=col_idx(i)
     end do
  else   ! col_val ꤵƤʤϺ color_setting ͤѤ.
     ncl=c_num

     allocate(c_val(ncl+1))
     allocate(c_idx(ncl+1))

     ccnum=DclGetShadeLevelNumber()

     if(ccnum==0)then
        ci_min=15
        ci_max=85
     else
        do i=1,ccnum
           call DclGetShadeLevel( i, tmpcmin, tmpcmax, tmpci )
!           if(tmpcmin==c_itv(1))then
!              ci_min=tmpci/1000     !  3  999 ꤵƤϤ.
!              setc_check(1)=.true.
!           end if
!           if(tmpcmax==c_itv(2))then
!              ci_max=tmpci/1000     !  3  999 ꤵƤϤ.
!              setc_check=.true.
!           end if
           if(tmpcmin==defun)then    ! Ѥο
              over_col(1)=tmpci/1000
              overcol_flag(1)=.true.
           end if
           if(tmpcmax==defun)then    ! 廰Ѥο
              over_col(2)=tmpci/1000
              overcol_flag(2)=.true.
           end if
           if(tmpcmax/=defun)then    ! col_val, col_idx 
              c_val(i)=tmpcmax
              c_idx(i)=tmpci/1000
           end if
        end do
     end if

     select case (sub_idx)
     case('s')   ! ǤͤϻȤʤ.
        aidx=DclGetLineIndex()
     case('l')
        aidx=DclGetLineIndex()
     case('p')
        aidx=DclGetMarkerIndex()
     end select
     if(aidx<=0)then   ! Ƥʤ 1.
        aidx=1
     end if

     do i=1,ncl+1
        if(ccnum==0)then
           c_val(i)=c_itv(1)+(c_itv(2)-c_itv(1))/real(c_num)*(i-1)
           c_idx(i)=(ci_min+int(real(ci_max-ci_min)/real(c_num)*real(i-1)))*10+aidx
                 ! index ϥǥեȤꤵƤͤ򻲾Ȥ.
        else
           c_idx(i)=c_idx(i)*10+aidx
        end if
     end do
  end if

  ! get marker size and line type (developing)
  select case (sub_idx)
  case('l')
     ltyp=DclGetLineType()
  case('p')
     msiz=DclGetMarkerSize()
     mtyp=DclGetMarkerType()
  end select

  if(present(tri_col))then
     over_col(1)=tri_col(1)
     over_col(2)=tri_col(2)
     overcol_flag=.true.
  end if

!write(*,*) "over_col check", over_col, aidx

  if(overcol_flag(1).eqv..true.)then
     over_col(1)=over_col(1)*10+aidx
  end if
  if(overcol_flag(1).eqv..true.)then
     over_col(2)=over_col(2)*10+aidx
  end if

  do j=1,nly
     if(valz(1,j)/=defun)then
        call val_estimate( c_val, valz(1,j), itmp )
        counter=1
     else
        itmp=-1
        counter=2
     end if

     if(nlx>1)then
        do i=2,nlx
           if(valz(i,j)/=defun)then
              call val_estimate( c_val, valz(i,j), tmp_i )
           else
              tmp_i=-1
           end if
           if(itmp/=tmp_i.and.i-counter>=0.and.itmp/=-1.and.i/=nlx)then
              select case (sub_idx)
              case ('s')
                 if(subsubidx=='l')then
                    if(i-counter>=1.and.tmp_i/=-1)then
                       if(counter==1)then
                          if(linex(counter,j)/=defun.and.  &
  &                          liney(counter,j)/=defun)then
                             counter=counter+1
                          end if
                       else
                          if(linex(counter-1,j)/=defun.and.  &
  &                          liney(counter-1,j)/=defun)then
                             counter=counter+1
                          end if
                       end if
                       if(i-counter>=1)then
                          call DclScalingPoint( linex(counter-1:i-1,j),  &
  &                                             liney(counter-1:i-1,j) )
                       end if
                    end if
                 else
                    call DclScalingPoint( linex(counter:i-1,j),  &
  &                                       liney(counter:i-1,j) )
                 end if
              case ('l')
                 if(i-counter>=1.and.tmp_i/=-1)then
                    if(counter==1)then
                       if(linex(counter,j)/=defun.and.  &
  &                       liney(counter,j)/=defun)then
                          counter=counter+1
                       end if
                    else
                       if(linex(counter-1,j)/=defun.and.  &
  &                       liney(counter-1,j)/=defun)then
                          counter=counter+1
                       end if
                    end if
                    if(i-counter>=1)then
                       if(itmp==0.and.overcol_flag(1).eqv..true.)then
!write(*,*) "DrawLinex checkt", linex(counter-1:i-1,j), counter-1, i-1
!write(*,*) "DrawLiney checkt", liney(counter-1:i-1,j), counter-1, i-1
                          call DclDrawLine( linex(counter-1:i-1,j),  &
  &                                         liney(counter-1:i-1,j),  &
  &                                         index=over_col(1), type=ltyp )
                       else if(itmp==ncl+1.and.overcol_flag(2).eqv..true.)then
!write(*,*) "DrawLinex checkt", linex(counter-1:i-1,j), counter-1, i-1
!write(*,*) "DrawLiney checkt", liney(counter-1:i-1,j), counter-1, i-1
                          call DclDrawLine( linex(counter-1:i-1,j),  &
  &                                         liney(counter-1:i-1,j),  &
  &                                         index=over_col(2), type=ltyp )
                       else if(itmp/=0.and.itmp/=ncl+1)then
!write(*,*) "DrawLinex checkt", linex(counter-1:i-1,j), counter-1, i-1
!write(*,*) "DrawLiney checkt", liney(counter-1:i-1,j), counter-1, i-1
                          call DclDrawLine( linex(counter-1:i-1,j),  &
  &                                         liney(counter-1:i-1,j),  &
  &                                         index=c_idx(itmp), type=ltyp )
                       end if
                    end if
                 end if
              case ('p')
                 if(itmp==0.and.overcol_flag(1).eqv..true.)then
!write(*,*) "tmpcheck1", over_col(1), itmp
!write(*,*) "tmplcheck1", linex(counter:i-1,j)
                    call DclDrawMarker( linex(counter:i-1,j),  &
  &                                     liney(counter:i-1,j),  &
  &                                     index=over_col(1),  &
  &                                     type=mtyp, height=msiz )
                 else if(itmp==ncl+1.and.overcol_flag(2).eqv..true.)then
!write(*,*) "tmpcheck1", over_col(2), itmp
!write(*,*) "tmplcheck1", linex(counter:i-1,j)
                    call DclDrawMarker( linex(counter:i-1,j),  &
  &                                     liney(counter:i-1,j),  &
  &                                     index=over_col(2),  &
  &                                     type=mtyp, height=msiz )
                 else if(itmp/=0.and.itmp/=ncl+1)then
!write(*,*) "tmpcheck1", c_idx(itmp), itmp
!write(*,*) "tmplcheck1", linex(counter:i-1,j)
                    call DclDrawMarker( linex(counter:i-1,j), liney(counter:i-1,j),  &
  &                                   index=c_idx(itmp), type=mtyp, height=msiz )
                 end if
              end select
              if(i-counter==1)then
                 counter=i
              else if(sub_idx=='p'.and.i-counter>=0)then
                 counter=i
              else if(sub_idx=='s'.and.i-counter>=0)then
                 if(subsubidx=='p')then
                    counter=i
                 end if
              end if
           else if(i==nlx.and.nlx-counter>1.and.itmp/=-1)then
              select case (sub_idx)
              case ('s')
                 if(subsubidx=='l')then
                    call DclScalingPoint( linex(counter-1:nlx,j),  &
  &                                       liney(counter-1:nlx,j) )
                 else
                    call DclScalingPoint( linex(counter:nlx,j),  &
  &                                       liney(counter:nlx,j) )
                 end if
              case ('l')
                 if(itmp==0)then
                    if(overcol_flag(1).eqv..true.)then
                       call DclDrawLine( linex(counter-1:nlx,j),  &
  &                                      liney(counter-1:nlx,j),  &
  &                                      index=over_col(1), type=ltyp )
!write(*,*) "DrawLinex check", linex(counter-1:nlx,j), counter-1, nlx
!write(*,*) "DrawLiney check", liney(counter-1:nlx,j), counter-1, nlx
                    end if
                 else if(itmp==ncl+1)then
                    if(overcol_flag(2).eqv..true.)then
                       call DclDrawLine( linex(counter-1:nlx,j),  &
  &                                      liney(counter-1:nlx,j),  &
  &                                      index=over_col(2), type=ltyp )
!write(*,*) "DrawLinex check", linex(counter-1:nlx,j), counter-1, nlx
!write(*,*) "DrawLiney check", liney(counter-1:nlx,j), counter-1, nlx
                    end if
                 else if(itmp/=0.and.itmp/=ncl+1)then
                    call DclDrawLine( linex(counter-1:nlx,j),  &
  &                                   liney(counter-1:nlx,j),  &
  &                                   index=c_idx(itmp), type=ltyp )
!write(*,*) "DrawLinex check", linex(counter-1:nlx,j), counter-1, nlx
!write(*,*) "DrawLiney check", liney(counter-1:nlx,j), counter-1, nlx
                 end if
              case ('p')
                 if(itmp==0)then
                    if(overcol_flag(1).eqv..true.)then
!write(*,*) "tmpcheck1", over_col(1), itmp
!write(*,*) "tmplcheck1", linex(counter:nlx,j)
                       call DclDrawMarker( linex(counter:nlx,j),  &
  &                                        liney(counter:nlx,j),  &
  &                                        index=over_col(1),  &
  &                                        type=mtyp, height=msiz )
                    end if
                 else if(itmp==ncl+1)then
                    if(overcol_flag(2).eqv..true.)then
!write(*,*) "tmpcheck1", over_col(2), itmp
!write(*,*) "tmplcheck1", linex(counter:nlx,j)
                       call DclDrawMarker( linex(counter:nlx,j),  &
  &                                        liney(counter:nlx,j),  &
  &                                        index=over_col(2),  &
  &                                        type=mtyp, height=msiz )
                    end if
                 else if(itmp/=0.and.itmp/=ncl+1)then
!write(*,*) "tmpcheck1", c_idx(itmp), itmp
!write(*,*) "tmplcheck1", linex(counter:nlx,j)
                    call DclDrawMarker( linex(counter:nlx,j), liney(counter:nlx,j),  &
  &                              index=c_idx(itmp), type=mtyp, height=msiz )
                 end if
              end select
           end if
           if(itmp==1.and.tmp_i==-1)then
              counter=i+1
           end if
           itmp=tmp_i
        end do

     else

        if(itmp>0)then
           select case (sub_idx)
           case ('s')
              call DclScalingPoint( linex(1:1,j), liney(1:1,j) )
              write(*,*) "*** WARNING *** (color_line:dcl_automatic)"
              write(*,*) "the array number of each line or marker is 1."
           case ('p')
              if(itmp==0)then
                 if(overcol_flag(1).eqv..true.)then
!write(*,*) "tmpcheck1", over_col(1), itmp
!write(*,*) "tmplcheck1", linex(1,j)
                    call DclDrawMarker( linex(1:1,j), liney(1:1,j),  &
  &                                   index=over_col(1), type=mtyp, height=msiz )
                 end if
              else if(itmp==ncl+1)then
                 if(overcol_flag(2).eqv..true.)then
!write(*,*) "tmpcheck1", over_col(2), itmp
!write(*,*) "tmplcheck1", linex(1,j)
                    call DclDrawMarker( linex(1:1,j), liney(1:1,j),  &
  &                                   index=over_col(2), type=mtyp, height=msiz )
                 end if
              else if(itmp/=0.and.itmp/=ncl+1)then
!write(*,*) "tmpcheck1", c_idx(itmp), itmp
!write(*,*) "tmplcheck1", linex(1,j)
                 call DclDrawMarker( linex(1:1,j), liney(1:1,j),  &
  &                                index=c_idx(itmp), type=mtyp, height=msiz )
              end if
           end select
        end if
     end if
  end do

end subroutine

!---------------------------------------------------
!---------------------------------------------------

subroutine val_estimate( c_val, val, idx )
! val  c_val ΤɤϰϤ¸ߤ뤫.
  implicit none
  real, intent(in) :: c_val(:)
  real, intent(in) :: val
  integer, intent(inout) :: idx
  integer :: i

  idx=0

  do i=1,size(c_val)
     if(c_val(i)<=val)then
        idx=i
     else
        exit
     end if
  end do

end subroutine

!---------------------------------------------------
!---------------------------------------------------

subroutine calc_vscale( length, v_length, vx_scale, vy_scale )
  ! ®٥ȥ襢ڥ˹碌뤿 V ɸϤˤñ̥٥ȥ
  ! ׻롼. x ͤꤷ, ΤȤ y Υ.
  ! ׻ˡϰʲΤȤ.
  ! U ɸϤ (uu, uv) Υ٥ȥ V ɸϤ (vu,vv) ˤ.
  ! (vu, vv)=(vx_scale*uu, vy_scale*uv) Ȥط.
  ! , դΰ U, V ɸϤǤ줾 ux, uy, vx, vy Ȥ,
  ! x  y ο̤Ȥ,
  ! v ɸϤǤ, vy/vx=v_asp ܤ y ٥ȥˤ,
  ! u ɸϤǤ, 1/(uy/ux)=1/u_asp ܤ y ٥ȥˤΤ,
  ! (vu, vv)=(vx_scale*uu, (v_asp/u_asp)*vy_scale*vy) ȤطƤФ褤.
  ! ˤĤƤξܤǰޤ Tex ե뻲.
  ! ä, vx_scale, vy_scale ƱΨѲȤ,
  ! (Ĥޤ, ®٥ȥȤѲȤ)
  ! vy_scale=vx_scale*v_asp*u_asp Ȥʤ.
  implicit none
  real, intent(in) :: length(2)  ! Υ [m]
  real, intent(in) :: v_length(2)  ! V ϤǤϰ
  real, intent(in) :: vx_scale  ! x Υ󥰥ե
  real, intent(inout) :: vy_scale  ! y Υ󥰥ե
!-- ʾ, 
  real :: x_length  ! Υ [m]
  real :: y_length  ! Υ [m]
  real :: vx_length  !  V ϤǤϰ
  real :: vy_length  !  V ϤǤϰ
!-- ʾ, ֤ѿ
  real :: u_asp, v_asp

!-- ֤ѿ֤
  x_length=length(1)
  y_length=length(2)
  vx_length=v_length(1)
  vy_length=v_length(2)

  u_asp=y_length/x_length
  v_asp=vy_length/vx_length

  vy_scale=(v_asp/u_asp)*vx_scale

end subroutine

!---------------------------------------------------
!---------------------------------------------------


subroutine format_make( val_type, order_num, form_name, frac_num )  ! ͥ٥ѥեޥåȺ롼
  implicit none
  character(1), intent(in) :: val_type  ! ٥벽ѿη : f = ¿(ץꤹ), i = 
  character(1), intent(in) :: order_num  ! ɽ
  character(1), intent(in), optional :: frac_num  ! ¿ΤȤΤ, 
  character(*), intent(out) :: form_name

  select case(val_type)
  case('f')
     form_name='('//val_type//order_num//'.'//frac_num//')'
     form_name=trim(form_name)
  case('F')
     form_name='('//val_type//order_num//'.'//frac_num//')'
     form_name=trim(form_name)
  case('i')
     form_name='('//val_type//order_num//')'
     form_name=trim(form_name)
  case('I')
     form_name='('//val_type//order_num//')'
     form_name=trim(form_name)
  end select

end subroutine format_make

!-- ʲ, 𱩥ѥå WVERBS

subroutine wverbd( vs, vd, vox, voy )
! V ɸϤ 1 Ĥ𱩤.
! ® vs (ñ knot)  vd (ñ deg) 
! , ǥȺɸϤΤб.
! vd ̤ 0 (360) deg ȤƻײˤȤ.
! ֿᤤƤ.
! Ĥޤ, ʤ, vd = 0.0.
! DCL ؤΰܿθƳع¤ɽ.
! Υ롼ľܻѤ뤳Ȥ¿ʬʤϤ.
  implicit none
  real, intent(in) :: vs  ! wind speed [knot]
  real, intent(in) :: vd  ! wind direction [deg]
  real, intent(in) :: vox  ! the origin of x-direction [V-coord.]
  real, intent(in) :: voy  ! the origin of y-direction [V-coord.]
  real, parameter :: vfact=0.05, pi=3.14159265, verbangle=120.0
  real, parameter, dimension(4) :: verbel=(/2.0, 5.0, 10.0, 50.0 /)
  integer :: i, counter, vounter
  integer, dimension(4) :: iblev
  logical, parameter :: verbflag=.true.  !  or ʣ (NOTE "counter")
  real :: vx, vy, vp, vinterval, vwidth, coe, verbi, vcoe
  real, dimension(30) :: vxtraj, vytraj
  real, dimension(10) :: vvxtraj, vvytraj

  iblev=(/0,0,0,0/)
  vinterval=0.5*vfact*0.2
  vwidth=0.5*vfact
  coe=pi/180.0
  verbi=180.0-verbangle
  vcoe=(vd+verbi)*coe

  vx=sin(vd*coe)*vfact
  vy=cos(vd*coe)*vfact
  vp=vs

!-- , α

  if(verbflag.eqv..true.)then
     do while (vp>verbel(4))
        iblev(4)=iblev(4)+1
        vp=vp-verbel(4)
     end do
  end if

  do while (vp>verbel(3))
     iblev(3)=iblev(3)+1
     vp=vp-verbel(3)
  end do
  do while (vp>verbel(2))
     iblev(2)=iblev(2)+1
     vp=vp-verbel(2)
  end do

!-- εפ׻.

  vxtraj(1)=vox
  vytraj(1)=voy
  vxtraj(2)=vxtraj(1)+vx
  vytraj(2)=vytraj(1)+vy
  vvxtraj(1)=vxtraj(2)+vx
  vvytraj(1)=vytraj(2)+vy

  counter=2
  vounter=1

  if(iblev(4)>0)then
     do i=1,iblev(4)
        counter=counter+1
        vounter=vounter+1
        vxtraj(counter)=vxtraj(counter-1)+sin(vcoe)*vwidth
        vytraj(counter)=vytraj(counter-1)+cos(vcoe)*vwidth
        vvxtraj(vounter)=vvxtraj(vounter-1)+sin(vcoe)*vwidth
        vvytraj(vounter)=vvytraj(vounter-1)+cos(vcoe)*vwidth
        counter=counter+1
        vounter=vounter+1
        vxtraj(counter)=vxtraj(counter-2)-sin(vd*coe)*vinterval
        vytraj(counter)=vytraj(counter-2)-cos(vd*coe)*vinterval
        vvxtraj(vounter)=vvxtraj(vounter-2)-sin(vd*coe)*vinterval
        vvytraj(vounter)=vvytraj(vounter-2)-cos(vd*coe)*vinterval
        vounter=vounter+1
        vvxtraj(vounter)=vvxtraj(vounter-3)
        vvytraj(vounter)=vvytraj(vounter-3)
     end do
  end if

  if(iblev(3)>0)then
     do i=1,iblev(3)
        counter=counter+1
        vxtraj(counter)=vxtraj(counter-1)+sin(vcoe)*vwidth
        vytraj(counter)=vytraj(counter-1)+cos(vcoe)*vwidth
        counter=counter+1
        vxtraj(counter)=vxtraj(counter-2)
        vytraj(counter)=vytraj(counter-2)
        counter=counter+1
        vxtraj(counter)=vxtraj(counter-1)-sin(vd*coe)*vinterval
        vytraj(counter)=vytraj(counter-1)-cos(vd*coe)*vinterval
     end do
  end if

  if(iblev(2)>0)then
     do i=1,iblev(2)
        counter=counter+1
        if(counter==3)then
           vxtraj(counter)=vxtraj(counter-1)-sin(vd*coe)*vinterval
           vytraj(counter)=vytraj(counter-1)-cos(vd*coe)*vinterval
           counter=counter+1
           vxtraj(counter)=vxtraj(counter-1)+sin(vcoe)*vwidth*0.5
           vytraj(counter)=vytraj(counter-1)+cos(vcoe)*vwidth*0.5
        else
           vxtraj(counter)=vxtraj(counter-1)+sin(vcoe)*vwidth*0.5
           vytraj(counter)=vytraj(counter-1)+cos(vcoe)*vwidth*0.5
        end if
     end do
  end if

  if(iblev(4)>0)then
     call SGTNZV( vounter, vvxtraj(1:vounter), vvytraj(1:vounter), 999 )
  end if

  call SGPLV( counter, vxtraj(1:counter), vytraj(1:counter) )

!write(*,*) "check", vounter, vvxtraj(1:vounter), vvytraj(1:vounter)

end subroutine wverbd

subroutine wvrbxy( ux, uy, vx, vy )
!-- For Cartesian
  implicit none
  real, intent(in) :: ux  ! wind component of x-coord [knot]
  real, intent(in) :: uy  ! wind component of y-coord [knot]
  real, intent(in) :: vx  ! the origin of x [vcoord]
  real, intent(in) :: vy  ! the origin of y [vcoord]
  real, parameter :: pi=3.141592653
  real :: vs, vd, rcoe

  rcoe=180.0/pi
  vs=sqrt(ux*ux+uy*uy)

  if(vs/=0.0)then
     if(uy==0.0)then
        vd=acos(ux/vs)*rcoe+180.0
     else
        vd=asin(uy/vs)*rcoe+180.0
     end if
     call wverbd( vs, vd, vx, vy )
  end if

end subroutine wvrbxy

end module
