! Copyright (C) GFD Dennou Club, 2000.  All rights reserved

subroutine GDNcVarDelAttr(var, name, err)
    use gtdata_netcdf_types, only: GD_NC_VARIABLE, GD_NC_VARIABLE_ENTRY
    use gtdata_netcdf_file_generic, only: GDNcFileDefineMode
    use gtdata_netcdf_internal, only: vtable_lookup
    use netcdf_f77, only: NF_NOERR, NF_DEL_ATT, NF_ENOTINDEFINE, NF_GLOBAL
    use dc_url, only: GT_PLUS
    use dc_error
    implicit none
    type(GD_NC_VARIABLE), intent(in):: var
    character(len = *), intent(in):: name
    logical, intent(out), optional:: err
    type(GD_NC_VARIABLE_ENTRY):: ent
    integer:: stat
continue
    stat = vtable_lookup(var, ent)
    if (stat /= NF_NOERR) goto 999
    stat = nf_del_att(ent%fileid, ent%varid, name=name)
    if (stat == 0) goto 999
    if (stat /= NF_ENOTINDEFINE) goto 999
    stat = GDNcFileDefineMode(ent%fileid)
    if (stat /= NF_NOERR) goto 999
    if (name(1:1) == GT_PLUS) then
        stat = nf_del_att(ent%fileid, NF_GLOBAL, name=name(2:))
    else
        stat = nf_del_att(ent%fileid, ent%varid, name=name)
    endif

999 continue
    call StoreError(stat, 'GDNcVarPutAttrChar', err)
end subroutine
