      PARAMETER ( N = 100)
      PARAMETER ( M = 50)
      REAL     PHI1(M+1,N/2+1) ,  PHI2(M+1,N/2+1)
     *       , WAVENUM , DELTAY , PI , TAUR , TAUI , WIDTH , XL
     *       , XGRD(2) , YGRD1(2) , YGRD2(2)
     *       , PHIR(N+1), YP(N+1)
      COMPLEX  CPHI1(N/2+1) , CPHI2(N/2+1)
     *       , UIMAG , C
      INTEGER  JX , JY
     *       , IPAT , NC , JCRT , JSIZE , NDOT
      DATA IPAT/Z'0000FFF0'/
*
      UIMAG   = ( 0.0 , 1.0 )
      PI      = 3.1416
      WIDTH   = 8.0
*
*
      CALL PLSTRT ( 20.0 , 20.0 , 'NLP1' )
*
      WAVENUM = 0.50
      CR = 0.0
      CI = 1.0
      C  = CR + UIMAG * CI
*
      DELTAY  = WIDTH / FLOAT(N)
*
      XL      = 2.0 * PI / WAVENUM
      XGRD(1)  =   0.0
      XGRD(2)  =   XL
      YGRD1(1) = - WIDTH * 0.5
      YGRD1(2) =   0.0
      YGRD2(1) =   0.0
      YGRD2(2) =   WIDTH * 0.5
*
      DO 10 JY = 1 , N+1
        YP(JY)   = (REAL(JY-1)/REAL(N)-0.5)*WIDTH
        IF(JY.LE.N/2) THEN
          CPHI1(JY)     = - UIMAG * EXP(WAVENUM*YP(JY))
        ELSEIF(JY.GE.N/2+2) THEN
          CPHI2(JY-N/2) =           EXP(-WAVENUM*YP(JY))
        ELSE
          CPHI1(JY)     = - UIMAG
          CPHI2(JY-N/2) = 1.0
        ENDIF
 10   CONTINUE
*
      DO 30 JY = 1 , N/2+1
        PHIR(JY)     = ABS(CPHI1(JY))
        PHIR(JY+N/2) = ABS(CPHI2(JY))
 30   CONTINUE
*
      DO 40 JX = 1 , M+1
        DO 50 JY = 1 , N/2+1
          PHI1(JX,JY) = REAL(CPHI1(JY) * UIMAG
     +                * EXP(UIMAG*FLOAT(JX-1)/FLOAT(M)*2*PI))
          PHI2(JX,JY) = REAL(CPHI2(JY) * UIMAG
     +                * EXP(UIMAG*FLOAT(JX-1)/FLOAT(M)*2*PI))
 50     CONTINUE
 40   CONTINUE
*
        XSTR = 0.25
        XEND = 0.35
        YSTR = 0.60
        YEND = 0.80
*
      CALL SET ( XSTR, XEND, YSTR, YEND, 0.0 , 1.0
     *         , -WIDTH*0.5, WIDTH*0.5 , 1 )
      CALL OPTN ( 'INTN' , 'LOW ' )
      CALL PCURVE ( PHIR , YP , N+1)
      CALL PWRIT  ( 1.15 , 0.0 , '|o|'  , 3 , 12 , 0 , 0 )
      CALL PWRIT  ( 1.15 , 0.0 , '/'    , 1 , 12 , 0 , 0 )
      CALL PWRIT  (-0.12 , 0.0 , ' 0.0' , 4 , 12 , 0 , 1 )
      CALL PWRIT  (-0.12 , WIDTH*0.50 , ' 4.0' , 4 , 12 , 0 , 1 )
      CALL PWRIT  (-0.12 ,-WIDTH*0.50 , '-4.0' , 4 , 12 , 0 , 1 )
      CALL PWRIT  ( 0.00 , WIDTH*0.60 , 'y'    , 1 , 16 , 0 , 1 )
      CALL PGRIDA (  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  1 ,  1 ,  0 ,  0 )
*
        XSTR = 0.40
        XEND = XSTR + (YEND - YSTR) / WIDTH * XL
      CALL SET ( XSTR, XEND, YSTR, YEND
     *         ,  0.0 , XL , -WIDTH*0.5 , WIDTH*0.5 , 1 )
      CALL PGRIDA (  0 ,  0 ,  0 ,  0 ,  1 ,  1 ,  0 ,  0 ,  0 ,  0 )
      CALL CONOPT ( -9 , -9 , 1 )
      CALL CONGRD ( PHI1 , M+1 , M+1 , N/2+1
     *            , -1.0 , 1.0 , 0.1 , 1 , -1 , -IPAT
     *            , -1 , XGRD , YGRD1 )
      CALL CONGRD ( PHI2 , M+1 , M+1 , N/2+1
     *            , -1.0 , 1.0 , 0.1 , 1 , -1 , -IPAT
     *            , -1 , XGRD , YGRD2 )
      CALL PWRIT  ( XL*0.70, WIDTH*0.64, 'k=     ', 7 , 12 , 0 , 1 )
      CALL PNUMBR ( XL*0.70, WIDTH*0.64, WAVENUM, 4, 6H(F4.2), 12, 0, 1)
      CALL PWRIT  ( XL*0.50, WIDTH*0.56, ' C =        ',12, 12, 0, -1)
      CALL PWRIT  ( XL*0.50, WIDTH*0.56, '           i', 12, 12, 0 ,-1)
      CALL PNUMBR ( XL*0.57, WIDTH*0.56, CI, 10, 6H(F8.4), 12, 0,-1)
*
*
      CALL PLFIN
      STOP
      END
